/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.controls;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.threads.CLocalFileSystem;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;

public class CLinkLabel
extends JLabel
implements MouseListener {
    private String m_sURLPath;

    public CLinkLabel(String sURL) {
        this._CLinkLabel(sURL, null);
    }

    public CLinkLabel(String sURL, String sText) {
        this._CLinkLabel(sURL, sText);
    }

    private void _CLinkLabel(String sURLPath, String sText) {
        this.m_sURLPath = sURLPath;
        if (sText != null && !sText.isEmpty()) {
            this.setText(String.format("<html><A href=\"%s\">%s</A></html>", sURLPath, sText));
        }
        this.addMouseListener(this);
    }

    public String GetURLPath() {
        return this.m_sURLPath;
    }

    protected URL GetURL() {
        URL rURL;
        block3: {
            rURL = null;
            try {
                if (this.GetURLPath() != null && !this.GetURLPath().isEmpty()) {
                    rURL = new URL(this.GetURLPath());
                }
            }
            catch (MalformedURLException ex) {
                if (!CAttr.DEBUG) break block3;
                Logger.getLogger(CLinkLabel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return rURL;
    }

    @Override
    public void mouseClicked(MouseEvent rMouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent rMouseEvent) {
        if (rMouseEvent != null) {
            Object rSource = rMouseEvent.getSource();
            URL rURL = this.GetURL();
            if (rURL != null) {
                CLocalFileSystem.GetLocalFileSystem().LaunchURL(rURL.toString());
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent rMouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent rMouseEvent) {
        if (rMouseEvent != null) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void mouseExited(MouseEvent rMouseEvent) {
        if (rMouseEvent != null) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

