/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui.applet;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.messages.CDialogModalityMsg;
import com.rhinosoft.messages.CFetchBrowserInfoMsg;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.applet.CRhinoAppletApp;
import com.rhinosoft.ui.applet.CRhinoAppletCommThread;
import java.awt.Dialog;
import java.util.LinkedHashMap;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class CRhinoApplet
extends JApplet {
    public static boolean DEBUG = CAttr.DEBUG;
    public static boolean DEBUG_APPLET_FUNCS;
    public static boolean DEBUG_PARMS;
    public static boolean DEBUG_USER_AGENT;
    public static boolean DEBUG_ATTACH;
    private static CRhinoApplet m_Applet;
    private boolean m_bAllowJSObject = true;
    private int m_nAllowJSObjectCount = 0;
    private LinkedHashMap<String, String> m_asParms;
    private CRhinoAppletApp m_App;
    protected OS m_OS = OS.UNKNOWN;
    protected BROWSER m_Browser = BROWSER.UNKNOWN;
    protected boolean m_bIsMicrosoftBrowser;
    protected CRhinoAppletCommThread m_tCommunicationThread;

    public CRhinoApplet() {
        this.m_asParms = new LinkedHashMap();
    }

    @Override
    public void init() {
        block4: {
            if (DEBUG_APPLET_FUNCS) {
                System.out.printf("Entering:  %s.init -->\r\n", CRhinoApplet.class.getName());
            }
            super.init();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        CRhinoApplet.this.OnAppletInit();
                    }
                });
            }
            catch (Exception e) {
                if (!DEBUG) break block4;
                System.out.printf("%s.start = catch exception | %s\r\n", CRhinoApplet.class.getName(), e.getMessage());
            }
        }
        if (DEBUG_APPLET_FUNCS) {
            System.out.printf("Exiting:  %s.init <--\r\n", CRhinoApplet.class.getName());
        }
    }

    @Override
    public void start() {
        block4: {
            if (DEBUG_APPLET_FUNCS) {
                System.out.printf("Entering:  %s.start -->\r\n", CRhinoApplet.class.getName());
            }
            super.start();
            m_Applet = this;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        CRhinoApplet.this.OnAppletStart();
                    }
                });
            }
            catch (Exception e) {
                if (!DEBUG) break block4;
                System.out.printf("%s.start = catch exception | %s\r\n", CRhinoApplet.class.getName(), e.getMessage());
            }
        }
        if (DEBUG_APPLET_FUNCS) {
            System.out.printf("Exiting:  %s.start <--\r\n", CRhinoApplet.class.getName());
        }
    }

    @Override
    public void stop() {
        block4: {
            if (DEBUG_APPLET_FUNCS) {
                System.out.printf("Entering:  %s.stop -->\r\n", CRhinoApplet.class.getName());
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        CRhinoApplet.this.OnAppletStop();
                    }
                });
            }
            catch (Exception e) {
                if (!DEBUG) break block4;
                System.out.printf("%s.stop = catch exception | %s\r\n", CRhinoApplet.class.getName(), e.getMessage());
            }
        }
        m_Applet = null;
        super.stop();
        if (DEBUG_APPLET_FUNCS) {
            System.out.printf("Exiting:  %s.stop <--\r\n", CRhinoApplet.class.getName());
        }
    }

    @Override
    public void destroy() {
        if (DEBUG_APPLET_FUNCS) {
            System.out.printf("Entering:  %s.destroy -->\r\n", CRhinoApplet.class.getName());
        }
        if (this.m_tCommunicationThread != null) {
            this.m_tCommunicationThread.Destroy();
        }
        this.m_tCommunicationThread = null;
        if (this.m_asParms != null) {
            this.m_asParms.clear();
        }
        this.m_asParms = null;
        if (this.m_App != null) {
            this.m_App.Destroy();
        }
        this.m_App = null;
        super.destroy();
        if (DEBUG_APPLET_FUNCS) {
            System.out.printf("Exiting:  %s.destroy <--\r\n", CRhinoApplet.class.getName());
        }
    }

    protected void OnAppletInit() {
        if (DEBUG_ATTACH) {
            JOptionPane.showMessageDialog(null, "Attach debugger.");
        }
        this.InitParameters();
    }

    protected void InitOSAndBrowser() {
        this.m_OS = OS.UNKNOWN;
        this.m_Browser = BROWSER.UNKNOWN;
        String sUserAgent = this.GetUserAgent();
        if (sUserAgent != null && !sUserAgent.isEmpty()) {
            sUserAgent = sUserAgent.toLowerCase();
            if (DEBUG_USER_AGENT) {
                System.out.println("User-Agent: " + sUserAgent);
            }
            if (sUserAgent.indexOf("macintosh") >= 0) {
                this.m_OS = OS.MAC;
            } else if (sUserAgent.indexOf("linux") >= 0) {
                this.m_OS = OS.NIX;
            } else if (sUserAgent.indexOf("windows") >= 0) {
                this.m_OS = OS.WINDOWS;
            }
            if (sUserAgent.indexOf("chrome") >= 0) {
                this.m_Browser = BROWSER.CHROME;
            } else if (sUserAgent.indexOf("safari") >= 0) {
                this.m_Browser = BROWSER.SAFARI;
            } else if (sUserAgent.indexOf("opera") >= 0) {
                this.m_Browser = BROWSER.OPERA;
            } else if (sUserAgent.indexOf("firefox") >= 0) {
                this.m_Browser = BROWSER.FIREFOX;
            } else if (sUserAgent.indexOf("msie") >= 0) {
                this.m_Browser = BROWSER.IE;
            }
        } else {
            CLocalFileSystem lfs = CLocalFileSystem.GetLocalFileSystem();
            if (lfs != null) {
                if (lfs.IsMac()) {
                    this.m_OS = OS.MAC;
                } else if (lfs.IsNIX()) {
                    this.m_OS = OS.NIX;
                } else if (lfs.IsWindows()) {
                    this.m_OS = OS.WINDOWS;
                }
            }
        }
        this.m_bIsMicrosoftBrowser = false;
        String sAppName = this.GetAppName();
        if (sAppName != null && !sAppName.isEmpty() && (sAppName = sAppName.toLowerCase()).indexOf("microsoft") >= 0) {
            this.m_bIsMicrosoftBrowser = true;
        }
    }

    public void InitCommunicationThread() {
        this.m_tCommunicationThread = this.CreateCommunicationThread();
        this.InitOSAndBrowser();
    }

    protected void OnAppletStart() {
        this.m_App = this.CreateApp();
        if (this.m_App != null) {
            if (this.m_App.GetMainWnd() != null) {
                this.add(this.m_App.GetMainWnd());
            } else if (DEBUG) {
                System.out.println("Programming error: No Main Window is defined!");
            }
            if (this.m_App.GetMainWnd() != null) {
                this.m_App.GetMainWnd().setVisible(true);
                this.m_App.GetMainWnd().invalidate();
                this.m_App.GetMainWnd().repaint();
            }
        } else if (DEBUG) {
            System.out.println("ASSERT:  Programming error, m_App is NULL");
        }
    }

    protected CRhinoAppletCommThread CreateCommunicationThread() {
        return new CRhinoAppletCommThread(this, CRhinoApp.GET_RHINO_APP());
    }

    public void RemoveMainWnd() {
        if (this.m_App.GetMainWnd() != null) {
            this.remove(this.m_App.GetMainWnd());
        }
    }

    protected void OnAppletStop() {
        if (this.m_tCommunicationThread != null) {
            this.m_tCommunicationThread.PostQuit();
        }
        if (this.m_App != null) {
            this.m_App.OnShutdown();
        }
        this.m_asParms = null;
        this.m_App = null;
    }

    protected abstract CRhinoAppletApp CreateApp();

    protected String[] GetExpectedStartupParameters() {
        String[] asKeys = new String[]{"-debug", "-FutureFeatures", null};
        return asKeys;
    }

    private void InitParameters() {
        String[] asKeys = this.GetExpectedStartupParameters();
        for (int nIdx = 0; nIdx < asKeys.length; ++nIdx) {
            String sKey = asKeys[nIdx];
            if (sKey == null || sKey.isEmpty()) continue;
            String sVal = this.getParameter(sKey);
            this.AddParam(sKey, sVal);
            this.InitParameter(sKey, sVal);
            if (!DEBUG_PARMS) continue;
            System.out.printf("<param name=\"%s\" value=\"%s\">\r\n", sKey, sVal);
        }
    }

    protected void InitParameter(String sKey, String sVal) {
        if (sKey != null && !sKey.isEmpty()) {
            if (sKey.equals("-debug")) {
                String sFmt = String.format("%s,%s", sKey, sVal);
                String[] asArguments = new String[]{sFmt};
                CAttr.InitDebugFlag(asArguments);
            } else if (sKey.equals("-FutureFeatures")) {
                String sFmt = String.format("%s,%s", sKey, sVal);
                String[] asArguments = new String[]{sFmt};
                CAttr.InitFutureFeatureFlag(asArguments);
            }
        }
    }

    protected void AddParam(String sKey, String sValue) {
        if (this.m_asParms != null && sKey != null && !sKey.isEmpty()) {
            this.m_asParms.put(sKey, sValue);
        }
    }

    protected String GetParam(String sKey) {
        String sVal = null;
        if (this.m_asParms != null) {
            sVal = this.m_asParms.get(sKey);
        }
        return sVal;
    }

    @Override
    public void setVisible(boolean bIsVisible) {
        if (!bIsVisible && this.m_App != null && this.m_App.GetMainWnd() != null) {
            this.m_App.GetMainWnd().setVisible(bIsVisible);
        }
        super.setVisible(bIsVisible);
        if (bIsVisible && this.m_App != null && this.m_App.GetMainWnd() != null) {
            this.m_App.GetMainWnd().setVisible(bIsVisible);
        }
    }

    public boolean IsMacintoshOS() {
        return this.m_OS == OS.MAC;
    }

    public boolean IsInternetExplorerBrowser() {
        return this.m_Browser == BROWSER.IE;
    }

    public boolean IsOperaBrowser() {
        return this.m_Browser == BROWSER.OPERA;
    }

    public boolean IsChromeBrowser() {
        return this.m_Browser == BROWSER.CHROME;
    }

    public boolean IsSafariBrowser() {
        return this.m_Browser == BROWSER.SAFARI;
    }

    public boolean IsFirefoxBrowser() {
        return this.m_Browser == BROWSER.FIREFOX;
    }

    public boolean IsMicrosoftBrowser() {
        return this.m_bIsMicrosoftBrowser;
    }

    @Override
    public int getWidth() {
        int nWidth = super.getWidth();
        if (nWidth < 1) {
            nWidth = this.GetClientWidth();
        }
        return nWidth;
    }

    public void OnFetchDlgModalityType(CDialogModalityMsg rMsg) {
        if (rMsg != null) {
            Dialog.ModalityType nDlgType = Dialog.ModalityType.DOCUMENT_MODAL;
            rMsg.SetModalityType(nDlgType);
        }
    }

    public boolean GetSupportsFileExplorerDragDrop() {
        return false;
    }

    public boolean AllowDragDropStringFlavors() {
        return false;
    }

    public void SetAllowJSObject(boolean bAllowJSObject) {
        if (bAllowJSObject) {
            ++this.m_nAllowJSObjectCount;
            if (this.m_nAllowJSObjectCount == 1) {
                this.m_bAllowJSObject = bAllowJSObject;
            } else if (DEBUG && this.m_nAllowJSObjectCount > 1) {
                System.out.println("AllowJSObject > 1");
            }
        } else {
            --this.m_nAllowJSObjectCount;
            if (this.m_nAllowJSObjectCount == 0) {
                this.m_bAllowJSObject = bAllowJSObject;
            }
        }
    }

    public boolean GetAllowJSObject() {
        return this.m_bAllowJSObject;
    }

    protected CRhinoAppletCommThread GetCommunicationThread() {
        return this.m_tCommunicationThread;
    }

    public String GetUserAgent() {
        String sUserAgent = null;
        if (this.GetCommunicationThread() != null) {
            sUserAgent = this.GetCommunicationThread().SendGetUserAgent();
        }
        return sUserAgent;
    }

    public String GetAppName() {
        String sAppName = null;
        if (this.GetCommunicationThread() != null) {
            sAppName = this.GetCommunicationThread().SendGetAppName();
        }
        return sAppName;
    }

    public int GetClientWidth() {
        Integer rClientWidth;
        int nWidth = super.getWidth();
        if (this.GetCommunicationThread() != null && (rClientWidth = this.GetCommunicationThread().SendGetClientWidth()) != null) {
            nWidth = rClientWidth;
        }
        return nWidth;
    }

    public int GetClientHeight() {
        Integer rClientHeight;
        int nHeight = super.getHeight();
        if (this.GetCommunicationThread() != null && (rClientHeight = this.GetCommunicationThread().SendGetClientHeight()) != null) {
            nHeight = rClientHeight;
        }
        return nHeight;
    }

    public void OnFetchBrowserInfo(CFetchBrowserInfoMsg rMsg) {
        if (rMsg != null) {
            rMsg.SetOS(this.m_OS);
            rMsg.SetBrowser(this.m_Browser);
        }
    }

    public static CRhinoApplet GET_RHINO_APPLET() {
        return m_Applet;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_APPLET_FUNCS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_PARMS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_USER_AGENT = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_ATTACH = false;
    }

    public static enum BROWSER {
        UNKNOWN,
        IE,
        FIREFOX,
        CHROME,
        SAFARI,
        OPERA;

    }

    public static enum OS {
        UNKNOWN,
        WINDOWS,
        NIX,
        MAC;

    }
}

