/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui;

import com.rhinosoft.archive.IArchive;
import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.strings.CString;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

public class CRhinoTrayMenuItem
extends CAttr {
    private MenuItem m_MenuItem;
    private JMenuItem m_jMenuItem;

    public CRhinoTrayMenuItem(String sText) {
        this._CRhinoTrayMenuItem(sText);
    }

    private void _CRhinoTrayMenuItem(String sText) {
        this.m_MenuItem = new MenuItem();
        this.m_jMenuItem = new JMenuItem();
        this.SetText(sText);
    }

    public void SetText(String sText) {
        if (this.m_MenuItem != null) {
            Character ch = CString.GetMnemonic(sText);
            if (ch != null) {
                Integer rKeyCode = new Integer(ch.charValue());
                int nKeyCode = rKeyCode;
                this.m_MenuItem.setShortcut(new MenuShortcut(nKeyCode));
                if (this.m_jMenuItem != null) {
                    this.m_jMenuItem.setMnemonic(ch.charValue());
                }
            }
            sText = CString.RemoveMnemonic(sText);
            this.m_MenuItem.setLabel(sText);
            if (this.m_jMenuItem != null) {
                this.m_jMenuItem.setText(sText);
            }
        }
    }

    public void addActionListener(ActionListener rListener) {
        if (this.m_MenuItem != null) {
            this.m_MenuItem.addActionListener(rListener);
        }
        if (this.m_jMenuItem != null) {
            this.m_jMenuItem.addActionListener(rListener);
        }
    }

    public void removeActionListener(ActionListener rListener) {
        if (this.m_MenuItem != null) {
            this.m_MenuItem.removeActionListener(rListener);
        }
        if (this.m_jMenuItem != null) {
            this.m_jMenuItem.removeActionListener(rListener);
        }
    }

    public MenuItem GetMenuItem() {
        return this.m_MenuItem;
    }

    public JMenuItem GetJMenuItem() {
        return this.m_jMenuItem;
    }

    public void SetActionCmd(String sCmd) {
        if (this.m_jMenuItem != null) {
            this.m_jMenuItem.setActionCommand(sCmd);
        }
    }

    @Override
    public void Save(IArchive rArchive) {
        if (DEBUG) {
            CDebugLog.INFO("Not implemented.");
        }
    }

    @Override
    public void Load(IArchive rArchive) {
        if (DEBUG) {
            CDebugLog.INFO("Not implemented.");
        }
    }
}

