/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.ui.CRhinoAction;
import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class CRhinoTrayIcon
extends TrayIcon
implements MouseListener,
PopupMenuListener {
    public static boolean DEBUG = CAttr.DEBUG;
    public static boolean DEBUG_USE_AWT_POPUP;
    private PopupMenu m_AWTPopupMenu;
    private JPopupMenu m_SwingPopupMenu;
    private Window m_wndHidden;
    private boolean m_bIsVisible;

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPopupMenu popup = new JPopupMenu();
                popup.add(new JMenuItem("Item 1"));
                popup.add(new JMenuItem("Item 2"));
                JMenu submenu = new JMenu("Submenu");
                submenu.add(new JMenuItem("item 1"));
                submenu.add(new JMenuItem("item 2"));
                submenu.add(new JMenuItem("item 3"));
                popup.add(submenu);
                JMenuItem exitItem = new JMenuItem("Exit");
                exitItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.exit(0);
                    }
                });
                popup.add(exitItem);
                BufferedImage image = new BufferedImage(32, 32, 2);
                Graphics2D g2 = (Graphics2D)image.getGraphics();
                g2.setColor(Color.RED);
                g2.fill(new Ellipse2D.Float(0.0f, 0.0f, image.getWidth(), image.getHeight()));
                g2.dispose();
                CRhinoTrayIcon tray = new CRhinoTrayIcon((Image)image, "Rhino Tray App", popup);
                try {
                    SystemTray.getSystemTray().add(tray);
                }
                catch (AWTException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public CRhinoTrayIcon(Image rTrayImage, String sTrayToolTip, JPopupMenu rPopupMenu) {
        super(rTrayImage, sTrayToolTip);
        this._CRhinoTrayIcon(rPopupMenu);
    }

    private void _CRhinoTrayIcon(JPopupMenu rPopupMenu) {
        this.m_bIsVisible = false;
        this.addMouseListener(this);
        this.m_AWTPopupMenu = new PopupMenu();
        this.SetPopupMenu(rPopupMenu);
    }

    private boolean UseSwingPopup() {
        boolean bUseJPopup = true;
        if (CLocalFileSystem.GetLocalFileSystem().IsMac()) {
            bUseJPopup = false;
        } else if (CLocalFileSystem.GetLocalFileSystem().IsNIX()) {
            bUseJPopup = false;
        }
        if (DEBUG_USE_AWT_POPUP) {
            bUseJPopup = false;
        }
        return bUseJPopup;
    }

    public final JPopupMenu GetSwingPopupMenu() {
        return this.m_SwingPopupMenu;
    }

    public final void SetPopupMenu(JPopupMenu rPopupMenu) {
        if (this.m_SwingPopupMenu != null) {
            this.m_SwingPopupMenu.removePopupMenuListener(this);
        }
        this.m_SwingPopupMenu = rPopupMenu;
        this.m_SwingPopupMenu.addPopupMenuListener(this);
    }

    private MenuItem CreateAWTMenuItem(JMenuItem rSwingMenuItem) {
        MenuItem rMenuItem = null;
        if (rSwingMenuItem != null && (rMenuItem = rSwingMenuItem instanceof JCheckBoxMenuItem ? new CCheckboxMenuItem((JCheckBoxMenuItem)rSwingMenuItem) : new CMenuItem(rSwingMenuItem)) != null) {
            rMenuItem.setActionCommand(rSwingMenuItem.getActionCommand());
        }
        return rMenuItem;
    }

    private void InitAWTPopupMenu(JComponent rSwingMenuComp, PopupMenu rPopupMenu, Menu rSubMenu) {
        if (rSwingMenuComp != null && rPopupMenu != null) {
            int nMax = rSwingMenuComp.getComponentCount();
            if (rSwingMenuComp instanceof JMenu) {
                nMax = ((JMenu)rSwingMenuComp).getMenuComponentCount();
            }
            MenuItem rMenuItem = null;
            for (int nIdx = 0; nIdx < nMax; ++nIdx) {
                Component rNextComp = null;
                rNextComp = rSwingMenuComp instanceof JMenu ? ((JMenu)rSwingMenuComp).getMenuComponent(nIdx) : rSwingMenuComp.getComponent(nIdx);
                if (rNextComp instanceof JMenu) {
                    JMenu rNextMenu = (JMenu)rNextComp;
                    Menu subMenu = new Menu(rNextMenu.getText());
                    subMenu.setActionCommand(rNextMenu.getActionCommand());
                    this.InitAWTPopupMenu(rNextMenu, rPopupMenu, subMenu);
                    if (rSubMenu != null) {
                        rSubMenu.add(subMenu);
                        continue;
                    }
                    rPopupMenu.add(subMenu);
                    continue;
                }
                if (rNextComp instanceof JMenuItem) {
                    JMenuItem rNextMenuItem = (JMenuItem)rNextComp;
                    rMenuItem = this.CreateAWTMenuItem(rNextMenuItem);
                    if (rSubMenu != null) {
                        rSubMenu.add(rMenuItem);
                        continue;
                    }
                    rPopupMenu.add(rMenuItem);
                    continue;
                }
                if (!(rNextComp instanceof JSeparator)) continue;
                if (rSubMenu != null) {
                    rSubMenu.addSeparator();
                    continue;
                }
                rPopupMenu.addSeparator();
            }
        }
    }

    private void InitAWTPopupMenu() {
        if (this.m_SwingPopupMenu != null && this.m_AWTPopupMenu != null) {
            this.m_AWTPopupMenu.removeAll();
            this.InitAWTPopupMenu(this.m_SwingPopupMenu, this.m_AWTPopupMenu, null);
        }
    }

    public final PopupMenu GetAWTPopupMenu() {
        return this.m_AWTPopupMenu;
    }

    private final void ShowPopupMenu(MouseEvent rEvent) {
        if (rEvent.isPopupTrigger()) {
            if (this.UseSwingPopup()) {
                if (this.m_wndHidden == null) {
                    if (CLocalFileSystem.GetLocalFileSystem().IsWindows()) {
                        this.m_wndHidden = new JDialog((Frame)null);
                        ((JDialog)this.m_wndHidden).setUndecorated(true);
                    } else {
                        this.m_wndHidden = new JWindow((Frame)null);
                    }
                    this.m_wndHidden.setAlwaysOnTop(true);
                    Dimension size = this.m_SwingPopupMenu.getPreferredSize();
                    Point centerPoint = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
                    if ((double)rEvent.getY() > centerPoint.getY()) {
                        this.m_wndHidden.setLocation(rEvent.getX(), rEvent.getY() - size.height);
                    } else {
                        this.m_wndHidden.setLocation(rEvent.getX(), rEvent.getY());
                    }
                    this.m_wndHidden.setVisible(true);
                    this.m_SwingPopupMenu.show(((RootPaneContainer)((Object)this.m_wndHidden)).getContentPane(), 0, 0);
                    this.m_wndHidden.toFront();
                }
            } else {
                this.setPopupMenu(null);
                this.InitAWTPopupMenu();
                this.setPopupMenu(this.GetAWTPopupMenu());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent rEvent) {
    }

    @Override
    public void mousePressed(MouseEvent rEvent) {
        this.ShowPopupMenu(rEvent);
    }

    @Override
    public void mouseReleased(MouseEvent rEvent) {
        this.ShowPopupMenu(rEvent);
    }

    @Override
    public void mouseEntered(MouseEvent rEvent) {
    }

    @Override
    public void mouseExited(MouseEvent rEvent) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent rEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent rEvent) {
        this.DestroyHiddenWnd();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent rEvent) {
        this.DestroyHiddenWnd();
    }

    private void DestroyHiddenWnd() {
        if (this.m_wndHidden != null) {
            this.m_wndHidden.dispose();
            this.m_wndHidden = null;
        }
    }

    public boolean PutOnOSTray() {
        boolean bSuccessful;
        block2: {
            bSuccessful = false;
            try {
                SystemTray.getSystemTray().add(this);
                this.m_bIsVisible = true;
                bSuccessful = true;
            }
            catch (AWTException e) {
                if (!DEBUG) break block2;
                System.err.println("TrayIcon could not be added to the System Tray.");
            }
        }
        return bSuccessful;
    }

    public boolean RemoveFromOSTray() {
        boolean bSuccessful;
        block2: {
            bSuccessful = false;
            try {
                SystemTray.getSystemTray().remove(this);
                this.m_bIsVisible = false;
                bSuccessful = true;
            }
            catch (Exception e) {
                if (!DEBUG) break block2;
                System.err.println("TrayIcon could not be added to the System Tray.");
            }
        }
        return bSuccessful;
    }

    public boolean IsVisible() {
        return this.m_bIsVisible;
    }

    public static boolean IsOSTraySupported() {
        return SystemTray.isSupported();
    }

    public void OnDestroy() {
        if (this.IsVisible()) {
            this.RemoveFromOSTray();
        }
        if (this.m_AWTPopupMenu != null) {
            this.m_AWTPopupMenu = null;
        }
        if (this.m_SwingPopupMenu != null) {
            this.m_SwingPopupMenu = null;
        }
        this.DestroyHiddenWnd();
    }

    public void OnMessage(CAttrMsg rMsg) {
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 3010: 
                case 3202: 
                case 3203: 
                case 3204: 
                case 3205: 
                case 3207: 
                case 3208: 
                case 3211: 
                case 3212: 
                case 3213: 
                case 3215: 
                case 3217: 
                case 3218: 
                case 3219: {
                    if (this.GetSwingPopupMenu() == null) break;
                    SwingUtilities.updateComponentTreeUI(this.GetSwingPopupMenu());
                    break;
                }
            }
        }
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_USE_AWT_POPUP = false;
    }

    private class CCheckboxMenuItem
    extends CheckboxMenuItem
    implements ActionListener,
    ItemListener {
        private JCheckBoxMenuItem m_rSwingMenuItem;

        public CCheckboxMenuItem(JCheckBoxMenuItem rSwingMenuItem) {
            super(rSwingMenuItem.getText());
            this.setState(rSwingMenuItem.isSelected());
            this.m_rSwingMenuItem = rSwingMenuItem;
            this.addActionListener(this);
            this.addItemListener(this);
        }

        public JCheckBoxMenuItem GetSwingMenuItem() {
            return this.m_rSwingMenuItem;
        }

        @Override
        public void actionPerformed(ActionEvent rEvent) {
            if (this.GetSwingMenuItem() != null) {
                this.GetSwingMenuItem().doClick();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent rEvent) {
            if (this.GetSwingMenuItem() != null) {
                this.GetSwingMenuItem().doClick();
            }
        }
    }

    private class CMenuItem
    extends MenuItem
    implements ActionListener {
        private JMenuItem m_rSwingMenuItem;

        public CMenuItem(JMenuItem rSwingMenuItem) {
            super(rSwingMenuItem.getText());
            this.m_rSwingMenuItem = rSwingMenuItem;
            this.addActionListener(this);
        }

        public JMenuItem GetSwingMenuItem() {
            return this.m_rSwingMenuItem;
        }

        public CRhinoAction GetAction() {
            CRhinoAction rAction = null;
            if (this.GetSwingMenuItem() != null) {
                if (this.GetSwingMenuItem().getAction() != null && this.GetSwingMenuItem().getAction() instanceof CRhinoAction) {
                    rAction = (CRhinoAction)this.GetSwingMenuItem().getAction();
                } else if (DEBUG) {
                    CDebugLog.ASSERT(CRhinoTrayIcon.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  wrong action type.");
                }
            }
            return rAction;
        }

        @Override
        public void actionPerformed(ActionEvent rEvent) {
            if (this.GetSwingMenuItem() != null) {
                this.GetSwingMenuItem().doClick();
            }
        }
    }
}

