/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui;

import com.rhinosoft.attrs.CAttrs;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.ui.CRhinoAction;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.CRhinoTrayIcon;
import com.rhinosoft.ui.CRhinoTrayStateItem;
import com.rhinosoft.ui.CRhinoTrayStateItemDefault;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class CRhinoTray
extends CAttrs
implements ActionListener {
    public static boolean DEBUG_DRAW_TRAY_ICON = true;
    public static boolean DEBUG_TRACK_EVENTS = DEBUG;
    public static final int KEY_STATE_ITEM_DEFAULT = 0;
    protected CRhinoTrayIcon m_TrayIcon;
    protected JPopupMenu m_PopupMenu;
    protected CRhinoTrayStateItem m_DefaultState;

    public static void main(String[] asArguments) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CRhinoTray rTray = new CRhinoTray(1L, false);
                JFrame rFrame = new JFrame();
                rFrame.setDefaultCloseOperation(2);
                rFrame.setVisible(true);
            }
        });
    }

    public CRhinoTray(long lUniqueID) {
        super(lUniqueID);
        this._CRhinoTray(false);
    }

    public CRhinoTray(long lUniqueID, boolean bAutosizeTrayImages) {
        super(lUniqueID);
        this._CRhinoTray(bAutosizeTrayImages);
    }

    private void _CRhinoTray(boolean bAutosizeTrayImages) {
        this.m_DefaultState = this.CreateDefaultStateItem();
        if (CRhinoTray.IsOSTraySupported()) {
            if (this.m_DefaultState == null || this.m_DefaultState.GetImage() == null) {
                System.err.println("CRhinoTray needs a rendered icon!");
            }
            this.m_PopupMenu = new JPopupMenu();
            this.InitPopupMenuItems(this.m_PopupMenu);
            Image rImage = null;
            if (this.m_DefaultState != null) {
                rImage = this.m_DefaultState.GetImage();
            }
            if (DEBUG_DRAW_TRAY_ICON && rImage == null) {
                BufferedImage image = new BufferedImage(32, 32, 2);
                Graphics2D g2 = (Graphics2D)image.getGraphics();
                g2.setColor(Color.RED);
                g2.fill(new Ellipse2D.Float(0.0f, 0.0f, image.getWidth(), image.getHeight()));
                g2.dispose();
                rImage = image;
                System.out.println("WARNING:  CRhinoTray has to have a rendered icon, otherwise it will fail!");
            }
            this.m_TrayIcon = new CRhinoTrayIcon(rImage, this.m_DefaultState.GetToolTip(), this.m_PopupMenu);
            this.m_TrayIcon.setImageAutoSize(bAutosizeTrayImages);
            this.m_TrayIcon.addActionListener(this);
            this.m_TrayIcon.PutOnOSTray();
        } else {
            System.err.println("CRhinoTray failed to create System Tray.");
        }
    }

    public void OnDestroy() {
        if (this.GetTrayIcon() != null) {
            this.GetTrayIcon().OnDestroy();
            this.m_TrayIcon = null;
            this.m_PopupMenu = null;
            this.m_DefaultState = null;
        }
    }

    public static boolean IsOSTraySupported() {
        return SystemTray.isSupported();
    }

    protected CRhinoTrayStateItem CreateDefaultStateItem() {
        if (DEBUG) {
            JOptionPane.showMessageDialog(null, "ASSERT:  Supposed to be sub-classed and overridden.");
        }
        return new CRhinoTrayStateItemDefault();
    }

    @Override
    public void actionPerformed(ActionEvent rEvent) {
        if (DEBUG_TRACK_EVENTS) {
            System.out.println(String.format("CRhinoTray.actionPerformed(ID=%d) on %s.", rEvent.getID(), rEvent.getSource().getClass().getName()));
        }
        if (rEvent.getSource() == this.GetTrayIcon() && DEBUG_TRACK_EVENTS) {
            System.out.println("actionPerformed from TrayIcon");
        }
    }

    protected void OnExit() {
        if (this.GetTrayIcon() != null) {
            this.GetTrayIcon().RemoveFromOSTray();
        }
    }

    public void ShowTrayBubble(String sTitle, String sMsg, TrayIcon.MessageType nType) {
        if (this.GetTrayIcon() != null) {
            this.GetTrayIcon().displayMessage(sTitle, sMsg, nType);
        }
    }

    public void ShowTrayImage(Image rImage) {
        if (this.GetTrayIcon() != null) {
            this.GetTrayIcon().setImage(rImage);
        }
    }

    public void ShowTrayTip(String sTrayTip) {
        if (this.GetTrayIcon() != null) {
            this.GetTrayIcon().setToolTip(sTrayTip);
        }
    }

    public void ShowState(CRhinoTrayStateItem rStateItem) {
        if (rStateItem != null) {
            this.ShowTrayImage(rStateItem.GetImage());
            this.ShowTrayTip(rStateItem.GetToolTip());
        }
    }

    protected CRhinoTrayStateItem GetDefaultStateItem() {
        return this.m_DefaultState;
    }

    protected void InitPopupMenuItems(JPopupMenu rPopupMenu) {
        if (rPopupMenu != null) {
            CRhinoAction rAction = CRhinoApp.GET_RHINO_APP().GetAction(3003);
            JMenuItem rItem = new JMenuItem(rAction);
            rItem.addActionListener(this);
            rPopupMenu.add(rItem);
        }
    }

    protected CRhinoTrayIcon GetTrayIcon() {
        return this.m_TrayIcon;
    }

    public boolean IsVisible() {
        boolean bIsVisible = false;
        if (this.GetTrayIcon() != null) {
            bIsVisible = this.GetTrayIcon().IsVisible();
        }
        return bIsVisible;
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        super.OnMessage(rMsg);
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                default: 
            }
        }
        if (this.GetTrayIcon() != null) {
            this.GetTrayIcon().OnMessage(rMsg);
        }
    }
}

