/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CUIMessage;
import com.rhinosoft.ui.CRhinoApp;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class CRhinoStatusBar
extends JPanel {
    public static boolean DEBUG = CAttr.DEBUG;
    public static boolean DEBUG_STATUS_TXT;
    private JLabel m_cStatusArea;
    private JLabel m_cResizeArea;
    private String m_sCurStatusTxt;

    public CRhinoStatusBar() {
        this.InitVars();
    }

    protected abstract void LayoutControls();

    private void InitVars() {
        this.m_sCurStatusTxt = "";
        this.m_cStatusArea = new JLabel();
        if (this.GetStatusArea() != null) {
            this.GetStatusArea().setAlignmentY(1.0f);
        }
        this.m_cResizeArea = new JLabel();
        if (this.GetResizeArea() != null) {
            this.GetResizeArea().setAlignmentX(1.0f);
            this.GetResizeArea().setAlignmentY(1.0f);
        }
    }

    protected JLabel GetStatusArea() {
        return this.m_cStatusArea;
    }

    protected JLabel GetResizeArea() {
        return this.m_cResizeArea;
    }

    public void SetStatus(String sStatus) {
        if (sStatus == null) {
            sStatus = "";
        }
        if (this.GetStatusArea() != null) {
            this.SetCurStatusTxt(sStatus);
            this.GetStatusArea().setText(this.GetCurStatusTxt());
            if (DEBUG_STATUS_TXT) {
                System.out.printf("CRhinoStatusBar.SetStatus(%s)\r\n", this.GetCurStatusTxt());
            }
        }
    }

    private void SetCurStatusTxt(String sCurStatus) {
        if (sCurStatus == null) {
            sCurStatus = "";
        }
        if (this.m_sCurStatusTxt != null) {
            if (!this.m_sCurStatusTxt.equals(sCurStatus)) {
                this.m_sCurStatusTxt = sCurStatus;
            }
        } else {
            this.m_sCurStatusTxt = sCurStatus;
        }
    }

    protected String GetCurStatusTxt() {
        return this.m_sCurStatusTxt;
    }

    public void OnMessage(CAttrMsg rMsg) {
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 4000: {
                    if (rMsg instanceof CUIMessage) {
                        CUIMessage rUIMsg = (CUIMessage)rMsg;
                        this.SetStatus(rUIMsg.GetStatusBarText());
                        break;
                    }
                    if (!DEBUG) break;
                    CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  invalid message.", false);
                    break;
                }
            }
        }
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_STATUS_TXT = false;
    }
}

