/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.IRhinoOnMessage;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CUIMessage;
import com.rhinosoft.ui.CRhinoApp;
import java.awt.Container;

public class CRhinoHourGlassInfo
implements IRhinoOnMessage {
    public static boolean DEBUG = CAttr.DEBUG;
    private Container m_rOwner;
    private int m_nWantsHourglass = 0;
    private boolean m_bOverrideWantsHourglass = false;

    public CRhinoHourGlassInfo(Container rOwner) {
        this.m_rOwner = rOwner;
        this.m_nWantsHourglass = 0;
        this.m_bOverrideWantsHourglass = false;
    }

    public void TurnOnOverride() {
        this.m_bOverrideWantsHourglass = true;
    }

    public void TurnOffOverride() {
        this.m_bOverrideWantsHourglass = false;
    }

    private boolean WantsHourglass() {
        boolean bWantsHourglass;
        boolean bl = bWantsHourglass = this.m_nWantsHourglass > 0;
        if (bWantsHourglass && this.m_bOverrideWantsHourglass) {
            bWantsHourglass = false;
        }
        return bWantsHourglass;
    }

    private void IncWantHourglass() {
        this.m_nWantsHourglass = this.m_nWantsHourglass < 0 ? 0 : ++this.m_nWantsHourglass;
    }

    private void DecWantHourglass() {
        this.m_nWantsHourglass = this.m_nWantsHourglass > 0 ? --this.m_nWantsHourglass : 0;
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 3490: 
                case 3491: {
                    if (rMsg instanceof CUIMessage) {
                        CUIMessage rUIMsg = (CUIMessage)rMsg;
                        this.HandleMessage(rUIMsg);
                        break;
                    }
                    if (!DEBUG) break;
                    CDebugLog.ASSERT(CRhinoHourGlassInfo.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid argument");
                    break;
                }
                case 3492: 
                case 3493: {
                    if (rMsg instanceof CUIMessage) {
                        CUIMessage rUIMsg = (CUIMessage)rMsg;
                        if (this.m_rOwner != rUIMsg.GetSource()) break;
                        this.HandleMessage(rUIMsg);
                        break;
                    }
                    if (!DEBUG) break;
                    CDebugLog.ASSERT(CRhinoHourGlassInfo.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid argument");
                    break;
                }
            }
        }
    }

    private void HandleMessage(CUIMessage rMsg) {
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 3491: {
                    Object[] aObjs = (Object[])rMsg.GetAttachedObject();
                    if (this.m_rOwner.getMousePosition(true) == null) break;
                    boolean bWantsHourglass = this.WantsHourglass();
                    if (aObjs.length <= 0) break;
                    aObjs[0] = bWantsHourglass;
                    break;
                }
                case 3490: {
                    Boolean rbReset;
                    CUIMessage rUIMsg;
                    Object[] aObjs;
                    if (!(rMsg instanceof CUIMessage) || (aObjs = (Object[])(rUIMsg = rMsg).GetAttachedObject()) == null) break;
                    if (CRhinoApp.GET_RHINO_APP() != null) {
                        CRhinoApp.GET_RHINO_APP().SetCursor(rMsg, this.m_rOwner);
                    }
                    if (aObjs.length <= 1 || (rbReset = (Boolean)aObjs[1]) == null || !rbReset.booleanValue()) break;
                    this.m_nWantsHourglass = 0;
                    break;
                }
                case 3492: {
                    this.IncWantHourglass();
                    break;
                }
                case 3493: {
                    this.DecWantHourglass();
                    break;
                }
            }
        }
    }

    public void PostBeginWaitCursor() {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().NewMessage(new CUIMessage(3492, this.m_rOwner));
        }
    }

    public void PostEndWaitCursor() {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().NewMessage(new CUIMessage(3493, this.m_rOwner));
        }
    }
}

