/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CUIMessage;
import com.rhinosoft.messages.CWorkerThreadMsg;
import com.rhinosoft.ui.CRhinoEvent;
import com.rhinosoft.ui.IRhinoEventQueue;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EmptyStackException;

public class CRhinoEventQueue
extends EventQueue {
    protected static boolean DEBUG = CAttr.DEBUG;
    protected static boolean DEBUG_DESTROY;
    public static final boolean DEBUG_TRACE_HOURGLASS;
    protected static final int MAX_EVENTS_TO_PROCESS = 10;
    private IRhinoEventQueue m_rTarget;

    public CRhinoEventQueue(IRhinoEventQueue rTarget) {
        this.m_rTarget = rTarget;
        this.Create();
    }

    public void Create() {
        if (DEBUG_DESTROY) {
            System.out.println("CRhinoEventQueue.Create -->");
        }
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(this);
        if (DEBUG_DESTROY) {
            System.out.println("CRhinoEventQueue.Create <--");
        }
    }

    public void Destroy() {
        block11: {
            if (DEBUG_DESTROY) {
                System.out.println("CRhinoEventQueue.Destroy -->");
            }
            AWTEvent rEvent = null;
            do {
                block10: {
                    if ((rEvent = this.peekEvent()) == null) continue;
                    try {
                        rEvent = this.getNextEvent();
                    }
                    catch (InterruptedException ex) {
                        if (!DEBUG_DESTROY) break block10;
                        CDebugLog.EXCEPTION(CRhinoEventQueue.class.getName(), CDebugLog.GetLineNumber(), "Could not get next event.", false);
                        ex.printStackTrace();
                    }
                }
                if (rEvent instanceof CRhinoEvent) {
                    int nMsgID = rEvent.getID();
                    if (rEvent.getSource() instanceof CWorkerThreadMsg) {
                        nMsgID = ((CWorkerThreadMsg)rEvent.getSource()).GetMsgID();
                    }
                    if (!DEBUG_DESTROY) continue;
                    System.out.println("CRhinoEventQueue.Destroy | CRhinoEvent | getNextEvent: " + nMsgID);
                    continue;
                }
                if (DEBUG_DESTROY) {
                    System.out.println("CRhinoEventQueue.Destroy | getNextEvent: " + rEvent.toString());
                }
                this.dispatchEvent(rEvent);
            } while (rEvent != null);
            try {
                this.pop();
            }
            catch (EmptyStackException ese) {
                if (!DEBUG_DESTROY) break block11;
                CDebugLog.EXCEPTION(CRhinoEventQueue.class.getName(), CDebugLog.GetLineNumber(), "Could not \"pop\" our event queue off.", false);
                ese.printStackTrace();
            }
        }
        if (DEBUG_DESTROY) {
            System.out.println("CRhinoEventQueue.Destroy <--");
        }
    }

    public void SetTarget(IRhinoEventQueue rTarget) {
        this.m_rTarget = rTarget;
    }

    public IRhinoEventQueue GetTarget() {
        return this.m_rTarget;
    }

    @Override
    protected void dispatchEvent(AWTEvent rAWTEvent) {
        boolean bHandled = false;
        if (rAWTEvent instanceof KeyEvent) {
            KeyEvent rEvent = (KeyEvent)rAWTEvent;
            if (rEvent.getKeyCode() == 9) {
                boolean bIsDlg;
                if (rEvent.getID() == 401 && !(bIsDlg = rEvent.getSource() instanceof Dialog)) {
                    CRhinoEvent rTabEvent = null;
                    rTabEvent = rEvent.isShiftDown() ? new CRhinoEvent(new CUIMessage(9498, this.GetTarget())) : new CRhinoEvent(new CUIMessage(9497, this.GetTarget()));
                    if (this.GetTarget() != null && rTabEvent != null) {
                        this.GetTarget().dispatchEvent(rTabEvent);
                        bHandled = true;
                    }
                }
            } else {
                if (rEvent.getKeyCode() == 27) {
                    this.SendChangeCursor(Cursor.getDefaultCursor(), true);
                }
                if (this.WantsHourglass()) {
                    rEvent.consume();
                    bHandled = true;
                }
            }
        } else if (rAWTEvent instanceof MouseEvent) {
            MouseEvent rEvent = (MouseEvent)rAWTEvent;
            if (rEvent.getID() == 501) {
                if (this.WantsHourglass()) {
                    rEvent.consume();
                    bHandled = true;
                }
            } else if (rEvent.getID() == 502) {
                if (this.WantsHourglass()) {
                    rEvent.consume();
                    bHandled = true;
                }
            } else if (rEvent.getID() == 500 || rEvent.getID() == 506) {
                if (this.WantsHourglass()) {
                    rEvent.consume();
                    bHandled = true;
                }
            } else if (rEvent.getID() == 503) {
                this.CheckForHourglass();
            }
        } else if (rAWTEvent instanceof CRhinoEvent && this.GetTarget() != null) {
            this.GetTarget().dispatchEvent(rAWTEvent);
            if (rAWTEvent.getID() == 3492 || rAWTEvent.getID() == 3493) {
                this.CheckForHourglass();
            }
            bHandled = true;
        }
        if (!bHandled) {
            super.dispatchEvent(rAWTEvent);
        }
    }

    private void SendChangeCursor(Cursor rCursor, boolean bReset) {
        if (this.GetTarget() != null) {
            Object[] aObjs = new Object[]{rCursor, bReset};
            this.GetTarget().dispatchEvent(new CRhinoEvent(new CUIMessage(3490, this.GetTarget(), (Object)aObjs)));
        }
    }

    private void CheckForHourglass() {
        Cursor cCursor = Cursor.getDefaultCursor();
        if (this.WantsHourglass()) {
            cCursor = Cursor.getPredefinedCursor(3);
        }
        this.SendChangeCursor(cCursor, false);
    }

    private boolean WantsHourglass() {
        boolean bWantsHourglass = false;
        if (this.GetTarget() != null && MouseInfo.getPointerInfo() != null) {
            Point ptMouseOnScreen = MouseInfo.getPointerInfo().getLocation();
            Object[] aObjs = new Object[]{false, ptMouseOnScreen};
            CRhinoEvent rEvent = new CRhinoEvent(new CUIMessage(3491, this.GetTarget(), (Object)aObjs));
            this.GetTarget().dispatchEvent(rEvent);
            Boolean brAskWantsHourglass = (Boolean)aObjs[0];
            if (brAskWantsHourglass != null) {
                bWantsHourglass = brAskWantsHourglass;
            }
        }
        if (DEBUG_TRACE_HOURGLASS) {
            System.out.printf("Wants Hourglass: %s\r\n", Boolean.toString(bWantsHourglass));
        }
        return bWantsHourglass;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_DESTROY = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACE_HOURGLASS = false;
    }
}

