/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui;

import com.rhinosoft.archive.CRhinoArchive;
import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.CBoolAttr;
import com.rhinosoft.attrs.CColorAttr;
import com.rhinosoft.attrs.CConnectionAttrs;
import com.rhinosoft.attrs.CContainerAttr;
import com.rhinosoft.attrs.CIntAttr;
import com.rhinosoft.attrs.CStringURLAttr;
import com.rhinosoft.dialogs.CRhinoMessageBox;
import com.rhinosoft.files.CFile;
import com.rhinosoft.files.cache.CRhinoFileInfoCache;
import com.rhinosoft.images.CCachedImageIcon;
import com.rhinosoft.images.CGraphicsUtilities;
import com.rhinosoft.images.CJarImages;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAllowJSObjectMsg;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CConnectionInfoMsg;
import com.rhinosoft.messages.CDialogModalityMsg;
import com.rhinosoft.messages.CDialogShowMsg;
import com.rhinosoft.messages.CFetchBrowserInfoMsg;
import com.rhinosoft.messages.CFetchCurWorkingDirMsg;
import com.rhinosoft.messages.CHelpDocMsg;
import com.rhinosoft.messages.CListing;
import com.rhinosoft.messages.CLocalListing;
import com.rhinosoft.messages.CNoopMsg;
import com.rhinosoft.messages.CRemoteListing;
import com.rhinosoft.messages.CRightClickMsg;
import com.rhinosoft.messages.CUIMessage;
import com.rhinosoft.messages.CUpdateCenterPointMsg;
import com.rhinosoft.messages.CWorkerThreadMsg;
import com.rhinosoft.net.HTTP.SU.CSUConnection;
import com.rhinosoft.net.HTTP.SU.CSUURLFactory;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.threads.CWorkerThread;
import com.rhinosoft.ui.CActionFactory;
import com.rhinosoft.ui.CLookAndFeel;
import com.rhinosoft.ui.CRhinoAction;
import com.rhinosoft.ui.CRhinoEvent;
import com.rhinosoft.ui.CRhinoEventQueue;
import com.rhinosoft.ui.IRhinoConsts;
import com.rhinosoft.ui.IRhinoEventQueue;
import com.rhinosoft.ui.controls.CLanguageComboBox;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class CRhinoApp
extends CWorkerThread
implements IRhinoEventQueue {
    public static boolean DEBUG_ICED_TEA;
    public static boolean DEBUG_ON_MESSAGES;
    public static boolean DEBUG_SHOW_LOCALHOST_WARNING;
    public static boolean DEBUG_PACE_IT_TO_CHECK_GUI;
    public static boolean DEBUG_SHOW_EXTRA_XFER_COLS;
    public static boolean DEBUG_BROWSER_URLS;
    public static boolean DEBUG_CREATE_DEBUG_LOG;
    public static boolean DEBUG_ASSERT_ON_NON_RHINO_EVENTS;
    public static boolean DEBUG_TRANSFERS_IN_PROGRESS;
    public static final String STARTUP_PARAM_LOGIN = "-login";
    public static final String STARTUP_PARAM_PASSWORD = "-pw";
    public static final String STARTUP_PARAM_HOST = "-hh";
    public static final String STARTUP_PARAM_PORT = "-sp";
    public static final String STARTUP_PARAM_HEADER_PORT = "-hp";
    public static final String STARTUP_PARAM_ENC_SESSION_ID = "-esi";
    public static final String STARTUP_PARAM_SESSION_ID = "-si";
    public static final String STARTUP_PARAM_LOGIN_ID = "-li";
    public static final String STARTUP_PARAM_LOCALE_CODES = "-hl";
    public static final String STARTUP_PARAM_SUPPORT_URL = "-sl";
    public static final String STARTUP_PARAM_HEADER_URL = "-hu";
    public static final String STARTUP_PARAM_IS_SECURE = "-is";
    public static final String STARTUP_PARAM_CAN_CHANGE_PWORD = "-ccp";
    public static final String STARTUP_PARAM_IS_LOCAL_ADMIN = "-ila";
    public static final String STARTUP_PARAM_USER_EMAIL_ADDRESS = "-uea";
    public static final String STARTUP_PARAM_USER_CAN_SET_EMAIL_ADDRESS = "-csea";
    public static final String STARTUP_PARAM_DEBUG_MEDIA = "-debugMedia";
    public static final String STARTUP_PARAM_DEBUG_STARTUP_PARAMS = "-logStartupParms";
    public static final String STARTUP_PARAM_DEBUG_METHODS = "-logMethods";
    public static final String STARTUP_PARAM_DEBUG_THREAD_LIFE = "-logThreadLife";
    public static final String STARTUP_PARAM_DEBUG_THREAD_LIST = "-trackThreadList";
    public static final String STARTUP_PARAM_DEBUG_DLG_LIST = "-trackDialogList";
    public static final String STARTUP_PARAM_DEBUG_LOG_LEVEL = "-debugLogLevel";
    public static final int INITIAL_FRAME_WIDTH = 800;
    public static final int INITIAL_FRAME_HEIGHT = 600;
    public final boolean DEBUG_LOG_RAW_ARGUMENTS;
    public static int DEF_VERSION_MAJOR_1;
    public static int DEF_VERSION_MAJOR_2;
    public static int DEF_VERSION_MINOR_1;
    public static int DEF_VERSION_MINOR_2;
    protected static final String BUILD_DATE_KEY = "IDS_BUILD_DATE=";
    protected static final String BUILD_DATE_TOKEN = ",";
    public static final String JAR_PATH_TO_BIN_DIR = "/bin/";
    public static final String FILE_EXT_ARCHIVE = ".properties";
    public static final int TIMER_INITIAL_DELAY_NOOP = 50000;
    public static final int TIMER_DELAY_NOOP = 55000;
    private static final int KILL_THREAD_TIMEOUT = 5000;
    public static final String THUMB_CACHE_ROOT_DIR = "Thumbs";
    public static final String THUMB_CACHE_ROOT_DIR_LOCAL = "Local";
    public static final String THUMB_CACHE_ROOT_DIR_REMOTE = "Remote";
    private static final String PATH_TO_RHINO_STRINGS = "com/rhinosoft/strings/Strings";
    private boolean m_bUpgradeOldLocalStoragePathApp;
    private boolean m_bUpgradeOldLocalStoragePathFileTypes;
    private boolean m_bUpgradeOldLocalStoragePathHost;
    private String m_sAppName;
    private int m_nVersionMajor1;
    private int m_nVersionMajor2;
    private int m_nVersionMinor1;
    private int m_nVersionMinor2;
    private String[] m_asArguments;
    private CContainerAttr m_MainWndAttr;
    private static CDebugLog m_DebugLog;
    protected CConnectionAttrs m_ConnectionInfo;
    private CSUURLFactory m_URLFactory;
    private Date m_dtBuildDate;
    private CLookAndFeel m_LookAndFeel;
    private CRhinoEventQueue m_EventQueue;
    private CActionFactory m_ActionFactory;
    private CRhinoFileInfoCache m_FileInfoCache;
    private boolean m_bHasServerCommunication;
    private CBoolAttr m_bConfirmErrorNoop;
    private CBoolAttr m_bConfirmErrorOnCloseNoop;
    private Timer m_NoopTimer;
    private CWorkerThread m_tGeneralThread;
    private CIntAttr m_nNumOfTransferThreads;
    private CBoolAttr m_bColorRows;
    private CColorAttr m_clrEvenRows;
    private CColorAttr m_clrOddRows;
    private CBoolAttr m_bAutoExpandNewTransfers;
    private CBoolAttr m_bAutoStartNewTransfers;
    private CBoolAttr m_bAutoRemoveCompletedTransfers;
    private CBoolAttr m_bConfirmUploadFileOverwrites;
    private CBoolAttr m_bConfirmDownloadFileOverwrites;
    private CBoolAttr m_bConfirmUploadFolderOverwrites;
    private CBoolAttr m_bConfirmDownloadFolderOverwrites;
    private CBoolAttr m_bConfirmFileDeletes;
    private CBoolAttr m_bConfirmFolderDeletes;
    private CBoolAttr m_bConfirmMultiDeletes;
    private CBoolAttr m_bConfirmLogoutDlg;
    private CBoolAttr m_bConfirmTransferRelistDlg;
    private CBoolAttr m_bConfirmCancelCloseDlg;
    private CIntAttr m_nOptionUploadFileOverwrites;
    private CIntAttr m_nOptionDownloadFileOverwrites;
    private CIntAttr m_nOptionUploadFolderOverwrites;
    private CIntAttr m_nOptionDownloadFolderOverwrites;
    private Container m_rCurrentDialog;
    private Vector<CDialogShowMsg> m_vectDialogShowMsgs;
    private Container m_rPrevDialog;
    private boolean m_bShowingOpaqueLayer;
    private Point m_ptCenterPoint;
    private HashMap<String, CCachedImageIcon> m_aCachedImages;
    private CJarImages m_JarImages;
    private boolean m_bTriedIPv6Loopback;
    private boolean m_bTryingIPv6Loopback;
    private int m_nTransfersInProgressCounter;
    private long m_nIndex;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CRhinoApp(long lStaticUniqueID, String sAppName, String[] asArguments) {
        super(lStaticUniqueID, false);
        if (DEBUG) {
            // empty if block
        }
        this.DEBUG_LOG_RAW_ARGUMENTS = false;
        this.m_bUpgradeOldLocalStoragePathApp = false;
        this.m_bUpgradeOldLocalStoragePathFileTypes = false;
        this.m_bUpgradeOldLocalStoragePathHost = false;
        this.m_bHasServerCommunication = false;
        this.m_rCurrentDialog = null;
        this.m_bShowingOpaqueLayer = false;
        this.m_ptCenterPoint = null;
        this.m_bTriedIPv6Loopback = false;
        this.m_bTryingIPv6Loopback = false;
        this.m_nTransfersInProgressCounter = 0;
        this.m_nIndex = 0L;
        this._CRhinoApp(sAppName, asArguments);
    }

    private void _CRhinoApp(String sAppName, String[] asArguments) {
        this.SetHasCommunication(false);
        this.m_sAppName = sAppName;
        this.m_asArguments = asArguments;
        CAttr.InitDebugFlag(asArguments);
        CAttr.InitFutureFeatureFlag(asArguments);
        this.InitVersionNumbers();
        this.InitLoadingScreen();
        this.SendLoadScreenEvent(10, CString.LoadString("IDS_LOADING_SCREEN_1"));
        this.m_EventQueue = new CRhinoEventQueue(this);
        this.Start();
        if (DEBUG_CREATE_DEBUG_LOG) {
            m_DebugLog = this.CreateDebugLog();
            CDebugLog.INFO("Created debug log.");
        }
        this.m_ConnectionInfo = new CConnectionAttrs();
        this.DecodeArguments(asArguments);
        this.InitStartupHost(asArguments);
        this.InitStartupLocale(asArguments);
        this.LoadBuildDate();
        if (CString.DEBUG_STRING_TABLES) {
            this.StartSpeedTest();
        }
        this.SendLoadScreenEvent(30, CString.LoadString("IDS_LOADING_SCREEN_3"));
        this.InitStrings(this.GetLanguageCode(), this.GetCountryCode());
        if (CString.DEBUG_STRING_TABLES) {
            this.StopSpeedTest("Strings");
        }
        this.SendLoadScreenEvent(40, CString.LoadString("IDS_LOADING_SCREEN_4"));
        this.InitGeneralThread();
        this.SendLoadScreenEvent(50, CString.LoadString("IDS_LOADING_SCREEN_5"));
        this.m_FileInfoCache = this.CreateFileInfoCache();
        this.SendLoadScreenEvent(60, CString.LoadString("IDS_LOADING_SCREEN_7"));
        this.m_LookAndFeel = this.CreateLookAndFeel();
        this.InitImageCache();
        this.m_JarImages = this.CreateJarImages();
        this.InitStartupUser(asArguments);
        CConnectionAttrs rConnAttrs = this.GetConnectionAttrs();
        if (rConnAttrs != null) {
            this.InitURLFactory(rConnAttrs.IsSecure(), rConnAttrs.GetHost(), rConnAttrs.GetHeaderPort(), rConnAttrs.GetEncSessionID());
        }
        this.m_vectDialogShowMsgs = new Vector();
        this.SendLoadScreenEvent(70, CString.LoadString("IDS_LOADING_SCREEN_6"));
        this.SetArchive(this.CreateArchive());
        this.InitAttrs();
    }

    protected void InitMainWnd() {
        this.m_ActionFactory = this.CreateActionFactory();
        this.m_MainWndAttr = this.CreateMainWndAttr();
        this.PostOnCreate();
        this.PostOnLoadSession();
        this.PostUpdateUI();
        this.PostOnInitialUpdate();
        this.CheckCommunication();
    }

    public static String RhinoConstToString(int nID) {
        String sRet = "Unknown";
        switch (nID) {
            case 2100: {
                sRet = "ON_MSG_QUIT";
                break;
            }
            case 2101: {
                sRet = "ON_MSG_THREAD_STATUS_STARTED";
                break;
            }
            case 2102: {
                sRet = "ON_MSG_THREAD_STATUS_WAITING";
                break;
            }
            case 2103: {
                sRet = "ON_MSG_THREAD_STATUS_RUNNING";
                break;
            }
            case 2104: {
                sRet = "ON_MSG_THREAD_STATUS_DEAD";
                break;
            }
            case 3001: {
                sRet = "ON_MSG_FILE";
                break;
            }
            case 2015: {
                sRet = "ON_MSG_EXIT";
                break;
            }
            case 3003: {
                sRet = "ON_MSG_SHUTDOWN";
                break;
            }
            case 3100: {
                sRet = "ON_MSG_EDIT";
                break;
            }
            case 3101: {
                sRet = "ON_MSG_SELECT_ALL";
                break;
            }
            case 3102: {
                sRet = "ON_MSG_INVERT_SELECTION";
                break;
            }
            case 2024: {
                sRet = "ON_MSG_OPTIONS";
                break;
            }
            case 3104: {
                sRet = "ON_MSG_UPDATE_UI";
                break;
            }
            case 3200: {
                sRet = "ON_MSG_VIEW";
                break;
            }
            case 3201: {
                sRet = "ON_MSG_THEME";
                break;
            }
            case 3202: {
                sRet = "ON_MSG_LNF_METAL";
                break;
            }
            case 3203: {
                sRet = "ON_MSG_LNF_NIMBUS";
                break;
            }
            case 3204: {
                sRet = "ON_MSG_LNF_ECLIPSE3X";
                break;
            }
            case 3205: {
                sRet = "ON_MSG_LNF_ECLIPSE";
                break;
            }
            case 3206: {
                sRet = "ON_MSG_LNF_WINDOWS";
                break;
            }
            case 3207: {
                sRet = "ON_MSG_LNF_WINDOWS_DEFAULT";
                break;
            }
            case 3208: {
                sRet = "ON_MSG_LNF_WINDOWS_VSNET";
                break;
            }
            case 3209: {
                sRet = "ON_MSG_LNF_WINDOWS_OFFICE";
                break;
            }
            case 3010: {
                sRet = "ON_MSG_LNF_WINDOWS_OFFICE_DEFAULT";
                break;
            }
            case 3211: {
                sRet = "ON_MSG_LNF_WINDOWS_OFFICE_GRAY";
                break;
            }
            case 3212: {
                sRet = "ON_MSG_LNF_WINDOWS_OFFICE_HOMESTEAD";
                break;
            }
            case 3213: {
                sRet = "ON_MSG_LNF_WINDOWS_OFFICE_METALLIC";
                break;
            }
            case 3215: {
                sRet = "ON_MSG_LNF_WINDOWS_OFFICE_BLUE";
                break;
            }
            case 3217: {
                sRet = "ON_MSG_LNF_XERTO";
                break;
            }
            case 3218: {
                sRet = "ON_MSG_LNF_NIX_GTK_PLUS";
                break;
            }
            case 3219: {
                sRet = "ON_MSG_LNF_MAC_AQUA";
                break;
            }
            case 3230: {
                sRet = "ON_MSG_TOOLBARS";
                break;
            }
            case 3231: {
                sRet = "ON_MSG_TOGGLE_TOOLBAR";
                break;
            }
            case 3232: {
                sRet = "ON_MSG_TOGGLE_MAIN_TOOLBAR";
                break;
            }
            case 3233: {
                sRet = "ON_MSG_PANES";
                break;
            }
            case 3234: {
                sRet = "ON_MSG_TOGGLE_FRAME";
                break;
            }
            case 3243: {
                sRet = "ON_MSG_VIEWS";
                break;
            }
            case 3244: {
                sRet = "ON_MSG_VIEW_LARGE_ICONS";
                break;
            }
            case 3245: {
                sRet = "ON_MSG_VIEW_SMALL_ICONS";
                break;
            }
            case 3246: {
                sRet = "ON_MSG_VIEW_LIST";
                break;
            }
            case 3247: {
                sRet = "ON_MSG_VIEW_DETAILS";
                break;
            }
            case 3248: {
                sRet = "ON_MSG_VIEW_THUMBS";
                break;
            }
            case 3249: {
                sRet = "ON_MSG_VIEW_THUMBS_75x75";
                break;
            }
            case 3250: {
                sRet = "ON_MSG_VIEW_THUMBS_100x100";
                break;
            }
            case 3251: {
                sRet = "ON_MSG_VIEW_THUMBS_150x150";
                break;
            }
            case 3252: {
                sRet = "ON_MSG_VIEW_THUMBS_200x200";
                break;
            }
            case 3253: {
                sRet = "ON_MSG_VIEW_THUMBS_250x250";
                break;
            }
            case 3300: {
                sRet = "ON_MSG_WINDOWS";
                break;
            }
            case 3301: {
                sRet = "ON_MSG_FRAME_CLOSE";
                break;
            }
            case 3302: {
                sRet = "ON_MSG_FRAME_FLOATING";
                break;
            }
            case 3303: {
                sRet = "ON_MSG_FRAME_AUTO_HIDE";
                break;
            }
            case 3304: {
                sRet = "ON_MSG_FRAME_AUTO_HIDE_HIDE";
                break;
            }
            case 3305: {
                sRet = "ON_MSG_FRAME_AUTO_HIDE_SHOW";
                break;
            }
            case 3306: {
                sRet = "ON_MSG_FRAME_DOCKABLE";
                break;
            }
            case 3307: {
                sRet = "ON_MSG_FRAME_AUTO_HIDE_ALL";
                break;
            }
            case 3308: {
                sRet = "ON_MSG_FRAME_CLOSE_ALL";
                break;
            }
            case 3309: {
                sRet = "ON_MSG_FRAME_RESET_LAYOUT";
                break;
            }
            case 3310: {
                sRet = "ON_MSG_FRAME_ACTIVATE";
                break;
            }
            case 3311: {
                sRet = "ON_MSG_ACTIVATE_TRANSFER_FRAME";
                break;
            }
            case 3312: {
                sRet = "ON_MSG_SHOW_WINDOWS_DLG";
                break;
            }
            case 3400: {
                sRet = "ON_MSG_HELP";
                break;
            }
            case 2141: {
                sRet = "ON_MSG_HELP_TOPICS";
                break;
            }
            case 2142: {
                sRet = "ON_MSG_HELP_OVERVIEW";
                break;
            }
            case 3403: {
                sRet = "ON_MSG_KNOWLEDGE_BASE";
                break;
            }
            case 2143: {
                sRet = "ON_MSG_SUPPORT";
                break;
            }
            case 2144: {
                sRet = "ON_MSG_ABOUT";
                break;
            }
            case 3499: {
                sRet = "ON_MSG_CUSTOMIZE";
                break;
            }
            case 3519: {
                sRet = "ON_MSG_TRANSFER_OPEN_FILE";
                break;
            }
            case 3520: {
                sRet = "ON_MSG_TRANSFER_SHOW_IN_FOLDER";
                break;
            }
            case 3500: {
                sRet = "ON_MSG_TRANSFER_STOP_AT_NEXT_FILE";
                break;
            }
            case 3501: {
                sRet = "ON_MSG_TRANSFER_SKIP_FILE";
                break;
            }
            case 3502: {
                sRet = "ON_MSG_TRANSFER_PAUSE";
                break;
            }
            case 3503: {
                sRet = "ON_MSG_TRANSFER_RESUME";
                break;
            }
            case 3504: {
                sRet = "ON_MSG_TRANSFER_START";
                break;
            }
            case 3505: {
                sRet = "ON_MSG_TRANSFER_RESTART";
                break;
            }
            case 3506: {
                sRet = "ON_MSG_TRANSFER_CANCEL";
                break;
            }
            case 3507: {
                sRet = "ON_MSG_TRANSFER_REMOVE";
                break;
            }
            case 3509: {
                sRet = "ON_MSG_TRANSFER_REMOVE_ALL_COMPLETED";
                break;
            }
            case 3510: {
                sRet = "ON_MSG_TRANSFER_REMOVE_ALL_CANCELLED";
                break;
            }
            case 3511: {
                sRet = "ON_MSG_TRANSFER_REMOVE_ALL_SKIPPED";
                break;
            }
            case 3512: {
                sRet = "ON_MSG_TRANSFER_REMOVE_ALL_PAUSED";
                break;
            }
            case 3513: {
                sRet = "ON_MSG_TRANSFER_REMOVE_ALL_WAITING";
                break;
            }
            case 3514: {
                sRet = "ON_MSG_TRANSFER_REMOVE_ALL_STOPPED";
                break;
            }
            case 3515: {
                sRet = "ON_MSG_TRANSFER_REMOVE_ALL";
                break;
            }
            case 3516: {
                sRet = "ON_MSG_RESET_TOOLBAR";
                break;
            }
            case 3523: {
                sRet = "ON_MSG_UPDATE_VIEWPORT_COLOR";
                break;
            }
            case 3530: {
                sRet = "ON_MSG_UPDATE_CENTER_POINT";
                break;
            }
            case 4000: {
                sRet = "ON_MSG_SET_STATUS_TXT";
                break;
            }
            case 4001: {
                sRet = "ON_MSG_SAVE_DOCK_LAYOUT";
                break;
            }
            case 4004: {
                sRet = "ON_MSG_LOAD_ATTRS";
                break;
            }
            case 4005: {
                sRet = "ON_MSG_SAVE_ATTRS";
                break;
            }
            case 4020: {
                sRet = "ON_MSG_CREATE";
                break;
            }
            case 4021: {
                sRet = "ON_MSG_DESTORY";
                break;
            }
            case 4022: {
                sRet = "ON_MSG_INITIAL_UPDATE";
                break;
            }
            case 4023: {
                sRet = "ON_MSG_UPDATE_DYNAMIC_BTNS";
                break;
            }
            case 4024: {
                sRet = "ON_MSG_UPDATE_TRANSFER_BTNS";
                break;
            }
            case 4050: {
                sRet = "ON_MSG_DOCK_FRAME_ADDED";
                break;
            }
            case 4051: {
                sRet = "ON_MSG_DOCK_FRAME_REMOVED";
                break;
            }
            case 4052: {
                sRet = "ON_MSG_DOCK_FRAME_ACTIVATED";
                break;
            }
            case 4053: {
                sRet = "ON_MSG_DOCK_FRAME_DEACTIVATED";
                break;
            }
            case 4054: {
                sRet = "ON_MSG_DOCK_BAR_ADDED";
                break;
            }
            case 4055: {
                sRet = "ON_MSG_DOCK_BAR_REMOVED";
                break;
            }
            case 4060: {
                sRet = "ON_MSG_ADD_TOGGLE_DOCK_BAR_ITEMS_TO_POPUP";
                break;
            }
            case 4070: {
                sRet = "ON_MSG_REMOVED_MODEL_ITEM";
                break;
            }
            case 4200: {
                sRet = "ON_MSG_RECV_STARTED";
                break;
            }
            case 4201: {
                sRet = "ON_MSG_RECV_ERROR";
                break;
            }
            case 4202: {
                sRet = "ON_MSG_RECV_CONFIRM";
                break;
            }
            case 4203: {
                sRet = "ON_MSG_RECV_DONE";
                break;
            }
            case 4204: {
                sRet = "ON_MSG_RECV_UNKNOWN";
                break;
            }
            case 4210: {
                sRet = "ON_MSG_SEND_LIST";
                break;
            }
            case 4211: {
                sRet = "ON_MSG_RECV_LIST_PARENT";
                break;
            }
            case 4212: {
                sRet = "ON_MSG_RECV_LIST_CHILD";
                break;
            }
            case 4220: {
                sRet = "ON_MSG_SEND_NOOP";
                break;
            }
            case 4221: {
                sRet = "ON_MSG_SEND_MKDIR";
                break;
            }
            case 4222: {
                sRet = "ON_MSG_SEND_RENAME";
                break;
            }
            case 4223: {
                sRet = "ON_MSG_SEND_DELETE";
                break;
            }
            case 4224: {
                sRet = "ON_MSG_RECV_DELETE";
                break;
            }
            case 4225: {
                sRet = "ON_MSG_SEND_UPLOAD";
                break;
            }
            case 4226: {
                sRet = "ON_MSG_RECV_UPLOAD";
                break;
            }
            case 4227: {
                sRet = "ON_MSG_SEND_DOWNLOAD";
                break;
            }
            case 4228: {
                sRet = "ON_MSG_RECV_DOWNLOAD";
                break;
            }
            case 4234: {
                sRet = "ON_MSG_SEND_CACHE_IMAGE";
                break;
            }
            case 4235: {
                sRet = "ON_MSG_RECV_CACHE_IMAGE";
                break;
            }
            case 4244: {
                sRet = "ON_MSG_RETRY_NOOP";
                break;
            }
            case 4260: {
                sRet = "ON_MSG_RECV_NOOP";
                break;
            }
            case 4263: {
                sRet = "ON_MSG_RECV_UPLOADING";
                break;
            }
            case 4264: {
                sRet = "ON_MSG_RECV_DOWNLOADING";
                break;
            }
            case 4265: {
                sRet = "ON_MSG_RECV_DELETING";
                break;
            }
            case 4266: {
                sRet = "ON_MSG_RECV_TRANSFER_STATS";
                break;
            }
            case 4268: {
                sRet = "ON_MSG_RECV_TRANSFER_LISTED_SOURCE";
                break;
            }
            case 4269: {
                sRet = "ON_MSG_RECV_TRANSFERRED_TARGET_DIR";
                break;
            }
            case 4270: {
                sRet = "ON_MSG_RECV_TRANSFER_RETARGETED";
                break;
            }
            case 4300: {
                sRet = "ON_MSG_THREAD_IS_PROCESSING";
                break;
            }
            case 5000: {
                sRet = "ON_MSG_UPDATE_CONNECTION_INFO";
                break;
            }
            case 5001: {
                sRet = "ON_MSG_UPDATE_LOCALE";
                break;
            }
            case 5002: {
                sRet = "ON_MSG_DOWNLOAD_ITEMS";
                break;
            }
            case 5003: {
                sRet = "ON_MSG_UPLOAD_ITEMS";
                break;
            }
            case 5004: {
                sRet = "ON_MSG_DELETE_ITEMS";
                break;
            }
            case 5005: {
                sRet = "ON_MSG_SHOW_CONNECTION_INFO";
                break;
            }
            case 5006: {
                sRet = "ON_MSG_SHOW_LOCALE";
                break;
            }
            case 5015: {
                sRet = "ON_MSG_DIALOG_ADD_TO_QUEUE";
                break;
            }
            case 5016: {
                sRet = "ON_MSG_DIALOG_SHOW";
                break;
            }
            case 5017: {
                sRet = "ON_MSG_RIGHT_CLICK";
                break;
            }
        }
        return sRet;
    }

    protected void InitAttrs() {
        this.m_bConfirmErrorNoop = new CBoolAttr(true, true, "ConfirmErrorNoop");
        this.m_bConfirmErrorOnCloseNoop = new CBoolAttr(true, true, "ConfirmErrorOnCloseNoop");
        this.m_nNumOfTransferThreads = new CIntAttr(4, 4, "TransferNumOfThreads");
        boolean bDefault = false;
        this.m_bColorRows = new CBoolAttr(bDefault, bDefault, "TransferRowColorOn");
        Color clrDefault = UIManager.getColor("Table.background");
        this.m_clrOddRows = new CColorAttr(clrDefault, clrDefault, "TransferRowColorOdd");
        clrDefault = Color.decode("#eeeeee");
        this.m_clrEvenRows = new CColorAttr(clrDefault, clrDefault, "TransferRowColorEven");
        bDefault = true;
        this.m_bAutoExpandNewTransfers = new CBoolAttr(bDefault, bDefault, "AutoExpandNewTransfers");
        bDefault = true;
        this.m_bAutoStartNewTransfers = new CBoolAttr(bDefault, bDefault, "AutoStartNewTransfers");
        bDefault = false;
        this.m_bAutoRemoveCompletedTransfers = new CBoolAttr(bDefault, bDefault, "AutoRemoveCompletedTransfers");
        bDefault = true;
        this.m_bConfirmUploadFileOverwrites = new CBoolAttr(bDefault, bDefault, "ConfirmUploadFileOverwrites");
        bDefault = true;
        this.m_bConfirmDownloadFileOverwrites = new CBoolAttr(bDefault, bDefault, "ConfirmDownloadFileOverwrites");
        bDefault = true;
        this.m_bConfirmUploadFolderOverwrites = new CBoolAttr(bDefault, bDefault, "ConfirmUploadFolderOverwrites");
        bDefault = true;
        this.m_bConfirmDownloadFolderOverwrites = new CBoolAttr(bDefault, bDefault, "ConfirmDownloadFolderOverwrites");
        bDefault = true;
        this.m_bConfirmFileDeletes = new CBoolAttr(bDefault, bDefault, "ConfirmFileDeletes");
        bDefault = true;
        this.m_bConfirmFolderDeletes = new CBoolAttr(bDefault, bDefault, "ConfirmFolderDeletes");
        bDefault = true;
        this.m_bConfirmMultiDeletes = new CBoolAttr(bDefault, bDefault, "ConfirmMultiDeletes");
        bDefault = true;
        this.m_bConfirmLogoutDlg = new CBoolAttr(bDefault, bDefault, "ConfirmLogout");
        bDefault = true;
        this.m_bConfirmTransferRelistDlg = new CBoolAttr(bDefault, bDefault, "ConfirmTransferRelist");
        bDefault = true;
        this.m_bConfirmCancelCloseDlg = new CBoolAttr(bDefault, bDefault);
        int nDefault = 0;
        this.m_nOptionUploadFileOverwrites = new CIntAttr(nDefault, nDefault, "OptionUploadFileOverwrites");
        this.m_nOptionDownloadFileOverwrites = new CIntAttr(nDefault, nDefault, "OptionDownloadFileOverwrites");
        this.m_nOptionUploadFolderOverwrites = new CIntAttr(nDefault, nDefault, "OptionUploadFolderOverwrites");
        this.m_nOptionDownloadFolderOverwrites = new CIntAttr(nDefault, nDefault, "OptionDownloadFolderOverwrites");
    }

    private void InitGeneralThread() {
        this.m_tGeneralThread = this.CreateWorkerThread();
    }

    protected CWorkerThread CreateWorkerThread() {
        return new CWorkerThread(true);
    }

    public static CRhinoApp GET_RHINO_APP() {
        CAttr rAttr = CRhinoApp.FindGlobalAttr(1L);
        CRhinoApp rApp = null;
        if (rAttr instanceof CRhinoApp) {
            rApp = (CRhinoApp)rAttr;
        }
        if (rApp == null) {
            if (!$assertionsDisabled && rApp != null) {
                throw new AssertionError();
            }
            if (DEBUG) {
                System.out.println("CRhinoApp.GET_APP is null");
            }
        }
        return rApp;
    }

    protected abstract CDebugLog CreateDebugLog();

    public abstract void LayoutThemeMenu(JMenu var1);

    public abstract CSUURLFactory CreateURLFactory(boolean var1, String var2, long var3, String var5);

    public abstract CSUConnection CreateSUConnection(String var1, CConnectionAttrs var2, int var3);

    protected void InitStrings(String sLanguageCode, String sCountryCode) {
        CString.InitStringTable(PATH_TO_RHINO_STRINGS, sLanguageCode, sCountryCode);
    }

    protected CJarImages CreateJarImages() {
        return new CJarImages();
    }

    public final Locale GetUserLocale() {
        Locale rLocale = null;
        if (this.m_ConnectionInfo != null) {
            rLocale = this.m_ConnectionInfo.GetLocale();
        }
        return rLocale;
    }

    public final String GetLanguageCode() {
        String sLangCode = Locale.ENGLISH.getLanguage();
        if (this.m_ConnectionInfo != null) {
            sLangCode = this.m_ConnectionInfo.GetLanguageCode();
        }
        return sLangCode;
    }

    public final String GetCountryCode() {
        String sCountryCode = Locale.US.getCountry();
        if (this.m_ConnectionInfo != null) {
            sCountryCode = this.m_ConnectionInfo.GetCountryCode();
        }
        return sCountryCode;
    }

    public final String GetAppName() {
        return this.m_sAppName;
    }

    public final String[] GetArguments() {
        return this.m_asArguments;
    }

    private String[] DecodeArguments(String[] asArguments) {
        if (this.DEBUG_LOG_RAW_ARGUMENTS) {
            CDebugLog.INFO("RAW Program Arguments...");
        }
        if (asArguments != null) {
            for (int nIdx = 0; nIdx < asArguments.length; ++nIdx) {
                String sArgument = asArguments[nIdx];
                if (sArgument == null || sArgument.startsWith(STARTUP_PARAM_PASSWORD)) continue;
                String sDecoded = CStringURLAttr.URLDecode(sArgument);
                if (this.DEBUG_LOG_RAW_ARGUMENTS) {
                    CDebugLog.INFO(String.format("Argument:  %s | URLDecoded:  %s\r\n", sArgument, sDecoded));
                }
                if (sDecoded == null) continue;
                asArguments[nIdx] = sDecoded;
            }
        }
        if (this.DEBUG_LOG_RAW_ARGUMENTS) {
            CDebugLog.INFO("...RAW Program Arguments");
        }
        return asArguments;
    }

    private void InitStartupHost(String[] asArguments) {
        String[] asSplit;
        String sArgument = CAttr.GetStartupArgument(asArguments, STARTUP_PARAM_HOST);
        if (sArgument != null && !sArgument.isEmpty()) {
            asSplit = sArgument.split(BUILD_DATE_TOKEN);
            if (asSplit != null && asSplit.length == 2) {
                this.m_ConnectionInfo.SetHost(asSplit[1]);
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  invalid startup argument");
            }
        }
        if ((sArgument = CAttr.GetStartupArgument(asArguments, STARTUP_PARAM_PORT)) != null && !sArgument.isEmpty()) {
            asSplit = sArgument.split(BUILD_DATE_TOKEN);
            if (asSplit != null && asSplit.length == 2) {
                this.m_ConnectionInfo.SetServerPort(CIntAttr.ConvertToInt(asSplit[1]));
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  invalid startup argument");
            }
        }
        if ((sArgument = CAttr.GetStartupArgument(asArguments, STARTUP_PARAM_HEADER_PORT)) != null && !sArgument.isEmpty()) {
            asSplit = sArgument.split(BUILD_DATE_TOKEN);
            if (asSplit != null && asSplit.length == 2) {
                this.m_ConnectionInfo.SetHeaderPort(CIntAttr.ConvertToInt(asSplit[1]));
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  invalid startup argument");
            }
        }
        if ((sArgument = CAttr.GetStartupArgument(asArguments, STARTUP_PARAM_IS_SECURE)) != null && !sArgument.isEmpty()) {
            asSplit = sArgument.split(BUILD_DATE_TOKEN);
            if (asSplit != null && asSplit.length == 2) {
                boolean bIsSecure = false;
                int nSecure = CIntAttr.ConvertToInt(asSplit[1]);
                if (nSecure == 1) {
                    bIsSecure = true;
                }
                this.m_ConnectionInfo.SetIsSecure(bIsSecure);
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  invalid startup argument");
            }
        }
        if ((sArgument = CAttr.GetStartupArgument(asArguments, STARTUP_PARAM_ENC_SESSION_ID)) != null && !sArgument.isEmpty()) {
            asSplit = sArgument.split(BUILD_DATE_TOKEN);
            if (asSplit != null && asSplit.length == 2) {
                this.m_ConnectionInfo.SetEncSessionID(asSplit[1]);
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  invalid startup argument");
            }
        }
        this.m_ConnectionInfo.SetUserAgent(this.GetAppNameVersion());
        sArgument = CAttr.GetStartupArgument(asArguments, STARTUP_PARAM_SUPPORT_URL);
        if (sArgument != null && !sArgument.isEmpty()) {
            asSplit = sArgument.split(BUILD_DATE_TOKEN);
            if (asSplit != null && asSplit.length == 2) {
                this.m_ConnectionInfo.SetSupportLink(asSplit[1]);
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  invalid startup argument");
            }
        }
    }

    private void InitStartupLocale(String[] asArguments) {
        String sArgument = CRhinoApp.GetStartupArgument(asArguments, STARTUP_PARAM_LOCALE_CODES);
        if (sArgument != null && !sArgument.isEmpty()) {
            String sLanguageCode = "en";
            String sCountryCode = "US";
            String[] asSplit = sArgument.split(BUILD_DATE_TOKEN);
            if (asSplit != null && asSplit.length == 3) {
                sLanguageCode = asSplit[1];
                sCountryCode = asSplit[2];
            }
            this.m_ConnectionInfo.SetLocaleCodes(sLanguageCode, sCountryCode);
        }
    }

    protected void InitStartupUser(String[] asArguments) {
        boolean bVal;
        Integer nVal;
        String[] asSplit;
        String sArgument = CRhinoApp.GetStartupArgument(asArguments, STARTUP_PARAM_LOGIN_ID);
        if (sArgument != null && !sArgument.isEmpty()) {
            asSplit = sArgument.split(BUILD_DATE_TOKEN);
            if (asSplit != null && asSplit.length == 2) {
                this.m_ConnectionInfo.SetLoginID(asSplit[1]);
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  invalid startup argument");
            }
        }
        if ((sArgument = CRhinoApp.GetStartupArgument(asArguments, STARTUP_PARAM_CAN_CHANGE_PWORD)) != null && !sArgument.isEmpty()) {
            asSplit = sArgument.split(BUILD_DATE_TOKEN);
            if (asSplit != null && asSplit.length == 2) {
                nVal = Integer.parseInt(asSplit[1]);
                if (nVal != null) {
                    bVal = nVal != 0;
                    this.m_ConnectionInfo.SetCanChangePword(bVal);
                }
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  invalid startup argument");
            }
        }
        if ((sArgument = CRhinoApp.GetStartupArgument(asArguments, STARTUP_PARAM_IS_LOCAL_ADMIN)) != null && !sArgument.isEmpty()) {
            asSplit = sArgument.split(BUILD_DATE_TOKEN);
            if (asSplit != null && asSplit.length == 2) {
                nVal = Integer.parseInt(asSplit[1]);
                if (nVal != null) {
                    bVal = nVal != 0;
                    this.m_ConnectionInfo.SetIsLocalAdmin(bVal);
                }
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  invalid startup argument");
            }
        }
        if ((sArgument = CAttr.GetStartupArgument(asArguments, STARTUP_PARAM_USER_CAN_SET_EMAIL_ADDRESS)) != null && !sArgument.isEmpty()) {
            asSplit = sArgument.split(BUILD_DATE_TOKEN);
            if (asSplit != null && asSplit.length == 2) {
                nVal = Integer.parseInt(asSplit[1]);
                if (nVal != null) {
                    bVal = nVal != 0;
                    this.m_ConnectionInfo.SetUserCanSetEmailAddress(bVal);
                }
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  invalid startup argument");
            }
        }
        if ((sArgument = CAttr.GetStartupArgument(asArguments, STARTUP_PARAM_USER_EMAIL_ADDRESS)) != null && !sArgument.isEmpty()) {
            asSplit = sArgument.split(BUILD_DATE_TOKEN);
            if (asSplit != null && asSplit.length == 2) {
                this.m_ConnectionInfo.SetUserEmailAddress(asSplit[1]);
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  invalid startup argument");
            }
        }
    }

    public IRhinoConsts.CACHE_IMAGES_COMMON GetResellerImage() {
        IRhinoConsts.CACHE_IMAGES_COMMON rRet = null;
        String sLangCode = this.GetLanguageCode();
        if (sLangCode != null && !sLangCode.isEmpty()) {
            if ((sLangCode = sLangCode.toLowerCase()).equals(Locale.GERMAN.getLanguage())) {
                rRet = IRhinoConsts.CACHE_IMAGES_COMMON.IMG_RESELLER_GERMAN_PNG;
            } else if (sLangCode.equals(Locale.FRENCH.getLanguage())) {
                rRet = IRhinoConsts.CACHE_IMAGES_COMMON.IMG_RESELLER_FRENCH_PNG;
            } else if (sLangCode.equals(Locale.ITALIAN.getLanguage())) {
                rRet = IRhinoConsts.CACHE_IMAGES_COMMON.IMG_RESELLER_ITALIAN_PNG;
            } else if (sLangCode.equals(Locale.CHINESE.getLanguage())) {
                rRet = IRhinoConsts.CACHE_IMAGES_COMMON.IMG_RESELLER_CHINESE_PNG;
            } else if (sLangCode.equals(Locale.JAPANESE.getLanguage()) || sLangCode.equals("jp")) {
                rRet = IRhinoConsts.CACHE_IMAGES_COMMON.IMG_RESELLER_JAPANESE_PNG;
            } else if (sLangCode.equals("es")) {
                rRet = IRhinoConsts.CACHE_IMAGES_COMMON.IMG_RESELLER_SPANISH_PNG;
            } else if (sLangCode.equals("sr")) {
                rRet = IRhinoConsts.CACHE_IMAGES_COMMON.IMG_RESELLER_SERBIAN_PNG;
            }
        }
        return rRet;
    }

    public ImageIcon GetResellerLogo() {
        ImageIcon icoRet = null;
        IRhinoConsts.CACHE_IMAGES_COMMON rImage = this.GetResellerImage();
        if (rImage != null) {
            icoRet = CRhinoApp.GetImage(rImage.GetFileName());
        }
        return icoRet;
    }

    private void LoadBuildDate() {
        block8: {
            BufferedReader bufReader;
            block7: {
                Object rDate = null;
                bufReader = null;
                try {
                    InputStream rInStream = this.getClass().getResourceAsStream("/bin/BuildDate.txt");
                    bufReader = new BufferedReader(new InputStreamReader(rInStream));
                    if (bufReader == null) break block7;
                    String sLine = null;
                    while ((sLine = bufReader.readLine()) != null) {
                        String sIdentifier = BUILD_DATE_KEY;
                        int nStartIdx = sLine.indexOf(sIdentifier);
                        if (nStartIdx < 0) continue;
                        String sTemp = sLine.substring(nStartIdx + sIdentifier.length(), sLine.length());
                        String[] asItems = (sTemp = sTemp.trim()).split(BUILD_DATE_TOKEN);
                        if (asItems.length == 6) {
                            Calendar cCal = Calendar.getInstance(TimeZone.getTimeZone("CST"), new Locale("en", "US"));
                            int nYear = Integer.parseInt(asItems[0]);
                            int nMonth = Integer.parseInt(asItems[1]);
                            int nDay = Integer.parseInt(asItems[2]);
                            int nHour = Integer.parseInt(asItems[3]);
                            int nMin = Integer.parseInt(asItems[4]);
                            int nSec = Integer.parseInt(asItems[5]);
                            cCal.set(nYear, nMonth - 1, nDay, nHour, nMin, nSec);
                            this.m_dtBuildDate = cCal.getTime();
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    if (!DEBUG) break block7;
                    ioe.printStackTrace();
                }
            }
            try {
                if (bufReader != null) {
                    bufReader.close();
                }
            }
            catch (IOException ioe) {
                if (!DEBUG) break block8;
                ioe.printStackTrace();
            }
        }
    }

    public Date GetBuildDate() {
        return this.m_dtBuildDate;
    }

    protected CLookAndFeel CreateLookAndFeel() {
        return new CLookAndFeel(2L, CLookAndFeel.GetDefaultLookAndFeelClassName());
    }

    public CLookAndFeel GetLookAndFeel() {
        return this.m_LookAndFeel;
    }

    public Container GetMainWnd() {
        Container rRet = null;
        if (this.GetMainWndAttr() != null) {
            rRet = this.GetMainWndAttr().GetContainer();
        }
        return rRet;
    }

    protected CContainerAttr CreateMainWndAttr() {
        return new CContainerAttr();
    }

    protected CContainerAttr GetMainWndAttr() {
        return this.m_MainWndAttr;
    }

    public void Debug_Entering(String sSourceClass, String sSourceMethod) {
        if (m_DebugLog != null) {
            m_DebugLog.Entering(sSourceClass, sSourceMethod);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().entering(sSourceClass, sSourceMethod);
        }
    }

    public void Debug_Entering(String sSourceClass, String sSourceMethod, Object rFromObject) {
        if (m_DebugLog != null) {
            m_DebugLog.Entering(sSourceClass, sSourceMethod);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().entering(sSourceClass, sSourceMethod, rFromObject);
        }
    }

    public void Debug_Entering(String sSourceClass, String sSourceMethod, Object[] arFromObjects) {
        if (m_DebugLog != null) {
            m_DebugLog.Entering(sSourceClass, sSourceMethod);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().entering(sSourceClass, sSourceMethod, arFromObjects);
        }
    }

    public void Debug_Exiting(String sSourceClass, String sSourceMethod) {
        if (m_DebugLog != null) {
            m_DebugLog.Exiting(sSourceClass, sSourceMethod);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().entering(sSourceClass, sSourceMethod);
        }
    }

    public void Debug_Exiting(String sSourceClass, String sSourceMethod, Object rFromObject) {
        if (m_DebugLog != null) {
            m_DebugLog.Exiting(sSourceClass, sSourceMethod, rFromObject);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().entering(sSourceClass, sSourceMethod, rFromObject);
        }
    }

    public void Debug_Assert(String sClassName, String sLineNumber, String sMsg, boolean bShowMsgBox) {
        if (m_DebugLog != null) {
            m_DebugLog.Assert(sClassName, sLineNumber, sMsg, bShowMsgBox);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().severe(CDebugLog.FormatAssert(sClassName, sLineNumber, sMsg));
        }
    }

    public void Debug_Exception(String sClassName, String sLineNumber, String sMsg, boolean bShowMsgBox) {
        if (m_DebugLog != null) {
            m_DebugLog.Exception(sClassName, sLineNumber, sMsg, bShowMsgBox);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().severe(CDebugLog.FormatAssert(sClassName, sLineNumber, sMsg));
        }
    }

    public void Debug_Info(String sMsg) {
        if (m_DebugLog != null) {
            m_DebugLog.Info(sMsg);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().info(sMsg);
        }
    }

    public void Debug_Trace(String sMsg) {
        if (m_DebugLog != null) {
            m_DebugLog.Trace(sMsg);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().finer(sMsg);
        }
    }

    public void Debug_Trace1(String sMsg) {
        if (m_DebugLog != null) {
            m_DebugLog.Trace1(sMsg);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().fine(sMsg);
        }
    }

    public void Debug_Warning(String sMsg) {
        if (m_DebugLog != null) {
            m_DebugLog.Warning(sMsg);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().warning(sMsg);
        }
    }

    @Override
    protected void NewMessage(CWorkerThreadMsg rMsg, boolean bHead) {
        if (DEBUG_LOG_METHODS) {
            CDebugLog.ENTERING(CWorkerThread.class.getName(), "NewMessage", rMsg);
        }
        if (rMsg != null) {
            if (rMsg.GetMsgID() == 2100) {
                super.NewMessage(rMsg, true);
            } else {
                CRhinoEvent rEvent = new CRhinoEvent(rMsg);
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(rEvent);
            }
        } else {
            CDebugLog.ASSERT(CWorkerThread.class.getName(), CDebugLog.GetLineNumber(), "Programming error, rCmd = null", false);
        }
        if (DEBUG_LOG_METHODS) {
            CDebugLog.EXITING(CWorkerThread.class.getName(), "NewMessage");
        }
    }

    @Override
    public void dispatchEvent(AWTEvent rEvent) {
        if (rEvent instanceof CRhinoEvent) {
            CRhinoEvent rRhinoEvent = (CRhinoEvent)rEvent;
            Object objSource = rRhinoEvent.getSource();
            if (objSource instanceof CWorkerThreadMsg) {
                CWorkerThreadMsg rMsg = (CWorkerThreadMsg)objSource;
                this.OnMessage(rMsg);
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  We only handle CWorkerThreadMsg objects!");
            }
        } else if (DEBUG_ASSERT_ON_NON_RHINO_EVENTS) {
            CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  We only handle CRhinoEvent objects!");
        }
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        super.OnMessage(rMsg);
        if (DEBUG_ON_MESSAGES) {
            System.out.printf("OnMessage | Index: %d | ID: %d\r\n", this.m_nIndex++, rMsg.GetMsgID());
        }
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 8005: {
                    this.IncTransfersInProgress();
                    break;
                }
                case 8006: {
                    this.DecTransfersInProgress();
                    break;
                }
                case 2015: {
                    this.OnExit();
                    break;
                }
                case 3003: {
                    this.OnShutdown();
                    break;
                }
                case 3403: {
                    String sURL = this.GetKnowledgeBaseURLString();
                    if (sURL == null || sURL.isEmpty()) break;
                    CLocalFileSystem.GetLocalFileSystem().LaunchURL(sURL);
                    break;
                }
                case 2143: {
                    String sURL = this.GetSupportURLString();
                    if (sURL != null && !sURL.isEmpty()) {
                        CLocalFileSystem.GetLocalFileSystem().LaunchURL(sURL);
                        break;
                    }
                    ArrayList<Image> aWindowImages = new ArrayList<Image>();
                    ImageIcon rImg = CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TECH_SUPPORT_PNG.GetFileName());
                    if (rImg != null) {
                        aWindowImages.add(rImg.getImage());
                    }
                    CRhinoMessageBox dlg = new CRhinoMessageBox(CRhinoApp.GetParentWindow(this.GetMainWnd()), CString.LoadString("IDS_NOTIFY_NO_SUPPORT_URL_TITLE"), aWindowImages, -1, 2, CString.LoadString("IDS_NOTIFY_NO_SUPPORT_URL_MSG"));
                    dlg.setPreferredSize(new Dimension(260, 160));
                    dlg.setResizable(false);
                    dlg.setVisible(true);
                    break;
                }
                case 2142: {
                    this.PostShowHelpDoc(this.GetHelpDoc(), this.GetHelpNode());
                    break;
                }
                case 3010: 
                case 3202: 
                case 3203: 
                case 3204: 
                case 3205: 
                case 3207: 
                case 3208: 
                case 3211: 
                case 3212: 
                case 3213: 
                case 3215: 
                case 3217: 
                case 3218: 
                case 3219: {
                    CRhinoAction rAction = this.GetAction(rMsg.GetMsgID());
                    rAction.SetSelected(true);
                    break;
                }
                case 4020: {
                    this.OnCreate();
                    break;
                }
                case 4022: {
                    this.OnInitialUpdate();
                    break;
                }
                case 4244: {
                    CNoopMsg rNoopMsg = (CNoopMsg)rMsg;
                    if (rNoopMsg.GetUISourceAttrID() != this.GetUniqueID()) break;
                    rNoopMsg.SetMsgID(4220);
                    this.PostNoop(rNoopMsg);
                    break;
                }
                case 5015: {
                    this.OnAddToDlgQueue((CDialogShowMsg)rMsg);
                    break;
                }
                case 5014: {
                    this.OnProcessDlgQueue();
                    break;
                }
                case 3530: {
                    CUpdateCenterPointMsg rUpdateCenterPtMsg = (CUpdateCenterPointMsg)rMsg;
                    if (rUpdateCenterPtMsg.GetCenterPoint() == null) break;
                    this.SetCenterPoint(rUpdateCenterPtMsg.GetCenterPoint());
                    break;
                }
                case 7000: {
                    CHelpDocMsg rHelpMsg = (CHelpDocMsg)rMsg;
                    this.ShowHelpDoc(rHelpMsg.GetHelpDoc(), rHelpMsg.GetHelpNode());
                    break;
                }
                case 3525: {
                    CUIMessage rUIMsg = (CUIMessage)rMsg;
                    if (rUIMsg == null) break;
                    String sAbsPath = (String)rUIMsg.GetSource();
                    String sMsg = String.format(CString.LoadString("IDS_FILE_OPEN_ERR_MSG"), this.GetAppName(), sAbsPath);
                    JOptionPane.showMessageDialog(this.GetMainWnd(), sMsg, CString.LoadString("IDS_FILE_OPEN_ERR_TITLE"), 0);
                    break;
                }
            }
        }
        if (this.GetLookAndFeel() != null) {
            this.GetLookAndFeel().OnMessage(rMsg);
        }
        if (this.GetMainWndAttr() != null) {
            this.GetMainWndAttr().OnMessage(rMsg);
        }
        if (this.m_vectDialogShowMsgs != null) {
            CRhinoEvent rSourceEvent = new CRhinoEvent(rMsg);
            for (CDialogShowMsg rDlgMsg : this.m_vectDialogShowMsgs) {
                if (rDlgMsg == null) continue;
                if (rDlgMsg.GetDialog() != null) {
                    rDlgMsg.GetDialog().dispatchEvent(rSourceEvent);
                }
                if (rDlgMsg.GetFileChooser() == null) continue;
                rDlgMsg.GetFileChooser().dispatchEvent(rSourceEvent);
            }
            Object var2_2 = null;
        }
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 4260: {
                    this.OnRecvNoop((CNoopMsg)rMsg);
                    break;
                }
                case 5016: {
                    this.OnShowDialog((CDialogShowMsg)rMsg);
                    break;
                }
            }
        }
    }

    protected String GetKnowledgeBaseURLString() {
        String sKBLink = "http://www.RhinoSoft.com/KnowledgeBase/?prod=su";
        return sKBLink;
    }

    protected String GetSupportURLString() {
        String sSupportLink = null;
        if (this.GetConnectionAttrs() != null) {
            sSupportLink = this.GetConnectionAttrs().GetSupportLink();
        }
        return sSupportLink;
    }

    public abstract void OnCloseMainWnd();

    public abstract void OnExit();

    public abstract void OnShutdown();

    protected void ExitApp() {
        if (this.GetMainWnd() != null) {
            this.SendOnSaveSession();
        }
        this.DestroyRootThumbCache();
        if (DEBUG) {
            CDebugLog.INFO("Application Stop.");
        }
        this.OnDestroy();
        if (this.GetMainWnd() != null) {
            this.GetMainWnd().setVisible(false);
            this.DestroyMainWnd();
        }
    }

    protected void DestroyMainWnd() {
        if (this.GetMainWnd() != null && this.GetMainWnd() instanceof Window) {
            ((Window)this.GetMainWnd()).dispose();
        }
    }

    protected void OnDestroy() {
        if (DEBUG_LOG_METHODS) {
            CDebugLog.ENTERING(CRhinoApp.class.getName(), "OnDestroy");
        }
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(4021);
        this.OnMessage(rMsg);
        this.PostQuit();
        this.KillThread(this.m_tGeneralThread);
        this.CleanImageCacheDir();
        if (this.m_EventQueue != null) {
            this.m_EventQueue.Destroy();
            this.m_EventQueue = null;
        }
        if (DEBUG_LOG_METHODS) {
            CDebugLog.EXITING(CRhinoApp.class.getName(), "OnDestroy");
        }
    }

    public void PostStatusBarMsg(Object objSource, String sStatusText) {
        CUIMessage rMsg = new CUIMessage(4000, objSource);
        if (rMsg != null) {
            rMsg.SetStatusBarText(sStatusText);
            this.NewMessage(rMsg);
        }
    }

    public void PostExit() {
        CUIMessage rMsg = new CUIMessage(2015, this);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostOnTreeTableRightClick(Object objSource, Point ptInSourceCoords) {
        CRightClickMsg rMsg = new CRightClickMsg(objSource, ptInSourceCoords);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostActionMsg(Object rSource, CRhinoAction rAction) {
        if (rSource != null && rAction != null) {
            CUIMessage rMsg = new CUIMessage((int)rAction.GetEventID(), rSource);
            this.NewMessage(rMsg);
        }
    }

    protected abstract CActionFactory CreateActionFactory();

    protected CActionFactory GetActionFactory() {
        return this.m_ActionFactory;
    }

    public CRhinoAction GetAction(int nID) {
        CRhinoAction rAction = null;
        if (this.GetActionFactory() != null) {
            rAction = this.GetActionFactory().GetAction(nID);
        }
        return rAction;
    }

    protected abstract String GetLocalStoragePathRoot(boolean var1);

    public String GetLocalStoragePathRoot() {
        return this.GetLocalStoragePathRoot(true);
    }

    protected abstract void DeleteOldLocalStoragePathApp();

    private void UpgradeOldLocalStoragePathApp(String sAbsNewPath) {
        if (!this.m_bUpgradeOldLocalStoragePathApp) {
            this.m_bUpgradeOldLocalStoragePathApp = true;
            this.UpgradeOldLocalStoragePathAppEx(sAbsNewPath);
        }
        this.DeleteOldLocalStoragePathApp();
    }

    protected abstract void UpgradeOldLocalStoragePathAppEx(String var1);

    public String GetLocalStoragePathApp(boolean bEnsureExists) {
        String sRetPath = null;
        StringBuilder sTemp = new StringBuilder(this.GetLocalStoragePathRoot(bEnsureExists));
        sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
        sTemp.append(this.GetAppName());
        sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
        sRetPath = sTemp.toString();
        if (bEnsureExists) {
            CLocalFileSystem.GetLocalFileSystem().CreateAllLocalDirs(sRetPath);
        }
        this.UpgradeOldLocalStoragePathApp(sRetPath);
        return sRetPath;
    }

    public String GetLocalStoragePathApp() {
        return this.GetLocalStoragePathApp(true);
    }

    protected abstract void UpgradeOldLocalStoragePathFileTypesEx(String var1);

    private void UpgradeOldLocalStoragePathFileTypes(String sAbsNewPath) {
        if (!this.m_bUpgradeOldLocalStoragePathFileTypes) {
            this.m_bUpgradeOldLocalStoragePathFileTypes = true;
            this.UpgradeOldLocalStoragePathFileTypesEx(sAbsNewPath);
        }
        this.DeleteOldLocalStoragePathApp();
    }

    public String GetLocalStoragePathFileTypes(boolean bEnsureExists) {
        String sRetPath = null;
        StringBuilder sTemp = new StringBuilder(this.GetLocalStoragePathRoot(bEnsureExists));
        sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
        sTemp.append("File Types");
        sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
        sRetPath = sTemp.toString();
        if (bEnsureExists) {
            CLocalFileSystem.GetLocalFileSystem().CreateAllLocalDirs(sRetPath);
        }
        this.UpgradeOldLocalStoragePathFileTypes(sRetPath);
        return sRetPath;
    }

    public String GetLocalStoragePathFileTypes() {
        return this.GetLocalStoragePathFileTypes(true);
    }

    protected abstract void UpgradeOldLocalStoragePathHostEx(String var1);

    private void UpgradeOldLocalStoragePathHost(String sAbsNewPath) {
        if (!this.m_bUpgradeOldLocalStoragePathHost) {
            this.m_bUpgradeOldLocalStoragePathHost = true;
            this.UpgradeOldLocalStoragePathHostEx(sAbsNewPath);
        }
        this.DeleteOldLocalStoragePathApp();
    }

    public String GetLocalStoragePathHost(boolean bEnsureExists) {
        String sRetPath = null;
        String sHost = this.GetHost(true);
        if (sHost != null && !sHost.isEmpty()) {
            StringBuilder sTemp = new StringBuilder(this.GetLocalStoragePathApp(bEnsureExists));
            sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
            sTemp.append(sHost);
            sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
            sRetPath = sTemp.toString();
        }
        this.UpgradeOldLocalStoragePathHost(sRetPath);
        if (bEnsureExists) {
            CLocalFileSystem.GetLocalFileSystem().CreateAllLocalDirs(sRetPath);
        }
        return sRetPath;
    }

    public String GetLocalStoragePathHost() {
        return this.GetLocalStoragePathHost(true);
    }

    public String GetLocalStoragePathUserID(boolean bEnsureExists) {
        String sRetPath = null;
        String sUserID = this.GetLoginID();
        if (sUserID != null && !sUserID.isEmpty()) {
            if (this.GetLocalStoragePathHost(bEnsureExists) != null) {
                StringBuilder sTemp = new StringBuilder(this.GetLocalStoragePathHost(bEnsureExists));
                sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
                sTemp.append(sUserID);
                sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
                sRetPath = sTemp.toString();
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "GetLocalStoragePathUserID() == null");
            }
        }
        if (bEnsureExists) {
            CLocalFileSystem.GetLocalFileSystem().CreateAllLocalDirs(sRetPath);
        }
        return sRetPath;
    }

    public String GetLocalStoragePathUserID() {
        return this.GetLocalStoragePathUserID(true);
    }

    public String GetLocalStoragePathImages(boolean bEnsureExists) {
        String sRetPath = null;
        if (this.GetLocalStoragePathHost(bEnsureExists) != null) {
            StringBuilder sTemp = new StringBuilder(this.GetLocalStoragePathHost(bEnsureExists));
            sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
            sTemp.append("Images");
            sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
            sRetPath = sTemp.toString();
        } else if (DEBUG) {
            CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "GetLocalStoragePathUserID() == null");
        }
        if (bEnsureExists) {
            CLocalFileSystem.GetLocalFileSystem().CreateAllLocalDirs(sRetPath);
        }
        return sRetPath;
    }

    public String GetLocalStoragePathImages() {
        return this.GetLocalStoragePathImages(true);
    }

    public String GetHost() {
        return this.GetHost(false);
    }

    public String GetHost(boolean bRemoveInvalidPathChars) {
        String sHost = null;
        if (this.m_ConnectionInfo != null) {
            sHost = this.m_ConnectionInfo.GetHost(bRemoveInvalidPathChars);
        }
        return sHost;
    }

    public long GetServerPort() {
        long lPort = 0L;
        if (this.m_ConnectionInfo != null) {
            lPort = this.m_ConnectionInfo.GetServerPort();
        }
        return lPort;
    }

    public long GetHeaderPort() {
        long lPort = 0L;
        if (this.m_ConnectionInfo != null) {
            lPort = this.m_ConnectionInfo.GetHeaderPort();
        }
        return lPort;
    }

    public String GetEncSessionID() {
        String sEncSessionID = null;
        if (this.m_ConnectionInfo != null) {
            sEncSessionID = this.m_ConnectionInfo.GetEncSessionID();
        }
        return sEncSessionID;
    }

    public boolean IsSecure() {
        boolean bIsSecure = false;
        if (this.m_ConnectionInfo != null) {
            bIsSecure = this.m_ConnectionInfo.IsSecure();
        }
        return bIsSecure;
    }

    public String GetLoginID() {
        String sLoginID = null;
        if (this.m_ConnectionInfo != null) {
            sLoginID = this.m_ConnectionInfo.GetLoginID();
        }
        return sLoginID;
    }

    public String GetJarPathToBinDir() {
        return JAR_PATH_TO_BIN_DIR;
    }

    protected String GetAppArchiveFilePath() {
        String sRetPath = null;
        String sLocalDir = this.GetLocalStoragePathUserID();
        if (CRhinoApp.IsValid(sLocalDir)) {
            StringBuilder sTemp = new StringBuilder(sLocalDir);
            sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
            sTemp.append(this.GetArchiveFileName());
            sRetPath = sTemp.toString();
        }
        return sRetPath;
    }

    protected String GetArchiveFileName() {
        return "App.properties";
    }

    @Override
    public CRhinoArchive GetArchive() {
        return super.GetArchive();
    }

    @Override
    protected CRhinoArchive CreateArchive() {
        CRhinoArchive rArchive = null;
        String sAppArchiveFilePath = this.GetAppArchiveFilePath();
        if (CRhinoApp.IsValid(sAppArchiveFilePath)) {
            rArchive = new CRhinoArchive(sAppArchiveFilePath);
        }
        return rArchive;
    }

    private void PostOnCreate() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(4020);
        this.NewMessage(rMsg);
    }

    protected void PostOnLoadSession() {
        CWorkerThreadMsg rAttrMsg = new CWorkerThreadMsg(4004);
        this.NewMessage(rAttrMsg);
    }

    private void SendOnSaveSession() {
        CWorkerThreadMsg rAttrMsg = new CWorkerThreadMsg(4005);
        this.OnMessage(rAttrMsg);
    }

    private void PostOnInitialUpdate() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(4022);
        this.NewMessage(rMsg);
    }

    public void PostRecvFileSysOpStarted(CWorkerThreadMsg rSourceMsg) {
        CUIMessage rMsg = new CUIMessage(4200, rSourceMsg);
        this.NewMessage(rMsg);
    }

    public void PostRecvFileSysOpError(CWorkerThreadMsg rSourceMsg) {
        CUIMessage rMsg = new CUIMessage(4201, rSourceMsg);
        this.NewMessage(rMsg);
    }

    public void PostRecvFileSysOpDone(CWorkerThreadMsg rSourceMsg) {
        CUIMessage rMsg = new CUIMessage(4203, rSourceMsg);
        this.NewMessage(rMsg);
    }

    public void PostRecvFileSysOptListParent(CListing rSourceMsg) {
        CUIMessage rMsg = new CUIMessage(4211, rSourceMsg);
        this.NewMessage(rMsg);
    }

    public void PostRecvFileSysOptListChild(CFile rChild, CListing rSourceMsg) {
        Object[] aObjs = new Object[]{rChild, rSourceMsg};
        CUIMessage rMsg = new CUIMessage(4212, aObjs);
        this.NewMessage(rMsg);
    }

    private CRhinoFileInfoCache CreateFileInfoCache() {
        CRhinoFileInfoCache cache = null;
        String sAbsPath = this.GetLocalStoragePathFileTypes();
        if (CRhinoApp.IsValid(sAbsPath)) {
            cache = new CRhinoFileInfoCache(sAbsPath);
        }
        return cache;
    }

    public Icon GetIcon16(CFile rFile) {
        Icon icoRet = null;
        if (this.m_FileInfoCache != null) {
            icoRet = this.m_FileInfoCache.GetIcon16(rFile);
        }
        return icoRet;
    }

    public Icon GetIcon32(CFile rFile) {
        Icon icoRet = null;
        if (this.m_FileInfoCache != null) {
            icoRet = this.m_FileInfoCache.GetIcon32(rFile);
        }
        return icoRet;
    }

    public String GetType(CFile rFile) {
        String sType = "";
        if (this.m_FileInfoCache != null) {
            sType = this.m_FileInfoCache.GetType(rFile);
        }
        return sType;
    }

    public void PostListPath(long lTargetID, String sAbsPath, boolean bIsLocal, boolean bIsDir, boolean bIsRefresh) {
        CListing rListing = null;
        rListing = bIsLocal ? new CLocalListing(this.GetThreadID(), lTargetID, bIsRefresh) : new CRemoteListing(this.GetThreadID(), lTargetID, bIsRefresh);
        this.NewMessage(rListing);
    }

    public void PostShowConnectionInfo() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(5005);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostShowLocale() {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(5006);
        if (rMsg != null) {
            this.NewMessage(rMsg);
        }
    }

    public void PostWorkerThreadResponse(CWorkerThreadMsg rMsg) {
        this.NewMessage(rMsg);
    }

    protected void OnCreate() {
    }

    protected void OnInitialUpdate() {
    }

    public String GetUserAgent() {
        String sUserAgent = null;
        if (this.m_ConnectionInfo != null) {
            sUserAgent = this.m_ConnectionInfo.GetUserAgent();
        }
        return sUserAgent;
    }

    protected void OnRecvNoop(CNoopMsg rMsg) {
        boolean bIsSuccessful = false;
        if (rMsg.GetHTTPCode() == 200 && rMsg.GetSUCode() == 0) {
            bIsSuccessful = true;
        }
        boolean bHandleError = true;
        if (!bIsSuccessful) {
            String sHost;
            if (rMsg.IsCheckingCommunication() && this.GetConnectionAttrs() != null && (sHost = this.GetConnectionAttrs().GetHost()) != null) {
                String sLowerHost = sHost.toLowerCase();
                if (sLowerHost.equals("localhost")) {
                    this.GetConnectionAttrs().SetHost("[::1]");
                    bHandleError = false;
                } else if (sLowerHost.equals("[::1]") || sLowerHost.equals("0000:0000:0000:0000:0000:0000:0000:0001")) {
                    if (!this.m_bTryingIPv6Loopback) {
                        this.m_bTriedIPv6Loopback = true;
                        this.GetConnectionAttrs().SetHost("127.0.0.1");
                        bHandleError = false;
                    }
                } else if (sLowerHost.equals("127.0.0.1") && !this.m_bTriedIPv6Loopback) {
                    this.m_bTryingIPv6Loopback = true;
                    this.GetConnectionAttrs().SetHost("[::1]");
                    bHandleError = false;
                }
            }
            if (bHandleError) {
                Container rOwner = null;
                if (this.GetMainWnd() instanceof Component) {
                    rOwner = this.GetMainWnd();
                }
                rMsg.OnError(rOwner, rOwner);
            } else if (this.GetGeneralThread() != null) {
                rMsg.SetMsgID(4220);
                rMsg.SetHost(this.GetConnectionAttrs().GetHost());
                this.PostNoop(rMsg);
            }
        }
        if (rMsg.IsCheckingCommunication()) {
            this.SetHasCommunication(bIsSuccessful);
            this.OnUpdateHasCommunication(rMsg);
        }
    }

    protected void OnUpdateHasCommunication(CNoopMsg rMsg) {
        boolean bIsSuccessful = false;
        if (rMsg != null) {
            if (rMsg.GetHTTPCode() == 200 && rMsg.GetSUCode() == 0) {
                bIsSuccessful = true;
            }
            if (bIsSuccessful) {
                CConnectionInfoMsg rConnMsg = new CConnectionInfoMsg(this.GetHost(), this.GetServerPort(), this.GetHeaderPort(), this.GetUserAgent(), this.GetEncSessionID(), this.IsCaseSensitiveOS());
                this.NewMessage(rConnMsg);
            }
        }
    }

    public boolean HasCommunication() {
        return this.m_bHasServerCommunication;
    }

    private void SetHasCommunication(boolean bHasCommunication) {
        this.m_bHasServerCommunication = bHasCommunication;
    }

    public CWorkerThread GetGeneralThread() {
        return this.m_tGeneralThread;
    }

    private void InitNoopTimer() {
        if (this.m_NoopTimer == null) {
            this.m_NoopTimer = new Timer(true);
            this.m_NoopTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    CRhinoApp.this.PostNoop();
                }
            }, 50000L, 55000L);
        }
    }

    public boolean KillThread(CWorkerThread tThread) {
        return this.KillThread(tThread, 5000);
    }

    private boolean KillThread(CWorkerThread tThread, int nTimeout) {
        boolean bIsDead = false;
        if (DEBUG_LOG_METHODS) {
            this.Debug_Entering(CRhinoApp.class.getName(), "KillThread");
        }
        if (tThread != null) {
            if (DEBUG_LOG_THREAD_LIFE) {
                this.Debug_Info(String.format("%40s KillThread | %s-%d", "<<< DEBUG >>>", tThread.GetThreadName(), tThread.GetThreadID()));
            }
            tThread.PostQuit();
            long nExpire = System.currentTimeMillis() + (long)nTimeout;
            boolean bExpired = false;
            while (tThread.GetThreadIsAlive() && !bExpired) {
                bExpired = System.currentTimeMillis() >= nExpire;
                try {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            if (bExpired && DEBUG_LOG_THREAD_LIFE) {
                String sTrack = String.format("%40s Expired waiting on %s-%d to die.", "<<< DEBUG_LOG_THREAD_LIFE >>>", tThread.GetThreadName(), tThread.GetThreadID());
                System.out.println(sTrack);
                this.Debug_Info(sTrack);
            }
            bIsDead = !tThread.GetThreadIsAlive();
        } else {
            this.Debug_Assert(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error, tThread == null", false);
        }
        if (DEBUG_LOG_METHODS) {
            this.Debug_Exiting(CRhinoApp.class.getName(), "KillThread");
        }
        return bIsDead;
    }

    protected void CheckCommunication() {
        this.PostNoop(true);
    }

    protected CNoopMsg CreateNoopMsg(String sHost, long lServerPort, boolean bIsSecure, long lHeaderPort, String sUserAgent, String sEncSessionID, long lUISourceAttrID, boolean bCheckingCommunication, CBoolAttr rbConfirmError, CBoolAttr rbConfirmOnCloseError) {
        return new CNoopMsg(sHost, lServerPort, bIsSecure, lHeaderPort, sUserAgent, sEncSessionID, lUISourceAttrID, bCheckingCommunication, rbConfirmError, rbConfirmOnCloseError);
    }

    public void PostNoop() {
        this.PostNoop(false);
    }

    public void PostNoop(boolean bCheckingCommunication) {
        CNoopMsg rMsg = this.CreateNoopMsg(this.GetHost(), this.GetServerPort(), this.IsSecure(), this.GetHeaderPort(), this.GetUserAgent(), this.GetEncSessionID(), this.GetUniqueID(), bCheckingCommunication, this.m_bConfirmErrorNoop, this.m_bConfirmErrorOnCloseNoop);
        this.PostNoop(rMsg);
    }

    protected void PostNoop(CNoopMsg rMsg) {
        if (this.GetGeneralThread() != null) {
            this.GetGeneralThread().NewMessage(rMsg);
        }
    }

    @Override
    public void OnLoadAttrs() {
        super.OnLoadAttrs();
        CRhinoArchive rAppArchive = this.GetArchive();
        if (rAppArchive != null) {
            this.m_bConfirmErrorNoop.Load(rAppArchive);
            this.m_bConfirmErrorOnCloseNoop.Load(rAppArchive);
            this.m_nNumOfTransferThreads.Load(rAppArchive);
            this.m_bColorRows.Load(rAppArchive);
            this.m_clrOddRows.Load(rAppArchive);
            this.m_clrEvenRows.Load(rAppArchive);
            this.m_bAutoExpandNewTransfers.Load(rAppArchive);
            this.m_bAutoStartNewTransfers.Load(rAppArchive);
            this.m_bAutoRemoveCompletedTransfers.Load(rAppArchive);
            this.m_bConfirmUploadFileOverwrites.Load(rAppArchive);
            this.m_bConfirmDownloadFileOverwrites.Load(rAppArchive);
            this.m_bConfirmUploadFolderOverwrites.Load(rAppArchive);
            this.m_bConfirmDownloadFolderOverwrites.Load(rAppArchive);
            this.m_bConfirmFileDeletes.Load(rAppArchive);
            this.m_bConfirmFolderDeletes.Load(rAppArchive);
            this.m_bConfirmMultiDeletes.Load(rAppArchive);
            this.m_bConfirmLogoutDlg.Load(rAppArchive);
            this.m_bConfirmTransferRelistDlg.Load(rAppArchive);
            this.m_nOptionUploadFileOverwrites.Load(rAppArchive);
            this.m_nOptionDownloadFileOverwrites.Load(rAppArchive);
            this.m_nOptionUploadFolderOverwrites.Load(rAppArchive);
            this.m_nOptionDownloadFolderOverwrites.Load(rAppArchive);
        }
    }

    @Override
    public void OnSaveAttrs() {
        super.OnSaveAttrs();
        CRhinoArchive rAppArchive = this.GetArchive();
        this.m_bConfirmErrorNoop.Save(rAppArchive);
        this.m_bConfirmErrorOnCloseNoop.Save(rAppArchive);
        this.m_nNumOfTransferThreads.Save(rAppArchive);
        this.m_bColorRows.Save(rAppArchive);
        this.m_clrOddRows.Save(rAppArchive);
        this.m_clrEvenRows.Save(rAppArchive);
        this.m_bAutoExpandNewTransfers.Save(rAppArchive);
        this.m_bAutoStartNewTransfers.Save(rAppArchive);
        this.m_bAutoRemoveCompletedTransfers.Save(rAppArchive);
        this.m_bConfirmUploadFileOverwrites.Save(rAppArchive);
        this.m_bConfirmDownloadFileOverwrites.Save(rAppArchive);
        this.m_bConfirmUploadFolderOverwrites.Save(rAppArchive);
        this.m_bConfirmDownloadFolderOverwrites.Save(rAppArchive);
        this.m_bConfirmFileDeletes.Save(rAppArchive);
        this.m_bConfirmFolderDeletes.Save(rAppArchive);
        this.m_bConfirmMultiDeletes.Save(rAppArchive);
        this.m_bConfirmLogoutDlg.Save(rAppArchive);
        this.m_bConfirmTransferRelistDlg.Save(rAppArchive);
        this.m_nOptionUploadFileOverwrites.Save(rAppArchive);
        this.m_nOptionDownloadFileOverwrites.Save(rAppArchive);
        this.m_nOptionUploadFolderOverwrites.Save(rAppArchive);
        this.m_nOptionDownloadFolderOverwrites.Save(rAppArchive);
    }

    public CIntAttr GetAttr_NumOfTransferThreads() {
        return this.m_nNumOfTransferThreads;
    }

    public CBoolAttr GetAttr_TransferRowsEnableColor() {
        return this.m_bColorRows;
    }

    public CColorAttr GetAttr_TransferRowColorOdd() {
        return this.m_clrOddRows;
    }

    public CColorAttr GetAttr_TransferRowColorEven() {
        return this.m_clrEvenRows;
    }

    public CBoolAttr GetAttr_ConfirmUploadFileOverwrites() {
        return this.m_bConfirmUploadFileOverwrites;
    }

    public CBoolAttr GetAttr_ConfirmDownloadFileOverwrites() {
        return this.m_bConfirmDownloadFileOverwrites;
    }

    public CBoolAttr GetAttr_ConfirmUploadFolderOverwrites() {
        return this.m_bConfirmUploadFolderOverwrites;
    }

    public CBoolAttr GetAttr_ConfirmDownloadFolderOverwrites() {
        return this.m_bConfirmDownloadFolderOverwrites;
    }

    public CBoolAttr GetAttr_ConfirmFileDeletes() {
        return this.m_bConfirmFileDeletes;
    }

    public CBoolAttr GetAttr_ConfirmFolderDeletes() {
        return this.m_bConfirmFolderDeletes;
    }

    public CBoolAttr GetAttr_ConfirmMultiDeletes() {
        return this.m_bConfirmMultiDeletes;
    }

    public CBoolAttr GetAttr_ConfirmLogoutDlg() {
        return this.m_bConfirmLogoutDlg;
    }

    public CBoolAttr GetAttr_ConfirmTransferRelistDlg() {
        return this.m_bConfirmTransferRelistDlg;
    }

    public int GetNumOfTransferThreadsMin() {
        return 1;
    }

    public int GetNumOfTransferThreadsMax() {
        return 10;
    }

    public boolean GetShowConfirmLogout() {
        return true;
    }

    public CIntAttr GetAttr_OptionUploadFileOverwrites() {
        return this.m_nOptionUploadFileOverwrites;
    }

    public CIntAttr GetAttr_OptionDownloadFileOverwrites() {
        return this.m_nOptionDownloadFileOverwrites;
    }

    public CIntAttr GetAttr_OptionUploadFolderOverwrites() {
        return this.m_nOptionUploadFolderOverwrites;
    }

    public CIntAttr GetAttr_OptionDownloadFolderOverwrites() {
        return this.m_nOptionDownloadFolderOverwrites;
    }

    public CBoolAttr GetAttr_ConfirmCancelCloseDlg() {
        return this.m_bConfirmCancelCloseDlg;
    }

    public boolean GetShowConfirmCancelCloseDlg() {
        boolean bShowConfirmCancelCloseDlg = true;
        CBoolAttr rAttr = this.GetAttr_ConfirmCancelCloseDlg();
        if (rAttr != null) {
            bShowConfirmCancelCloseDlg = rAttr.GetValue();
        }
        return bShowConfirmCancelCloseDlg;
    }

    public void SetShowConfirmCancelCloseDlg(boolean bConfirm) {
        CBoolAttr rAttr = this.GetAttr_ConfirmCancelCloseDlg();
        if (rAttr != null) {
            rAttr.SetValue(bConfirm);
        }
    }

    private void OnAddToDlgQueue(CDialogShowMsg rDlgMsg) {
        if (this.m_vectDialogShowMsgs != null) {
            this.m_vectDialogShowMsgs.add(rDlgMsg);
        }
        this.OnProcessDlgQueue();
    }

    protected boolean CheckCanShowDialogs() {
        return true;
    }

    public void PostProcessDlgQueue() {
        CUIMessage rMsg = new CUIMessage(5014, this.GetMainWnd());
        this.NewMessage(rMsg);
    }

    private void OnProcessDlgQueue() {
        if (this.m_vectDialogShowMsgs != null && this.m_vectDialogShowMsgs.size() > 0) {
            CDialogShowMsg rDlgMsg;
            if (this.m_rCurrentDialog == null && (rDlgMsg = this.m_vectDialogShowMsgs.get(0)) != null) {
                if (!this.m_bShowingOpaqueLayer && this.m_vectDialogShowMsgs.size() == 1) {
                    this.m_bShowingOpaqueLayer = true;
                    this.OnModalDlgIsUp();
                }
                if (this.CheckCanShowDialogs()) {
                    this.m_rCurrentDialog = rDlgMsg.GetDlgContainer();
                    rDlgMsg.SetMsgID(5016);
                    this.OnMessage(rDlgMsg);
                    this.m_rPrevDialog = this.m_rCurrentDialog;
                    this.m_rCurrentDialog = null;
                    this.m_vectDialogShowMsgs.remove(rDlgMsg);
                    this.OnProcessDlgQueue();
                }
            }
        } else if (this.m_bShowingOpaqueLayer) {
            this.m_bShowingOpaqueLayer = false;
            this.OnModalDlgIsDown();
        }
    }

    public void PostAddDialogToQueue(Component rSource, JDialog rDlg) {
        this.NewMessage(new CDialogShowMsg(5015, rSource, rDlg));
    }

    public void PostAddDialogToQueue(Component rSource, JFileChooser rFileChooser, String sApproveBtnTxt) {
        this.NewMessage(new CDialogShowMsg(5015, rSource, rFileChooser, sApproveBtnTxt));
    }

    public CBoolAttr GetAttr_AutoExpandNewTransfers() {
        return this.m_bAutoExpandNewTransfers;
    }

    public CBoolAttr GetAttr_AutoStartNewTransfers() {
        return this.m_bAutoStartNewTransfers;
    }

    public CBoolAttr GetAttr_AutoRemoveCompletedTransfers() {
        return this.m_bAutoRemoveCompletedTransfers;
    }

    protected boolean GetAlwaysFetchCenterPoint() {
        return true;
    }

    protected void SetCenterPoint(Point ptCenterPoint) {
        this.m_ptCenterPoint = ptCenterPoint;
    }

    public void PostOnUpdateCenterPoint(int nContainerWidth, int nContainerHeight) {
        block6: {
            if (this.GetMainWnd() != null) {
                Dimension dimMainWndSize = this.GetMainWnd().getSize();
                if (this.GetMainWnd().isVisible() && dimMainWndSize.width > 0 && dimMainWndSize.height > 0) {
                    try {
                        CUpdateCenterPointMsg rMsg;
                        Point ptMainWndLoc = this.GetMainWnd().getLocationOnScreen();
                        boolean bOutOfBounds = false;
                        Rectangle rMainScreen = new Rectangle(0, 0, 0, 0);
                        Rectangle rAllScreens = new Rectangle(0, 0, 0, 0);
                        CGraphicsUtilities.GetScreenRects(rAllScreens, rMainScreen);
                        if (ptMainWndLoc.x > rAllScreens.width || ptMainWndLoc.y > rAllScreens.height || ptMainWndLoc.x < rAllScreens.x || ptMainWndLoc.y < rAllScreens.y) {
                            bOutOfBounds = true;
                        }
                        if (!bOutOfBounds && (rMsg = new CUpdateCenterPointMsg(this.GetMainWnd(), nContainerWidth, nContainerHeight, ptMainWndLoc, dimMainWndSize)) != null) {
                            this.NewMessage(rMsg);
                        }
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block6;
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public Point GetCenterPoint() {
        Point ptCenter;
        block7: {
            Point ptScreenLoc;
            ptCenter = this.m_ptCenterPoint;
            if (this.GetAlwaysFetchCenterPoint() && this.GetMainWnd() != null && this.GetMainWnd().isVisible()) {
                ptScreenLoc = this.GetMainWnd().getLocationOnScreen();
                Dimension dimSize = this.GetMainWnd().getSize();
                int nX = ptScreenLoc.x + dimSize.width / 2;
                int nY = ptScreenLoc.y + dimSize.height / 2;
                if (ptCenter == null) {
                    ptCenter = new Point(nX, nY);
                } else {
                    ptCenter.x = nX;
                    ptCenter.y = nY;
                }
            }
            if (ptCenter == null && this.GetMainWnd() != null && this.GetMainWnd().isVisible()) {
                try {
                    ptScreenLoc = this.GetMainWnd().getLocationOnScreen();
                    if (ptScreenLoc != null) {
                        Rectangle rRect = CGraphicsUtilities.GetScreenRect(ptScreenLoc);
                        ptCenter = new Point(rRect.x + rRect.width / 2, rRect.y + rRect.height / 2);
                    }
                }
                catch (Exception e) {
                    if (!DEBUG) break block7;
                    e.printStackTrace();
                }
            }
        }
        return ptCenter;
    }

    public void CenterWindow(Window rWnd) {
        this.CenterWindow(rWnd, this.GetMainWnd());
    }

    public void CenterWindow(Window rWnd, Component rOwner) {
        if (rWnd != null) {
            Point ptCenter = null;
            if (CRhinoApp.GET_RHINO_APP() != null) {
                ptCenter = CRhinoApp.GET_RHINO_APP().GetCenterPoint();
            }
            if (ptCenter != null) {
                Dimension dimSizeDlg = rWnd.getSize();
                int nX = ptCenter.x;
                int nY = ptCenter.y;
                rWnd.setLocation(nX -= dimSizeDlg.width / 2, nY -= dimSizeDlg.height / 2);
            } else {
                rWnd.setLocationRelativeTo(rOwner);
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
        }
    }

    @Override
    protected boolean IsMainThread() {
        return true;
    }

    public String GetRemoteStoragePathImages(boolean bIsCommon) {
        String sServerDirPath = null;
        if (bIsCommon) {
            sServerDirPath = "/Common/Java/Images/";
        }
        return sServerDirPath;
    }

    private void InitImageCache() {
        if (this.m_aCachedImages == null) {
            this.m_aCachedImages = new HashMap();
        } else {
            this.m_aCachedImages.clear();
        }
        this.LoadImageCacheCommon(this.GetConnectionAttrs(), this.GetGeneralThread());
        this.LoadImageCacheProduct(this.GetConnectionAttrs(), this.GetGeneralThread());
        this.FetchImageCache();
    }

    private void FetchImageCache() {
        if (this.m_aCachedImages != null) {
            CConnectionAttrs rConnAttrs;
            Collection<CCachedImageIcon> arCacheImages = this.m_aCachedImages.values();
            if (arCacheImages != null && (rConnAttrs = this.GetConnectionAttrs()) != null) {
                String sHost = rConnAttrs.GetHost();
                long lServerPort = rConnAttrs.GetServerPort();
                boolean bIsSecure = rConnAttrs.IsSecure();
                long lHeaderPort = rConnAttrs.GetHeaderPort();
                String sUserAgent = rConnAttrs.GetUserAgent();
                for (CCachedImageIcon rNext : arCacheImages) {
                    if (rNext == null) continue;
                    rNext.FetchImage(sHost, lServerPort, bIsSecure, lHeaderPort, sUserAgent);
                }
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "m_aCachedImages is null?  We have a race-condition!");
        }
    }

    protected boolean AddCachedImage(String sFileName, CCachedImageIcon rCachedImageIcon) {
        boolean bAdded = false;
        if (sFileName != null && !sFileName.isEmpty() && rCachedImageIcon != null) {
            this.m_aCachedImages.put(sFileName, rCachedImageIcon);
            bAdded = true;
        }
        return bAdded;
    }

    protected abstract void LoadImageCacheProduct(CConnectionAttrs var1, CWorkerThread var2);

    protected void LoadImageCacheCommon(CConnectionAttrs rConnInfo, CWorkerThread rThread) {
        IRhinoConsts.CACHE_IMAGES_COMMON[] arImages = IRhinoConsts.CACHE_IMAGES_COMMON.values();
        if (arImages != null) {
            String sClientDirPath = this.GetLocalStoragePathImages();
            String sServerDirPath = this.GetRemoteStoragePathImages(true);
            for (int nIdx = 0; nIdx < arImages.length; ++nIdx) {
                IRhinoConsts.CACHE_IMAGES_COMMON rImg = arImages[nIdx];
                if (rImg == null) continue;
                this.AddCachedImage(rImg.GetFileName(), new CCachedImageIcon(rImg.GetFileName(), rImg.IsCommon(), rImg.GetWidth(), rImg.GetHeight(), rConnInfo, rThread, sClientDirPath, sServerDirPath));
            }
        }
    }

    protected void CleanImageCacheDir() {
        String sStoragePath = this.GetLocalStoragePathImages(false);
        if (sStoragePath != null && !sStoragePath.isEmpty()) {
            File[] afFiles;
            File fCacheDir = new File(sStoragePath);
            if (fCacheDir != null && fCacheDir.exists() && (afFiles = fCacheDir.listFiles()) != null && afFiles.length > 0) {
                for (int nIdx = 0; nIdx < afFiles.length; ++nIdx) {
                    String sFileName;
                    File fCachedImg = afFiles[nIdx];
                    if (fCachedImg == null || (sFileName = fCachedImg.getName()) == null || sFileName.isEmpty() || this.m_aCachedImages.containsKey(sFileName)) continue;
                    CLocalFileSystem.GetLocalFileSystem().Delete(fCachedImg, true);
                }
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Missing local storage path for application images.");
        }
    }

    public ImageIcon GetJARImage(String sFileName) {
        ImageIcon rImageIcon = null;
        if (this.m_JarImages != null) {
            rImageIcon = this.m_JarImages.GetImage(sFileName);
        }
        return rImageIcon;
    }

    public ImageIcon GetCachedImage(String sFileName) {
        ImageIcon rImageIcon = null;
        if (this.m_aCachedImages != null) {
            rImageIcon = this.m_aCachedImages.get(sFileName);
        }
        return rImageIcon;
    }

    public final CConnectionAttrs GetConnectionAttrs() {
        return this.m_ConnectionInfo;
    }

    public static ImageIcon GetImage(String sFileName) {
        return CRhinoApp.GetImage(sFileName, false);
    }

    public static ImageIcon GetImage(String sFileName, boolean bIsJARImage) {
        ImageIcon rImageIcon = null;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            rImageIcon = bIsJARImage ? CRhinoApp.GET_RHINO_APP().GetJARImage(sFileName) : CRhinoApp.GET_RHINO_APP().GetCachedImage(sFileName);
        }
        return rImageIcon;
    }

    public static ImageIcon GetPercentImage(long nNumerator, long nDenominator) {
        ImageIcon rRet = null;
        CRhinoApp rApp = CRhinoApp.GET_RHINO_APP();
        if (rApp != null) {
            rRet = rApp.GetCachedImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_000_PNG.GetFileName());
            if (nDenominator != 0L) {
                long nPercent = nNumerator * 100L / nDenominator;
                if (nPercent == 100L) {
                    rRet = rApp.GetCachedImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_100_PNG.GetFileName());
                } else if (nPercent >= 93L) {
                    rRet = rApp.GetCachedImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_093_PNG.GetFileName());
                } else if (nPercent >= 87L) {
                    rRet = rApp.GetCachedImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_087_PNG.GetFileName());
                } else if (nPercent >= 81L) {
                    rRet = rApp.GetCachedImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_081_PNG.GetFileName());
                } else if (nPercent >= 75L) {
                    rRet = rApp.GetCachedImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_075_PNG.GetFileName());
                } else if (nPercent >= 68L) {
                    rRet = rApp.GetCachedImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_068_PNG.GetFileName());
                } else if (nPercent >= 62L) {
                    rRet = rApp.GetCachedImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_062_PNG.GetFileName());
                } else if (nPercent >= 56L) {
                    rRet = rApp.GetCachedImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_056_PNG.GetFileName());
                } else if (nPercent >= 50L) {
                    rRet = rApp.GetCachedImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_050_PNG.GetFileName());
                } else if (nPercent >= 43L) {
                    rRet = rApp.GetCachedImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_043_PNG.GetFileName());
                } else if (nPercent >= 37L) {
                    rRet = rApp.GetCachedImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_037_PNG.GetFileName());
                } else if (nPercent >= 31L) {
                    rRet = rApp.GetCachedImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_031_PNG.GetFileName());
                } else if (nPercent >= 25L) {
                    rRet = rApp.GetCachedImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_025_PNG.GetFileName());
                } else if (nPercent >= 18L) {
                    rRet = rApp.GetCachedImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_018_PNG.GetFileName());
                } else if (nPercent >= 12L) {
                    rRet = rApp.GetCachedImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_012_PNG.GetFileName());
                } else if (nPercent >= 6L) {
                    rRet = rApp.GetCachedImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PERCENT_006_PNG.GetFileName());
                }
            }
        }
        return rRet;
    }

    public boolean CanChangeFont() {
        boolean bCanChangeFont = true;
        String sLang = this.GetLanguageCode();
        if (sLang != null && !sLang.isEmpty() && (sLang.equals(Locale.JAPANESE.getLanguage()) || sLang.equals("ja") || sLang.equals(Locale.CHINESE.getLanguage()))) {
            bCanChangeFont = false;
        }
        return bCanChangeFont;
    }

    public String GetLocalStoragePathThumbnailRoot() {
        return this.GetLocalStoragePathThumbnailRoot(false);
    }

    public String GetLocalStoragePathThumbnailRoot(boolean bCreateDir) {
        String sRetPath = null;
        StringBuilder sTemp = new StringBuilder(this.GetLocalStoragePathRoot(bCreateDir));
        sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
        sTemp.append(THUMB_CACHE_ROOT_DIR);
        sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
        sRetPath = sTemp.toString();
        if (bCreateDir) {
            CLocalFileSystem.GetLocalFileSystem().CreateAllLocalDirs(sRetPath);
        }
        return sRetPath;
    }

    public String GetLocalStoragePathThumbnailRoot(String sThumbRootDir) {
        String sRetPath = null;
        StringBuilder sTemp = new StringBuilder(this.GetLocalStoragePathThumbnailRoot());
        sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
        sTemp.append(sThumbRootDir);
        sTemp = CString.EnsureLastCharIsAFileSeparator(sTemp);
        sRetPath = sTemp.toString();
        CLocalFileSystem.GetLocalFileSystem().CreateAllLocalDirs(sRetPath);
        return sRetPath;
    }

    public void DestroyRootThumbCache() {
        String sThumbRoot = this.GetLocalStoragePathThumbnailRoot(false);
        if (sThumbRoot != null) {
            CLocalFileSystem.GetLocalFileSystem().Delete(new File(sThumbRoot), true);
        }
    }

    private void OnModalDlgIsUp() {
        CUIMessage rMsg = new CUIMessage(5200, this.GetMainWnd());
        this.NewMessage(rMsg);
    }

    private void OnModalDlgIsDown() {
        CUIMessage rMsg = new CUIMessage(5201, this.GetMainWnd());
        this.NewMessage(rMsg);
    }

    public void PostTransferAllDoneInCurDir() {
        CUIMessage rUIMsg = new CUIMessage(3518, this.GetMainWnd());
        this.NewMessage(rUIMsg);
    }

    public abstract String GetHTTPHeader_ClientName();

    public void PostUpdateUI() {
        this.NewMessage(new CWorkerThreadMsg(3104));
    }

    public void PostShowHelpDoc(String sHelpFile, String sHelpNode) {
        CHelpDocMsg rMsg = new CHelpDocMsg(sHelpFile, sHelpNode);
        this.NewMessage(rMsg);
    }

    private void ShowHelpDoc(String sFile, String sNode) {
        if (this.GetURLFactory() != null) {
            String sTemp = Locale.ENGLISH.getLanguage();
            CConnectionAttrs rConnAttrs = this.GetConnectionAttrs();
            if (rConnAttrs != null) {
                String sLang = rConnAttrs.GetLanguageCode();
                if (sLang != null && sLang.toLowerCase().equals(Locale.JAPANESE.getLanguage())) {
                    sLang = "jp";
                }
                sTemp = String.format("%s,%s", sLang, rConnAttrs.GetCountryCode());
            }
            if (this.GetHelpPath() != null && sFile != null && sNode != null) {
                URL rURL = this.GetURLFactory().CreateHelp(this.GetHelpPath(), sFile, sNode, sTemp);
                this.LaunchURL(rURL);
            } else if (DEBUG) {
                CDebugLog.ASSERT(CRhinoApp.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args.");
            }
        }
    }

    protected abstract String GetHelpPath();

    public CSUURLFactory GetURLFactory() {
        return this.m_URLFactory;
    }

    public void LaunchURL(URL rURL) {
        if (rURL != null) {
            CLocalFileSystem fsu;
            if (DEBUG_BROWSER_URLS) {
                CDebugLog.INFO(rURL.toString());
            }
            if ((fsu = CLocalFileSystem.GetLocalFileSystem()) != null) {
                fsu.LaunchURL(rURL.toString());
            }
        }
    }

    private void InitURLFactory(boolean bIsSecure, String sHost, long lPort, String sSessionID) {
        this.m_URLFactory = this.CreateURLFactory(bIsSecure, sHost, lPort, sSessionID);
    }

    public static String GetAppNameAndVersion() {
        String sAppNameVersion = "Rhino Java App 1.0.0.0";
        if (CRhinoApp.GET_RHINO_APP() != null) {
            sAppNameVersion = CRhinoApp.GET_RHINO_APP().GetAppNameVersion();
        }
        return sAppNameVersion;
    }

    public String GetAppNameVersion() {
        String sAppName = this.GetAppName();
        int nVersionMajor1 = this.GetVersionMajor1();
        int nVersionMajor2 = this.GetVersionMajor2();
        int nVersionMinor1 = this.GetVersionMinor1();
        int nVersionMinor2 = this.GetVersionMinor2();
        String sAppNameVersion = String.format("%s %d.%d.%d.%d", sAppName, nVersionMajor1, nVersionMajor2, nVersionMinor1, nVersionMinor2);
        return sAppNameVersion;
    }

    public static int GetAppVersionMajor1() {
        int nVersion = DEF_VERSION_MAJOR_1;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            nVersion = CRhinoApp.GET_RHINO_APP().GetVersionMajor1();
        }
        return nVersion;
    }

    public static int GetAppVersionMajor2() {
        int nVersion = DEF_VERSION_MAJOR_2;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            nVersion = CRhinoApp.GET_RHINO_APP().GetVersionMajor2();
        }
        return nVersion;
    }

    public static int GetAppVersionMinor1() {
        int nVersion = DEF_VERSION_MINOR_1;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            nVersion = CRhinoApp.GET_RHINO_APP().GetVersionMinor1();
        }
        return nVersion;
    }

    public static int GetAppVersionMinor2() {
        int nVersion = DEF_VERSION_MINOR_2;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            nVersion = CRhinoApp.GET_RHINO_APP().GetVersionMinor2();
        }
        return nVersion;
    }

    public final int GetVersionMajor1() {
        return this.m_nVersionMajor1;
    }

    public final int GetVersionMajor2() {
        return this.m_nVersionMajor2;
    }

    public final int GetVersionMinor1() {
        return this.m_nVersionMinor1;
    }

    public final int GetVersionMinor2() {
        return this.m_nVersionMinor2;
    }

    protected void SetVersionMajor1(int nNum) {
        this.m_nVersionMajor1 = nNum;
    }

    protected void SetVersionMajor2(int nNum) {
        this.m_nVersionMajor2 = nNum;
    }

    protected void SetVersionMinor1(int nNum) {
        this.m_nVersionMinor1 = nNum;
    }

    protected void SetVersionMinor2(int nNum) {
        this.m_nVersionMinor2 = nNum;
    }

    public abstract void InitVersionNumbers();

    public static Window GetParentWindow(Component rCheckComp) {
        Container rComp;
        Window rParentWindow = null;
        if (rCheckComp != null && rCheckComp instanceof Window) {
            rParentWindow = (Window)rCheckComp;
        } else if (CRhinoApp.GET_RHINO_APP() != null && (rComp = CRhinoApp.GET_RHINO_APP().GetMainWnd()) != null) {
            if (rComp instanceof Window) {
                rParentWindow = (Window)rComp;
            } else {
                Window rCheck;
                Component rStart = rCheckComp;
                if (rCheckComp == null) {
                    rStart = rComp;
                }
                if ((rCheck = (Window)SwingUtilities.getAncestorOfClass(Window.class, rStart)) != null) {
                    rParentWindow = rCheck;
                }
            }
        }
        return rParentWindow;
    }

    public Dialog.ModalityType SendFetchDialogModalityType(Component rSource) {
        Dialog.ModalityType nDlgType = Dialog.ModalityType.DOCUMENT_MODAL;
        CDialogModalityMsg rFetchMsg = new CDialogModalityMsg(rSource);
        this.OnMessage(rFetchMsg);
        if (rFetchMsg != null) {
            nDlgType = rFetchMsg.GetModalityType();
        }
        return nDlgType;
    }

    public CFetchBrowserInfoMsg SendFetchBrowserInfo(Component rSource) {
        CFetchBrowserInfoMsg rFetchMsg = new CFetchBrowserInfoMsg(rSource);
        this.OnMessage(rFetchMsg);
        return rFetchMsg;
    }

    protected void OnShowDialog(CDialogShowMsg rDlgMsg) {
        if (rDlgMsg != null && rDlgMsg.GetSource() == this.GetMainWnd() && !rDlgMsg.IsConsumed()) {
            rDlgMsg.DoModal();
            int nResult = rDlgMsg.GetResult();
            rDlgMsg.Consume();
        }
    }

    public boolean AllowDragDropStringFlavors() {
        return true;
    }

    public String FetchCurWorkingDir(Object objSource) {
        String sCurWorkingDir = null;
        CFetchCurWorkingDirMsg rMsg = new CFetchCurWorkingDirMsg(objSource);
        this.OnMessage(rMsg);
        sCurWorkingDir = rMsg.GetCurWorkingDir();
        return sCurWorkingDir;
    }

    public void SetAllowJSObject(Object objSource, boolean bAllowJSObject) {
        CAllowJSObjectMsg rMsg = new CAllowJSObjectMsg(objSource, bAllowJSObject);
        this.OnMessage(rMsg);
    }

    protected void IncTransfersInProgress() {
        ++this.m_nTransfersInProgressCounter;
        if (DEBUG_TRANSFERS_IN_PROGRESS) {
            CDebugLog.INFO("m_nTransfersInProgressCounter: " + this.m_nTransfersInProgressCounter);
        }
    }

    protected void DecTransfersInProgress() {
        --this.m_nTransfersInProgressCounter;
        if (DEBUG_TRANSFERS_IN_PROGRESS) {
            CDebugLog.INFO("m_nTransfersInProgressCounter: " + this.m_nTransfersInProgressCounter);
        }
    }

    public void PostIncTransfersInProgress() {
        CUIMessage rUIMsg = new CUIMessage(8005, this.GetMainWnd());
        this.NewMessage(rUIMsg);
    }

    public void PostDecTransfersInProgress() {
        CUIMessage rUIMsg = new CUIMessage(8006, this.GetMainWnd());
        this.NewMessage(rUIMsg);
    }

    protected boolean AreTransfersInProgress() {
        return this.m_nTransfersInProgressCounter > 0;
    }

    public boolean IsCaseSensitiveOS() {
        boolean bIsCaseSensitiveOS = false;
        if (this.m_ConnectionInfo != null) {
            bIsCaseSensitiveOS = this.m_ConnectionInfo.IsCaseSensitiveOS();
        }
        return bIsCaseSensitiveOS;
    }

    protected CBoolAttr GetConfirmErrorNoop() {
        return this.m_bConfirmErrorNoop;
    }

    protected CBoolAttr GetConfirmErrorOnCloseNoop() {
        return this.m_bConfirmErrorOnCloseNoop;
    }

    public void SetCursor(CAttrMsg rMsg, Component rComp) {
        CUIMessage rUIMsg;
        Object[] aObjs;
        if (rMsg != null && rComp != null && rMsg instanceof CUIMessage && (aObjs = (Object[])(rUIMsg = (CUIMessage)rMsg).GetAttachedObject()) != null && aObjs.length > 0) {
            Cursor rCursorTo = (Cursor)aObjs[0];
            if (rComp.getCursor().getType() != rCursorTo.getType()) {
                rComp.setCursor(rCursorTo);
            }
        }
    }

    protected boolean RemoveStrings(String sLanguageCode, String sCountryCode) {
        return CString.RemoveStringTable(PATH_TO_RHINO_STRINGS, sLanguageCode, sCountryCode);
    }

    protected boolean ReplaceStrings(String sLanguageCode, String sCountryCode) {
        boolean bReplaced = this.RemoveStrings(this.GetLanguageCode(), this.GetCountryCode());
        if (bReplaced) {
            this.InitStrings(sLanguageCode, sCountryCode);
        }
        if (bReplaced) {
            this.m_ConnectionInfo.SetLocaleCodes(sLanguageCode, sCountryCode);
        }
        return bReplaced;
    }

    public CLanguageComboBox.LANGUAGE GetLanguage() {
        return CLanguageComboBox.GetLanguage(this.GetLanguageCode(), this.GetCountryCode());
    }

    protected void InitLoadingScreen() {
    }

    protected void SendLoadScreenEvent(int nProgLoc, String sMsg) {
    }

    protected String GetHelpDoc() {
        return null;
    }

    protected String GetHelpNode() {
        return null;
    }

    static {
        boolean bl = $assertionsDisabled = !CRhinoApp.class.desiredAssertionStatus();
        if (DEBUG) {
            // empty if block
        }
        DEBUG_ICED_TEA = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_ON_MESSAGES = false;
        DEBUG_SHOW_LOCALHOST_WARNING = true;
        DEBUG_PACE_IT_TO_CHECK_GUI = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_SHOW_EXTRA_XFER_COLS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_BROWSER_URLS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_CREATE_DEBUG_LOG = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_ASSERT_ON_NON_RHINO_EVENTS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRANSFERS_IN_PROGRESS = false;
        DEF_VERSION_MAJOR_1 = 1;
        DEF_VERSION_MAJOR_2 = 0;
        DEF_VERSION_MINOR_1 = 0;
        DEF_VERSION_MINOR_2 = 0;
    }
}

