/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui;

import com.rhinosoft.attrs.CAttrs;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.strings.CString;
import com.rhinosoft.ui.CRhinoApp;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class CRhinoAction
extends AbstractAction
implements MouseListener {
    public static boolean DEBUG = CAttrs.DEBUG;
    public static boolean DEBUG_STATUS_TXT;
    public static final int MAX_VISIBLE_ID = 55000;
    private Vector<Component> m_aOwners;
    private CRhinoAction[] m_arActionGroup;
    private boolean m_bDispatchOnAction;
    private CRhinoAction m_VisibleAction;

    public CRhinoAction(Integer nActionID) {
        this._CRhinoAction(nActionID);
    }

    public CRhinoAction(CRhinoAction rCopyFrom) {
        if (rCopyFrom != null) {
            this._CRhinoAction(rCopyFrom.GetEventID());
            for (int nIdx = 0; nIdx < rCopyFrom.GetOwnerCount(); ++nIdx) {
                this.AddOwner(rCopyFrom.GetOwner(nIdx));
            }
            CRhinoAction[] aActionGroup = rCopyFrom.GetActionGroup();
            if (aActionGroup != null) {
                this.SetActionGroup((CRhinoAction[])aActionGroup.clone());
            }
            this.SetName(rCopyFrom.GetName());
            this.putValue("AcceleratorKey", rCopyFrom.getValue("AcceleratorKey"));
            this.SetLongDesc(rCopyFrom.GetLongDesc());
            this.SetShortDesc(rCopyFrom.GetShortDesc());
            this.SetSmallIcon(rCopyFrom.GetSmallIcon());
            this.SetLargeIcon(rCopyFrom.GetLargeIcon());
            this.SetSelected(rCopyFrom.IsSelected());
        }
    }

    private void _CRhinoAction(Integer nID) {
        this.SetEventID(nID);
        this.m_aOwners = new Vector();
        this.m_bDispatchOnAction = true;
    }

    public String toString() {
        StringBuilder sbRet = new StringBuilder();
        sbRet.append(String.format("Class:     %s\r\n", this.getClass().getName()));
        sbRet.append(String.format("EventID:   %s\r\n", this.GetEventID()));
        return sbRet.toString();
    }

    public void SetEventID(Integer nEventID) {
        if (nEventID != null) {
            this.putValue("ActionCommandKey", String.valueOf(nEventID));
        }
    }

    public Integer GetEventID() {
        Integer nID = null;
        String sEventID = (String)this.getValue("ActionCommandKey");
        if (sEventID != null) {
            nID = new Integer(sEventID);
        }
        return nID;
    }

    public void SetName(String sName) {
        Character chMnemonic = CString.GetMnemonic(sName);
        sName = CString.RemoveMnemonic(sName);
        this.putValue("Name", sName);
        if (chMnemonic != null) {
            char nAsciiVal = chMnemonic.charValue();
            this.putValue("MnemonicKey", nAsciiVal);
        }
    }

    public void SetAccelerator(int nAccKey) {
        this.SetAccelerator(nAccKey, 0);
    }

    public void SetAccelerator(int nAccKey, int nAccModifier) {
        if (nAccKey >= 0) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(nAccKey, nAccModifier));
        }
    }

    public void SetLongDesc(String sDesc) {
        this.putValue("LongDescription", sDesc);
    }

    public String GetLongDesc() {
        return (String)this.getValue("LongDescription");
    }

    public String GetName() {
        return (String)this.getValue("Name");
    }

    public void SetShortDesc(String sDesc) {
        this.putValue("ShortDescription", sDesc);
    }

    public String GetShortDesc() {
        return (String)this.getValue("ShortDescription");
    }

    public void SetSmallIcon(ImageIcon image) {
        this.putValue("SmallIcon", image);
    }

    public ImageIcon GetSmallIcon() {
        return (ImageIcon)this.getValue("SmallIcon");
    }

    public void SetLargeIcon(ImageIcon icoImage) {
        this.putValue("SwingLargeIconKey", icoImage);
    }

    public ImageIcon GetLargeIcon() {
        return (ImageIcon)this.getValue("SwingLargeIconKey");
    }

    public void SetSelected(boolean bSelected) {
        this.SetSelected(bSelected, true);
    }

    private void SetSelected(boolean bSelected, boolean bUpdateActionGroup) {
        CRhinoAction[] arActionGroup;
        this.putValue("SwingSelectedKey", bSelected);
        for (int nIdx = 0; nIdx < this.GetOwnerCount(); ++nIdx) {
            Component rComp = this.GetOwner(nIdx);
            if (!(rComp instanceof JButton)) continue;
            JButton rBtn = (JButton)rComp;
            rBtn.setSelected(bSelected);
        }
        if (bSelected && bUpdateActionGroup && (arActionGroup = this.GetActionGroup()) != null) {
            for (int nIdx = 0; nIdx < arActionGroup.length; ++nIdx) {
                CRhinoAction rAction = arActionGroup[nIdx];
                if (rAction == null) continue;
                Integer rThisID = this.GetEventID();
                Integer rActionID = rAction.GetEventID();
                if (rThisID != null && rActionID != null && rThisID.intValue() == rActionID.intValue()) continue;
                rAction.SetSelected(false, false);
            }
        }
    }

    public boolean IsSelected() {
        boolean bIsSelected = false;
        Boolean bVal = (Boolean)this.getValue("SwingSelectedKey");
        if (bVal != null) {
            bIsSelected = bVal;
        }
        return bIsSelected;
    }

    protected Vector<Component> GetOwners() {
        return this.m_aOwners;
    }

    public boolean AddOwner(Component rComp) {
        boolean bRet = false;
        if (rComp != null) {
            rComp.addMouseListener(this);
            if (this.GetOwners() != null) {
                bRet = this.GetOwners().add(rComp);
            }
            if (rComp instanceof JButton) {
                JButton rBtn = (JButton)rComp;
                rBtn.setSelected(this.IsSelected());
            }
        }
        return bRet;
    }

    public Component RemoveOwner(int nIdx) {
        Component rRet = null;
        Component rTemp = this.GetOwner(nIdx);
        if (this.RemoveOwner(rTemp)) {
            rRet = rTemp;
        }
        return rRet;
    }

    public boolean RemoveOwner(Component rComp) {
        boolean bRet = false;
        if (rComp != null) {
            rComp.removeMouseListener(this);
            if (this.GetOwners() != null) {
                bRet = this.GetOwners().remove(rComp);
            }
        }
        return bRet;
    }

    public Component GetOwner(int nIdx) {
        Component rOwner = null;
        if (this.GetOwners() != null && nIdx >= 0 && nIdx < this.GetOwners().size()) {
            rOwner = this.GetOwners().get(nIdx);
        }
        return rOwner;
    }

    public int GetOwnerCount() {
        int nSize = 0;
        if (this.GetOwners() != null) {
            nSize = this.GetOwners().size();
        }
        return nSize;
    }

    protected CRhinoAction[] GetActionGroup() {
        return this.m_arActionGroup;
    }

    public void SetActionGroup(CRhinoAction[] arActionGroup) {
        this.m_arActionGroup = arActionGroup;
    }

    protected CRhinoAction GetActionFromGroup(int nEventID) {
        CRhinoAction rRet = null;
        CRhinoAction[] arActionGroup = this.GetActionGroup();
        if (arActionGroup != null && arActionGroup.length > 0) {
            for (int nIdx = 0; nIdx < arActionGroup.length && rRet == null; ++nIdx) {
                Integer nNextID;
                CRhinoAction rNext = arActionGroup[nIdx];
                if (rNext == null || (nNextID = rNext.GetEventID()) == null || nNextID != nEventID) continue;
                rRet = rNext;
            }
        }
        return rRet;
    }

    public CRhinoAction GetSelectedGroupItem() {
        CRhinoAction rRet = null;
        CRhinoAction[] arActionGroup = this.GetActionGroup();
        if (arActionGroup != null && arActionGroup.length > 0) {
            for (int nIdx = 0; nIdx < arActionGroup.length && rRet == null; ++nIdx) {
                CRhinoAction rNext = arActionGroup[nIdx];
                if (rNext == null || !rNext.IsSelected()) continue;
                rRet = rNext;
            }
        }
        return rRet;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Integer nEventID;
        Boolean bIsSelected = (Boolean)this.getValue("SwingSelectedKey");
        boolean bUpdateAction = true;
        if (event.getSource() instanceof JButton) {
            JButton rBtn = (JButton)event.getSource();
            if (bIsSelected != null) {
                bIsSelected = bIsSelected == false;
            }
        }
        if ((nEventID = this.GetEventID()) != null && this.GetActionFromGroup(nEventID) != null && bIsSelected != null && !bIsSelected.booleanValue()) {
            bUpdateAction = false;
        }
        if (!bUpdateAction && bIsSelected != null) {
            if (event.getSource() instanceof JButton) {
                ((JButton)event.getSource()).setSelected(bIsSelected == false);
            } else if (event.getSource() instanceof JMenuItem) {
                ((JMenuItem)event.getSource()).setSelected(bIsSelected == false);
            }
        }
        if (bUpdateAction && bIsSelected != null) {
            this.SetSelected(bIsSelected, true);
        }
        if (this.GetDispatchOnAction()) {
            this.PostStatusBarMsg(event.getSource(), null);
            this.PostActionMessage(event.getSource());
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        if (DEBUG_STATUS_TXT) {
            CDebugLog.INFO("CRhinoAction.mouseEntered");
        }
        this.PostStatusBarMsg(event.getSource(), this.GetLongDesc());
    }

    @Override
    public void mouseExited(MouseEvent event) {
        if (DEBUG_STATUS_TXT) {
            CDebugLog.INFO("CRhinoAction.mouseExited");
        }
        this.PostStatusBarMsg(event.getSource(), null);
    }

    public void SetDispatchOnAction(boolean bVal) {
        this.m_bDispatchOnAction = bVal;
    }

    public boolean GetDispatchOnAction() {
        return this.m_bDispatchOnAction;
    }

    public CRhinoAction GetVisibleAction() {
        return this.m_VisibleAction;
    }

    public void InitVisibleAction() {
        this.m_VisibleAction = this.CreateVisibleAction();
    }

    protected CRhinoAction CreateVisibleAction() {
        CRhinoAction rAction = new CRhinoAction(this.GetEventID() + 55000);
        String sName = CString.LoadString(this.GetName(), false);
        rAction.SetName(sName);
        rAction.SetShortDesc(this.FormatVisibleTip(sName));
        rAction.SetLongDesc(this.FormatVisibleStatus(sName));
        rAction.SetSmallIcon(this.GetSmallIcon());
        rAction.SetLargeIcon(this.GetLargeIcon());
        return rAction;
    }

    private String FormatVisibleStatus(String sName) {
        String sRet = CString.LoadString("IDS_FMT_SHOW_HIDE_STATUS");
        if (sRet != null) {
            sRet = String.format(sRet, CString.RemoveMnemonic(sName));
        }
        return sRet;
    }

    private String FormatVisibleTip(String sName) {
        String sRet = CString.LoadString("IDS_FMT_SHOW_HIDE_TIP");
        if (sRet != null) {
            sRet = String.format(sRet, CString.RemoveMnemonic(sName));
        }
        return sRet;
    }

    public void PostActionMessage(Object objSource) {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().PostActionMsg(objSource, this);
        }
    }

    private void PostStatusBarMsg(Object objSource, String sStatusText) {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().PostStatusBarMsg(objSource, sStatusText);
        }
    }

    public void SetVisible(boolean bVisible) {
        Vector<Component> arOwners = this.GetOwners();
        if (arOwners != null) {
            for (int nIdx = 0; nIdx < arOwners.size(); ++nIdx) {
                Component rComp = arOwners.get(nIdx);
                if (rComp == null) continue;
                rComp.setVisible(false);
            }
        }
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_STATUS_TXT = false;
    }
}

