/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui;

import com.rhinosoft.archive.IArchive;
import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.CAttrs;
import com.rhinosoft.attrs.CIntAttr;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CWorkerThreadMsg;
import com.rhinosoft.ui.CRhinoApp;
import java.awt.Color;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class CLookAndFeel
extends CAttrs {
    public static final String IDS_NIMBUS_LNF_NAME = "Nimbus";
    public static final int ACTIVE_ID_METAL = 0;
    public static final int ACTIVE_ID_NIMBUS = 1;
    public static final int ACTIVE_ID_WINDOWS = 2;
    public static final int ACTIVE_ID_MOTIF = 3;
    public static final int ACTIVE_ID_MAC = 4;
    private CIntAttr m_nCurLnFMsgID;
    protected String m_sLnFClassName;
    protected boolean m_bAlreadyLoadedFromArchive;

    public CLookAndFeel(long lUniqueID, String sLnFClassName) {
        super(lUniqueID);
        this._CLookAndFeel(sLnFClassName);
    }

    private void _CLookAndFeel(String sLnFClassName) {
        this.InitExtensions();
        this.m_nCurLnFMsgID = this.CreateCurLnFMsgID();
        this.m_bAlreadyLoadedFromArchive = false;
        this.m_sLnFClassName = sLnFClassName;
        try {
            this.SetLookAndFeel(sLnFClassName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void InitExtensions() {
    }

    public static void SetLookAndFeelUI(String sClassName) {
        block9: {
            if (sClassName == null || sClassName.isEmpty()) {
                sClassName = CLookAndFeel.GetCrossPlatformClassName();
            }
            try {
                UIManager.setLookAndFeel(sClassName);
            }
            catch (ClassNotFoundException cnfe) {
                if (CAttr.DEBUG) {
                    cnfe.printStackTrace();
                }
            }
            catch (InstantiationException ie) {
                if (CAttr.DEBUG) {
                    ie.printStackTrace();
                }
            }
            catch (IllegalAccessException iae) {
                if (CAttr.DEBUG) {
                    iae.printStackTrace();
                }
            }
            catch (UnsupportedLookAndFeelException ulafe) {
                if (!CAttr.DEBUG) break block9;
                ulafe.printStackTrace();
            }
        }
    }

    public static String GetCrossPlatformClassName() {
        return UIManager.getCrossPlatformLookAndFeelClassName();
    }

    public static String GetDefaultLookAndFeelClassName() {
        String sDefLnfClassName = UIManager.getSystemLookAndFeelClassName();
        if (sDefLnfClassName == null || sDefLnfClassName.isEmpty()) {
            sDefLnfClassName = CLookAndFeel.GetCrossPlatformClassName();
        }
        return sDefLnfClassName;
    }

    public void SetLookAndFeel(String sLnFClassName) throws UnsupportedOperationException {
        if (sLnFClassName == null || sLnFClassName.isEmpty()) {
            sLnFClassName = CLookAndFeel.GetCrossPlatformClassName();
        }
        this.m_sLnFClassName = sLnFClassName;
        CLookAndFeel.SetLookAndFeelUI(sLnFClassName);
        this.PostUpdateUI();
    }

    public void SetLookAndFeel(String sLnFClassName, int nStyle) throws UnsupportedOperationException {
        this.SetLookAndFeel(sLnFClassName, nStyle, null);
    }

    public void SetLookAndFeel(String sLnFClassName, int nStyle, String sTheme) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static boolean HasNimbusLnF() {
        boolean bHasNimbus = false;
        String sClassName = CLookAndFeel.GetNimbusClassName();
        if (sClassName != null && !sClassName.isEmpty()) {
            bHasNimbus = true;
        }
        return bHasNimbus;
    }

    public static String GetNimbusClassName() {
        String sClassName = null;
        UIManager.LookAndFeelInfo[] aInfo = UIManager.getInstalledLookAndFeels();
        if (aInfo != null) {
            for (int nIdx = 0; nIdx < aInfo.length; ++nIdx) {
                String sLnfName;
                UIManager.LookAndFeelInfo rInfo = aInfo[nIdx];
                if (rInfo == null || (sLnfName = rInfo.getName()) == null || sLnfName.isEmpty() || !sLnfName.equals(IDS_NIMBUS_LNF_NAME)) continue;
                sClassName = rInfo.getClassName();
                break;
            }
        }
        return sClassName;
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        super.OnMessage(rMsg);
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 3010: 
                case 3202: 
                case 3203: 
                case 3204: 
                case 3205: 
                case 3207: 
                case 3208: 
                case 3211: 
                case 3212: 
                case 3213: 
                case 3215: 
                case 3217: 
                case 3218: 
                case 3219: {
                    this.OnChangeLnF(rMsg.GetMsgID());
                    break;
                }
                case 4004: {
                    this.OnLoadAppProperties();
                    break;
                }
                case 4005: {
                    this.OnSaveAppProperties();
                    break;
                }
            }
        }
    }

    protected void OnChangeLnF(int nMsgID) {
        switch (nMsgID) {
            case 3202: {
                this.SetLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                this.SetCurLnFMsgID(3202);
                break;
            }
            case 3203: {
                this.SetLookAndFeel(CLookAndFeel.GetNimbusClassName());
                this.SetCurLnFMsgID(3203);
                break;
            }
            default: {
                if (!DEBUG) break;
                CDebugLog.ASSERT(CLookAndFeel.class.getName(), CDebugLog.GetLineNumber(), "Unsupported LnF Message ID!");
            }
        }
    }

    protected void SetCurLnFMsgID(int nMsgID) {
        this.m_nCurLnFMsgID.SetValue(nMsgID);
    }

    protected CIntAttr CreateCurLnFMsgID() {
        return new CIntAttr(3203, 3202, "LnFMsgID");
    }

    protected void OnLoadAppProperties() {
        this.LoadAppProperties(this.GetArchive());
    }

    protected void OnSaveAppProperties() {
        this.SaveAppProperties(this.GetArchive());
    }

    protected void LoadAppProperties(IArchive rArchive) {
        if (this.m_nCurLnFMsgID != null) {
            if (!this.m_bAlreadyLoadedFromArchive) {
                this.m_bAlreadyLoadedFromArchive = true;
                this.m_nCurLnFMsgID.Load(rArchive);
            }
            if (CRhinoApp.GET_RHINO_APP() != null) {
                CRhinoApp.GET_RHINO_APP().OnMessage(new CWorkerThreadMsg(this.m_nCurLnFMsgID.GetValueInt()));
            }
        }
    }

    protected void SaveAppProperties(IArchive rArchive) {
        if (this.m_nCurLnFMsgID != null) {
            this.m_nCurLnFMsgID.Save(rArchive);
        }
    }

    public boolean IsMetal() {
        boolean bIsMetal = false;
        String sCrossPlatName = CLookAndFeel.GetCrossPlatformClassName();
        if (this.m_sLnFClassName != null && sCrossPlatName != null && this.m_sLnFClassName.equals(sCrossPlatName)) {
            bIsMetal = true;
        }
        return bIsMetal;
    }

    public boolean IsNimbus() {
        boolean bIsNimbus = false;
        String sNimbusClassName = CLookAndFeel.GetNimbusClassName();
        if (this.m_sLnFClassName != null && sNimbusClassName != null && this.m_sLnFClassName.equals(sNimbusClassName)) {
            bIsNimbus = true;
        }
        return bIsNimbus;
    }

    protected void PostUpdateUI() {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().PostUpdateUI();
        }
    }

    public static Color GetFocusColor(Component rComp) {
        String sName = "CheckBox";
        if (rComp != null) {
            if (rComp instanceof JTabbedPane) {
                sName = "TabbedPane";
            } else if (rComp instanceof JRadioButton) {
                sName = "RadioButton";
            } else if (rComp instanceof JToggleButton) {
                sName = "ToggleButton";
            } else if (rComp instanceof AbstractButton) {
                sName = "Button";
            }
        }
        return UIManager.getColor(String.format("%s.focus", sName));
    }

    public static int GetCurrentlySetLnFID() {
        String sID;
        int nID = 0;
        LookAndFeel rLnF = UIManager.getLookAndFeel();
        if (rLnF != null && (sID = rLnF.getID()) != null && !sID.isEmpty()) {
            if ((sID = sID.toLowerCase()).startsWith("windows")) {
                nID = 2;
            } else if (sID.startsWith("motif")) {
                nID = 3;
            } else if (sID.startsWith("mac")) {
                nID = 4;
            } else if (sID.startsWith("nimbus")) {
                nID = 1;
            }
        }
        return nID;
    }
}

