/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.ui;

import com.rhinosoft.attrs.CAttrs;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.strings.CString;
import com.rhinosoft.ui.CRhinoAction;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import java.util.HashMap;

public abstract class CActionFactory {
    public static boolean DEBUG = CAttrs.DEBUG;
    private HashMap<Integer, CRhinoAction> m_aActionMap;

    public CActionFactory() {
        this._CActionFactory();
    }

    private void _CActionFactory() {
        this.m_aActionMap = new HashMap();
        this.LoadActionMap();
    }

    protected abstract void LoadActionMap();

    protected void InitActionGroup(int[] anActionGroupIDs) {
        if (anActionGroupIDs != null && anActionGroupIDs.length > 0) {
            CRhinoAction[] anGroup = new CRhinoAction[anActionGroupIDs.length];
            for (int nIdx = 0; nIdx < anActionGroupIDs.length; ++nIdx) {
                for (int nIdx2 = 0; nIdx2 < anActionGroupIDs.length; ++nIdx2) {
                    CRhinoAction rAction;
                    anGroup[nIdx2] = rAction = this.GetAction(anActionGroupIDs[nIdx2]);
                }
                CRhinoAction rAction = this.GetAction(anActionGroupIDs[nIdx]);
                if (rAction == null) continue;
                rAction.SetActionGroup(anGroup);
            }
        }
    }

    protected HashMap<Integer, CRhinoAction> GetActionMap() {
        return this.m_aActionMap;
    }

    protected boolean AddAction(Integer nID, CRhinoAction rAction) {
        boolean bRet = false;
        if (nID != null && this.GetActionMap() != null && rAction != null) {
            CRhinoAction rVisibleAction;
            if (this.GetActionMap().put(nID, rAction) != null) {
                bRet = true;
            }
            if ((rVisibleAction = rAction.GetVisibleAction()) != null) {
                this.AddAction(rVisibleAction.GetEventID(), rVisibleAction);
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CActionFactory.class.getName(), CDebugLog.GetLineNumber(), "Programming Error, bad vars.");
        }
        return bRet;
    }

    protected CRhinoAction RemoveAction(int nID) {
        CRhinoAction action = null;
        if (this.GetActionMap() != null) {
            action = this.GetActionMap().remove(nID);
        }
        return action;
    }

    public CRhinoAction GetAction(int nID) {
        CRhinoAction action = null;
        if (this.GetActionMap() != null) {
            action = this.GetActionMap().get(nID);
        }
        return action;
    }

    protected CRhinoAction CreateActionObj(int nEventID) {
        CRhinoAction action = new CRhinoAction(nEventID);
        return action;
    }

    protected CRhinoAction CreateAction(int nEventID) {
        CRhinoAction action = null;
        switch (nEventID) {
            case 3001: {
                action = this.CreateFile();
                break;
            }
            case 2015: {
                action = this.CreateExit();
                break;
            }
            case 3003: {
                action = this.CreateShutdown();
                break;
            }
            case 3100: {
                action = this.CreateEdit();
                break;
            }
            case 3101: {
                action = this.CreateSelectAll();
                break;
            }
            case 3102: {
                action = this.CreateInvertSelection();
                break;
            }
            case 2024: {
                action = this.CreateOptions();
                break;
            }
            case 3200: {
                action = this.CreateView();
                break;
            }
            case 3201: {
                action = this.CreateTheme();
                break;
            }
            case 3202: {
                action = this.CreateLnfMetal();
                break;
            }
            case 3203: {
                action = this.CreateLnfNimbus();
                break;
            }
            case 3204: {
                action = this.CreateLnfEclipse3x();
                break;
            }
            case 3205: {
                action = this.CreateLnfEclipse();
                break;
            }
            case 3206: {
                action = this.CreateLnfWindows();
                break;
            }
            case 3207: {
                action = this.CreateLnfWindowsDefault();
                break;
            }
            case 3208: {
                action = this.CreateLnfWindowsVSNET();
                break;
            }
            case 3209: {
                action = this.CreateLnfWindowsOffice();
                break;
            }
            case 3010: {
                action = this.CreateLnfWindowsOfficeDefault();
                break;
            }
            case 3211: {
                action = this.CreateLnfWindowsOfficeGray();
                break;
            }
            case 3212: {
                action = this.CreateLnfWindowsOfficeHomestead();
                break;
            }
            case 3213: {
                action = this.CreateLnfWindowsOfficeMetallic();
                break;
            }
            case 3215: {
                action = this.CreateLnfWindowsOfficeBlue();
                break;
            }
            case 3217: {
                action = this.CreateLnfXerto();
                break;
            }
            case 3218: {
                action = this.CreateLnfNixGTKPlus();
                break;
            }
            case 3219: {
                action = this.CreateLnfMacAqua();
                break;
            }
            case 3230: {
                action = this.CreateToolbars();
                break;
            }
            case 3232: {
                action = this.CreateToggleMainToolbar();
                break;
            }
            case 3233: {
                action = this.CreatePanes();
                break;
            }
            case 3300: {
                action = this.CreateWindows();
                break;
            }
            case 3301: {
                action = this.CreateFrameClose();
                break;
            }
            case 3302: {
                action = this.CreateFrameFloating();
                break;
            }
            case 3303: {
                action = this.CreateFrameAutoHide();
                break;
            }
            case 3304: {
                action = this.CreateFrameAutoHideHide();
                break;
            }
            case 3305: {
                action = this.CreateFrameAutoHideShow();
                break;
            }
            case 3306: {
                action = this.CreateFrameDockable();
                break;
            }
            case 3307: {
                action = this.CreateFrameAutoHideAll();
                break;
            }
            case 3308: {
                action = this.CreateFrameCloseAll();
                break;
            }
            case 3309: {
                action = this.CreateFrameResetLayout();
                break;
            }
            case 3310: {
                action = this.CreateFrameActivate();
                break;
            }
            case 3311: {
                action = this.CreateActivateTransferFrame();
                break;
            }
            case 3234: {
                action = this.CreateToggleFrame();
                break;
            }
            case 3231: {
                action = this.CreateToggleToolbar();
                break;
            }
            case 3312: {
                action = this.CreateShowWindowsDlg();
                break;
            }
            case 3400: {
                action = this.CreateHelp();
                break;
            }
            case 2141: {
                action = this.CreateHelpTopics();
                break;
            }
            case 2142: {
                action = this.CreateHelpOverview();
                break;
            }
            case 2143: {
                action = this.CreateSupport();
                break;
            }
            case 3403: {
                action = this.CreateKnowledgeBase();
                break;
            }
            case 2144: {
                action = this.CreateAbout();
                break;
            }
            case 3499: {
                action = this.CreateCustomize();
                break;
            }
            case 3519: {
                action = this.CreateTransferOpenFile();
                break;
            }
            case 3520: {
                action = this.CreateTransferShowInFolder();
                break;
            }
            case 3500: {
                action = this.CreateTransferStopAtNextFile();
                break;
            }
            case 3501: {
                action = this.CreateTransferSkipFile();
                break;
            }
            case 3502: {
                action = this.CreateTransferPause();
                break;
            }
            case 3503: {
                action = this.CreateTransferResume();
                break;
            }
            case 3504: {
                action = this.CreateTransferStart();
                break;
            }
            case 3505: {
                action = this.CreateTransferRestart();
                break;
            }
            case 3506: {
                action = this.CreateTransferCancel();
                break;
            }
            case 3507: {
                action = this.CreateTransferRemove();
                break;
            }
            case 3508: {
                action = this.CreateRemoveAll();
                break;
            }
            case 3509: {
                action = this.CreateTransferRemoveAllCompleted();
                break;
            }
            case 3510: {
                action = this.CreateTransferRemoveAllCancelled();
                break;
            }
            case 3511: {
                action = this.CreateTransferRemoveAllSkipped();
                break;
            }
            case 3512: {
                action = this.CreateTransferRemoveAllPaused();
                break;
            }
            case 3513: {
                action = this.CreateTransferRemoveAllWaiting();
                break;
            }
            case 3514: {
                action = this.CreateTransferRemoveAllStopped();
                break;
            }
            case 3515: {
                action = this.CreateTransferRemoveAll();
                break;
            }
            case 3516: {
                action = this.CreateResetToolbar();
                break;
            }
        }
        return action;
    }

    private CRhinoAction CreateFile() {
        CRhinoAction rAction = new CRhinoAction(3001);
        rAction.SetName(CString.LoadString("IDS_FILE_MENU", false));
        rAction.SetLongDesc(CString.LoadString("IDS_FILE_STATUS"));
        return rAction;
    }

    private CRhinoAction CreateExit() {
        CRhinoAction rAction = this.CreateActionObj(2015);
        rAction.SetName(CString.LoadString("IDS_EXIT_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_EXIT_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_EXIT_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_EXIT_PNG.GetFileName()));
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateShutdown() {
        CRhinoAction rAction = this.CreateActionObj(3003);
        rAction.SetName(CString.LoadString("IDS_SHUTDOWN_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_SHUTDOWN_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_SHUTDOWN_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_EXIT_PNG.GetFileName()));
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateEdit() {
        CRhinoAction rAction = new CRhinoAction(3100);
        rAction.SetName(CString.LoadString("IDS_EDIT_MENU", false));
        rAction.SetLongDesc(CString.LoadString("IDS_EDIT_STATUS"));
        return rAction;
    }

    private CRhinoAction CreateSelectAll() {
        CRhinoAction rAction = this.CreateActionObj(3101);
        rAction.SetName(CString.LoadString("IDS_SELECT_ALL_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_SELECT_ALL_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_SELECT_ALL_STATUS"));
        rAction.SetAccelerator(65, 128);
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_ROWS_SELECT_ALL_PNG.GetFileName()));
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateInvertSelection() {
        CRhinoAction rAction = this.CreateActionObj(3102);
        rAction.SetName(CString.LoadString("IDS_INVERT_SELECTION_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_INVERT_SELECTION_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_INVERT_SELECTION_STATUS"));
        rAction.SetAccelerator(73, 128);
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_ROWS_INVERT_SELECTION_PNG.GetFileName()));
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateOptions() {
        CRhinoAction rAction = this.CreateActionObj(2024);
        rAction.SetName(CString.LoadString("IDS_PREFERENCES_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_PREFERENCES_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_PREFERENCES_STATUS"));
        rAction.SetAccelerator(120);
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PREFERENCES_PNG.GetFileName()));
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateView() {
        CRhinoAction rAction = new CRhinoAction(3200);
        rAction.SetName(CString.LoadString("IDS_VIEW_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_VIEW_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_VIEW_STATUS"));
        return rAction;
    }

    private CRhinoAction CreateTheme() {
        CRhinoAction rAction = new CRhinoAction(3201);
        rAction.SetName(CString.LoadString("IDS_THEME_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_THEME_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_THEME_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_STYLE_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateLnfMetal() {
        CRhinoAction rAction = this.CreateActionObj(3202);
        rAction.SetName(CString.LoadString("IDS_LNF_METAL_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_METAL_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_STYLE_METAL_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateLnfNimbus() {
        CRhinoAction rAction = this.CreateActionObj(3203);
        rAction.SetName(CString.LoadString("IDS_LNF_NIMBUS_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_NIMBUS_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        return rAction;
    }

    private CRhinoAction CreateLnfEclipse3x() {
        CRhinoAction rAction = this.CreateActionObj(3204);
        rAction.SetName(CString.LoadString("IDS_LNF_ECLIPSE3X_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_ECLIPSE3X_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_STYLE_ECLIPSE_3X_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateLnfEclipse() {
        CRhinoAction rAction = this.CreateActionObj(3205);
        rAction.SetName(CString.LoadString("IDS_LNF_ECLIPSE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_ECLIPSE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_STYLE_ECLIPSE_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateLnfWindows() {
        CRhinoAction rAction = new CRhinoAction(3206);
        rAction.SetName(CString.LoadString("IDS_LNF_WINDOWS_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_WINDOWS_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_STYLE_WINDOWS_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateLnfWindowsDefault() {
        CRhinoAction rAction = this.CreateActionObj(3207);
        rAction.SetName(CString.LoadString("IDS_LNF_WINDOWS_DEFAULT_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_WINDOWS_DEFAULT_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_STYLE_WINDOWS_DEFAULT_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateLnfWindowsVSNET() {
        CRhinoAction rAction = this.CreateActionObj(3208);
        rAction.SetName(CString.LoadString("IDS_LNF_WINDOWS_VSNET_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_WINDOWS_VSNET_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_STYLE_WINDOWS_VSNET_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateLnfWindowsOffice() {
        CRhinoAction rAction = new CRhinoAction(3209);
        rAction.SetName(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_STYLE_OFFICE_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateLnfWindowsOfficeDefault() {
        CRhinoAction rAction = this.CreateActionObj(3010);
        rAction.SetName(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_DEFAULT_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_DEFAULT_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_STYLE_OFFICE_2003_DEFAULT_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateLnfWindowsOfficeGray() {
        CRhinoAction rAction = this.CreateActionObj(3211);
        rAction.SetName(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_GRAY_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_GRAY_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_STYLE_OFFICE_2003_GRAY_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateLnfWindowsOfficeHomestead() {
        CRhinoAction rAction = this.CreateActionObj(3212);
        rAction.SetName(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_HOMESTEAD_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_HOMESTEAD_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_STYLE_OFFICE_2003_HOMESTEAD_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateLnfWindowsOfficeMetallic() {
        CRhinoAction rAction = this.CreateActionObj(3213);
        rAction.SetName(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_METALLIC_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_METALLIC_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_STYLE_OFFICE_2003_METALLIC_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateLnfWindowsOfficeBlue() {
        CRhinoAction rAction = this.CreateActionObj(3215);
        rAction.SetName(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_BLUE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_WINDOWS_OFFICE_BLUE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_STYLE_OFFICE_2003_BLUE_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateLnfXerto() {
        CRhinoAction rAction = this.CreateActionObj(3217);
        rAction.SetName(CString.LoadString("IDS_LNF_XERTO_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_XERTO_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_STYLE_XERTO_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateLnfNixGTKPlus() {
        CRhinoAction rAction = this.CreateActionObj(3218);
        rAction.SetName(CString.LoadString("IDS_LNF_NIX_GTK_PLUS", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_NIX_GTK_PLUS"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_STYLE_GTK_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateLnfMacAqua() {
        CRhinoAction rAction = this.CreateActionObj(3219);
        rAction.SetName(CString.LoadString("IDS_LNF_MAC_AQUA", false));
        rAction.SetShortDesc(CString.LoadString("IDS_LNF_MAC_AQUA"));
        rAction.SetLongDesc(CString.LoadString("IDS_LNF_DESC"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_STYLE_AQUA_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateToolbars() {
        CRhinoAction rAction = new CRhinoAction(3230);
        rAction.SetName(CString.LoadString("IDS_TOOLBARS_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_TOOLBARS_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_TOOLBARS_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TOOLBARS_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateToggleMainToolbar() {
        CRhinoAction rAction = this.CreateToggleToolbar();
        rAction.SetName(CString.LoadString("IDS_TOOLBARS_MAIN_MENU", false));
        rAction.SetLongDesc(String.format(CString.LoadString("IDS_FMT_TOGGLE_BAR_STATUS"), CString.LoadString("IDS_TOOLBARS_MAIN_MENU")));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TBAR_MAIN_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreatePanes() {
        CRhinoAction rAction = new CRhinoAction(3233);
        rAction.SetName(CString.LoadString("IDS_PANES_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_PANES_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_PANES_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PANES_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateHelp() {
        CRhinoAction rAction = new CRhinoAction(3400);
        rAction.SetName(CString.LoadString("IDS_HELP_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_HELP_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_HELP_STATUS"));
        return rAction;
    }

    private CRhinoAction CreateHelpTopics() {
        CRhinoAction rAction = this.CreateActionObj(2141);
        rAction.SetName(CString.LoadString("IDS_HELP_TOPICS_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_HELP_TOPICS_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_HELP_TOPICS_STATUS"));
        rAction.SetAccelerator(112);
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_HELP_TOPICS_PNG.GetFileName()));
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateHelpOverview() {
        CRhinoAction rAction = this.CreateActionObj(2142);
        rAction.SetName(CString.LoadString("IDS_HELP_OVERVIEW_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_HELP_OVERVIEW_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_HELP_OVERVIEW_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_HELP_OVERVIEW_PNG.GetFileName()));
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateSupport() {
        CRhinoAction rAction = this.CreateActionObj(2143);
        rAction.SetName(CString.LoadString("IDS_HELP_SUPPORT_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_HELP_SUPPORT_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_HELP_SUPPORT_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TECH_SUPPORT_PNG.GetFileName()));
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateKnowledgeBase() {
        CRhinoAction rAction = this.CreateActionObj(3403);
        rAction.SetName(CString.LoadString("IDS_HELP_KNOWLEDGE_BASE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_HELP_KNOWLEDGE_BASE_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_HELP_KNOWLEDGE_BASE_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_KNOWLEDGEBASE_PNG.GetFileName()));
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateAbout() {
        CRhinoAction rAction = this.CreateActionObj(2144);
        String sName = CString.LoadString("IDS_ABOUT_MENU", false);
        sName = String.format(sName, CRhinoApp.GET_RHINO_APP().GetAppName());
        rAction.SetName(sName);
        rAction.SetShortDesc(CString.LoadString("IDS_ABOUT_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_ABOUT_STATUS"));
        rAction.SetAccelerator(123);
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_ABOUT_PNG.GetFileName()));
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateCustomize() {
        CRhinoAction rAction = this.CreateActionObj(3499);
        rAction.SetName(CString.LoadString("IDS_CUSTOMIZE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_CUSTOMIZE_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_CUSTOMIZE_STATUS"));
        return rAction;
    }

    private CRhinoAction CreateTransferOpenFile() {
        CRhinoAction rAction = this.CreateActionObj(3519);
        rAction.SetName(CString.LoadString("IDS_OPEN_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_OPEN_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_OPEN_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_OPEN_FILE_PNG.GetFileName()));
        rAction.SetSelected(false);
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateTransferShowInFolder() {
        CRhinoAction rAction = this.CreateActionObj(3520);
        rAction.SetName(CString.LoadString("IDS_SHOW_IN_FOLDER_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_SHOW_IN_FOLDER_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_SHOW_IN_FOLDER_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_SHOW_IN_FOLDER_PNG.GetFileName()));
        rAction.SetSelected(false);
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateTransferStopAtNextFile() {
        CRhinoAction rAction = this.CreateActionObj(3500);
        rAction.SetName(CString.LoadString("IDS_TRANSFER_STOP_AT_NEXT_FILE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_TRANSFER_STOP_AT_NEXT_FILE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_TRANSFER_STOP_AT_NEXT_FILE_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_STOPPED_PNG.GetFileName()));
        rAction.SetSelected(false);
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateTransferSkipFile() {
        CRhinoAction rAction = this.CreateActionObj(3501);
        rAction.SetName(CString.LoadString("IDS_TRANSFER_SKIP_FILE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_TRANSFER_SKIP_FILE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_TRANSFER_SKIP_FILE_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_SKIPPED_PNG.GetFileName()));
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateTransferPause() {
        CRhinoAction rAction = this.CreateActionObj(3502);
        rAction.SetName(CString.LoadString("IDS_TRANSFER_PAUSE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_TRANSFER_PAUSE_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_TRANSFER_PAUSE_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_PAUSED_PNG.GetFileName()));
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateTransferResume() {
        CRhinoAction rAction = this.CreateActionObj(3503);
        rAction.SetName(CString.LoadString("IDS_RESUME_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_RESUME_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_RESUME_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_RESUME_PNG.GetFileName()));
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateTransferStart() {
        CRhinoAction rAction = this.CreateActionObj(3504);
        rAction.SetName(CString.LoadString("IDS_START_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_START_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_START_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_START_PNG.GetFileName()));
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateTransferRestart() {
        CRhinoAction rAction = this.CreateActionObj(3505);
        rAction.SetName(CString.LoadString("IDS_RESTART_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_RESTART_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_RESTART_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_RESTART_PNG.GetFileName()));
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateTransferCancel() {
        CRhinoAction rAction = this.CreateActionObj(3506);
        rAction.SetName(CString.LoadString("IDS_CANCEL_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_CANCEL_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_CANCEL_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_CANCELLED_PNG.GetFileName()));
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateTransferRemove() {
        CRhinoAction rAction = this.CreateActionObj(3507);
        rAction.SetName(CString.LoadString("IDS_REMOVE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_REMOVE_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_REMOVE_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_DELETE_PNG.GetFileName()));
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateRemoveAll() {
        CRhinoAction rAction = new CRhinoAction(3508);
        rAction.SetName(CString.LoadString("IDS_REMOVE_ALL_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_REMOVE_ALL_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_REMOVE_ALL_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_REMOVE_ALL.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateTransferRemoveAllCompleted() {
        CRhinoAction rAction = this.CreateActionObj(3509);
        rAction.SetName(CString.LoadString("IDS_REMOVE_ALL_COMPLETED_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_REMOVE_ALL_COMPLETED_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_REMOVE_ALL_COMPLETED_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_REMOVE_ALL_DONE.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateTransferRemoveAllCancelled() {
        CRhinoAction rAction = this.CreateActionObj(3510);
        rAction.SetName(CString.LoadString("IDS_REMOVE_ALL_CANCELLED_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_REMOVE_ALL_CANCELLED_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_REMOVE_ALL_CANCELLED_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_REMOVE_ALL_CANCELLED.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateTransferRemoveAllSkipped() {
        CRhinoAction rAction = this.CreateActionObj(3511);
        rAction.SetName(CString.LoadString("IDS_REMOVE_ALL_SKIPPED_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_REMOVE_ALL_SKIPPED_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_REMOVE_ALL_SKIPPED_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_REMOVE_ALL_SKIPPED.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateTransferRemoveAllPaused() {
        CRhinoAction rAction = this.CreateActionObj(3512);
        rAction.SetName(CString.LoadString("IDS_REMOVE_ALL_PAUSED_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_REMOVE_ALL_PAUSED_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_REMOVE_ALL_PAUSED_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_REMOVE_ALL_PAUSED.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateTransferRemoveAllWaiting() {
        CRhinoAction rAction = this.CreateActionObj(3513);
        rAction.SetName(CString.LoadString("IDS_REMOVE_ALL_WAITING_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_REMOVE_ALL_WAITING_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_REMOVE_ALL_WAITING_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_REMOVE_ALL_WAITING.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateTransferRemoveAllStopped() {
        CRhinoAction rAction = this.CreateActionObj(3514);
        rAction.SetName(CString.LoadString("IDS_REMOVE_ALL_STOPPED_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_REMOVE_ALL_STOPPED_TIP"));
        rAction.SetLongDesc(CString.LoadString("IDS_REMOVE_ALL_STOPPED_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_REMOVE_ALL_STOPPED.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateTransferRemoveAll() {
        CRhinoAction rAction = this.CreateActionObj(3515);
        rAction.SetName(CString.LoadString("IDS_REMOVE_ALL_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_REMOVE_ALL_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_REMOVE_ALL_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TRANSFER_REMOVE_ALL.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateResetToolbar() {
        CRhinoAction rAction = this.CreateActionObj(3516);
        rAction.SetName(CString.LoadString("IDS_RESET_TOOLBAR_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_RESET_TOOLBAR_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_RESET_TOOLBAR_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_RESET_TOOLBAR_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateWindows() {
        CRhinoAction rAction = this.CreateActionObj(3300);
        rAction.SetName(CString.LoadString("IDS_WINDOWS_MENU", false));
        rAction.SetLongDesc(CString.LoadString("IDS_WINDOWS_STATUS"));
        return rAction;
    }

    private CRhinoAction CreateFrameFloating() {
        CRhinoAction rAction = this.CreateActionObj(3302);
        rAction.SetName(CString.LoadString("IDS_FRAME_FLOATING_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_FLOATING_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_FLOATING_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_WINDOWS_FLOATING_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateFrameDockable() {
        CRhinoAction rAction = this.CreateActionObj(3306);
        rAction.SetName(CString.LoadString("IDS_FRAME_DOCKABLE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_DOCKABLE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_DOCKABLE_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_WINDOWS_DOCKABLE_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateFrameAutoHide() {
        CRhinoAction rAction = this.CreateActionObj(3303);
        rAction.SetName(CString.LoadString("IDS_FRAME_AUTO_HIDE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_AUTO_HIDE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_AUTO_HIDE_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_WINDOWS_AUTOHIDE_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateFrameAutoHideHide() {
        CRhinoAction rAction = this.CreateActionObj(3304);
        rAction.SetName(CString.LoadString("IDS_FRAME_AUTO_HIDE_HIDE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_AUTO_HIDE_HIDE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_AUTO_HIDE_HIDE_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_WINDOWS_AUTOHIDE_HIDE_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateFrameAutoHideShow() {
        CRhinoAction rAction = this.CreateActionObj(3305);
        rAction.SetName(CString.LoadString("IDS_FRAME_AUTO_HIDE_SHOW_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_AUTO_HIDE_SHOW_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_AUTO_HIDE_SHOW_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_WINDOWS_AUTOHIDE_SHOW_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateFrameClose() {
        CRhinoAction rAction = this.CreateActionObj(3301);
        rAction.SetName(CString.LoadString("IDS_FRAME_CLOSE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_CLOSE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_CLOSE_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_CLOSE_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateFrameAutoHideAll() {
        CRhinoAction rAction = this.CreateActionObj(3307);
        rAction.SetName(CString.LoadString("IDS_FRAME_AUTO_HIDE_ALL_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_AUTO_HIDE_ALL_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_AUTO_HIDE_ALL_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_WINDOWS_AUTOHIDE_ALL_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateFrameCloseAll() {
        CRhinoAction rAction = this.CreateActionObj(3308);
        rAction.SetName(CString.LoadString("IDS_FRAME_CLOSE_ALL_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_CLOSE_ALL_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_CLOSE_ALL_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_WINDOWS_CLOSE_ALL_FRAMES_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateFrameResetLayout() {
        CRhinoAction rAction = this.CreateActionObj(3309);
        rAction.SetName(CString.LoadString("IDS_FRAME_RESET_LAYOUT_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_RESET_LAYOUT_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_RESET_LAYOUT_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_RESET_LAYOUT_PNG.GetFileName()));
        return rAction;
    }

    protected CRhinoAction CreateFrameActivate() {
        CRhinoAction rAction = this.CreateActionObj(3310);
        rAction.SetName(CString.LoadString("IDS_FRAME_ACTIVATE_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_FRAME_ACTIVATE_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_FRAME_ACTIVATE_STATUS"));
        return rAction;
    }

    protected CRhinoAction CreateToggleFrame() {
        CRhinoAction rAction = this.CreateActionObj(3234);
        rAction.SetName(CString.LoadString("IDS_TOGGLE_FRAME_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_TOGGLE_FRAME_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_TOGGLE_FRAME_STATUS"));
        return rAction;
    }

    protected CRhinoAction CreateToggleToolbar() {
        CRhinoAction rAction = this.CreateActionObj(3231);
        rAction.SetName(CString.LoadString("IDS_TOGGLE_TOOLBAR_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_TOGGLE_TOOBAR_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_TOGGLE_TOOLBAR_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_TBAR_TOOLBAR_PNG.GetFileName()));
        return rAction;
    }

    private CRhinoAction CreateShowWindowsDlg() {
        CRhinoAction rAction = this.CreateActionObj(3312);
        rAction.SetName(CString.LoadString("IDS_SHOW_WINDOWS_DLG_MENU", false));
        rAction.SetShortDesc(CString.LoadString("IDS_SHOW_WINDOWS_DLG_MENU"));
        rAction.SetLongDesc(CString.LoadString("IDS_SHOW_WINDOWS_DLG_STATUS"));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_WINDOWS_DLG_PNG.GetFileName()));
        rAction.InitVisibleAction();
        return rAction;
    }

    private CRhinoAction CreateActivateTransferFrame() {
        CRhinoAction rAction = this.CreateFrameActivate();
        rAction.SetName(CString.LoadString("IDS_ACTIVATE_FRAME_TRANSFER_MENU", false));
        rAction.SetLongDesc(String.format(CString.LoadString("IDS_FMT_ACTIVATE_FRAME_STATUS"), CString.LoadString("IDS_ACTIVATE_FRAME_TRANSFER_MENU")));
        rAction.SetSmallIcon(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_PANE_TRANSFER_PNG.GetFileName()));
        return rAction;
    }
}

