/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.threads;

import com.rhinosoft.attrs.CAttrs;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CWorkerThreadMsg;
import com.rhinosoft.threads.CAsynchQueue;
import com.rhinosoft.ui.CRhinoApp;

public class CWorkerThread
extends CAttrs
implements Runnable {
    public static final boolean DEBUG_LOG_METHODS;
    public static final boolean DEBUG_LOG_THREAD_LIFE;
    public static final boolean DEBUG_TRACE_WAITS;
    public static final boolean DEBUG_SINGLE_THREADED = false;
    public static final long THREAD_ID_INVALID = -1L;
    private Thread m_tWorkerThread;
    protected CAsynchQueue m_AsynchQueue;
    private boolean m_bShouldQuit;
    private boolean m_bIsProcessing;
    private CWorkerThreadMsg m_rCurrentMsg = null;

    public CWorkerThread(boolean bAutoStart) {
        this._CWorkerThread(bAutoStart);
    }

    public CWorkerThread(long lUniqueID, boolean bAutoStart) {
        super(lUniqueID);
        this._CWorkerThread(bAutoStart);
    }

    private void _CWorkerThread(boolean bAutoStart) {
        this.m_AsynchQueue = this.CreateAsynchQueue();
        this.m_tWorkerThread = new Thread(this);
        this.m_bShouldQuit = false;
        this.m_bIsProcessing = false;
        if (bAutoStart) {
            this.Start();
        }
    }

    private Thread GetThread() {
        return this.m_tWorkerThread;
    }

    public long GetThreadID() {
        long lThreadID = -1L;
        if (this.m_tWorkerThread != null) {
            lThreadID = this.m_tWorkerThread.getId();
        }
        return lThreadID;
    }

    public String GetThreadName() {
        String sName = "Unknown";
        if (this.m_tWorkerThread != null) {
            sName = this.m_tWorkerThread.getName();
        }
        return sName;
    }

    public void SetThreadName(String sThreadName) {
        if (this.m_tWorkerThread != null) {
            this.m_tWorkerThread.setName(sThreadName);
        }
    }

    public boolean GetThreadIsAlive() {
        boolean bIsAlive = false;
        if (this.m_tWorkerThread != null) {
            bIsAlive = this.m_tWorkerThread.isAlive();
        }
        return bIsAlive;
    }

    public void Start() {
        if (this.GetThread() != null) {
            this.GetThread().start();
        } else {
            CDebugLog.ASSERT(CWorkerThread.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  GetThread == null", false);
        }
    }

    private synchronized void SetShouldQuit(boolean bShouldQuit) {
        if (DEBUG_LOG_METHODS) {
            CDebugLog.ENTERING(CWorkerThread.class.getName(), "SetShouldQuit", bShouldQuit);
        }
        this.m_bShouldQuit = bShouldQuit;
        if (DEBUG_LOG_METHODS) {
            CDebugLog.EXITING(CWorkerThread.class.getName(), "SetShouldQuit", this.m_bShouldQuit);
        }
    }

    protected synchronized boolean GetShouldQuit() {
        if (DEBUG_LOG_METHODS) {
            CDebugLog.ENTERING(CWorkerThread.class.getName(), "GetShouldQuit");
            CDebugLog.EXITING(CWorkerThread.class.getName(), "GetShouldQuit");
        }
        return this.m_bShouldQuit;
    }

    public boolean SetCancel(boolean bCancel) {
        boolean bChanged = false;
        if (DEBUG_LOG_METHODS) {
            CDebugLog.ENTERING(CWorkerThread.class.getName(), "SetCancel");
        }
        if (this.GetCurrentMsg() != null) {
            bChanged = this.GetCurrentMsg().SetCancel(bCancel);
        }
        if (DEBUG_LOG_METHODS) {
            CDebugLog.EXITING(CWorkerThread.class.getName(), "SetCancel");
        }
        return bChanged;
    }

    public boolean GetCancel() {
        boolean bCancel = false;
        if (this.GetCurrentMsg() != null) {
            bCancel = this.GetCurrentMsg().GetCancel();
        }
        return bCancel;
    }

    protected synchronized void SetCurrentMsg(CWorkerThreadMsg rMsg) {
        this.m_rCurrentMsg = rMsg;
    }

    protected synchronized CWorkerThreadMsg GetCurrentMsg() {
        return this.m_rCurrentMsg;
    }

    public boolean IsValidCurrentMsg() {
        return this.GetCurrentMsg() != null;
    }

    @Override
    public void run() {
        if (DEBUG_LOG_METHODS) {
            CDebugLog.ENTERING(CWorkerThread.class.getName(), "run");
        }
        this.PostThreadStatus(2101);
        while (true) {
            this.SetIsProcessing(false);
            if (this.GetShouldQuit()) break;
            if (!this.IsMainThread()) {
                this.PostThreadStatus(2102);
            }
            CWorkerThreadMsg rMsg = null;
            this.SetCurrentMsg(null);
            try {
                rMsg = (CWorkerThreadMsg)this.m_AsynchQueue.GetHead();
            }
            catch (InterruptedException ie) {
                CDebugLog.WARNING(String.format("Thread-%d has been interrupted.", this.GetThreadID()));
                break;
            }
            if (!this.IsMainThread()) {
                this.PostThreadStatus(2103);
            }
            this.SetCurrentMsg(rMsg);
            this.SetIsProcessing(true);
            if (rMsg == null) continue;
            if (rMsg.GetMsgID() == 2100) break;
            this.OnMessage(rMsg);
        }
        if (DEBUG_LOG_THREAD_LIFE) {
            String sTrack = String.format("%40s %s-%d is dead.", "<<< DEBUG_LOG_THREAD_LIFE >>>", this.GetThread().getName(), this.GetThread().getId());
            CDebugLog.TRACE(sTrack);
        }
        this.PostThreadStatus(2104);
        if (DEBUG_LOG_METHODS) {
            CDebugLog.EXITING(CWorkerThread.class.getName(), "run");
        }
    }

    @Override
    public void NewMessage(CAttrMsg rMsg) {
        if (rMsg != null) {
            this.NewMessage((CWorkerThreadMsg)rMsg, false);
        } else if (DEBUG) {
            CDebugLog.ASSERT(CWorkerThread.class.getName(), CDebugLog.GetLineNumber(), "Programming error: rMsg = null");
        }
    }

    protected void NewMessage(CWorkerThreadMsg rMsg, boolean bHead) {
        if (rMsg != null) {
            rMsg.SetThreadAttrID(this.GetUniqueID());
        } else if (DEBUG) {
            CDebugLog.ASSERT(CWorkerThread.class.getName(), CDebugLog.GetLineNumber(), "Programming error: rMsg = null");
        }
        if (DEBUG_LOG_METHODS) {
            CDebugLog.ENTERING(CWorkerThread.class.getName(), "NewMessage", rMsg);
        }
        if (rMsg != null) {
            if (bHead) {
                this.m_AsynchQueue.AddHead(rMsg);
            } else {
                this.m_AsynchQueue.AddItem(rMsg);
            }
        } else {
            CDebugLog.ASSERT(CWorkerThread.class.getName(), CDebugLog.GetLineNumber(), "Programming error, rCmd = null", false);
        }
        if (DEBUG_LOG_METHODS) {
            CDebugLog.EXITING(CWorkerThread.class.getName(), "NewMessage");
        }
    }

    public void PostQuit() {
        if (DEBUG_LOG_METHODS) {
            CDebugLog.ENTERING(CWorkerThread.class.getName(), "Quit");
        }
        this.SetShouldQuit(true);
        this.SetCancel(true);
        this.NewMessage(new CWorkerThreadMsg(2100, this.GetThreadID()), true);
        if (DEBUG_LOG_METHODS) {
            CDebugLog.EXITING(CWorkerThread.class.getName(), "Quit");
        }
    }

    protected void PostToMainThread(CWorkerThreadMsg rMsg) {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().NewMessage(rMsg);
        } else if (DEBUG) {
            CDebugLog.ASSERT(CWorkerThread.class.getName(), CDebugLog.GetLineNumber(), "GET_APP() is NULL");
        }
    }

    protected void PostThreadStatus(int nThreadStatusMsgID) {
        CWorkerThreadMsg rMsg = new CWorkerThreadMsg(nThreadStatusMsgID, this.GetThreadID());
        this.PostToMainThread(rMsg);
    }

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        super.OnMessage(rMsg);
        if (rMsg != null) {
            rMsg.OnMessage();
            switch (rMsg.GetMsgID()) {
                default: 
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CWorkerThread.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  rMsg = null");
        }
    }

    protected void SetIsProcessing(boolean bIsProcessing) {
        this.m_bIsProcessing = bIsProcessing;
    }

    public boolean IsProcessing() {
        return this.m_bIsProcessing;
    }

    protected boolean IsMainThread() {
        return false;
    }

    public void Sleep(long lMilliSecs) {
        block3: {
            try {
                if (Thread.currentThread() == this.GetThread()) {
                    Thread.sleep(lMilliSecs);
                }
            }
            catch (InterruptedException ex) {
                if (!DEBUG) break block3;
                CDebugLog.ASSERT(CWorkerThread.class.getName(), CDebugLog.GetLineNumber(), "Thread.sleep failed.");
                ex.printStackTrace();
            }
        }
    }

    protected CAsynchQueue CreateAsynchQueue() {
        return new CAsynchQueue();
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_LOG_METHODS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_LOG_THREAD_LIFE = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACE_WAITS = false;
    }
}

