/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.threads;

import com.rhinosoft.files.CFile;
import com.rhinosoft.files.CLocalFile;
import com.rhinosoft.files.WindowsLink.CWindowsLink;
import com.rhinosoft.images.CImageUtil;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CListing;
import com.rhinosoft.messages.CLocalListing;
import com.rhinosoft.messages.CUIMessage;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CFileSystem;
import com.rhinosoft.ui.CRhinoApp;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import sun.awt.shell.ShellFolder;

public class CLocalFileSystem
extends CFileSystem {
    private static boolean DEBUG_TRACE_ROOTS;
    private static boolean DEBUG_JAVA_FILE_ICONS;
    private static boolean DEBUG_TRACK_USE_SHELL_FOLDER;
    private static boolean DEBUG_TRACK_FILE_TYPE;
    private static boolean DEBUG_TRACK_OPEN;
    public static final int REGISTRY_CODE_OK = 0;
    public static final int REGISTRY_CODE_INVALID_PARMS = 1;
    public static final int REGISTRY_CODE_DOES_NOT_EXIST = 2;
    public static CLocalFileSystem m_gLocalFileSystem;
    private MediaTracker m_MediaTracker = new MediaTracker(new JPanel());
    private boolean m_bUseShellFolders = false;
    private File[] m_afRootDirs;

    public CLocalFileSystem() {
        this._CLocalFileSystem(true, true);
    }

    public CLocalFileSystem(boolean bInitShellFolders, boolean bInitRoots) {
        this._CLocalFileSystem(bInitShellFolders, bInitRoots);
    }

    private void _CLocalFileSystem(boolean bInitShellFolders, boolean bInitRoots) {
        if (bInitShellFolders) {
            this.InitUseShellFolders();
        }
        if (bInitRoots) {
            this.InitRoots();
        }
    }

    public static CLocalFileSystem GetLocalFileSystem() {
        if (m_gLocalFileSystem == null) {
            m_gLocalFileSystem = new CLocalFileSystem();
        }
        return m_gLocalFileSystem;
    }

    @Override
    public int CheckExists(String sAbsPath) {
        int nRc = 6;
        File fTemp = new File(sAbsPath);
        if (fTemp != null && fTemp.exists()) {
            nRc = 12;
        }
        fTemp = null;
        return nRc;
    }

    @Override
    protected int CreateAllDirs(String sAbsPath) {
        int nRc = 1;
        File fNewDir = this.CreateAllLocalDirs(sAbsPath);
        if (fNewDir != null && fNewDir.exists()) {
            nRc = 0;
        }
        return nRc;
    }

    public File CreateAllLocalDirs(String sAbsPath) {
        File fDir = null;
        if (sAbsPath != null && !sAbsPath.isEmpty()) {
            fDir = new File(sAbsPath);
            File fParent = fDir.getParentFile();
            if (fParent == null || !fParent.exists()) {
                fParent = this.CreateAllLocalDirs(fParent.getPath());
            }
            if (fParent != null && fParent.exists() && (fDir == null || !fDir.exists())) {
                try {
                    fDir.mkdir();
                }
                catch (Exception e) {
                    if (DEBUG) {
                        CDebugLog.INFO("We failed to create the directory at:  " + fDir.getAbsolutePath());
                        e.printStackTrace();
                    }
                    fDir = null;
                }
            }
        }
        return fDir;
    }

    public File GetTempFolder() {
        File fTempFolder = null;
        String sTempDir = System.getProperty("java.io.tmpdir");
        fTempFolder = new File(sTempDir);
        if (fTempFolder == null || !fTempFolder.exists()) {
            File fTemp;
            block4: {
                fTemp = null;
                try {
                    fTemp = File.createTempFile("Temp", ".txt");
                }
                catch (IOException ioe) {
                    if (!DEBUG) break block4;
                    ioe.printStackTrace();
                }
            }
            if (fTemp != null && fTemp.exists()) {
                fTempFolder = fTemp.getParentFile();
                fTemp.deleteOnExit();
                fTemp.delete();
            }
        }
        return fTempFolder;
    }

    public boolean OpenFile(String sAbsFilePath) {
        boolean bShowOpenError = false;
        if (sAbsFilePath != null && !sAbsFilePath.isEmpty()) {
            boolean bDesktopWorked;
            block17: {
                CWindowsLink link;
                String sResolvedPath;
                String sTemp = sAbsFilePath;
                if ((sTemp = sTemp.toUpperCase()).endsWith(".LNK") && (sResolvedPath = (link = new CWindowsLink(sAbsFilePath)).GetResolvedPath()) != null && !sResolvedPath.isEmpty()) {
                    sAbsFilePath = sResolvedPath;
                }
                sAbsFilePath = CString.MakeBackSlashes(sAbsFilePath);
                sAbsFilePath = sAbsFilePath.replace('\\', File.separatorChar);
                bDesktopWorked = false;
                try {
                    if (Desktop.isDesktopSupported()) {
                        if (DEBUG_TRACK_OPEN) {
                            System.out.println("Desktop.getDesktop --> pre-call");
                        }
                        Desktop.getDesktop().open(new File(sAbsFilePath));
                        bDesktopWorked = true;
                        if (DEBUG_TRACK_OPEN) {
                            System.out.println("Desktop.getDesktop --> post-call");
                        }
                    } else if (DEBUG_TRACK_OPEN) {
                        System.out.println("Desktop.isDesktopSupported = FALSE");
                    }
                }
                catch (Exception e) {
                    if (!DEBUG_TRACK_OPEN) break block17;
                    System.out.printf("CLocalFile.OpenFile | JDesktop.open failed | %s", e.getMessage());
                }
            }
            if (!bDesktopWorked) {
                if (this.IsWindows()) {
                    try {
                        String sCmnd = String.format("rundll32 url.dll, FileProtocolHandler \"%s\"", sAbsFilePath);
                        if (DEBUG_TRACK_OPEN) {
                            System.out.printf("CLocalFile.OpenFile | getRuntime().exec(%s)", sCmnd);
                        }
                        Runtime.getRuntime().exec(sCmnd);
                    }
                    catch (Exception e) {
                        bShowOpenError = true;
                        if (DEBUG_TRACK_OPEN) {
                            System.out.printf("CLocalFile.OpenFile | rundll failed | %s", e.getMessage());
                        }
                    }
                } else {
                    bShowOpenError = true;
                }
            }
            if (bShowOpenError && CRhinoApp.GET_RHINO_APP() != null) {
                CUIMessage rMsg = new CUIMessage(3525, (Object)sAbsFilePath);
                CRhinoApp.GET_RHINO_APP().NewMessage(rMsg);
            }
        }
        return !bShowOpenError;
    }

    public void LaunchURL(String sURL) {
        block4: {
            try {
                Desktop.getDesktop().browse(new URL(sURL).toURI());
            }
            catch (IOException ioe) {
                System.err.println("Error in trying to show the URL (" + sURL + ") in the default browser.");
                if (DEBUG) {
                    ioe.printStackTrace();
                }
            }
            catch (URISyntaxException UriSE) {
                System.err.println("Error in trying to show the URL (" + sURL + ") in the default browser.");
                if (!DEBUG) break block4;
                UriSE.printStackTrace();
            }
        }
    }

    public boolean IsMac() {
        boolean bIsMac = false;
        String sOS = System.getProperty("os.name");
        if (sOS != null && (sOS = sOS.toLowerCase()).startsWith("mac os x")) {
            bIsMac = true;
        }
        return bIsMac;
    }

    public boolean IsSolaris() {
        boolean bIsMac = false;
        String sOS = System.getProperty("os.name");
        if (sOS != null && (sOS = sOS.toLowerCase()).startsWith("solaris")) {
            bIsMac = true;
        }
        return bIsMac;
    }

    public boolean IsNIX() {
        boolean bIsNIX = false;
        String sOS = System.getProperty("os.name");
        if (sOS != null && (sOS = sOS.toLowerCase()).startsWith("linux")) {
            bIsNIX = true;
        }
        return bIsNIX;
    }

    public boolean IsWindows() {
        boolean bIsWindows = false;
        String sOS = System.getProperty("os.name");
        if (sOS != null && (sOS = sOS.toLowerCase()).startsWith("windows")) {
            bIsWindows = true;
        }
        return bIsWindows;
    }

    public void ExtractJARFile(String sJARPath, String sDiskPath, boolean bOverwrite) {
        block7: {
            if (sJARPath != null && !sJARPath.isEmpty() && sDiskPath != null && !sDiskPath.isEmpty()) {
                InputStream inStream;
                File fDest = new File(sDiskPath);
                if ((bOverwrite || !fDest.exists()) && (inStream = this.getClass().getResourceAsStream(sJARPath)) != null) {
                    FileOutputStream outStream = null;
                    byte[] aBuf = new byte[1024];
                    try {
                        outStream = new FileOutputStream(fDest);
                        int nRead = 0;
                        while ((nRead = inStream.read(aBuf, 0, aBuf.length)) > -1) {
                            outStream.write(aBuf, 0, nRead);
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        if (DEBUG) {
                            fnfe.printStackTrace();
                        }
                    }
                    catch (IOException ioe) {
                        if (!DEBUG) break block7;
                        ioe.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    protected CListing CreateListMsg(long lTargetID, String sAbsPath, boolean bIsDir, boolean bIsRefresh) {
        CLocalListing rListing = new CLocalListing(this.GetUniqueID(), lTargetID, bIsRefresh);
        return rListing;
    }

    @Override
    protected int List(CListing rListing) {
        int nRc = 1;
        if (rListing != null) {
            CFile rListFile = rListing.GetListFile();
            if (rListFile != null) {
                String sAbsPath = rListFile.GetAbsPath();
                if (sAbsPath != null && !sAbsPath.isEmpty()) {
                    if (sAbsPath.equals("/")) {
                        File[] afRoots = this.GetRoots();
                        if (afRoots.length > 0) {
                            this.ListChildFiles(rListing, afRoots[0]);
                        }
                    } else {
                        File fList = new File(sAbsPath);
                        if (fList != null && fList.exists() && sAbsPath.toLowerCase().endsWith("lnk")) {
                            CWindowsLink link = new CWindowsLink(sAbsPath);
                            String sResolvedPath = link.GetResolvedPath();
                            if (sResolvedPath != null && !sResolvedPath.isEmpty()) {
                                fList = new File(sResolvedPath);
                                if (fList.exists()) {
                                    rListFile = new CLocalFile(fList);
                                    rListing.SetListFile(rListFile);
                                }
                            } else {
                                fList = null;
                            }
                        }
                        if (fList != null && fList.exists()) {
                            if (CRhinoApp.GET_RHINO_APP() != null) {
                                rListFile.SetIcon16(CRhinoApp.GET_RHINO_APP().GetIcon16(rListFile));
                                rListFile.SetIcon32(CRhinoApp.GET_RHINO_APP().GetIcon32(rListFile));
                                rListFile.SetType(CRhinoApp.GET_RHINO_APP().GetType(rListFile));
                            }
                            this.PostRecvFileSysOptListParent(rListing);
                            File[] afFiles = fList.listFiles();
                            this.ListChildFiles(rListing, fList);
                        } else {
                            nRc = 6;
                        }
                    }
                } else {
                    nRc = 33;
                    if (DEBUG) {
                        CDebugLog.ASSERT(CLocalFileSystem.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid arg(s).");
                    }
                }
            } else if (DEBUG) {
                CDebugLog.ASSERT(CLocalFileSystem.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid arg(s).");
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CLocalFileSystem.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid arg(s).");
        }
        return nRc;
    }

    private void ListChildFiles(CListing rListing, File rParent) {
        if (rParent != null && rParent.exists()) {
            File[] afChildFiles = rParent.listFiles();
            if (afChildFiles != null && afChildFiles.length > 0) {
                for (int nIdx = 0; nIdx < afChildFiles.length; ++nIdx) {
                    File fFile = afChildFiles[nIdx];
                    if (fFile != null) {
                        CLocalFile fChildFile = new CLocalFile(fFile);
                        if (CRhinoApp.GET_RHINO_APP() != null) {
                            fChildFile.SetIcon16(CRhinoApp.GET_RHINO_APP().GetIcon16(fChildFile));
                            fChildFile.SetIcon32(CRhinoApp.GET_RHINO_APP().GetIcon32(fChildFile));
                            fChildFile.SetType(CRhinoApp.GET_RHINO_APP().GetType(fChildFile));
                        }
                        rListing.AddChildFile(fChildFile);
                        this.PostRecvFileSysOptListChild(fChildFile, rListing);
                        if (!fFile.isDirectory() || !rListing.IsSearch()) continue;
                        this.ListChildFiles(rListing, fFile);
                        continue;
                    }
                    if (!DEBUG) continue;
                    CDebugLog.ASSERT(CLocalFileSystem.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid arg(s)");
                }
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CLocalFileSystem.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid arg(s)");
        }
    }

    public Image IconToImage(Icon icon) {
        Image rRet = null;
        if (icon != null) {
            if (icon instanceof ImageIcon) {
                rRet = ((ImageIcon)icon).getImage();
            } else {
                BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                Graphics2D g2 = image.createGraphics();
                icon.paintIcon(new JLabel(), g2, 0, 0);
                g2.dispose();
                rRet = image;
            }
        }
        return rRet;
    }

    private Icon GetJavaFileIcon(File fFile, boolean b32x32) {
        Icon icoRet = this.GetJavaFileIcon(fFile);
        if (fFile != null) {
            File fTemp;
            if (FileSystemView.getFileSystemView().isDrive(fFile) && (fTemp = this.GetDrive(fFile.getAbsolutePath())) != null) {
                fFile = fTemp;
            }
            if (fFile.exists()) {
                if (this.GetUseShellFolders()) {
                    if ((fFile = this.GetShellFile(fFile)) != null && fFile instanceof ShellFolder) {
                        ShellFolder fShellFile = (ShellFolder)fFile;
                        if (fShellFile.getIcon(true) != null) {
                            icoRet = new ImageIcon(fShellFile.getIcon(b32x32));
                        } else if (DEBUG_JAVA_FILE_ICONS) {
                            CDebugLog.ASSERT(CLocalFileSystem.class.getName(), CDebugLog.GetLineNumber(), "ASSERT:  Programming error, rShellFile.getIcon(true) = null");
                        }
                    }
                } else if (b32x32) {
                    icoRet = this.GetScaledIcon(icoRet, 32, 32);
                }
            }
        }
        return icoRet;
    }

    private Icon GetJavaFileIcon(File rFile) {
        Icon icoRet;
        block7: {
            icoRet = null;
            if (rFile != null && rFile.exists()) {
                if (this.IsMac()) {
                    JFileChooser FileChooser = this.GetFileChooser(null);
                    icoRet = FileChooser.getIcon(rFile);
                    FileChooser = null;
                } else {
                    Icon icoTemp = FileSystemView.getFileSystemView().getSystemIcon(rFile);
                    if (icoTemp != null) {
                        icoRet = icoTemp;
                        if (!(icoTemp instanceof Icon)) {
                            try {
                                BufferedImage bufferedImg = new BufferedImage(icoTemp.getIconWidth(), icoTemp.getIconHeight(), 2);
                                icoTemp.paintIcon(new JLabel(), bufferedImg.createGraphics(), 0, 0);
                                icoRet = new ImageIcon(bufferedImg);
                            }
                            catch (ClassCastException cce) {
                                if (!DEBUG) break block7;
                                cce.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
        return icoRet;
    }

    private Icon GetScaledIcon(Icon icoFileIcon, int nWidth, int nHeight) {
        Icon icoRet = icoFileIcon;
        if (icoFileIcon != null && (icoFileIcon.getIconWidth() != nWidth || icoFileIcon.getIconHeight() != nHeight)) {
            Image rImage = this.IconToImage(icoFileIcon);
            this.m_MediaTracker.addImage(rImage, 1);
            this.m_MediaTracker.checkID(1, true);
            try {
                this.m_MediaTracker.waitForID(1);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (!this.m_MediaTracker.isErrorAny()) {
                Image rScaledImage = CImageUtil.CreateScaledImage(null, rImage, nWidth, nHeight, CImageUtil.SCALE_OPTION.FIT_TO_TARGET);
                icoRet = new ImageIcon(rScaledImage);
            }
            this.m_MediaTracker.removeImage(rImage, 1);
        }
        return icoRet;
    }

    private boolean GetUseShellFolders() {
        return this.m_bUseShellFolders;
    }

    private void SetUseShellFolders(boolean bUseShellFolders) {
        this.m_bUseShellFolders = bUseShellFolders;
    }

    private void InitUseShellFolders() {
        File[] cbFolders;
        File[] afRoots;
        boolean bUseShellFolders = false;
        Boolean bFoundItInFileChooser = null;
        FileSystemView fsv = FileSystemView.getFileSystemView();
        JFileChooser rFileChooser = this.GetFileChooser(fsv);
        if (rFileChooser != null && (bFoundItInFileChooser = (Boolean)rFileChooser.getClientProperty("FileChooser.useShellFolder")) != null) {
            bUseShellFolders = bFoundItInFileChooser;
        }
        if (!bUseShellFolders && bFoundItInFileChooser == null && this.IsWindows() && (afRoots = fsv.getRoots()) != null && afRoots.length == 1 && (cbFolders = (File[])ShellFolder.get("fileChooserComboBoxFolders")) != null) {
            for (int nIdx = 0; nIdx < cbFolders.length; ++nIdx) {
                if (afRoots[0] != cbFolders[nIdx]) continue;
                bUseShellFolders = true;
                break;
            }
        }
        if (DEBUG_TRACK_USE_SHELL_FOLDER) {
            System.out.printf("UseShellFolder: %s\r\n", Boolean.toString(bUseShellFolders));
        }
        this.SetUseShellFolders(bUseShellFolders);
    }

    private synchronized File CheckSpecialFile(File fFile) {
        File fRet = null;
        if (fFile != null) {
            fRet = this.IsARoot(fFile.getAbsolutePath()) ? this.GetRoot(fFile.getAbsolutePath()) : fFile;
        }
        return fRet;
    }

    public File GetJavaFile(String sAbsPath) {
        File fRet = null;
        if (sAbsPath != null) {
            fRet = this.CheckSpecialFile(new File(sAbsPath));
        }
        return fRet;
    }

    public File GetCanonicalFile(File fFile) {
        File fCanonical = null;
        try {
            fCanonical = fFile.getCanonicalFile();
        }
        catch (IOException e) {
            fCanonical = fFile;
        }
        return fCanonical;
    }

    private File GetShellFile(File fFile) {
        File fShellFile;
        block2: {
            fShellFile = this.GetCanonicalFile(fFile);
            try {
                fShellFile = this.GetUseShellFolders() ? ShellFolder.getShellFolder(fShellFile) : fShellFile;
            }
            catch (FileNotFoundException fnfe) {
                if (!DEBUG) break block2;
                CDebugLog.EXCEPTION(CLocalFileSystem.class.getName(), CDebugLog.GetLineNumber(), String.format("EXCEPTION:  failed to get shell folder (%s)", fnfe.getMessage()), false);
            }
        }
        return fShellFile;
    }

    @Override
    public boolean IsARoot(String sAbsPath) {
        boolean bIsRoot = super.IsARoot(sAbsPath);
        if (CLocalFileSystem.IsValid(sAbsPath) && !bIsRoot) {
            File[] afRoots = this.GetRoots();
            if (afRoots != null) {
                for (int nIdx = 0; nIdx < afRoots.length && !bIsRoot; ++nIdx) {
                    boolean bIsMatch;
                    File fRoot = afRoots[nIdx];
                    if (fRoot == null) continue;
                    if (DEBUG_TRACE_ROOTS) {
                        System.out.printf("RootFile | Path: %s | DisplayName: %s\r\n", fRoot.getAbsolutePath(), FileSystemView.getFileSystemView().getSystemDisplayName(fRoot));
                    }
                    File fTemp2 = new File(fRoot.getAbsolutePath());
                    if (DEBUG_TRACE_ROOTS) {
                        System.out.printf("sAbsPath: %s | fNextRoot: %s | fTemp: %s\r\n", sAbsPath, fRoot.getAbsolutePath(), fTemp2.getAbsolutePath());
                    }
                    if (!(bIsMatch = fRoot.getAbsolutePath().endsWith(sAbsPath)) && fTemp2 != null && fTemp2.getAbsolutePath() != null) {
                        bIsMatch = fTemp2.getAbsolutePath().endsWith(sAbsPath);
                    }
                    if (!bIsMatch) continue;
                    boolean bIsUserFolder = false;
                    String sUserFolderType = null;
                    if (CRhinoApp.GET_RHINO_APP() != null) {
                        File fTemp = new File(CRhinoApp.GET_RHINO_APP().GetLocalStoragePathApp());
                        if (fTemp != null && fTemp.exists()) {
                            sUserFolderType = FileSystemView.getFileSystemView().getSystemTypeDescription(fTemp);
                        } else if (DEBUG) {
                            System.out.println("ASSERT:  Programming error, file is null");
                        }
                    }
                    String sRootFolderType = FileSystemView.getFileSystemView().getSystemTypeDescription(fRoot);
                    if (sUserFolderType != null && sRootFolderType != null && !sUserFolderType.isEmpty() && sUserFolderType.equals(sRootFolderType)) {
                        bIsUserFolder = true;
                    }
                    if (this.IsWindowsLink(sAbsPath) || bIsUserFolder) continue;
                    bIsRoot = true;
                }
            }
        } else if (DEBUG) {
            CDebugLog.TRACE("CLocalFileSystem.IsARoot | sAbsPath might be null or empty");
        }
        return bIsRoot;
    }

    public File[] GetRoots() {
        return this.m_afRootDirs;
    }

    private void SetRoots(File[] afRoots) {
        this.m_afRootDirs = afRoots;
    }

    private void InitRoots() {
        File[] afRootDirs = null;
        afRootDirs = this.GetUseShellFolders() ? (File[])ShellFolder.get("fileChooserComboBoxFolders") : FileSystemView.getFileSystemView().getRoots();
        this.SetRoots(afRootDirs);
    }

    public File GetRoot(String sAbsPath) {
        File fRet = null;
        if (CLocalFileSystem.IsValid(sAbsPath)) {
            File[] afRoots = this.GetRoots();
            if (afRoots != null) {
                if (sAbsPath.equals(this.GetRootPath())) {
                    fRet = afRoots[0];
                } else {
                    for (int nIdx = 0; nIdx < afRoots.length && fRet == null; ++nIdx) {
                        boolean bIsMatch;
                        File fRoot = afRoots[nIdx];
                        if (fRoot == null) continue;
                        if (DEBUG_TRACE_ROOTS) {
                            System.out.printf("RootFile | Path: %s | DisplayName: %s\r\n", fRoot.getAbsolutePath(), FileSystemView.getFileSystemView().getSystemDisplayName(fRoot));
                        }
                        File fTemp2 = new File(fRoot.getAbsolutePath());
                        if (DEBUG_TRACE_ROOTS) {
                            System.out.printf("sAbsPath: %s | fNextRoot: %s | fTemp: %s\r\n", sAbsPath, fRoot.getAbsolutePath(), fTemp2.getAbsolutePath());
                        }
                        if (!(bIsMatch = fRoot.getAbsolutePath().endsWith(sAbsPath)) && fTemp2 != null && fTemp2.getAbsolutePath() != null) {
                            bIsMatch = fTemp2.getAbsolutePath().endsWith(sAbsPath);
                        }
                        if (!bIsMatch) continue;
                        fRet = fRoot;
                    }
                }
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CLocalFile.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid args");
        }
        return fRet;
    }

    public File GetDrive(String sAbsPath) {
        File fDrive = null;
        File fFile = new File(sAbsPath);
        if (FileSystemView.getFileSystemView().isDrive(fFile)) {
            File[] afRoots = this.GetRoots();
            for (int nIdx = 0; nIdx < afRoots.length; ++nIdx) {
                File fRoot = afRoots[nIdx];
                if (!fFile.equals(fRoot)) continue;
                fDrive = fRoot;
                break;
            }
        }
        return fDrive;
    }

    public boolean IsWindowsLink(String sPath) {
        boolean bIsWindowsLink = false;
        if (this.IsWindows() && sPath != null && !sPath.isEmpty() && (sPath = sPath.toLowerCase()).endsWith(".lnk")) {
            bIsWindowsLink = true;
        }
        return bIsWindowsLink;
    }

    public Icon GetIcon16(File fFile) {
        return this.GetJavaFileIcon(fFile, false);
    }

    public Icon GetIcon32(File fFile) {
        return this.GetJavaFileIcon(fFile, true);
    }

    public String GetType(File fFile) {
        String sType = "";
        FileSystemView fsv = FileSystemView.getFileSystemView();
        if (fFile != null && fsv != null) {
            File fTemp;
            if (fsv.isDrive(fFile) && (fTemp = this.GetDrive(fFile.getAbsolutePath())) != null) {
                fFile = fTemp;
            }
            if (fFile.exists() && ((sType = fsv.getSystemTypeDescription(fFile)) == null || sType.isEmpty())) {
                String sExt;
                if (DEBUG_TRACK_FILE_TYPE) {
                    System.out.println("No type found on system.  Creating default.");
                }
                sType = !fFile.isDirectory() ? ((sExt = CString.GetFileExtension(fFile.getPath(), fFile.isDirectory(), false)) == null || sExt.isEmpty() ? CString.LoadString("IDS_FILE") : String.format(CString.LoadString("IDS_FMT_FILE"), sExt.toUpperCase())) : CString.LoadString("IDS_DIRECTORY");
            }
        }
        return sType;
    }

    public boolean IsDST(Date dt) {
        boolean bIsDST = false;
        TimeZone tz = TimeZone.getDefault();
        bIsDST = tz.inDaylightTime(dt);
        return bIsDST;
    }

    public int GetDSTAmount() {
        TimeZone tz = TimeZone.getDefault();
        return tz.getDSTSavings();
    }

    public Date AdjustToLocal(Date dtGMT, boolean bAdjustDST) {
        Date dtAdjusted = dtGMT;
        if (dtGMT != null) {
            dtAdjusted = new Date(dtGMT.getTime());
            if (dtAdjusted != null && dtAdjusted.getTime() > -1L) {
                int nAmt = this.GetDSTAmount();
                boolean bIsCurDST = this.IsDST(Calendar.getInstance().getTime());
                if (bAdjustDST) {
                    if (!this.IsDST(dtGMT)) {
                        if (bIsCurDST) {
                            dtAdjusted = new Date(dtGMT.getTime() + (long)nAmt);
                        }
                    } else if (!bIsCurDST) {
                        dtAdjusted = new Date(dtGMT.getTime() - (long)nAmt);
                    }
                }
            } else if (CRhinoApp.DEBUG) {
                CDebugLog.ASSERT(CLocalFileSystem.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid method parms");
            }
        }
        return dtAdjusted;
    }

    public boolean Delete(File fFile) {
        return this.Delete(fFile, false);
    }

    public boolean Delete(File fFile, boolean bDeleteOnExit) {
        boolean bDeleted = true;
        if (fFile != null && fFile.exists()) {
            block8: {
                File[] afFiles;
                if (fFile.isDirectory() && (afFiles = fFile.listFiles()) != null && afFiles.length > 0) {
                    for (int nIdx = afFiles.length - 1; nIdx >= 0; --nIdx) {
                        bDeleted = this.Delete(afFiles[nIdx]) && bDeleted;
                    }
                }
                try {
                    bDeleted = fFile.delete() && bDeleted;
                }
                catch (Exception e) {
                    if (!DEBUG) break block8;
                    CDebugLog.ASSERT(CLocalFileSystem.class.getName(), CDebugLog.GetLineNumber(), e.getMessage());
                    e.printStackTrace();
                }
            }
            if (!bDeleted) {
                fFile.deleteOnExit();
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CLocalFileSystem.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid method parms");
        }
        return bDeleted;
    }

    public int Copy(String sAbsFrom, String sAbsTo) {
        return this.Copy(new File(sAbsFrom), new File(sAbsTo));
    }

    public int Copy(File fFrom, File fTo) {
        return this.Copy(fFrom, fTo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int Copy(File fFrom, File fTo, String[] asAbsExcludePaths) {
        int nResult = 1;
        if (fFrom != null && fFrom.exists() && fTo != null) {
            int nIdx;
            boolean bExcluded = false;
            if (asAbsExcludePaths != null) {
                String sAbsSourcePath = fFrom.getAbsolutePath();
                sAbsSourcePath = CString.EnsureLastCharIsNotASlash(sAbsSourcePath);
                for (nIdx = 0; nIdx < asAbsExcludePaths.length; ++nIdx) {
                    String sAbsExcludedPath = asAbsExcludePaths[nIdx];
                    if (sAbsExcludedPath == null || !(sAbsExcludedPath = CString.EnsureLastCharIsNotASlash(sAbsExcludedPath)).equals(sAbsSourcePath)) continue;
                    bExcluded = true;
                    break;
                }
            }
            if (!bExcluded) {
                block49: {
                    if (!fTo.exists()) {
                        try {
                            if (fFrom.isDirectory()) {
                                fTo.mkdir();
                            } else {
                                fTo.createNewFile();
                            }
                        }
                        catch (IOException ioe) {
                            if (CRhinoApp.DEBUG) {
                                ioe.printStackTrace();
                            }
                        }
                        catch (SecurityException se) {
                            if (!CRhinoApp.DEBUG) break block49;
                            se.printStackTrace();
                        }
                    }
                }
                if (fTo.exists()) {
                    if (fFrom.isDirectory()) {
                        nResult = 0;
                        File[] afChildren = fFrom.listFiles();
                        for (nIdx = 0; nIdx < afChildren.length; ++nIdx) {
                            File fToChild;
                            int nResultDir;
                            File fNextChild = afChildren[nIdx];
                            if (fNextChild == null || !fNextChild.exists()) continue;
                            StringBuilder sPath = new StringBuilder(fNextChild.getAbsolutePath());
                            sPath = sPath.delete(0, fFrom.getAbsolutePath().length());
                            if (fNextChild.isDirectory()) {
                                sPath = CString.EnsureLastCharIsAFileSeparator(sPath);
                                sPath = CString.EnsureNotFirstChar(Character.valueOf(File.separatorChar), sPath);
                            }
                            String sToChild = fTo.getAbsolutePath();
                            if (fNextChild.isDirectory()) {
                                sToChild = CString.EnsureLastCharIsAFileSeparator(sToChild);
                            }
                            if ((nResultDir = this.Copy(afChildren[nIdx], fToChild = new File(sToChild = sToChild + sPath), asAbsExcludePaths)) == 0) continue;
                            nResult = nResultDir;
                        }
                    } else {
                        FileInputStream rInStream = null;
                        FileOutputStream rOutStream = null;
                        try {
                            long nTotalRead;
                            rInStream = new FileInputStream(fFrom);
                            rOutStream = new FileOutputStream(fTo);
                            byte[] aReadBuf = new byte[0x100000];
                            long nLen = fFrom.length();
                            int nRead = 0;
                            for (nTotalRead = 0L; nTotalRead < nLen && !this.GetCancel(); nTotalRead += (long)nRead) {
                                nRead = rInStream.read(aReadBuf);
                                rOutStream.write(aReadBuf, 0, nRead);
                            }
                            if (nTotalRead == nLen) {
                                nResult = 0;
                            }
                        }
                        catch (FileNotFoundException fnfe) {
                            if (CRhinoApp.DEBUG) {
                                System.out.println(String.format("EXCEPTION:  We couldn't find the file that the Streams are trying to connect to. (%s)", fnfe.getMessage()));
                            }
                        }
                        catch (IOException ioe) {
                            if (CRhinoApp.DEBUG) {
                                System.out.println(String.format("EXCEPTION:  EXCEPTION:  We couldn't read or write to the streams. (%s)", ioe.getMessage()));
                            }
                        }
                        finally {
                            if (rInStream != null) {
                                try {
                                    rInStream.close();
                                }
                                catch (IOException ioe) {
                                    ioe.printStackTrace();
                                }
                                rInStream = null;
                            }
                            if (rOutStream != null) {
                                try {
                                    rOutStream.close();
                                }
                                catch (IOException ioe) {
                                    ioe.printStackTrace();
                                }
                                rOutStream = null;
                            }
                        }
                        fTo.setLastModified(fFrom.lastModified());
                        fTo.setWritable(fFrom.canWrite());
                        fTo.setReadable(fFrom.canRead());
                    }
                } else {
                    nResult = 6;
                }
            } else {
                nResult = 0;
            }
        } else {
            nResult = 6;
        }
        return nResult;
    }

    private JFileChooser GetFileChooser(FileSystemView rFSV) {
        JFileChooser rFileChooser;
        block4: {
            rFileChooser = null;
            try {
                rFileChooser = rFSV != null ? new JFileChooser(rFSV) : new JFileChooser();
            }
            catch (Exception rFileChooserException) {
                LookAndFeel rCurLookAndFeel = null;
                try {
                    rCurLookAndFeel = UIManager.getLookAndFeel();
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    rFileChooser = rFSV != null ? new JFileChooser(rFSV) : new JFileChooser();
                    UIManager.setLookAndFeel(rCurLookAndFeel);
                }
                catch (Exception e) {
                    if (!DEBUG) break block4;
                    rFileChooserException.printStackTrace();
                }
            }
        }
        return rFileChooser;
    }

    private Object[] ReadRegistry(HKEY rHKey, HKEY_TYPE rKeyType, String sKeyPath, String sKeyName) {
        String sValue;
        int nRetCode;
        block16: {
            nRetCode = 0;
            sValue = null;
            if (this.IsWindows() && rHKey != null && rKeyType != null && sKeyPath != null && !sKeyPath.isEmpty() && sKeyName != null && !sKeyName.isEmpty()) {
                String sAbsKeyPath = rHKey.GetHKey();
                sAbsKeyPath = CString.EnsureLastCharIsABackSlash(sAbsKeyPath);
                sAbsKeyPath = sAbsKeyPath + sKeyPath;
                sAbsKeyPath = CString.MakeBackSlashes(sAbsKeyPath);
                try {
                    String sOutput;
                    StringBuilder sbQueryResult;
                    block15: {
                        String sQuery = String.format("reg query \"%s\" /v \"%s\"", sAbsKeyPath, sKeyName);
                        Process rProcess = Runtime.getRuntime().exec(sQuery);
                        InputStream rInputStream = rProcess.getInputStream();
                        sbQueryResult = new StringBuilder();
                        try {
                            int nChar = -1;
                            while ((nChar = rInputStream.read()) != -1) {
                                sbQueryResult.append((char)nChar);
                            }
                        }
                        catch (IOException e) {
                            if (!DEBUG) break block15;
                            e.printStackTrace();
                        }
                    }
                    if ((sOutput = sbQueryResult.toString()) != null) {
                        if (!(sOutput = sOutput.trim()).isEmpty()) {
                            String sType;
                            if (DEBUG) {
                                System.out.println(sOutput);
                            }
                            if ((sType = rKeyType.GetType()) != null && !sType.isEmpty()) {
                                int nFound = sOutput.indexOf(sType);
                                if (nFound > -1) {
                                    sValue = sOutput.substring(nFound += sType.length());
                                    sValue = sValue.trim();
                                } else {
                                    nRetCode = 2;
                                }
                            } else {
                                nRetCode = 2;
                            }
                        } else {
                            nRetCode = 2;
                        }
                        break block16;
                    }
                    nRetCode = 2;
                }
                catch (Exception e) {
                    if (DEBUG) {
                        e.printStackTrace();
                    }
                    break block16;
                }
            }
            nRetCode = 1;
        }
        Object[] aRetVals = new Object[]{nRetCode, sValue};
        return aRetVals;
    }

    public final String ReadRegistry(HKEY rHKey, String sKeyPath, String sKeyName, String sDefValue) {
        String sRegistryValue = null;
        HKEY_TYPE[] aTypes = new HKEY_TYPE[]{HKEY_TYPE.REG_SZ, HKEY_TYPE.REG_MULTI_SZ, HKEY_TYPE.REG_EXPAND_SZ, HKEY_TYPE.REG_BINARY};
        for (int nIdx = 0; nIdx < aTypes.length; ++nIdx) {
            Object[] aRetVals = this.ReadRegistry(rHKey, aTypes[nIdx], sKeyPath, sKeyName);
            if (aRetVals == null || aRetVals.length != 2) continue;
            try {
                Integer nRetCode = (Integer)aRetVals[0];
                if (nRetCode == null || nRetCode != 0) continue;
                sRegistryValue = (String)aRetVals[1];
                break;
            }
            catch (Exception e) {
                if (!DEBUG) continue;
                e.printStackTrace();
            }
        }
        if (sRegistryValue == null || sRegistryValue.isEmpty()) {
            sRegistryValue = sDefValue;
        }
        return sRegistryValue;
    }

    public final long ReadRegistry(HKEY rHKey, String sKeyPath, String sKeyName, long lDefValue) {
        long lValue;
        block7: {
            lValue = lDefValue;
            String sRegistryValue = null;
            HKEY_TYPE[] aTypes = new HKEY_TYPE[]{HKEY_TYPE.REG_DWORD, HKEY_TYPE.REG_QWORD};
            for (int nIdx = 0; nIdx < aTypes.length; ++nIdx) {
                Object[] aRetVals = this.ReadRegistry(rHKey, aTypes[nIdx], sKeyPath, sKeyName);
                if (aRetVals == null || aRetVals.length != 2) continue;
                try {
                    Integer nRetCode = (Integer)aRetVals[0];
                    if (nRetCode == null || nRetCode != 0) continue;
                    sRegistryValue = (String)aRetVals[1];
                    break;
                }
                catch (Exception e) {
                    if (!DEBUG) continue;
                    e.printStackTrace();
                }
            }
            if (sRegistryValue != null && !sRegistryValue.isEmpty()) {
                try {
                    Long lVal = Long.decode(sRegistryValue);
                    if (lVal != null) {
                        lValue = lVal;
                    }
                }
                catch (Exception e) {
                    lValue = lDefValue;
                    if (!DEBUG) break block7;
                    e.printStackTrace();
                }
            }
        }
        return lValue;
    }

    public final Color ReadRegistryColor(HKEY rHKey, String sKeyPath, String sKeyName, Color rDefValue) {
        Color clrValue = rDefValue;
        String sRegistryValue = null;
        HKEY_TYPE rFoundType = null;
        HKEY_TYPE[] aTypes = new HKEY_TYPE[]{HKEY_TYPE.REG_BINARY, HKEY_TYPE.REG_DWORD, HKEY_TYPE.REG_QWORD};
        for (int nIdx = 0; nIdx < aTypes.length; ++nIdx) {
            Object[] aRetVals = this.ReadRegistry(rHKey, aTypes[nIdx], sKeyPath, sKeyName);
            if (aRetVals == null || aRetVals.length != 2) continue;
            try {
                Integer nRetCode = (Integer)aRetVals[0];
                if (nRetCode == null || nRetCode != 0) continue;
                sRegistryValue = (String)aRetVals[1];
                rFoundType = aTypes[nIdx];
                break;
            }
            catch (Exception e) {
                if (!DEBUG) continue;
                e.printStackTrace();
            }
        }
        if (rFoundType != null && sRegistryValue != null && !sRegistryValue.isEmpty()) {
            int nBlue;
            int nGreen;
            int nRed;
            block11: {
                int nValue;
                block12: {
                    nRed = rDefValue.getRed();
                    nGreen = rDefValue.getGreen();
                    nBlue = rDefValue.getBlue();
                    nValue = rDefValue.getRed() | rDefValue.getGreen() << 8 | rDefValue.getBlue() << 16;
                    if (rFoundType == HKEY_TYPE.REG_BINARY) {
                        String sHex = sRegistryValue;
                        try {
                            nRed = Integer.parseInt(sHex.substring(0, 2), 16);
                            nGreen = Integer.parseInt(sHex.substring(2, 4), 16);
                            nBlue = Integer.parseInt(sHex.substring(4, 6), 16);
                        }
                        catch (Exception e) {
                            nRed = rDefValue.getRed();
                            nGreen = rDefValue.getGreen();
                            nBlue = rDefValue.getBlue();
                            if (DEBUG) {
                                e.printStackTrace();
                            }
                            break block11;
                        }
                    }
                    nValue = rDefValue.getRed() | rDefValue.getGreen() << 8 | rDefValue.getBlue() << 16;
                    try {
                        Integer nValObj = Integer.decode(sRegistryValue);
                        if (nValObj != null) {
                            nValue = nValObj;
                        }
                    }
                    catch (Exception e) {
                        nValue = rDefValue.getRed() | rDefValue.getGreen() << 8 | rDefValue.getBlue() << 16;
                        if (!DEBUG) break block12;
                        e.printStackTrace();
                    }
                }
                nRed = nValue & 0xFF;
                nGreen = (nValue & 0xFF00) >> 8;
                nBlue = (nValue & 0xFF0000) >> 16;
            }
            clrValue = new Color(nRed, nGreen, nBlue);
        }
        return clrValue;
    }

    public boolean IsRuntime_OpenJDK() {
        boolean bIsOpenJDKRuntime;
        block4: {
            bIsOpenJDKRuntime = false;
            if (this.IsNIX()) {
                try {
                    int nFound;
                    String sVersion = System.getProperty("java.runtime.name");
                    if (sVersion != null && !sVersion.isEmpty() && (nFound = (sVersion = sVersion.toLowerCase()).indexOf("openjdk")) > -1) {
                        bIsOpenJDKRuntime = true;
                    }
                }
                catch (Exception e) {
                    if (!DEBUG) break block4;
                    e.printStackTrace();
                }
            }
        }
        return bIsOpenJDKRuntime;
    }

    public boolean Is64Bit() {
        boolean bIs64Bit = false;
        if (this.IsWindows()) {
            String sProcArch = System.getenv("PROCESSOR_ARCHITECTURE");
            if (DEBUG) {
                System.out.println("PROCESSOR_ARCHITECTURE = " + sProcArch);
            }
            if (sProcArch != null) {
                if ((sProcArch = sProcArch.toLowerCase()).equals("amd64")) {
                    bIs64Bit = true;
                } else {
                    sProcArch = System.getenv("PROCESSOR_ARCHITEW6432");
                    if (DEBUG) {
                        System.out.println("PROCESSOR_ARCHITEW6432 = " + sProcArch);
                    }
                    if (sProcArch != null && (sProcArch = sProcArch.toLowerCase()).equals("amd64")) {
                        bIs64Bit = true;
                    }
                }
            }
        } else {
            String sOsArch = System.getProperty("os.arch");
            if (DEBUG) {
                System.out.println("os.arch = " + sOsArch);
            }
            if (sOsArch != null && (sOsArch = sOsArch.toLowerCase()).equals("amd64")) {
                bIs64Bit = true;
            }
        }
        return bIs64Bit;
    }

    public int Move(String sAbsSourcePath, String sAbsTargetPath) {
        int nResult;
        block3: {
            nResult = 1;
            try {
                File fSource = new File(sAbsSourcePath);
                File fTarget = new File(sAbsTargetPath);
                if (fSource.renameTo(fTarget)) {
                    nResult = 0;
                }
            }
            catch (Exception e) {
                if (!DEBUG) break block3;
                CDebugLog.EXCEPTION(CLocalFileSystem.class.getName(), CDebugLog.GetLineNumber(), "Could not rename the file.", false);
                e.printStackTrace();
            }
        }
        return nResult;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACE_ROOTS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_JAVA_FILE_ICONS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_USE_SHELL_FOLDER = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_FILE_TYPE = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_OPEN = false;
        m_gLocalFileSystem = null;
    }

    public static enum HKEY_TYPE {
        REG_BINARY("REG_BINARY"),
        REG_DWORD("REG_DWORD"),
        REG_QWORD("REG_QWORD"),
        REG_SZ("REG_SZ"),
        REG_EXPAND_SZ("REG_EXPAND_SZ"),
        REG_MULTI_SZ("REG_MULTI_SZ");

        private String m_sType;

        private HKEY_TYPE(String sType) {
            this.m_sType = sType;
        }

        public final String GetType() {
            return this.m_sType;
        }
    }

    public static enum HKEY {
        HKEY_CURRENT_USER("HKCU"),
        HKEY_LOCAL_MACHINE("HKLM");

        private String m_sHKey;

        private HKEY(String sHKey) {
            this.m_sHKey = sHKey;
        }

        public final String GetHKey() {
            return this.m_sHKey;
        }
    }
}

