/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.threads;

import com.rhinosoft.files.CFile;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.messages.CListing;
import com.rhinosoft.messages.CWorkerThreadMsg;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CWorkerThread;
import com.rhinosoft.ui.CRhinoApp;

public abstract class CFileSystem
extends CWorkerThread {
    public static final String ROOT_DIR_PATH = "/";
    public static final int SESS_LOCAL_CANT_CREATE_DIR = -3;
    public static final int SESS_OKAY = 0;
    public static final int SESS_FAIL = 1;
    public static final int SESS_PENDING = 2;
    public static final int SESS_PERMISSION_DENIED = 3;
    public static final int SESS_INVALID_PARAMETER = 4;
    public static final int SESS_BAD_SEQUENCE_OF_COMMANDS = 5;
    public static final int SESS_NOT_FOUND = 6;
    public static final int SESS_PATH_IS_PORT = 7;
    public static final int SESS_LOGIN_TOO_MANY_INVALID_TRIES = 8;
    public static final int SESS_COMMAND_PENDING = 9;
    public static final int SESS_COMMAND_ABORTED = 10;
    public static final int SESS_INTERNAL_ERROR = 11;
    public static final int SESS_ALREADY_EXISTS = 12;
    public static final int SESS_FILE_IS_DIR = 13;
    public static final int SESS_DIR_IS_FILE = 14;
    public static final int SESS_CANT_REST_EMPTY_FILE = 15;
    public static final int SESS_CANT_REST_BEYOND_EOF = 16;
    public static final int SESS_CANT_SET_FILE_POS = 17;
    public static final int SESS_COMPRESSED_TRANSFER_COMPLETE = 18;
    public static final int SESS_UNAUTHORIZED_IP = 19;
    public static final int SESS_TIME_OUT = 20;
    public static final int SESS_EXCEEDED_MAX_SESSION_TIME = 21;
    public static final int SESS_TOO_MANY_SESSIONS_IP = 22;
    public static final int SESS_TOO_MANY_SESSIONS = 23;
    public static final int SESS_BLOCKED = 24;
    public static final int SESS_DATA_SOCKET_CONNECT = 25;
    public static final int SESS_DATA_SOCKET_CLOSED = 26;
    public static final int SESS_DECR_USER_QUOTA = 27;
    public static final int SESS_NO_FILES_FOUND = 28;
    public static final int SESS_LOCK_CONFLICT = 29;
    public static final int SESS_ADMIN_ABORTED = 30;
    public static final int SESS_UNAUTHORIZED = 31;
    public static final int SESS_NO_SUCH_PATH = 33;
    public static final int SESS_INVALID_PATH = 34;
    public static final int SESS_PROTOCOL_NOT_ALLOWED_FOR_USER = 35;
    public static final int SESS_REVERSE_DNS_NAME_REQUIRED_TO_LOGIN = 38;
    public static final int SESS_USER_OKAY_NEED_PWD = 100;
    public static final int SESS_USER_NOT_FOUND = 101;
    public static final int SESS_USER_OKAY_NEED_EMAIL = 102;
    public static final int SESS_USER_NEED_SECURE_CONNECTION = 104;
    public static final int SESS_PASSWORD_EXPIRED_CHANGE = 202;
    public static final int SESS_CHG_PASSWORD_NO_OLD_PASSWORD_MATCH = 300;
    public static final int SESS_CHG_PASSWORD_TOO_SHORT = 301;
    public static final int SESS_CHG_PASSWORD_NOT_COMPLEX = 302;
    public static final int SESS_CHG_PASSWORD_OLD_NEW_MATCH = 303;
    public static final int SESS_CHG_PASSWORD_CANT_CHANGE_ANONYMOUS = 304;
    public static final int SESS_XCRC_CANNOT_READ_FROM_FILE = 400;
    public static final int SESS_CANT_LOAD_GDI_PLUS = 601;
    public static final int SESS_CANT_CREATE_THUMBNAIL = 602;
    public static final int SESS_CANT_SAVE_THUMBNAIL = 603;
    public static final int SESS_CANT_WRITE = 605;
    public static final int SESS_SERVER_STOP_PENDING = 606;
    public static final int SESS_RETR_INSUFFICIENT_CREDIT = 607;
    public static final int SESS_STOR_INSUFFICIENT_DISK_QUOTA = 608;
    public static final int SESS_STOR_INSUFFICIENT_DISK_SPACE = 609;
    public static final int SESS_STOR_FILE_TOO_LARGE = 610;
    public static final int SESS_FUTURE_TIME = 700;
    public static final int SESS_LIC_NO_FVJV = 906;
    private CFile m_fTreeRoot = null;

    public CFileSystem() {
        super(false);
    }

    public int MakeDirectory(String sAbsPath) {
        int nRc = 1;
        nRc = this.CheckExists(sAbsPath) == 12 ? 12 : this.CreateAllDirs(sAbsPath);
        return nRc;
    }

    public abstract int CheckExists(String var1);

    protected abstract int CreateAllDirs(String var1);

    public void PostListPath(long lTargetID, String sAbsPath, boolean bIsDir, boolean bIsRefresh) {
        CListing ListMsg = this.CreateListMsg(lTargetID, sAbsPath, bIsDir, bIsRefresh);
        this.NewMessage(ListMsg);
    }

    protected abstract CListing CreateListMsg(long var1, String var3, boolean var4, boolean var5);

    @Override
    public void OnMessage(CAttrMsg rMsg) {
        super.OnMessage(rMsg);
        if (rMsg != null) {
            switch (rMsg.GetMsgID()) {
                case 4210: {
                    this.OnList((CListing)rMsg);
                    break;
                }
                case 4221: {
                    break;
                }
                case 4222: {
                    break;
                }
                case 4223: {
                    break;
                }
                case 4225: {
                    break;
                }
                case 4227: {
                    break;
                }
            }
            rMsg.OnMessage(rMsg);
        } else if (DEBUG) {
            CDebugLog.ASSERT(CFileSystem.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  rMsg = null");
        }
    }

    protected void OnList(CListing rMsg) {
        if (rMsg != null) {
            this.PostRecvFileSysOpStarted(rMsg);
            int nRc = this.List(rMsg);
            if (nRc == 0) {
                this.PostRecvFileSysOpDone(rMsg);
            } else {
                this.PostRecvFileSysOpError(rMsg);
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CFileSystem.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  rMsg = null");
        }
    }

    protected void PostRecvFileSysOptListParent(CListing rSourceMsg) {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().PostRecvFileSysOptListParent(rSourceMsg);
        }
    }

    protected void PostRecvFileSysOptListChild(CFile rChild, CListing rSourceMsg) {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().PostRecvFileSysOptListChild(rChild, rSourceMsg);
        }
    }

    protected abstract int List(CListing var1);

    protected void PostRecvFileSysOpStarted(CWorkerThreadMsg rMsg) {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().PostRecvFileSysOpStarted(rMsg);
        }
    }

    protected void PostRecvFileSysOpError(CWorkerThreadMsg rMsg) {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().PostRecvFileSysOpError(rMsg);
        }
    }

    protected void PostRecvFileSysOpDone(CWorkerThreadMsg rMsg) {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().PostRecvFileSysOpDone(rMsg);
        }
    }

    public String GetRootPath() {
        return ROOT_DIR_PATH;
    }

    public static int GetMaxDepth(String sAbsPath, String sFileSep) {
        int nMaxDepth = 0;
        if (sAbsPath != null && !sAbsPath.isEmpty()) {
            sAbsPath = CString.EnsureLastChar(sFileSep.charAt(0), sAbsPath);
            int nCurIndex = 0;
            if (sAbsPath.charAt(0) == sFileSep.charAt(0) && sAbsPath.length() > 2 && sAbsPath.charAt(1) == sFileSep.charAt(0)) {
                nCurIndex = sAbsPath.indexOf(sFileSep, 2);
                ++nCurIndex;
                ++nMaxDepth;
            }
            while (nCurIndex < sAbsPath.length()) {
                int nNextIndex = sAbsPath.indexOf(sFileSep, nCurIndex);
                if (nNextIndex < 0 || nNextIndex > sAbsPath.length()) {
                    nNextIndex = sAbsPath.length();
                }
                nCurIndex = nNextIndex + 1;
                ++nMaxDepth;
            }
        }
        return nMaxDepth;
    }

    public boolean IsARoot(String sAbsPath) {
        boolean bIsRoot = false;
        if (CFileSystem.IsValid(sAbsPath)) {
            if (sAbsPath.equals(this.GetRootPath())) {
                bIsRoot = true;
            }
        } else if (DEBUG) {
            CDebugLog.TRACE("CFileSystem.IsARoot | sAbsPath is null");
        }
        return bIsRoot;
    }

    protected void SetTreeRoot(CFile rTreeRoot) {
        this.m_fTreeRoot = rTreeRoot;
    }

    public CFile GetTreeRoot() {
        return this.m_fTreeRoot;
    }
}

