/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.strings;

import com.rhinosoft.attrs.CAttrs;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.utils.CSpeedTest;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class CStringTable {
    private static boolean DEBUG = CAttrs.DEBUG;
    private static boolean DEBUG_ICED_TEA = CRhinoApp.DEBUG_ICED_TEA;
    private static boolean DEBUG_ICED_TEA_STRINGS;
    private static boolean DEBUG_RESOURCE_TIME;
    private static boolean DEBUG_TRACK_UNDEF_STRINGS;
    private String m_sBundlePath;
    private Locale m_UserLocale;
    private ResourceBundle m_ResourceBundle;

    public CStringTable(String sBundlePath, String sLanguageCode, String sCountryCode) {
        Locale rResourceBundleLocale;
        block7: {
            this.InitVars();
            this.SetBundlePath(sBundlePath);
            rResourceBundleLocale = null;
            try {
                this.m_UserLocale = new Locale(sLanguageCode, sCountryCode);
                if (this.m_UserLocale == null) {
                    this.m_UserLocale = Locale.getDefault();
                }
                if (this.m_UserLocale == null) {
                    this.m_UserLocale = new Locale(Locale.ENGLISH.getLanguage(), Locale.US.getCountry());
                }
                rResourceBundleLocale = this.m_UserLocale;
                String sLang = sLanguageCode.toLowerCase();
                rResourceBundleLocale = sLang.equals("zh") && sCountryCode.toLowerCase().equals("tw") ? this.m_UserLocale : (sLang.equals("en") || sLang.equals("de") || sLang.equals("es") || sLang.equals("fr") || sLang.equals("it") || sLang.equals("ja") || sLang.equals("ru") || sLang.equals("zh") || sLang.equals("sr") ? new Locale(sLanguageCode) : Locale.ENGLISH);
                if (rResourceBundleLocale == null) {
                    rResourceBundleLocale = Locale.getDefault();
                }
                if (rResourceBundleLocale == null) {
                    rResourceBundleLocale = new Locale(Locale.ENGLISH.getLanguage());
                }
                if (DEBUG) {
                    System.out.printf("Loading Locale: %s,%s\r\n", sLanguageCode, sCountryCode);
                    System.out.printf("English Locale: %s, %s\r\n", Locale.ENGLISH.getLanguage(), Locale.US.getCountry());
                }
            }
            catch (Exception e) {
                if (!DEBUG) break block7;
                System.out.printf("Failed to load Locale: %s,%s\r\n", sLanguageCode, sCountryCode);
                System.out.printf("English Locale: %s, %s\r\n", Locale.ENGLISH.getLanguage(), Locale.US.getCountry());
                e.printStackTrace();
            }
        }
        this.LoadStringsFromResourceBundle(this.GetBundlePath(), rResourceBundleLocale);
    }

    private void InitVars() {
        this.m_UserLocale = Locale.US;
    }

    private boolean LoadStringsFromResourceBundle(String sBundlePath, Locale rLocale) {
        boolean bLoaded;
        block13: {
            bLoaded = false;
            if (sBundlePath != null && rLocale != null) {
                try {
                    CSpeedTest sp = new CSpeedTest();
                    if (DEBUG_RESOURCE_TIME) {
                        sp.Start();
                    }
                    if (DEBUG_ICED_TEA_STRINGS) {
                        JOptionPane.showMessageDialog(null, "ResourceBundle.getBundle -->" + sBundlePath + " | " + rLocale.toString());
                    }
                    this.m_ResourceBundle = ResourceBundle.getBundle(sBundlePath, rLocale, new ResourceBundle.Control(){

                        @Override
                        public List<String> getFormats(String baseName) {
                            if (baseName == null) {
                                throw new NullPointerException();
                            }
                            return Arrays.asList("java.properties");
                        }

                        @Override
                        public List<Locale> getCandidateLocales(String baseName, Locale locale) {
                            if (baseName == null) {
                                throw new NullPointerException();
                            }
                            List<Locale> aLocaleList = null;
                            aLocaleList = locale.equals(new Locale("zh", "TW")) ? Arrays.asList(locale, Locale.CHINESE, Locale.ENGLISH, Locale.ROOT) : super.getCandidateLocales(baseName, locale);
                            return aLocaleList;
                        }
                    });
                    if (DEBUG_ICED_TEA_STRINGS) {
                        JOptionPane.showMessageDialog(null, "ResourceBundle.getBundle <--");
                    }
                    if (DEBUG_RESOURCE_TIME) {
                        System.out.printf("Loaded ResourceBundle: Path: %s | Locale: %s,%s\r\n", sBundlePath, rLocale.getLanguage(), rLocale.getCountry());
                        sp.Stop();
                        sp.PrintResults("Loaded ResourceBundle");
                    }
                    bLoaded = true;
                }
                catch (MissingResourceException exc) {
                    if (DEBUG_ICED_TEA) {
                        JOptionPane.showMessageDialog(null, "ResourceBundle.getBundle: Exception: " + exc.getMessage());
                    }
                    this.m_ResourceBundle = null;
                    if (DEBUG) {
                        System.out.printf("Failed to load ResourceBundle: Path: %s | Locale: %s,%s\r\n", sBundlePath, rLocale.getLanguage(), rLocale.getCountry());
                        exc.printStackTrace();
                    }
                    break block13;
                }
                catch (Exception e) {
                    if (DEBUG_ICED_TEA) {
                        JOptionPane.showMessageDialog(null, "ResourceBundle.getBundle: Exception: " + e.getMessage());
                    }
                    if (DEBUG) {
                        e.printStackTrace();
                    }
                    break block13;
                }
            }
            if (DEBUG) {
                CDebugLog.ASSERT(CStringTable.class.getName(), CDebugLog.GetLineNumber(), "Failed to load string resources.");
            }
        }
        return bLoaded;
    }

    public Locale GetUserLocale() {
        return this.m_UserLocale;
    }

    protected String GetBundlePath() {
        return this.m_sBundlePath;
    }

    protected void SetBundlePath(String sBundlePath) {
        this.m_sBundlePath = sBundlePath;
    }

    public String GetString(String sKey) {
        String sVal;
        block4: {
            sVal = null;
            if (this.m_ResourceBundle != null) {
                try {
                    String sTemp = this.m_ResourceBundle.getString(sKey);
                    if (sTemp != null) {
                        sVal = sTemp;
                    }
                }
                catch (Exception e) {
                    if (!DEBUG_TRACK_UNDEF_STRINGS) break block4;
                    CDebugLog.INFO(String.format("CStringTable.GetString() - Missing string: %s", sKey));
                }
            }
        }
        return sVal;
    }

    public void Unload() {
        ResourceBundle.clearCache();
    }

    static {
        if (DEBUG_ICED_TEA) {
            // empty if block
        }
        DEBUG_ICED_TEA_STRINGS = false;
        DEBUG_RESOURCE_TIME = true;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_UNDEF_STRINGS = false;
    }
}

