/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.strings;

import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CFileNameComparator
implements Comparator<String> {
    Pattern SEGMENT_PATTERN = Pattern.compile("(\\d+(\\.\\d+)?|\\D+)");

    @Override
    public int compare(String lhs, String rhs) {
        if (lhs == null && rhs == null) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        Matcher lhsMatcher = this.SEGMENT_PATTERN.matcher(lhs);
        Matcher rhsMatcher = this.SEGMENT_PATTERN.matcher(rhs);
        int result = 0;
        while (result == 0) {
            boolean lhsFound = lhsMatcher.find();
            boolean rhsFound = rhsMatcher.find();
            if (!lhsFound && !rhsFound) {
                return lhs.compareTo(rhs);
            }
            if (!lhsFound) {
                result = -1;
                continue;
            }
            if (!rhsFound) {
                result = 1;
                continue;
            }
            String lhsSegment = lhsMatcher.group();
            String rhsSegment = rhsMatcher.group();
            if (Character.isDigit(lhsSegment.toCharArray()[0])) {
                result = this.compareNumberSegments(lhsSegment, rhsSegment);
                continue;
            }
            result = this.compareStringSegments(lhsSegment, rhsSegment);
        }
        return result;
    }

    protected int compareNumberSegments(String lhs, String rhs) {
        return new Double(lhs).compareTo(new Double(rhs));
    }

    protected int compareStringSegments(String lhs, String rhs) {
        int nRet = 0;
        Collator colr = Collator.getInstance(Locale.getDefault());
        nRet = colr.compare(lhs, rhs);
        return nRet;
    }
}

