/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.net.HTTP.SU;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.CConnectionAttrs;
import com.rhinosoft.files.CFile;
import com.rhinosoft.files.CRemoteFile;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.net.HTTP.CHTTPConnection;
import com.rhinosoft.net.HTTP.SU.CDirSize;
import com.rhinosoft.net.HTTP.SU.CListing;
import com.rhinosoft.net.HTTP.SU.CNoop;
import com.rhinosoft.net.HTTP.SU.CParsedObj;
import com.rhinosoft.net.HTTP.SU.CResult;
import com.rhinosoft.net.HTTP.SU.CSUURLFactory;
import com.rhinosoft.net.HTTP.SU.CSpaceAvailable;
import com.rhinosoft.net.HTTP.SU.CTransferStatsEvent;
import com.rhinosoft.net.HTTP.SU.IListDirListener;
import com.rhinosoft.net.HTTP.SU.ITransferStatsListener;
import com.rhinosoft.ui.CRhinoApp;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public abstract class CSUConnection
extends CHTTPConnection {
    public static final boolean DEBUG = CAttr.DEBUG;
    public static final boolean DEBUG_IMAGES;
    public static final boolean DEBUG_DYNAMIC_BUFFER;
    public static final boolean DEBUG_TRACK_UPLOAD_INDICES;
    public static final boolean DEBUG_SPEED_LISTING;
    public static final boolean DEBUG_SERVER_RESOURCES;
    public static final boolean DEBUG_UPLOAD_MSGS;
    public static final boolean DEBUG_UPLOAD_FILE_RET_GOOD;
    public static final boolean DEBUG_UPLOAD_WATCHDOG;
    public static final int DEFAULT_HTTP_RESPONSE_CODE = -1;
    public static final int DEFAULT_SU_RESULT_CODE = -1;
    private static final int TRANSFER_BUFFER_SIZE_MINIMUM = 1024;
    public static final int TRANSFER_BUFFER_SIZE_DEFAULT = 5120;
    private static final long TIMEOUT_ADJUST_TRANSFER_BUFFER = 100L;
    private static final long TIMEOUT_STATS_INITIAL = 250L;
    private static final long TIMEOUT_STATS = 250L;
    private static final int UPLOAD_MAX = 0x7FFFFBFF;
    private CConnectionAttrs m_rConnectionInfo;
    private String m_sUserAgent;
    private CSUURLFactory m_URLFactory;
    private String m_sDirChangeMsg;
    private CRemoteFile m_RemoteFile;
    private long m_lDirectorySize;
    private long m_lSpaceAvailable;
    private byte[] m_aBuffer;
    private Vector<ITransferStatsListener> m_aTransferStatsListeners;
    private SimpleDateFormat m_DateFormatter;
    private Vector<IListDirListener> m_aListDirListeners;
    private boolean m_bResume = false;
    private long m_lResumeStartIndex = -1L;
    private long m_lResumeEndIndex = -1L;
    private long m_lNumOfBytesReadForCycle = 0L;
    private long m_lNumOfBytesReadTotal = 0L;
    private long m_lStartTime = 0L;
    private String m_sHTTPJavaClient;

    public CSUConnection(String sUserAgent, CConnectionAttrs rConnInfo, int nCompressionType) {
        super(nCompressionType);
        this.SetConnectionInfo(rConnInfo);
        this.m_sUserAgent = sUserAgent;
        this.m_aTransferStatsListeners = new Vector();
        this.m_aListDirListeners = new Vector();
        this.m_DateFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);
        this.m_DateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.InitHTTPJavaClient();
    }

    public final String GetUserAgent() {
        return this.m_sUserAgent;
    }

    @Override
    public void finalize() throws Throwable {
        this.m_rConnectionInfo = null;
        super.finalize();
    }

    private void InitHTTPJavaClient() {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            this.m_sHTTPJavaClient = CRhinoApp.GET_RHINO_APP().GetHTTPHeader_ClientName();
        }
    }

    private void SetConnectionInfo(CConnectionAttrs rInfo) {
        this.m_rConnectionInfo = rInfo;
        if (this.m_rConnectionInfo != null) {
            if (this.m_URLFactory != null) {
                this.m_URLFactory = null;
            }
            this.m_URLFactory = this.CreateURLFactory(this.m_rConnectionInfo.IsSecure(), this.m_rConnectionInfo.GetHost(), this.m_rConnectionInfo.GetPublicPort(), this.m_rConnectionInfo.GetEncSessionID());
        }
    }

    protected CSUURLFactory CreateURLFactory(boolean bIsSecure, String sHost, long lPort, String sSessionID) {
        CSUURLFactory rURLFactory = null;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            rURLFactory = CRhinoApp.GET_RHINO_APP().CreateURLFactory(bIsSecure, sHost, lPort, sSessionID);
        }
        return rURLFactory;
    }

    protected CConnectionAttrs GetConnectionInfo() {
        return this.m_rConnectionInfo;
    }

    protected CSUURLFactory GetURLFactory() {
        return this.m_URLFactory;
    }

    protected String[] CompileRequestHeader(boolean bAcceptCompression) throws NullPointerException {
        if (this.GetConnectionInfo() == null) {
            throw new NullPointerException("GetConnectionInfo == null in CSUConnection.CompileRequestHeader");
        }
        String[] asRet = new String[]{"User-Agent", this.GetUserAgent(), "Cookie", "Session=" + this.GetConnectionInfo().GetEncSessionID(), "Accept-Language", "en-us,en;q=0.5", "Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7", "X-User-Agent", this.GetUserAgent(), this.m_sHTTPJavaClient, "1"};
        if (bAcceptCompression) {
            String[] asTemp = new String[asRet.length];
            System.arraycopy(asRet, 0, asTemp, 0, asRet.length);
            asRet = new String[asRet.length + 2];
            System.arraycopy(asTemp, 0, asRet, 0, asTemp.length);
            asRet[asRet.length - 2] = "Accept-Encoding";
            asRet[asRet.length - 1] = "gzip,deflate";
        }
        return asRet;
    }

    private int[] SendListPath(URL rURL, boolean bUseCompression) {
        int[] anRet = new int[]{-1, -1};
        if (!this.GetCancel()) {
            anRet = this.GetListing(rURL, bUseCompression);
        } else if (DEBUG) {
            CDebugLog.INFO("CSUConnection.SendListPath was cancelled.");
        }
        return anRet;
    }

    private int[] SendListPath(String sAbsPath, boolean bIsDir) {
        int[] anRet = new int[]{-1, -1};
        if (this.GetURLFactory() != null) {
            if (sAbsPath != null && !sAbsPath.isEmpty()) {
                URL rURL = this.GetURLFactory().CreateList(sAbsPath, bIsDir);
                anRet = this.SendListPath(rURL, this.UseCompression());
            } else {
                if (DEBUG) {
                    CDebugLog.ASSERT(CSUConnection.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  AbsPath is null for SendListPath!");
                }
                anRet[1] = 11008;
            }
        } else {
            if (DEBUG) {
                CDebugLog.ASSERT(CSUConnection.class.getName(), CDebugLog.GetLineNumber(), "Programming error:  GetURLFactory is null for SendListPath!");
            }
            anRet[1] = 11001;
        }
        return anRet;
    }

    public int[] SendListDir(String sAbsPath) {
        return this.SendListPath(sAbsPath, true);
    }

    public int[] SendListFile(String sAbsPath) {
        return this.SendListPath(sAbsPath, false);
    }

    public CRemoteFile TakeListDir() {
        CRemoteFile rListDir = this.m_RemoteFile;
        this.m_RemoteFile = null;
        return rListDir;
    }

    protected CRemoteFile GetListDir() {
        return this.m_RemoteFile;
    }

    private int[] SendDeletePath(String sAbsPath, boolean bIsDir, boolean bUseCompression) {
        int[] anRet = new int[]{-1, -1};
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateDelete(sAbsPath, bIsDir);
            anRet = this.GetResult(rURL, bUseCompression);
        } else {
            anRet[1] = 11001;
        }
        return anRet;
    }

    private int[] SendDeletePath(String sAbsPath, boolean bIsDir) {
        return this.SendDeletePath(sAbsPath, bIsDir, this.UseCompression());
    }

    public int[] SendDeleteDir(String sAbsPath) {
        return this.SendDeletePath(sAbsPath, true);
    }

    public int[] SendDeleteFile(String sAbsPath) {
        return this.SendDeletePath(sAbsPath, false);
    }

    public int[] SendRenamePath(String sAbsPathFrom, String sAbsPathTo, boolean bUseCompression) {
        int[] anRet = new int[]{-1, -1};
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateRename(sAbsPathFrom, sAbsPathTo);
            anRet = this.GetResult(rURL, bUseCompression);
        } else {
            anRet[1] = 11001;
        }
        return anRet;
    }

    public int[] SendRenamePath(String sAbsPathFrom, String sAbsPathTo) {
        return this.SendRenamePath(sAbsPathFrom, sAbsPathTo, this.UseCompression());
    }

    public int[] SendCreateDir(String sAbsPath, long lLastModifiedTimestamp, boolean bUseCompression) {
        int[] anRet = new int[]{-1, -1};
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateDir(sAbsPath);
            anRet = this.GetResult(rURL, bUseCompression);
        } else {
            anRet[1] = 11001;
        }
        return anRet;
    }

    public int[] SendCreateDir(String sAbsPath, long lLastModifiedTimestamp) {
        return this.SendCreateDir(sAbsPath, lLastModifiedTimestamp, this.UseCompression());
    }

    public int[] SendDownload(String sAbsFromPath, long lFromSize, String sAbsToPath, boolean bIsThumb, int nThumbWidth, int nThumbHeight, long lResumeStart, boolean bUseCompression) {
        int[] anRet = new int[2];
        int nParseRc = 1;
        anRet[0] = -1;
        anRet[1] = -1;
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateDownload(sAbsFromPath, bIsThumb, nThumbWidth, nThumbHeight);
            boolean bCanTransfer = true;
            String[] asHeaderInfo = this.CompileRequestHeader(bUseCompression);
            if (this.GetResume() && asHeaderInfo != null) {
                this.SetResumeRange(0L, lFromSize - 1L);
                if (lResumeStart < 0L) {
                    lResumeStart = this.FindResumeStartIndex(sAbsToPath, false);
                }
                if (lResumeStart >= lFromSize) {
                    bCanTransfer = false;
                    anRet[0] = 200;
                    anRet[1] = 0;
                } else {
                    this.SetResumeStartIndex(lResumeStart);
                    String[] asTemp = new String[asHeaderInfo.length];
                    System.arraycopy(asHeaderInfo, 0, asTemp, 0, asHeaderInfo.length);
                    asHeaderInfo = new String[asTemp.length + 2];
                    System.arraycopy(asTemp, 0, asHeaderInfo, 0, asTemp.length);
                    asHeaderInfo[asHeaderInfo.length - 2] = "Range";
                    asHeaderInfo[asHeaderInfo.length - 1] = "bytes=" + this.GetResumeStartIndex() + "-" + this.GetResumeEndIndex();
                }
            }
            if (bCanTransfer) {
                boolean bIsResume = this.GetResume();
                anRet[0] = this.Get(rURL, asHeaderInfo);
                if (bIsResume && anRet[0] == 206) {
                    anRet[0] = 200;
                }
                if (anRet[0] == 200) {
                    String sContentType = this.GetHeaderValue("Content-Type", anRet);
                    if (sContentType != null && anRet[0] == 200) {
                        if (sContentType != null) {
                            sContentType = sContentType.toLowerCase();
                        }
                        if (sContentType != null && !sContentType.isEmpty() && (sContentType.equals("application/download") || bIsThumb && sContentType.startsWith("image"))) {
                            this.DownloadToFile(sAbsToPath, anRet);
                        } else {
                            BufferedInputStream inStream = this.GetInputStream(anRet);
                            if (anRet[0] == 200 && inStream != null) {
                                CResult rResult = new CResult(this);
                                nParseRc = rResult.Parse(inStream, bUseCompression);
                                anRet[1] = rResult.GetResult();
                                rResult.Destroy();
                                rResult = null;
                                this.CloseInputStream(inStream);
                            } else {
                                anRet[1] = 11003;
                            }
                        }
                    } else {
                        anRet[1] = 11018;
                    }
                } else if (anRet[0] == -1) {
                    anRet[1] = 11002;
                }
            }
            this.Disconnect();
        } else {
            anRet[1] = 11001;
        }
        if (nParseRc == 3) {
            anRet = this.SendDownload(sAbsFromPath, lFromSize, sAbsToPath, bIsThumb, nThumbWidth, nThumbHeight, lResumeStart, bUseCompression);
        }
        return anRet;
    }

    public int[] SendDownload(String sAbsFromPath, long lFromSize, String sAbsToPath, boolean bIsThumb, int nThumbWidth, int nThumbHeight, long lResumeStart) {
        return this.SendDownload(sAbsFromPath, lFromSize, sAbsToPath, bIsThumb, nThumbWidth, nThumbHeight, lResumeStart, this.UseCompression());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void DownloadToFile(String sAbsToPath, int[] anRet) {
        lReceivedSize = 0L;
        lContentLen = 0L;
        lStartIndex = 0L;
        bIsResume = this.GetResume();
        this.SetResume(false);
        if (sAbsToPath != null && !sAbsToPath.isEmpty()) {
            block53: {
                fRecvFile = new File(sAbsToPath);
                if (!fRecvFile.exists()) {
                    try {
                        if (!fRecvFile.createNewFile()) {
                            fRecvFile = null;
                        }
                    }
                    catch (IOException ioe) {
                        fRecvFile = null;
                        if (!CSUConnection.DEBUG) break block53;
                        CDebugLog.ASSERT(this.getClass().getName(), CDebugLog.GetLineNumber(), "Could not create Local target file.", true);
                    }
                }
            }
            if (fRecvFile != null && fRecvFile.exists()) {
                block54: {
                    inStream = null;
                    outStream = null;
                    fRecvFile.setWritable(true);
                    lLastModified = lStartTime = System.currentTimeMillis();
                    try {
                        bAppendToFile = false;
                        if (bIsResume) {
                            bAppendToFile = true;
                        }
                        outStream = new FileOutputStream(fRecvFile, bAppendToFile);
                    }
                    catch (Exception e) {
                        if (!CSUConnection.DEBUG) break block54;
                        e.printStackTrace();
                    }
                }
                if (outStream != null) {
                    try {
                        inStream = this.GetInputStream(anRet);
                        if (anRet[0] == 200 && inStream != null) {
                            if (inStream == null || outStream == null) {
                                throw new NullPointerException("Failed to get InputStream or OutputStream");
                            }
                            sHeaderVal = null;
                            sHeaderVal = this.GetHeaderValue("Content-Length", anRet);
                            if (sHeaderVal != null && anRet[0] == 200) {
                                if (sHeaderVal == null || sHeaderVal.isEmpty()) {
                                    sHeaderVal = this.GetHeaderValue("X-Content-Length", anRet);
                                }
                                if (sHeaderVal != null && anRet[0] == 200) {
                                    lContentLen = Long.parseLong(sHeaderVal);
                                    sHeaderVal = this.GetHeaderValue("Last-Modified", anRet);
                                    if (sHeaderVal != null && anRet[0] == 200) {
                                        block55: {
                                            try {
                                                dtLastMod = this.m_DateFormatter.parse(sHeaderVal);
                                                lLastModified = dtLastMod.getTime();
                                            }
                                            catch (Exception e) {
                                                if (!CSUConnection.DEBUG) break block55;
                                                e.printStackTrace();
                                            }
                                        }
                                        sHeaderVal = this.GetHeaderValue("SU-Last-Modified", anRet);
                                        if (sHeaderVal != null && anRet[0] == 200) {
                                            lLastModified = Long.parseLong(sHeaderVal);
                                            lLastModified *= 1000L;
                                        }
                                        nOffset = 0;
                                        lMarkerTime = 0L;
                                        lBytesPerSec = 0L;
                                        nRead = 0;
                                        if (bIsResume && (sContentRange = this.GetHeaderValue("Content-Range", anRet)) != null && anRet[0] == 200) {
                                            sHeaderVal = sContentRange;
                                            sRemove = "bytes ";
                                            sHeaderVal = sHeaderVal.substring(sRemove.length());
                                            nHyphenIdx = sHeaderVal.indexOf("-");
                                            nSlashIdx = sHeaderVal.indexOf("/");
                                            sStartIndex = sHeaderVal.substring(0, nHyphenIdx);
                                            sEndIndex = sHeaderVal.substring(nHyphenIdx + 1, nSlashIdx);
                                            sFileSize = sHeaderVal.substring(nSlashIdx + 1);
                                            lStartIndex = Long.parseLong(sStartIndex);
                                            lFileSize = Long.parseLong(sFileSize);
                                            lReceivedSize = lStartIndex;
                                            lContentLen = lFileSize;
                                            outStream.getChannel().position(lStartIndex);
                                        }
                                        if (anRet[0] == 200) {
                                            event = new CTransferStatsEvent(CTransferStatsEvent.STATE.STARTED, lReceivedSize, lContentLen, lStartIndex, lStartTime, -1L);
                                            this.FireTransferStats(event);
                                            lCalcPerSecSize = lReceivedSize;
                                            lResumeReceivedSize = 0L;
                                            this.m_aBuffer = new byte[5120];
                                            if (lContentLen == 0L && lReceivedSize == lContentLen) {
                                                event = new CTransferStatsEvent(CTransferStatsEvent.STATE.PROCESSING, lReceivedSize, lContentLen, lStartIndex, lStartTime, System.currentTimeMillis());
                                                this.FireTransferStats(event);
                                            } else {
                                                lSendStatsExpiration = System.currentTimeMillis() + 250L;
                                                while (nRead > -1 && lReceivedSize < lContentLen && !this.GetCancel()) {
                                                    nRead = inStream.read(this.m_aBuffer, nOffset, this.m_aBuffer.length);
                                                    lMarkerTime = System.currentTimeMillis();
                                                    if (nRead > 0) {
                                                        outStream.write(this.m_aBuffer, nOffset, nRead);
                                                        lReceivedSize += (long)nRead;
                                                    }
                                                    lCalcPerSecSize = lReceivedSize;
                                                    if (bIsResume) {
                                                        lCalcPerSecSize = lResumeReceivedSize += (long)nRead;
                                                    }
                                                    lBytesPerSec = CSUConnection.CalcBytesPerSecond(lMarkerTime, lStartTime, lCalcPerSecSize);
                                                    if (System.currentTimeMillis() >= lSendStatsExpiration) {
                                                        event = new CTransferStatsEvent(CTransferStatsEvent.STATE.PROCESSING, lReceivedSize, lContentLen, lStartIndex, lStartTime, lMarkerTime);
                                                        this.FireTransferStats(event);
                                                        lSendStatsExpiration = System.currentTimeMillis() + 250L;
                                                    }
                                                    if (lMarkerTime - lStartTime <= 100L) continue;
                                                    this.AdjustTransferBuffer(lBytesPerSec);
                                                }
                                            }
                                            if (lReceivedSize != lContentLen) ** GOTO lbl171
                                            anRet[1] = 0;
                                        }
                                        anRet[1] = 11020;
                                    }
                                    anRet[1] = 11019;
                                }
                                anRet[1] = 11017;
                            }
                            anRet[1] = 11016;
                        }
                        if (anRet[0] != -1) ** GOTO lbl171
                        anRet[1] = 11003;
                    }
                    catch (NullPointerException npe) {
                        if (CSUConnection.DEBUG) {
                            npe.printStackTrace();
                        }
                        anRet[1] = 11030;
                    }
                    catch (FileNotFoundException fnfe) {
                        if (CSUConnection.DEBUG) {
                            fnfe.printStackTrace();
                        }
                        anRet[1] = 11031;
                    }
                    catch (IOException ioe) {
                        if (CSUConnection.DEBUG) {
                            ioe.printStackTrace();
                        }
                        anRet[1] = 11035;
                    }
                    catch (NumberFormatException nfe) {
                        if (CSUConnection.DEBUG) {
                            nfe.printStackTrace();
                        }
                        anRet[1] = 11032;
                    }
                    catch (IllegalArgumentException iae) {
                        if (CSUConnection.DEBUG) {
                            iae.printStackTrace();
                        }
                        anRet[1] = 11033;
                    }
                    catch (SecurityException se) {
                        if (CSUConnection.DEBUG) {
                            se.printStackTrace();
                        }
                        anRet[1] = 11034;
                    }
                    finally {
                        event = new CTransferStatsEvent(CTransferStatsEvent.STATE.ENDED, lReceivedSize, lContentLen, lStartIndex, lStartTime, System.currentTimeMillis());
                        this.FireTransferStats(event);
                        this.m_aBuffer = null;
                        this.CloseInputStream(inStream);
                        this.CloseOutputStream(outStream);
                        if (fRecvFile != null && !fRecvFile.setLastModified(lLastModified)) {
                            if (CSUConnection.DEBUG) {
                                System.out.println("Failed to set \"Last Modified\" timestamp!");
                            }
                            anRet[1] = 11015;
                        }
                    }
                } else {
                    anRet[1] = 11006;
                }
            } else {
                anRet[1] = 11013;
            }
        } else {
            anRet[1] = 11009;
        }
lbl171:
        // 17 sources

        this.m_lNumOfBytesReadTotal = lReceivedSize;
    }

    public int[] SendUpload(long lTransferID, String sAbsFromPath, long lFromSize, String sAbsToPath, long lResumeStart, boolean bUseCompression) {
        int[] anRet = new int[]{-1, -1};
        this.m_lNumOfBytesReadForCycle = 0L;
        if (this.GetURLFactory() != null) {
            if (sAbsToPath != null) {
                URL rURL = this.GetURLFactory().CreateUpload(lTransferID, sAbsToPath);
                String sBoundary = this.CreateBoundary();
                String sContentDispName = "File";
                File fFromFile = new File(sAbsFromPath);
                String sContentDispFileName = fFromFile.getName();
                if (fFromFile != null && fFromFile.exists()) {
                    long lLen = fFromFile.length();
                    this.SetResumeRange(0L, lLen - 1L);
                    if (lResumeStart < 0L) {
                        lResumeStart = this.FindResumeStartIndex(sAbsToPath, true);
                    }
                    if (!this.GetResume()) {
                        lResumeStart = 0L;
                    }
                    if (lResumeStart > lFromSize) {
                        anRet[1] = 11021;
                    } else {
                        int nErrorID = 0;
                        this.SetResumeStartIndex(lResumeStart);
                        lLen = this.GetResumeEndIndex() - this.GetResumeStartIndex() + 1L;
                        if (lLen > -1L) {
                            this.SetResume(true);
                            this.m_lStartTime = System.currentTimeMillis();
                            do {
                                int nAttempt = 0;
                                do {
                                    ++nAttempt;
                                    int nLen = 0;
                                    nLen = lLen <= 0x7FFFFBFFL ? (int)lLen : 0x7FFFFBFF;
                                    int nBoundaryLength = this.GetFileBoundaryLength(sBoundary, sContentDispName, sContentDispFileName);
                                    String[] asHeaderInfo = this.CompileRequestHeader(bUseCompression);
                                    int nInfoSize = asHeaderInfo.length + 8;
                                    String[] asHeaderInfo2 = new String[nInfoSize];
                                    System.arraycopy(asHeaderInfo, 0, asHeaderInfo2, 0, asHeaderInfo.length);
                                    asHeaderInfo2[asHeaderInfo.length] = "Accept";
                                    asHeaderInfo2[asHeaderInfo.length + 1] = "*/*";
                                    asHeaderInfo2[asHeaderInfo.length + 2] = "Content-Type";
                                    asHeaderInfo2[asHeaderInfo.length + 3] = String.format("multipart/form-data; boundary=%s", sBoundary);
                                    asHeaderInfo2[asHeaderInfo.length + 4] = "Last-Modified";
                                    asHeaderInfo2[asHeaderInfo.length + 5] = this.m_DateFormatter.format(new Date(fFromFile.lastModified())) + " GMT";
                                    asHeaderInfo2[asHeaderInfo.length + 6] = "Range";
                                    asHeaderInfo2[asHeaderInfo.length + 7] = "bytes=" + this.GetResumeStartIndex() + "-" + (this.GetResumeStartIndex() + (long)(nLen - 1));
                                    anRet[0] = this.Post(rURL, asHeaderInfo2, nLen + nBoundaryLength);
                                    if (anRet[0] == 1) {
                                        this.UploadFile(nLen, fFromFile, sBoundary, sContentDispName, sContentDispFileName, lTransferID, bUseCompression, anRet);
                                        if (DEBUG_UPLOAD_WATCHDOG && anRet[0] == 408) {
                                            CDebugLog.INFO("Just encountered an upload watchdog!");
                                        }
                                        if (anRet[0] == 200 && anRet[1] == 0 || anRet[0] == 408) {
                                            if (anRet[0] == 408) {
                                                long lTargetFileSize = this.FindResumeStartIndex(sAbsToPath, true);
                                                this.SetResumeStartIndex(lTargetFileSize);
                                                lLen -= lTargetFileSize;
                                            } else {
                                                this.SetResumeStartIndex(this.GetResumeStartIndex() + this.m_lNumOfBytesReadForCycle);
                                                lLen -= this.m_lNumOfBytesReadForCycle;
                                            }
                                            if (DEBUG_UPLOAD_FILE_RET_GOOD) {
                                                lLen = 0L;
                                            }
                                        } else {
                                            nErrorID = 3;
                                        }
                                    } else {
                                        nErrorID = 2;
                                    }
                                    this.Disconnect();
                                } while (anRet[0] == 408 && nAttempt <= 3);
                            } while (lLen > 0L && nErrorID == 0);
                            this.SetResume(false);
                        } else {
                            anRet[1] = 11022;
                        }
                        if (nErrorID > 0) {
                            switch (nErrorID) {
                                case 1: {
                                    anRet[0] = 200;
                                    anRet[1] = 17;
                                    break;
                                }
                                case 2: {
                                    if (anRet[0] == 1) {
                                        anRet[0] = 503;
                                    }
                                    anRet[1] = 11002;
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                            }
                        }
                    }
                } else {
                    anRet[1] = 11012;
                }
            } else {
                anRet[1] = 11008;
            }
        } else {
            if (DEBUG) {
                CDebugLog.ASSERT(CSUConnection.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid parms.");
            }
            anRet[1] = 11000;
        }
        return anRet;
    }

    public int[] SendUpload(long lTransferID, String sAbsFromPath, long lFromSize, String sAbsToPath, long lResumeStart) {
        return this.SendUpload(lTransferID, sAbsFromPath, lFromSize, sAbsToPath, lResumeStart, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void UploadFile(int nLen, File fFile, String sBoundary, String sContentDispName, String sContentDispFileName, long lTransferID, boolean bUseCompression, int[] anRet) {
        if (DEBUG_UPLOAD_FILE_RET_GOOD) {
            anRet[0] = 200;
            anRet[1] = 0;
            return;
        }
        if (DEBUG_PRINT_REQUEST_HEADER) {
            this.PrintRequestHeader();
        }
        if (DEBUG_UPLOAD_MSGS) {
            Date dtTime = new Date(System.currentTimeMillis());
            System.out.printf("Begin uploading: %s | Timestamp: %s\r\n", fFile.getName(), dtTime.toString());
        }
        boolean bPollForResult = false;
        anRet[1] = -1;
        this.m_lNumOfBytesReadForCycle = 0L;
        int nParseRc = 1;
        boolean bOverrideResult = false;
        if (fFile != null && fFile.exists()) {
            InputStream finStream;
            OutputStream outStream;
            block35: {
                outStream = null;
                finStream = null;
                try {
                    finStream = new FileInputStream(fFile);
                }
                catch (Exception e) {
                    if (!DEBUG) break block35;
                    e.printStackTrace();
                }
            }
            if (finStream != null) {
                long lTotalRead;
                long lStartPos = lTotalRead = 0L;
                long lFileSize = fFile.length();
                CTransferStatsEvent event = null;
                try {
                    outStream = this.GetOutputStream();
                    if (outStream != null) {
                        long lBytesRead = 0L;
                        long lMarkerTime = 0L;
                        String sTemp = null;
                        sTemp = this.FmtStartBoundary(sBoundary, sContentDispName, sContentDispFileName);
                        outStream.write(sTemp.getBytes(), 0, sTemp.getBytes().length);
                        outStream.flush();
                        long lResumeStart = this.GetResumeStartIndex();
                        if (lResumeStart >= 0L) {
                            long lSkipped;
                            lTotalRead = lSkipped = finStream.skip(lResumeStart);
                        }
                        lStartPos = lTotalRead;
                        long lCalcPerSecSize = lTotalRead;
                        long lResumeReceivedSize = 0L;
                        long lBytesPerSec = 0L;
                        event = new CTransferStatsEvent(CTransferStatsEvent.STATE.STARTED, lTotalRead, lFileSize, lStartPos, this.m_lStartTime, -1L);
                        this.FireTransferStats(event);
                        int nBufSize = Math.min(5120, nLen);
                        this.m_aBuffer = new byte[nBufSize];
                        if (lFileSize == 0L) {
                            event = new CTransferStatsEvent(CTransferStatsEvent.STATE.PROCESSING, lTotalRead, lFileSize, lStartPos, this.m_lStartTime, System.currentTimeMillis());
                            this.FireTransferStats(event);
                        } else {
                            long lSendStatsExpiration = System.currentTimeMillis() + 250L;
                            while (nLen > 0 && (lBytesRead = (long)finStream.read(this.m_aBuffer, 0, this.m_aBuffer.length)) != -1L && !this.GetCancel()) {
                                if (DEBUG_TRACK_UPLOAD_INDICES) {
                                    System.out.printf("lBytesRead: %d | nLen: %d | m_aBuffer.length: %d\r\n", lBytesRead, nLen, this.m_aBuffer.length);
                                }
                                outStream.write(this.m_aBuffer, 0, (int)lBytesRead);
                                lMarkerTime = System.currentTimeMillis();
                                nLen = (int)((long)nLen - lBytesRead);
                                this.m_lNumOfBytesReadForCycle += lBytesRead;
                                lTotalRead += lBytesRead;
                                lCalcPerSecSize = lResumeReceivedSize += lBytesRead;
                                lBytesPerSec = CSUConnection.CalcBytesPerSecond(lMarkerTime, this.m_lStartTime, lCalcPerSecSize);
                                if (System.currentTimeMillis() >= lSendStatsExpiration) {
                                    event = new CTransferStatsEvent(CTransferStatsEvent.STATE.PROCESSING, lTotalRead, lFileSize, lStartPos, this.m_lStartTime, lMarkerTime);
                                    this.FireTransferStats(event);
                                    lSendStatsExpiration = System.currentTimeMillis() + 250L;
                                }
                                if (lMarkerTime - this.m_lStartTime > 100L) {
                                    this.AdjustTransferBuffer(lBytesPerSec);
                                }
                                if (this.m_aBuffer.length <= nLen) continue;
                                this.m_aBuffer = null;
                                this.m_aBuffer = new byte[nLen];
                            }
                        }
                        sTemp = this.FmtEndBoundary(sBoundary);
                        outStream.write(sTemp.getBytes(), 0, sTemp.getBytes().length);
                        outStream.flush();
                    }
                    anRet[1] = 11004;
                }
                catch (NullPointerException npe) {
                    if (DEBUG) {
                        npe.printStackTrace();
                    }
                    anRet[1] = 11036;
                }
                catch (IOException ioe) {
                    if (DEBUG) {
                        ioe.printStackTrace();
                    }
                    anRet[1] = 11037;
                    bPollForResult = true;
                }
                finally {
                    event = new CTransferStatsEvent(CTransferStatsEvent.STATE.ENDED, lTotalRead, lFileSize, lStartPos, this.m_lStartTime, System.currentTimeMillis());
                    this.FireTransferStats(event);
                    outStream = this.CloseOutputStream(outStream);
                    finStream = this.CloseInputStream(finStream);
                    this.m_aBuffer = null;
                    if (DEBUG_PRINT_RESPONSE_HEADER) {
                        this.PrintResponseHeader();
                    }
                    if (DEBUG_PRINT_RESPONSE_BODY) {
                        this.PrintResponseBody();
                    }
                    this.m_lNumOfBytesReadTotal = lTotalRead;
                }
            } else {
                anRet[1] = -6;
                bOverrideResult = true;
            }
        } else {
            anRet[1] = 11013;
        }
        if (DEBUG_UPLOAD_MSGS) {
            Date dtTime = new Date(System.currentTimeMillis());
            System.out.printf("Finished uploading: %s | Timestamp: %s\r\n", fFile.getName(), dtTime.toString());
        }
        if (!bPollForResult) {
            anRet[0] = this.GetHTTPResponseCode();
            if (!this.GetCancel() && !bOverrideResult && anRet[0] == 200) {
                BufferedInputStream inStream = this.GetInputStream(anRet);
                if (anRet[0] == 200 && inStream != null) {
                    CResult rResult = new CResult(this);
                    nParseRc = rResult.Parse(inStream, bUseCompression);
                    anRet[1] = rResult.GetResult();
                    rResult.Destroy();
                    rResult = null;
                    this.CloseInputStream(inStream);
                } else if (anRet[0] == -1 && inStream == null) {
                    anRet[1] = 11003;
                }
            }
        } else {
            anRet = this.PollForResult(lTransferID, bUseCompression);
        }
    }

    private boolean AdjustTransferBuffer(long lBytesPerSecond) {
        boolean bContinue = true;
        long lBufferSize = this.m_aBuffer.length;
        lBufferSize = lBytesPerSecond < 102400L ? lBytesPerSecond / 6L : (lBytesPerSecond < 204800L ? lBytesPerSecond / 5L : (lBytesPerSecond < 307200L ? lBytesPerSecond / 4L : (lBytesPerSecond < 409600L ? lBytesPerSecond / 3L : lBytesPerSecond / 2L)));
        if (lBufferSize < 1024L) {
            lBufferSize = 1024L;
        }
        if ((double)Math.abs(lBufferSize - (long)this.m_aBuffer.length) > (double)this.m_aBuffer.length * 0.05) {
            int nBufSize = this.m_aBuffer.length;
            nBufSize = lBufferSize > 0x7FFFFFFEL ? 0x7FFFFFFE : (int)lBufferSize;
            if (DEBUG_DYNAMIC_BUFFER) {
                System.out.println("AdjustTransferBuffer: " + nBufSize);
            }
            this.m_aBuffer = null;
            try {
                this.m_aBuffer = new byte[nBufSize];
            }
            catch (Exception e) {
                try {
                    System.gc();
                    this.m_aBuffer = new byte[nBufSize];
                }
                catch (Exception ex) {
                    if (DEBUG) {
                        ex.printStackTrace();
                        CDebugLog.ASSERT(this.getClass().getName(), CDebugLog.GetLineNumber(), "Failed to create a dynamic buffer.", false);
                    }
                    bContinue = false;
                    this.SetCancel(true);
                }
            }
        }
        return bContinue;
    }

    public static long CalcBytesPerSecond(long lCurTime, long lStartTime, long lNumOfBytes) {
        return CSUConnection.CalcBytesPerSecond(lCurTime - lStartTime, lNumOfBytes);
    }

    public static long CalcBytesPerSecond(long lElapsedTimeInMillis, long lNumOfBytes) {
        long lBytesPerSecond = 0L;
        double dSecondsElapsed = (double)lElapsedTimeInMillis / 1000.0;
        long lSecondsElapsed = (long)Math.ceil(dSecondsElapsed);
        if (lSecondsElapsed < 1L) {
            lSecondsElapsed = 1L;
        }
        lBytesPerSecond = lNumOfBytes / lSecondsElapsed;
        return lBytesPerSecond;
    }

    protected Vector<ITransferStatsListener> GetTransferStatsListeners() {
        return this.m_aTransferStatsListeners;
    }

    public void AddTransferStatsListener(ITransferStatsListener rListener) {
        if (this.GetTransferStatsListeners() != null && rListener != null) {
            this.GetTransferStatsListeners().add(rListener);
        }
    }

    public void RemoveTransferStatsListener(ITransferStatsListener rListener) {
        if (this.GetTransferStatsListeners() != null && rListener != null) {
            this.GetTransferStatsListeners().remove(rListener);
        }
    }

    protected void FireTransferStats(CTransferStatsEvent rEvent) {
        assert (rEvent != null);
        assert (this.GetTransferStatsListeners() != null);
        for (int nIdx = this.GetTransferStatsListeners().size() - 1; nIdx >= 0; --nIdx) {
            ITransferStatsListener rListener = this.GetTransferStatsListeners().get(nIdx);
            if (rListener == null) continue;
            rListener.OnUpdateTransferStats(rEvent);
        }
    }

    public int[] SendNoop(boolean bUseCompression, CNoop[] arNoopObj) {
        int[] anRet = new int[2];
        int nParseRc = 1;
        anRet[0] = -1;
        anRet[1] = -1;
        if (this.GetURLFactory() != null) {
            String[] asHeaderInfo;
            URL rURL = this.GetURLFactory().CreateNoop();
            anRet[0] = this.Get(rURL, asHeaderInfo = this.CompileRequestHeader(bUseCompression));
            if (anRet[0] == 200) {
                String sAcceptEncoding = this.GetHeaderValue("Accept-Encoding", anRet);
                if (sAcceptEncoding != null && anRet[0] == 200) {
                    sAcceptEncoding = sAcceptEncoding.toLowerCase();
                }
                if (anRet[0] == 200) {
                    BufferedInputStream inStream = this.GetInputStream(anRet);
                    if (anRet[0] == 200 && inStream != null) {
                        CNoop rNoop = this.CreateNoop();
                        if (arNoopObj != null && arNoopObj.length > 0) {
                            arNoopObj[0] = rNoop;
                        }
                        rNoop.Parse(inStream, bUseCompression);
                        if (this.GetConnectionInfo() != null) {
                            this.GetConnectionInfo().SetCaseSensitiveOS(rNoop.IsCaseSensitiveOS());
                        }
                        if (CRhinoApp.GET_RHINO_APP() != null && CRhinoApp.GET_RHINO_APP().GetConnectionAttrs() != null && CRhinoApp.GET_RHINO_APP().GetConnectionAttrs() != this.GetConnectionInfo()) {
                            CRhinoApp.GET_RHINO_APP().GetConnectionAttrs().SetCaseSensitiveOS(rNoop.IsCaseSensitiveOS());
                        }
                        anRet[1] = rNoop.GetResult();
                        rNoop.Destroy();
                        rNoop = null;
                        this.CloseInputStream(inStream);
                    }
                }
            } else if (anRet[0] == -1) {
                anRet[1] = 11002;
            }
            this.Disconnect();
        } else {
            anRet[1] = 11001;
        }
        if (nParseRc == 3) {
            anRet = this.SendNoop(false, arNoopObj);
        }
        return anRet;
    }

    public int[] SendNoop(CNoop[] arNoopObj) {
        return this.SendNoop(this.UseCompression(), arNoopObj);
    }

    public int[] SendLogout(boolean bUseCompression) {
        int[] anRet = new int[]{-1, -1};
        if (this.GetURLFactory() != null) {
            String[] asHeaderInfo;
            URL rURL = this.GetURLFactory().CreateLogout();
            anRet[0] = this.Get(rURL, asHeaderInfo = this.CompileRequestHeader(bUseCompression));
            if (anRet[0] == 200) {
                anRet[1] = 0;
            }
            this.Disconnect();
        }
        return anRet;
    }

    public int[] SendLogout() {
        return this.SendLogout(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public int[] SendChangePassword(String sOldPword, String sNewPword, boolean bUseCompression) {
        anRet = new int[2];
        nParseRc = 1;
        anRet[0] = -1;
        anRet[1] = -1;
        if (this.GetURLFactory() != null) {
            rURL = this.GetURLFactory().CreateChangePassword();
            sData = new StringBuilder();
            sData.append("old_password=" + CSUURLFactory.URLEncode(sOldPword));
            sData.append("&");
            sData.append("new_password=" + CSUURLFactory.URLEncode(sNewPword));
            asHeaderInfo = this.CompileRequestHeader(bUseCompression);
            aData = sData.toString().getBytes();
            nContentLen = aData.length;
            anRet[0] = this.Post(rURL, asHeaderInfo, nContentLen);
            if (anRet[0] == 1) {
                outStream = null;
                inStream /* !! */  = null;
                try {
                    outStream = this.GetOutputStream();
                    outStream.write(aData, 0, nContentLen);
                    outStream.flush();
                    outStream = this.CloseOutputStream(outStream);
                    anRet[0] = this.GetHTTPResponseCode();
                    inStream /* !! */  = this.GetInputStream(anRet);
                    if (anRet[0] != 200 || inStream /* !! */  == null) ** GOTO lbl47
                    rResult = new CResult(this);
                    nParseRc = rResult.Parse(inStream /* !! */ , bUseCompression);
                    anRet[1] = rResult.GetResult();
                    rResult.Destroy();
                    rResult = null;
                    inStream /* !! */  = this.CloseInputStream(inStream /* !! */ );
                }
                catch (IOException ioe) {
                    if (CSUConnection.DEBUG) {
                        ioe.printStackTrace();
                    }
                    anRet[1] = 11038;
                }
                finally {
                    this.CloseOutputStream();
                    this.CloseInputStream();
                }
            } else if (anRet[0] == -1) {
                anRet[1] = 11002;
            }
lbl47:
            // 6 sources

            this.Disconnect();
        } else {
            anRet[1] = 11001;
        }
        if (nParseRc == 3) {
            anRet = this.SendChangePassword(sOldPword, sNewPword, false);
        }
        return anRet;
    }

    public int[] SendChangePassword(String sOldPword, String sNewPword) {
        return this.SendChangePassword(sOldPword, sNewPword, this.UseCompression());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] SendChangeEmail(String sNewEmail, boolean bUseCompression) {
        int[] anRet = new int[2];
        int nParseRc = 1;
        anRet[0] = -1;
        anRet[1] = -1;
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateChangeEmail();
            StringBuilder sData = new StringBuilder();
            sData.append("emailaddress=" + CSUURLFactory.URLEncode(sNewEmail));
            String[] asHeaderInfo = this.CompileRequestHeader(bUseCompression);
            byte[] aData = sData.toString().getBytes();
            int nContentLen = aData.length;
            anRet[0] = this.Post(rURL, asHeaderInfo, nContentLen);
            if (anRet[0] == 1) {
                OutputStream outStream = null;
                InputStream inStream = null;
                try {
                    outStream = this.GetOutputStream();
                    if (outStream != null) {
                        outStream.write(aData, 0, nContentLen);
                        outStream.flush();
                        outStream = this.CloseOutputStream(outStream);
                        anRet[0] = this.GetHTTPResponseCode();
                        inStream = this.GetInputStream(anRet);
                        if (anRet[0] == 200 && inStream != null) {
                            CResult rResult = new CResult(this);
                            nParseRc = rResult.Parse(inStream, bUseCompression);
                            anRet[1] = rResult.GetResult();
                            rResult.Destroy();
                            rResult = null;
                            inStream = this.CloseInputStream(inStream);
                        }
                    } else {
                        anRet[1] = 11004;
                    }
                }
                catch (IOException ioe) {
                    if (DEBUG) {
                        ioe.printStackTrace();
                    }
                    anRet[1] = 11039;
                }
                finally {
                    this.CloseOutputStream();
                    this.CloseInputStream();
                }
            }
            this.Disconnect();
        } else {
            anRet[1] = 11001;
        }
        if (nParseRc == 3) {
            anRet = this.SendChangeEmail(sNewEmail, false);
        }
        return anRet;
    }

    public int[] SendChangeEmail(String sNewEmail) {
        return this.SendChangeEmail(sNewEmail, this.UseCompression());
    }

    private int[] PollForResult(long lTransferID, boolean bUseCompression) {
        boolean bTimedOut;
        int[] anRet = null;
        long lTimeout = System.currentTimeMillis() + 30000L;
        boolean bContinue = true;
        boolean bl = bTimedOut = System.currentTimeMillis() >= lTimeout;
        while (bContinue && !bTimedOut) {
            boolean bl2 = bTimedOut = System.currentTimeMillis() >= lTimeout;
            anRet = this.SendTransferStats(lTransferID, bUseCompression);
            if (anRet == null || anRet.length != 2 || anRet[0] != 200 || anRet[1] == -1 || anRet[1] == 6 || anRet[1] == 9) continue;
            bContinue = false;
        }
        if (anRet != null && anRet.length == 2 && anRet[1] == -1) {
            anRet[1] = 1;
        }
        if (bTimedOut) {
            anRet[1] = 20;
        }
        return anRet;
    }

    public int[] SendTransferStats(long lTransferID, boolean bUseCompression) {
        int[] anRet = new int[]{-1, -1};
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateTransferStats(lTransferID);
            anRet = this.GetResult(rURL, bUseCompression);
        } else {
            anRet[1] = 11001;
        }
        return anRet;
    }

    protected Vector<IListDirListener> GetListDirListeners() {
        return this.m_aListDirListeners;
    }

    public void AddListDirListener(IListDirListener rListener) {
        if (this.GetListDirListeners() != null && rListener != null) {
            this.GetListDirListeners().add(rListener);
        }
    }

    public void RemoveListDirListener(IListDirListener rListener) {
        if (this.GetListDirListeners() != null && rListener != null) {
            this.GetListDirListeners().remove(rListener);
        }
    }

    public int GetListDirListenerCount() {
        int nCount = 0;
        if (this.GetListDirListeners() != null) {
            nCount = this.GetListDirListeners().size();
        }
        return nCount;
    }

    public IListDirListener GetListDirListener(int nIndex) {
        IListDirListener rListener = null;
        if (this.GetListDirListeners() != null && nIndex >= 0 && nIndex < this.GetListDirListenerCount()) {
            rListener = this.GetListDirListeners().get(nIndex);
        }
        return rListener;
    }

    public synchronized boolean GetResume() {
        return this.m_bResume;
    }

    public synchronized void SetResume(boolean bResume) {
        this.m_bResume = bResume;
    }

    private long FindResumeStartIndex(String sAbsToPath, boolean bDestIsRemote) {
        long lStart = 0L;
        if (bDestIsRemote) {
            CFile fChild;
            int[] anRetCodes = this.SendListPath(sAbsToPath, false);
            if (anRetCodes != null && anRetCodes.length == 2 && anRetCodes[0] == 200 && anRetCodes[1] == 0 && this.GetListDir() != null && (fChild = this.GetListDir().GetFile(0)) != null) {
                lStart = fChild.GetSize();
            }
        } else {
            File fDest = new File(sAbsToPath);
            if (fDest != null && fDest.exists()) {
                lStart = fDest.length();
            }
        }
        return lStart;
    }

    private void SetResumeStartIndex(long lStartIndex) {
        this.m_lResumeStartIndex = lStartIndex;
    }

    private long GetResumeStartIndex() {
        return this.m_lResumeStartIndex;
    }

    private void SetResumeEndIndex(long lEndIndex) {
        this.m_lResumeEndIndex = lEndIndex;
    }

    private long GetResumeEndIndex() {
        return this.m_lResumeEndIndex;
    }

    private void SetResumeRange(long lStartIndex, long lEndIndex) {
        this.SetResumeStartIndex(lStartIndex);
        this.SetResumeEndIndex(lEndIndex);
    }

    public URL GetDownloadMediaURI(String sAbsFromPath) {
        URL url = null;
        if (this.GetURLFactory() != null) {
            url = this.GetURLFactory().CreateDownloadMedia(sAbsFromPath);
        }
        return url;
    }

    public int[] SendGetDirectorySize(String sAbsPath) {
        int[] anRet = new int[]{-1, -1};
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateGetDirectorySize(sAbsPath);
            CDirSize rDirSize = new CDirSize(this);
            anRet = this.Get(rURL, this.UseCompression(), rDirSize);
            if (anRet[0] == -1) {
                anRet[1] = 11002;
            }
            this.m_lDirectorySize = rDirSize.GetDirectorySize();
            rDirSize.Destroy();
            rDirSize = null;
        } else {
            anRet[1] = 11001;
        }
        return anRet;
    }

    public int[] SendGetSpaceAvailable(String sAbsPath) {
        int[] anRet = new int[]{-1, -1};
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateGetSpaceAvailable(sAbsPath);
            CSpaceAvailable rSpaceAvail = new CSpaceAvailable(this);
            anRet = this.Get(rURL, this.UseCompression(), rSpaceAvail);
            if (anRet[0] == -1) {
                anRet[1] = 11002;
            }
            this.m_lSpaceAvailable = rSpaceAvail.GetSpaceAvailable();
            rSpaceAvail.Destroy();
            rSpaceAvail = null;
        } else {
            anRet[1] = 11001;
        }
        return anRet;
    }

    public long GetDirSize() {
        return this.m_lDirectorySize;
    }

    public long GetSpaceAvailable() {
        return this.m_lSpaceAvailable;
    }

    public String GetDirChangeMsg() {
        return this.m_sDirChangeMsg;
    }

    public int[] SendGetImage(String sFromServerPath, String sToClientPath, String sModifiedTimestamp) {
        int[] anRet = new int[2];
        boolean bUseCompression = false;
        anRet[0] = -1;
        anRet[1] = -1;
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateImage(sFromServerPath);
            String[] asHeaderInfo = this.CompileRequestHeader(bUseCompression);
            if (sModifiedTimestamp != null && !sModifiedTimestamp.isEmpty()) {
                String[] asTemp = new String[asHeaderInfo.length];
                System.arraycopy(asHeaderInfo, 0, asTemp, 0, asHeaderInfo.length);
                asHeaderInfo = new String[asTemp.length + 2];
                System.arraycopy(asTemp, 0, asHeaderInfo, 0, asTemp.length);
                asHeaderInfo[asHeaderInfo.length - 2] = "If-Modified-Since";
                asHeaderInfo[asHeaderInfo.length - 1] = sModifiedTimestamp;
                if (DEBUG_IMAGES) {
                    System.out.printf("If-Modified-Since: %s\r\n", sModifiedTimestamp);
                }
            }
            if ((anRet[0] = this.Get(rURL, asHeaderInfo)) == 200) {
                String sContentType;
                if (DEBUG_IMAGES) {
                    System.out.printf("Images have changed (%s -> %s)\r\n", sFromServerPath, sToClientPath);
                }
                if ((sContentType = this.GetHeaderValue("Content-Type", anRet)) != null && anRet[0] == 200) {
                    if ((sContentType = sContentType.toLowerCase()) != null && !sContentType.isEmpty() && (sContentType.equals("application/download") || sContentType.startsWith("image"))) {
                        this.DownloadToFile(sToClientPath, anRet);
                    } else {
                        if (DEBUG_IMAGES) {
                            System.out.printf("Could not download image (%s -> %s)\r\n", sFromServerPath, sToClientPath);
                        }
                        anRet[1] = 1;
                        this.CloseInputStream();
                    }
                }
            } else if (anRet[0] == 304) {
                anRet[1] = 0;
                if (DEBUG_IMAGES) {
                    System.out.printf("Images have not changed (%s -> %s)\r\n", sFromServerPath, sToClientPath);
                }
            } else if (anRet[0] == -1) {
                anRet[1] = 11002;
            }
            this.Disconnect();
        } else {
            anRet[1] = 11001;
        }
        return anRet;
    }

    protected CNoop CreateNoop() {
        return new CNoop(this);
    }

    public int[] SendGetResource(String sFromServerPath, String sToClientPath, String sModifiedTimestamp) {
        int[] anRet = new int[2];
        boolean bUseCompression = false;
        anRet[0] = -1;
        anRet[1] = -1;
        if (this.GetURLFactory() != null) {
            URL rURL = this.GetURLFactory().CreateDownloadResource(sFromServerPath);
            String[] asHeaderInfo = this.CompileRequestHeader(bUseCompression);
            if (sModifiedTimestamp != null && !sModifiedTimestamp.isEmpty()) {
                String[] asTemp = new String[asHeaderInfo.length];
                System.arraycopy(asHeaderInfo, 0, asTemp, 0, asHeaderInfo.length);
                asHeaderInfo = new String[asTemp.length + 2];
                System.arraycopy(asTemp, 0, asHeaderInfo, 0, asTemp.length);
                asHeaderInfo[asHeaderInfo.length - 2] = "If-Modified-Since";
                asHeaderInfo[asHeaderInfo.length - 1] = sModifiedTimestamp;
                if (DEBUG_SERVER_RESOURCES) {
                    System.out.printf("If-Modified-Since: %s\r\n", sModifiedTimestamp);
                }
            }
            if ((anRet[0] = this.Get(rURL, asHeaderInfo)) == 200) {
                String sContentType = this.GetHeaderValue("Content-Type", anRet);
                if (sContentType != null && anRet[0] == 200) {
                    if ((sContentType = sContentType.toLowerCase()) != null && !sContentType.isEmpty() && (sContentType.equals("application/download") || sContentType.startsWith("application/zip"))) {
                        this.DownloadToFile(sToClientPath, anRet);
                    } else {
                        if (DEBUG_SERVER_RESOURCES) {
                            System.out.printf("Could not download resource (%s -> %s)\r\n", sFromServerPath, sToClientPath);
                        }
                        anRet[1] = 1;
                        this.CloseInputStream();
                    }
                }
            } else if (anRet[0] == 304) {
                anRet[1] = 0;
                if (DEBUG_SERVER_RESOURCES) {
                    System.out.printf("Resource file has not changed (%s -> %s)\r\n", sFromServerPath, sToClientPath);
                }
            } else if (anRet[0] == -1) {
                anRet[1] = 11002;
            }
            this.Disconnect();
        } else {
            anRet[1] = 11001;
        }
        return anRet;
    }

    protected int[] Get(URL rURL, boolean bUseCompression, CParsedObj rResponseParser) {
        int[] anRetCodes = new int[]{-1, -1};
        if (rURL != null) {
            if (rResponseParser != null) {
                String[] asHeaderInfo = this.CompileRequestHeader(bUseCompression);
                anRetCodes[0] = this.Get(rURL, asHeaderInfo);
                if (anRetCodes[0] == 200) {
                    BufferedInputStream inStream = null;
                    inStream = this.GetInputStream(anRetCodes);
                    if (inStream != null) {
                        if (anRetCodes[0] == 200) {
                            int nParsedResult = 1;
                            nParsedResult = rResponseParser.Parse(inStream, bUseCompression);
                            if (nParsedResult == 3 && bUseCompression) {
                                anRetCodes = this.Get(rURL, false, rResponseParser);
                            } else {
                                anRetCodes[1] = rResponseParser.GetResult();
                            }
                        }
                    } else {
                        anRetCodes[1] = 11003;
                    }
                    this.Disconnect();
                } else if (anRetCodes[0] == -1) {
                    anRetCodes[1] = 11002;
                }
            } else {
                anRetCodes[1] = 11024;
            }
        } else {
            if (DEBUG) {
                CDebugLog.ASSERT(CSUConnection.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid argument.");
            }
            anRetCodes[1] = 11023;
        }
        return anRetCodes;
    }

    protected int[] GetResult(URL rURL, boolean bUseCompression) {
        CResult rResult = new CResult(this);
        int[] anRetCodes = this.Get(rURL, bUseCompression, rResult);
        rResult.Destroy();
        rResult = null;
        return anRetCodes;
    }

    protected int[] GetListing(URL rURL, boolean bUseCompression) {
        CListing rListing = new CListing(this);
        for (IListDirListener rListener : this.GetListDirListeners()) {
            rListing.AddListDirListener(rListener);
        }
        int[] anRetCodes = this.Get(rURL, bUseCompression, rListing);
        for (IListDirListener rListener : this.GetListDirListeners()) {
            rListing.RemoveListDirListener(rListener);
        }
        this.m_sDirChangeMsg = rListing.GetDirChangeMsg();
        this.m_RemoteFile = rListing.TakeParent();
        rListing.Destroy();
        rListing = null;
        return anRetCodes;
    }

    @Override
    public void Destroy() {
        this.m_rConnectionInfo = null;
        this.m_URLFactory = null;
        this.m_RemoteFile = null;
        this.m_aBuffer = null;
        if (this.m_aTransferStatsListeners != null) {
            this.m_aTransferStatsListeners.clear();
        }
        this.m_aTransferStatsListeners = null;
        this.m_DateFormatter = null;
        if (this.m_aListDirListeners != null) {
            this.m_aListDirListeners.clear();
        }
        this.m_aListDirListeners = null;
        super.Destroy();
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_IMAGES = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_DYNAMIC_BUFFER = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_UPLOAD_INDICES = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_SPEED_LISTING = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_SERVER_RESOURCES = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_UPLOAD_MSGS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_UPLOAD_FILE_RET_GOOD = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_UPLOAD_WATCHDOG = false;
    }
}

