/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.net.HTTP.SU;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.IRhinoDestroy;
import com.rhinosoft.log.CDebugLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public abstract class CParsedObj
implements IRhinoDestroy {
    public static final boolean DEBUG = CAttr.DEBUG;
    public static final boolean DEBUG_TRACK_EXCEPTIONS = DEBUG;
    public static final int END_OF_FILE = -1;
    public static final String END_OF_FILE_MARKER = "EOF";
    public static final int RET_UNKNOWN = -2;
    public static final int RET_END_OF_FILE = -1;
    public static final int RET_OKAY = 0;
    public static final int RET_FAILED = 1;
    public static final int RET_EXCEPTION_THROWN = 2;
    public static final int RET_TRY_RAW_DATA = 3;
    public static final int RET_SILENT_PARSE_OK = 20;
    public static final int RET_SILENT_PARSE_FAILED = 21;
    protected static final int[] SILENT_RETURN_CODES = new int[]{20, 21};
    public static final String ENCODING_UTF_8 = "UTF-8";
    public static final String ENCODING_UTF_16 = "UTF-16";
    public static final String ENCODING_UTF_16BE = "UTF-16BE";
    public static final String ENCODING_UTF_16LE = "UTF-16LE";
    public static final String ENCODING_US_ASCII = "US-ASCII";
    public static final String ENCODING_ISO_8859_1 = "ISO-8859-1";
    public static final int BUFFER_LENGTH = 102400;
    public static final int MAX_BUFFER_LENGTH = 0x500000;
    protected int[] m_anSilentRets;
    private String m_sEncoding;
    protected StringBuilder m_sData;
    private byte[] m_aBuffer;
    protected int m_nRead;
    private boolean m_bIsCompressedData;
    private byte[] m_aInflated;
    private Inflater m_Decompressor;
    private boolean m_bTryOtherCompression;

    public CParsedObj(String sEncoding, int[] anSilentRetCodes) {
        this._CParsedObj(sEncoding, anSilentRetCodes);
    }

    public CParsedObj() {
        this._CParsedObj(ENCODING_UTF_8, SILENT_RETURN_CODES);
    }

    public void _CParsedObj(String sEncoding, int[] anSilentRetCodes) {
        this.SetEncoding(sEncoding);
        this.SetSilentRetCodes(anSilentRetCodes);
        this.m_sData = new StringBuilder();
        this.m_bIsCompressedData = false;
        this.m_bTryOtherCompression = false;
    }

    @Override
    public void Destroy() {
        this.m_sData = null;
        this.m_aBuffer = null;
        this.m_aInflated = null;
        this.m_Decompressor = null;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    protected abstract int ProcessData(boolean var1);

    protected abstract boolean GetCancel();

    private void InitDecompressor(boolean bReset, boolean bGzip) {
        if (this.m_Decompressor == null || bReset) {
            this.m_Decompressor = new Inflater(bGzip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int Parse(InputStream inStream, boolean bIsCompressedData) {
        int nRc = -2;
        if (inStream != null) {
            nRc = 0;
            try {
                this.m_bIsCompressedData = bIsCompressedData;
                this.InitDecompressor(false, true);
                this.m_aBuffer = new byte[102400];
                this.m_aInflated = new byte[102400];
                this.m_nRead = 0;
                int nInflated = 0;
                boolean bNeedsInput = false;
                while (this.m_nRead != -1 && nRc == 0 && !this.GetCancel()) {
                    this.m_nRead = inStream.read(this.m_aBuffer, 0, this.m_aBuffer.length);
                    if (this.m_nRead <= 0) continue;
                    if (this.m_bIsCompressedData) {
                        this.m_Decompressor.setInput(this.m_aBuffer, 0, this.m_nRead);
                        this.m_aInflated = new byte[this.m_aBuffer.length];
                        nInflated = this.m_Decompressor.inflate(this.m_aInflated);
                        bNeedsInput = this.m_Decompressor.needsInput();
                        this.m_sData.append(new String(this.m_aInflated, 0, nInflated, this.GetEncoding()));
                        while (!bNeedsInput && !this.GetCancel()) {
                            nInflated = this.m_Decompressor.inflate(this.m_aInflated);
                            bNeedsInput = this.m_Decompressor.needsInput();
                            this.m_sData.append(new String(this.m_aInflated, 0, nInflated, this.GetEncoding()));
                        }
                        nRc = this.ProcessData(false);
                        continue;
                    }
                    this.m_sData.append(new String(this.m_aBuffer, 0, this.m_nRead, this.GetEncoding()));
                    nRc = this.ProcessData(false);
                }
                if (nRc != 0 || this.GetCancel()) return nRc;
                nRc = this.ProcessData(this.m_nRead == -1);
                return nRc;
            }
            catch (UnsupportedEncodingException uee) {
                nRc = 2;
                if (!DEBUG_TRACK_EXCEPTIONS) return nRc;
                uee.printStackTrace();
                return nRc;
            }
            catch (DataFormatException dfe) {
                nRc = 2;
                if (DEBUG_TRACK_EXCEPTIONS) {
                    dfe.printStackTrace();
                }
                if (this.m_bTryOtherCompression || this.GetCancel()) return nRc;
                this.m_bTryOtherCompression = true;
                this.InitDecompressor(true, false);
                nRc = this.Parse(inStream, bIsCompressedData);
                if (nRc == 2) {
                    nRc = 3;
                }
                this.m_bTryOtherCompression = false;
                return nRc;
            }
            catch (IOException ioe) {
                nRc = 2;
                if (!DEBUG_TRACK_EXCEPTIONS) return nRc;
                ioe.printStackTrace();
                return nRc;
            }
            catch (Exception e) {
                nRc = 2;
                if (!DEBUG_TRACK_EXCEPTIONS) return nRc;
                e.printStackTrace();
                return nRc;
            }
            finally {
                this.m_aBuffer = null;
                this.m_aInflated = null;
            }
        } else {
            nRc = 2;
            if (!DEBUG) return nRc;
            CDebugLog.ASSERT(CParsedObj.class.getName(), CDebugLog.GetLineNumber(), "InputStream is null!  If this is caused by our timeout thread, then this is expected behavior.");
        }
        return nRc;
    }

    public void SetEncoding(String sEncoding) {
        this.m_sEncoding = sEncoding;
    }

    public String GetEncoding() {
        return this.m_sEncoding;
    }

    protected void SetSilentRetCodes(int[] anSilentRetCodes) {
        this.m_anSilentRets = anSilentRetCodes;
    }

    protected Integer ParseInteger(String sValue) {
        Integer nVal;
        block3: {
            nVal = null;
            if (sValue != null && !sValue.isEmpty()) {
                try {
                    nVal = Integer.parseInt(sValue);
                }
                catch (Exception e) {
                    if (!DEBUG_TRACK_EXCEPTIONS) break block3;
                    e.printStackTrace();
                }
            }
        }
        return nVal;
    }

    protected Boolean ParseBoolean(String sValue, boolean bAsInt) {
        Boolean bVal;
        block6: {
            bVal = null;
            if (sValue != null && !sValue.isEmpty()) {
                try {
                    if (bAsInt) {
                        Integer nInt = this.ParseInteger(sValue);
                        if (nInt != null) {
                            bVal = nInt != 0;
                        }
                    } else {
                        bVal = Boolean.parseBoolean(sValue);
                    }
                }
                catch (Exception e) {
                    if (!DEBUG_TRACK_EXCEPTIONS) break block6;
                    e.printStackTrace();
                }
            }
        }
        return bVal;
    }

    protected Long ParseLong(String sValue) {
        Long lVal = null;
        if (sValue != null && !sValue.isEmpty() && !sValue.equals("18446744073709551615")) {
            try {
                lVal = Long.parseLong(sValue);
            }
            catch (Exception e) {
                if (DEBUG_TRACK_EXCEPTIONS) {
                    e.printStackTrace();
                }
            }
        } else if (DEBUG) {
            System.out.println(String.format("Cannot parse file size. String is too big for the Long.parse method.\nFile: %s", sValue));
        }
        return lVal;
    }

    protected void ReleaseObjs() {
    }

    public int GetResult() {
        return -1;
    }
}

