/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.net.HTTP.SU;

import com.rhinosoft.attrs.CDateAttr;
import com.rhinosoft.attrs.CStringURLAttr;
import com.rhinosoft.files.CFile;
import com.rhinosoft.files.CRemoteFile;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.net.HTTP.SU.CListDirEvent;
import com.rhinosoft.net.HTTP.SU.CParsedObj;
import com.rhinosoft.net.HTTP.SU.CResult;
import com.rhinosoft.net.HTTP.SU.CSUConnection;
import com.rhinosoft.net.HTTP.SU.IListDirListener;
import com.rhinosoft.strings.CString;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class CListing
extends CResult {
    public static final boolean DEBUG_TRACK_LISTENERS;
    public static final int CSV_COL_HAS_PARENT_DIR = 1;
    public static final int CSV_COL_PARENT_NAME = 2;
    public static final int CSV_COL_PARENT_IS_DRIVE = 3;
    public static final int CSV_COL_PARENT_DRIVE_TYPE = 4;
    public static final int CSV_COL_PARENT_DRIVE_LABEL = 5;
    public static final int CSV_COL_DIR_CHANGE_MSG = 6;
    public static final int CSV_COL_DIR_MODIFIED_TIMESTAMP = 7;
    public static final int CSV_MAX_PARENT_COLS = 8;
    public static final int CSV_COL_CHILD_NAME = 0;
    public static final int CSV_COL_CHILD_SIZE = 1;
    public static final int CSV_COL_CHILD_MODIFIED_TIMESTAMP = 2;
    public static final int CSV_COL_CHILD_ACCESSED_TIMESTAMP = 3;
    public static final int CSV_COL_CHILD_CREATED_TIMESTAMP = 4;
    public static final int CSV_COL_CHILD_IS_DIR = 5;
    public static final int CSV_COL_CHILD_IS_READ_ONLY = 6;
    public static final int CSV_COL_CHILD_IS_LINK = 7;
    public static final int CSV_COL_CHILD_IS_IMAGE = 8;
    public static final int CSV_COL_CHILD_IS_DRIVE = 9;
    public static final int CSV_COL_CHILD_DRIVE_TYPE = 10;
    public static final int CSV_COL_CHILD_DRIVE_LABEL = 11;
    public static final int CSV_COL_CHILD_IS_NORMAL = 12;
    public static final int CSV_COL_CHILD_IS_HIDDEN = 13;
    public static final int CSV_COL_CHILD_IS_COMPRESSED = 14;
    public static final int CSV_COL_CHILD_IS_ENCRYPTED = 15;
    public static final int CSV_COL_CHILD_IS_ARCHIVED = 16;
    public static final int CSV_COL_CHILD_IS_AUDIO = 17;
    public static final int CSV_COL_CHILD_IS_VIDEO = 18;
    public static final int CSV_MAX_CHILD_COLS = 19;
    private boolean m_bIsParent = false;
    private boolean m_bHasParent = false;
    private String m_sName = "";
    private boolean m_bIsDrive = false;
    private int m_nDriveType = 0;
    private String m_sDriveLabel = "";
    private String m_sDirChangeMsg = "";
    private long m_lSize = -1L;
    private long m_lDateModified = -1L;
    private long m_lDateAccessed = -1L;
    private long m_lDateCreated = -1L;
    private boolean m_bIsDirectory = false;
    private boolean m_bIsReadOnly = false;
    private boolean m_bIsLink = false;
    private boolean m_bIsImage = false;
    private boolean m_bIsNormal = false;
    private boolean m_bIsHidden = false;
    private boolean m_bIsCompressed = false;
    private boolean m_bIsEncrypted = false;
    private boolean m_bIsArchived = false;
    private boolean m_bIsAudio = false;
    private boolean m_bIsVideo = false;
    private Vector<IListDirListener> m_aListDirListeners = new Vector();
    private CRemoteFile m_fParent;
    public static final int NUM_OF_CHILDREN_TO_FIRE_EVENT = 50;
    private Vector<CFile> m_aChildFiles = new Vector();
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void main(String[] asArguments) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                block2: {
                    CListing Tag2 = new CListing(null);
                    try {
                        FileInputStream fis = new FileInputStream("C:\\Temp2\\List.csv");
                        Tag2.Parse(fis, false);
                    }
                    catch (Exception e) {
                        if (!CParsedObj.DEBUG) break block2;
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public CListing(CSUConnection rSUConnection) {
        super(rSUConnection);
    }

    @Override
    public void Destroy() {
        this.ReleaseMemberObjs();
        super.Destroy();
    }

    @Override
    protected void ReleaseObjs() {
        this.ReleaseMemberObjs();
        super.ReleaseObjs();
    }

    private void ReleaseMemberObjs() {
        if (this.m_aListDirListeners != null) {
            this.m_aListDirListeners.clear();
        }
        this.m_aListDirListeners = null;
        if (this.m_fParent != null) {
            if (DEBUG) {
                CDebugLog.ASSERT(CListing.class.getName(), CDebugLog.GetLineNumber(), "Programming error, we should not have ownership of this object anymore.");
            }
            this.m_fParent.Destroy();
        }
        this.m_fParent = null;
        if (this.m_aChildFiles != null) {
            this.m_aChildFiles.clear();
        }
        this.m_aChildFiles = null;
    }

    @Override
    public void finalize() throws Throwable {
        this.m_aListDirListeners.clear();
        if (this.m_aChildFiles != null) {
            this.m_aChildFiles.clear();
        }
        this.m_aChildFiles = null;
        super.finalize();
    }

    @Override
    public int Parse(InputStream inStream, boolean bIsCompressedData) {
        int nRc = super.Parse(inStream, bIsCompressedData);
        this.FireChildFiles(true);
        return nRc;
    }

    @Override
    protected int ProcessLine(StringBuilder rsLine) {
        int nRet = 0;
        if (rsLine.length() > 0) {
            if (this.m_nLineNumber == 0) {
                String sValue = null;
                String[] asCols = this.MakeArray(rsLine);
                if (asCols.length <= 8) {
                    block31: for (int nIdx = 0; nIdx < asCols.length; ++nIdx) {
                        sValue = asCols[nIdx];
                        switch (nIdx) {
                            case 0: {
                                Integer nVal = this.ParseInteger(sValue);
                                if (nVal != null) {
                                    this.m_nResult = nVal;
                                    continue block31;
                                }
                                nRet = 21;
                                continue block31;
                            }
                            case 1: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    this.m_bHasParent = bVal;
                                    continue block31;
                                }
                                nRet = 21;
                                continue block31;
                            }
                            case 2: {
                                this.m_sName = CStringURLAttr.URLDecode(sValue);
                                continue block31;
                            }
                            case 3: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    this.m_bIsDrive = bVal;
                                    continue block31;
                                }
                                nRet = 21;
                                continue block31;
                            }
                            case 4: {
                                Integer nVal = this.ParseInteger(sValue);
                                if (nVal != null) {
                                    this.m_nDriveType = nVal;
                                    continue block31;
                                }
                                nRet = 21;
                                continue block31;
                            }
                            case 5: {
                                this.m_sDriveLabel = sValue;
                                continue block31;
                            }
                            case 6: {
                                this.m_sDirChangeMsg = CStringURLAttr.URLDecode(sValue);
                                continue block31;
                            }
                            case 7: {
                                Long lTimeT = this.ParseLong(sValue);
                                if (lTimeT != null) {
                                    this.m_lDateModified = CDateAttr.ConvertTimeT(lTimeT);
                                    continue block31;
                                }
                                nRet = 21;
                                continue block31;
                            }
                            default: {
                                if (!DEBUG) continue block31;
                                System.out.println("WARNING:  Unknown case in CListing.ProcessLine | Parent.");
                            }
                        }
                    }
                    if (this.m_fParent != null) {
                        this.m_fParent.Destroy();
                        this.m_fParent = null;
                    }
                    this.m_fParent = new CRemoteFile(this.m_sName, true);
                    this.m_fParent.SetUpDirEnabled(this.m_bHasParent);
                    this.m_fParent.SetIsDrive(this.m_bIsDrive);
                    this.m_fParent.SetDriveType(this.m_nDriveType);
                    this.m_fParent.SetDriveLabel(this.m_sDriveLabel);
                    this.m_fParent.SetTimestampModified(this.m_lDateModified);
                    this.m_fParent.SetHasListing(true);
                    CListDirEvent rEvent = new CListDirEvent(this.m_fParent);
                    this.FireRecvParent(rEvent);
                } else if (DEBUG) {
                    System.out.println("WARNING:  Unknown column length in CListing.ProcessLine | Parent.");
                }
            } else {
                this.m_sName = "";
                this.m_nDriveType = 0;
                this.m_sDriveLabel = "";
                String sValue = null;
                String[] asCols = this.MakeArray(rsLine);
                if (asCols.length <= 19) {
                    CListing rCurrentChild = new CListing(null);
                    block32: for (int nIdx = 0; nIdx < asCols.length; ++nIdx) {
                        sValue = asCols[nIdx];
                        switch (nIdx) {
                            case 0: {
                                String sAbsParent;
                                String sName = CStringURLAttr.URLDecode(sValue);
                                if (rCurrentChild == null) continue block32;
                                String sAbsChild = sAbsParent = this.m_fParent.GetAbsPath();
                                sAbsChild = CString.EnsureLastCharIsAForwardSlash(sAbsChild);
                                sAbsChild = sAbsChild + sName;
                                rCurrentChild.m_sName = sAbsChild = CString.MakeForwardSlashes(sAbsChild);
                                continue block32;
                            }
                            case 1: {
                                Long lVal = this.ParseLong(sValue);
                                if (lVal != null) {
                                    if (rCurrentChild == null) continue block32;
                                    rCurrentChild.m_lSize = lVal;
                                    continue block32;
                                }
                                nRet = 21;
                                continue block32;
                            }
                            case 2: {
                                Long lTimeT = this.ParseLong(sValue);
                                if (lTimeT != null) {
                                    if (rCurrentChild == null) continue block32;
                                    rCurrentChild.m_lDateModified = CDateAttr.ConvertTimeT(lTimeT);
                                    continue block32;
                                }
                                nRet = 21;
                                continue block32;
                            }
                            case 3: {
                                Long lTimeT = this.ParseLong(sValue);
                                if (lTimeT != null) {
                                    if (rCurrentChild == null) continue block32;
                                    rCurrentChild.m_lDateAccessed = CDateAttr.ConvertTimeT(lTimeT);
                                    continue block32;
                                }
                                nRet = 21;
                                continue block32;
                            }
                            case 4: {
                                Long lTimeT = this.ParseLong(sValue);
                                if (lTimeT != null) {
                                    if (rCurrentChild == null) continue block32;
                                    rCurrentChild.m_lDateCreated = CDateAttr.ConvertTimeT(lTimeT);
                                    continue block32;
                                }
                                nRet = 21;
                                continue block32;
                            }
                            case 5: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    if (rCurrentChild == null) continue block32;
                                    rCurrentChild.m_bIsDirectory = bVal;
                                    continue block32;
                                }
                                nRet = 21;
                                continue block32;
                            }
                            case 6: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    if (rCurrentChild == null) continue block32;
                                    rCurrentChild.m_bIsReadOnly = bVal;
                                    continue block32;
                                }
                                nRet = 21;
                                continue block32;
                            }
                            case 7: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    if (rCurrentChild == null) continue block32;
                                    rCurrentChild.m_bIsLink = bVal;
                                    continue block32;
                                }
                                nRet = 21;
                                continue block32;
                            }
                            case 8: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    if (rCurrentChild == null) continue block32;
                                    rCurrentChild.m_bIsImage = bVal;
                                    continue block32;
                                }
                                nRet = 21;
                                continue block32;
                            }
                            case 9: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    if (rCurrentChild == null) continue block32;
                                    rCurrentChild.m_bIsDrive = bVal;
                                    continue block32;
                                }
                                nRet = 21;
                                continue block32;
                            }
                            case 10: {
                                Integer nVal = this.ParseInteger(sValue);
                                if (nVal != null) {
                                    if (rCurrentChild == null) continue block32;
                                    rCurrentChild.m_nDriveType = nVal;
                                    continue block32;
                                }
                                nRet = 21;
                                continue block32;
                            }
                            case 11: {
                                if (rCurrentChild == null) continue block32;
                                rCurrentChild.m_sDriveLabel = sValue;
                                continue block32;
                            }
                            case 12: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    if (rCurrentChild == null) continue block32;
                                    rCurrentChild.m_bIsNormal = bVal;
                                    continue block32;
                                }
                                nRet = 21;
                                continue block32;
                            }
                            case 13: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    if (rCurrentChild == null) continue block32;
                                    rCurrentChild.m_bIsHidden = bVal;
                                    continue block32;
                                }
                                nRet = 21;
                                continue block32;
                            }
                            case 14: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    if (rCurrentChild == null) continue block32;
                                    rCurrentChild.m_bIsCompressed = bVal;
                                    continue block32;
                                }
                                nRet = 21;
                                continue block32;
                            }
                            case 15: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    if (rCurrentChild == null) continue block32;
                                    rCurrentChild.m_bIsEncrypted = bVal;
                                    continue block32;
                                }
                                nRet = 21;
                                continue block32;
                            }
                            case 16: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    if (rCurrentChild == null) continue block32;
                                    rCurrentChild.m_bIsArchived = bVal;
                                    continue block32;
                                }
                                nRet = 21;
                                continue block32;
                            }
                            case 17: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    if (rCurrentChild == null) continue block32;
                                    rCurrentChild.m_bIsAudio = bVal;
                                    continue block32;
                                }
                                nRet = 21;
                                continue block32;
                            }
                            case 18: {
                                Boolean bVal = this.ParseBoolean(sValue, true);
                                if (bVal != null) {
                                    if (rCurrentChild == null) continue block32;
                                    rCurrentChild.m_bIsVideo = bVal;
                                    continue block32;
                                }
                                nRet = 21;
                                continue block32;
                            }
                            default: {
                                if (!DEBUG) continue block32;
                                System.out.println("WARNING:  Unknown case in CListing.ProcessLine | Child.");
                            }
                        }
                    }
                    if (rCurrentChild != null) {
                        CRemoteFile fChild = new CRemoteFile(rCurrentChild.m_sName, rCurrentChild.m_bIsDirectory);
                        this.m_fParent.AddFile(fChild);
                        fChild.SetSize(rCurrentChild.m_lSize);
                        fChild.SetTimestampModified(rCurrentChild.m_lDateModified);
                        fChild.SetTimestampCreated(rCurrentChild.m_lDateCreated);
                        fChild.SetTimestampAccessed(rCurrentChild.m_lDateAccessed);
                        fChild.SetIsReadOnly(rCurrentChild.m_bIsReadOnly);
                        fChild.SetIsLink(rCurrentChild.m_bIsLink);
                        fChild.SetIsImage(rCurrentChild.m_bIsImage);
                        fChild.SetIsDrive(rCurrentChild.m_bIsDrive);
                        fChild.SetDriveType(rCurrentChild.m_nDriveType);
                        fChild.SetDriveLabel(rCurrentChild.m_sDriveLabel);
                        fChild.SetIsNormal(rCurrentChild.m_bIsNormal);
                        fChild.SetIsHidden(rCurrentChild.m_bIsHidden);
                        fChild.SetIsCompressed(rCurrentChild.m_bIsCompressed);
                        fChild.SetIsEncrypted(rCurrentChild.m_bIsEncrypted);
                        fChild.SetIsArchived(rCurrentChild.m_bIsArchived);
                        fChild.SetIsAudio(rCurrentChild.m_bIsAudio);
                        fChild.SetIsVideo(rCurrentChild.m_bIsVideo);
                        if (!fChild.IsDirectory() && !fChild.IsDrive()) {
                            fChild.SetHasListing(true);
                        }
                        this.AddChildFile(fChild);
                        this.FireChildFiles();
                        rCurrentChild.Destroy();
                        rCurrentChild = null;
                    } else if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                } else if (DEBUG) {
                    System.out.println("WARNING:  Unknown column length in CListing.ProcessLine | Child.");
                }
            }
        }
        ++this.m_nLineNumber;
        return nRet;
    }

    protected Vector<IListDirListener> GetListDirListeners() {
        return this.m_aListDirListeners;
    }

    public void AddListDirListener(IListDirListener rListener) {
        if (this.GetListDirListeners() != null && rListener != null) {
            this.GetListDirListeners().add(rListener);
        }
    }

    public void RemoveListDirListener(IListDirListener rListener) {
        if (this.GetListDirListeners() != null && rListener != null) {
            this.GetListDirListeners().remove(rListener);
        }
    }

    protected void FireRecvParent(CListDirEvent rEvent) {
        if (!$assertionsDisabled && rEvent == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.GetListDirListeners() == null) {
            throw new AssertionError();
        }
        for (int nIdx = this.GetListDirListeners().size() - 1; nIdx >= 0; --nIdx) {
            IListDirListener rListener = this.GetListDirListeners().get(nIdx);
            if (rListener == null) continue;
            rListener.OnRecvParentFile(rEvent);
        }
    }

    protected void FireRecvChildFiles(CListDirEvent rEvent) {
        if (!$assertionsDisabled && rEvent == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.GetListDirListeners() == null) {
            throw new AssertionError();
        }
        for (int nIdx = this.GetListDirListeners().size() - 1; nIdx >= 0; --nIdx) {
            IListDirListener rListener = this.GetListDirListeners().get(nIdx);
            if (rListener == null) continue;
            rListener.OnRecvChildFiles(rEvent);
        }
    }

    protected CRemoteFile GetParent() {
        return this.m_fParent;
    }

    public CRemoteFile TakeParent() {
        CRemoteFile rParent = this.m_fParent;
        this.m_fParent = null;
        return rParent;
    }

    private void AddChildFile(CFile fChild) {
        this.m_aChildFiles.add(fChild);
    }

    private void FireChildFiles() {
        this.FireChildFiles(false);
    }

    private void FireChildFiles(boolean bForce) {
        if (this.m_aChildFiles.size() >= 50 || bForce) {
            CListDirEvent rEvent = new CListDirEvent(this.GetParent());
            rEvent.SetFiles(this.m_aChildFiles);
            this.FireRecvChildFiles(rEvent);
            this.m_aChildFiles.clear();
        }
    }

    @Override
    protected void DumpObj(int nRetCode) {
        System.out.println("Start dump object...");
        System.out.printf("  Routine Code: %d\n", nRetCode);
        System.out.printf("  Result: %s\n", Integer.toString(this.m_nResult));
        System.out.println("  Parent ...");
        System.out.printf("    Name: %s\n", this.m_sName);
        System.out.printf("    HasParent: %s\n", Boolean.toString(this.m_bHasParent));
        System.out.printf("    IsDrive: %s\n", Boolean.toString(this.m_bIsDrive));
        System.out.printf("    DriveType: %s\n", Integer.toString(this.m_nDriveType));
        System.out.printf("    DriveLabel: %s\n", this.m_sDriveLabel);
        System.out.println("  ... Parent");
        if (this.m_aChildFiles != null) {
            for (CFile rChild : this.m_aChildFiles) {
                if (rChild == null) continue;
                System.out.println("      Child ....");
                System.out.printf("        Name: %s\n", rChild.GetDisplayName());
                System.out.printf("        Size: %s\n", Long.toString(rChild.GetSize()));
                System.out.printf("        DateModified: %s\n", Long.toString(rChild.GetTimestampModified()));
                System.out.printf("        IsDirectory: %s\n", Boolean.toString(rChild.IsDirectory()));
                System.out.printf("        IsReadOnly: %s\n", Boolean.toString(rChild.IsReadOnly()));
                System.out.printf("        IsLink: %s\n", Boolean.toString(rChild.IsLink()));
                System.out.printf("        IsImage: %s\n", Boolean.toString(rChild.IsImage()));
                System.out.printf("        IsDrive: %s\n", Boolean.toString(rChild.IsDrive()));
                System.out.printf("\t       DriveType: %s\n", Integer.toString(rChild.GetDriveType()));
                System.out.printf("        DriveLabel: %s\n", rChild.GetDriveLabel());
                System.out.printf("        IsCompressed: %s\n", Boolean.toString(rChild.IsCompressed()));
                System.out.printf("        IsEncrypted: %s\n", Boolean.toString(rChild.IsEncrypted()));
                System.out.printf("        IsAudio: %s\n", Boolean.toString(rChild.IsAudio()));
                System.out.printf("        IsVideo: %s\n", Boolean.toString(rChild.IsVideo()));
                System.out.println("      ... Child");
            }
        }
        System.out.println("... End dump object");
    }

    public String GetDirChangeMsg() {
        return this.m_sDirChangeMsg;
    }

    @Override
    protected boolean GetCancel() {
        boolean bCancel = false;
        if (this.GetSUConnection() != null) {
            bCancel = this.GetSUConnection().GetCancel();
        }
        return bCancel;
    }

    static {
        boolean bl = $assertionsDisabled = !CListing.class.desiredAssertionStatus();
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_LISTENERS = false;
    }
}

