/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.net.HTTP;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.IRhinoDestroy;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CAttrMsg;
import com.rhinosoft.threads.IWatchDogListener;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.CRhinoEvent;
import com.rhinosoft.utils.CSpeedTest;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JTextPane;

public class CHTTPConnection
implements IWatchDogListener,
IRhinoDestroy {
    protected static final int HTTP_RESPONSE_CODE_INVALID = -1;
    protected static final int HTTP_RESPONSE_CODE_PENDING = 1;
    public static final int WATCH_DOG_TIMER_INTERVAL = 5000;
    public static final int WATCH_DOG_EXPIRATION_CONNECTION = 10000;
    public static final int WATCH_DOG_EXPIRATION = 30000;
    protected static final int WATCHDOG_ATTEMPTS = 3;
    public static JTextPane DEBUG_TEXT_PANE = null;
    public static boolean DEBUG = CAttr.DEBUG;
    public static boolean DEBUG_PRINT_URL;
    public static boolean DEBUG_PRINT_REQUEST_HEADER;
    public static boolean DEBUG_UPLOAD_BOUNDARY;
    public static boolean DEBUG_PRINT_RESPONSE_HEADER;
    public static boolean DEBUG_PRINT_RESPONSE_BODY;
    private static boolean DEBUG_GET_INPUT_STREAM;
    private static final boolean DEBUG_WATCHDOG;
    public static boolean DEBUG_OVERRIDE_USE_COMPRESSION;
    public static boolean DEBUG_INFLATE_PACKETS;
    public static final int COMPRESSION_UNKNOWN = 0;
    public static final int COMPRESSION_GZIP = 1;
    public static final int COMPRESSION_DEFLATE = 2;
    private HttpURLConnection m_Connection;
    private int m_nCompressionType = 0;
    private BufferedInputStream m_InputStream;
    private OutputStream m_OutputStream;
    private final Object m_Crit = new Object();
    private long m_lTickleTime;
    private boolean m_bWatchDogIsActive = false;
    private boolean m_bIsDisconnectedByWatchDog = false;
    private boolean m_bIsCheckingConnectTimeout = true;
    private boolean m_bCancel = false;

    public CHTTPConnection(int nCompressionType) {
        this.m_nCompressionType = nCompressionType;
    }

    public void finalize() throws Throwable {
        this.CloseInputStream();
        this.CloseOutputStream();
        this.Disconnect();
        super.finalize();
    }

    protected HttpURLConnection GetConnection() {
        return this.m_Connection;
    }

    private boolean SetConnection(HttpURLConnection rConnection) {
        boolean bDirty = false;
        if (this.m_Connection != rConnection) {
            bDirty = true;
            this.m_Connection = rConnection;
        }
        return bDirty;
    }

    public void SetCompressionType(int nCompressionType) {
        this.m_nCompressionType = nCompressionType;
    }

    public int GetCompressionType() {
        return this.m_nCompressionType;
    }

    private HttpURLConnection CreateConnection(URL rURL) throws IOException {
        HttpURLConnection rConnection = null;
        rConnection = (HttpURLConnection)rURL.openConnection();
        if (rConnection == null) {
            throw new NullPointerException("HttpURLConnection failed in CURLConnection.CreateConnection");
        }
        rConnection.setDoInput(true);
        rConnection.setDoOutput(true);
        rConnection.setUseCaches(false);
        rConnection.setDefaultUseCaches(false);
        return rConnection;
    }

    private void LoadRequestHeader(String[] asHeaderInfo) throws NullPointerException {
        if (asHeaderInfo == null || this.GetConnection() == null) {
            throw new NullPointerException("Invalid parms in CURLConnection.LoadRequestHeader");
        }
        for (int nIdx = 0; nIdx < asHeaderInfo.length; nIdx += 2) {
            String sKey = asHeaderInfo[nIdx];
            String sValue = asHeaderInfo[nIdx + 1];
            if (sKey == null) {
                throw new NullPointerException("Invalid key in CURLConnection.LoadRequestHeader");
            }
            this.GetConnection().setRequestProperty(sKey, sValue);
        }
    }

    protected void PrintRequestHeader() {
        String sMsg = String.format("---------- HTTP Header | Request | %s ----------\r\n", Thread.currentThread().getName());
        System.out.printf(sMsg, new Object[0]);
        if (DEBUG_TEXT_PANE != null) {
            DEBUG_TEXT_PANE.setText(DEBUG_TEXT_PANE.getText() + sMsg);
        }
        this.PrintHTTPFields(this.GetConnection().getRequestProperties());
    }

    protected void PrintResponseHeader() {
        String sMsg = String.format("---------- HTTP Header | Response | %s ----------\r\n", Thread.currentThread().getName());
        System.out.printf(sMsg, new Object[0]);
        if (DEBUG_TEXT_PANE != null) {
            DEBUG_TEXT_PANE.setText(DEBUG_TEXT_PANE.getText() + sMsg);
        }
        this.PrintHTTPFields(this.GetConnection().getHeaderFields());
    }

    private void PrintHTTPFields(Map<String, List<String>> aFieldMap) {
        Set<String> asSet;
        if (aFieldMap != null && (asSet = aFieldMap.keySet()) != null) {
            for (String sHeaderField : asSet) {
                String sMsg = String.format("%30s: %s\r\n", sHeaderField, aFieldMap.get(sHeaderField));
                System.out.printf(sMsg, new Object[0]);
                if (DEBUG_TEXT_PANE == null) continue;
                DEBUG_TEXT_PANE.setText(DEBUG_TEXT_PANE.getText() + sMsg);
            }
            String sMsg = String.format("%30s: %s\r\n", "Using Proxy", this.GetConnection().usingProxy());
            System.out.printf(sMsg, new Object[0]);
            if (DEBUG_TEXT_PANE != null) {
                DEBUG_TEXT_PANE.setText(DEBUG_TEXT_PANE.getText() + sMsg);
            }
        }
    }

    protected void PrintResponseBody() {
        block6: {
            try {
                String decodedString;
                StringBuilder sbResponse = new StringBuilder("---------- Response Body ----------\r\n");
                InputStream streamInput = this.GetConnection().getInputStream();
                boolean bMarkSupported = streamInput.markSupported();
                if (bMarkSupported) {
                    streamInput.mark(Integer.MAX_VALUE);
                }
                BufferedReader streamReader = new BufferedReader(new InputStreamReader(streamInput));
                while ((decodedString = streamReader.readLine()) != null) {
                    sbResponse.append("\t" + decodedString + "\r\n");
                }
                if (bMarkSupported) {
                    streamInput.reset();
                }
                System.out.println(sbResponse);
                if (DEBUG_TEXT_PANE != null) {
                    DEBUG_TEXT_PANE.setText(DEBUG_TEXT_PANE.getText() + sbResponse.toString() + "\r\n");
                }
            }
            catch (IOException ioe) {
                if (CRhinoApp.GET_RHINO_APP() == null) break block6;
                CRhinoApp.GET_RHINO_APP().Debug_Warning(String.format("EXCEPTION:  PrintResponse failed (%s)", ioe.getMessage()));
            }
        }
    }

    private boolean ConnectToServer() throws IOException {
        boolean bConnected = false;
        if (DEBUG_PRINT_REQUEST_HEADER) {
            this.PrintRequestHeader();
        }
        this.CloseInputStream();
        this.CloseOutputStream();
        if (this.GetConnection() != null) {
            this.GetConnection().setConnectTimeout(10000);
            this.GetConnection().connect();
            bConnected = true;
        }
        if (DEBUG_PRINT_RESPONSE_HEADER) {
            this.PrintResponseHeader();
        }
        if (DEBUG_PRINT_RESPONSE_BODY) {
            this.PrintResponseBody();
        }
        return bConnected;
    }

    public int Get(URL rURL, String[] asRequestHeaderInfo) {
        int nServerResponseCode = -1;
        if (DEBUG_PRINT_URL) {
            String sMsg = String.format("---------- URL ----------\r\n\t%s", rURL.toString());
            System.out.println(sMsg);
            sMsg = sMsg + "\r\n";
            if (DEBUG_TEXT_PANE != null) {
                DEBUG_TEXT_PANE.setText(DEBUG_TEXT_PANE.getText() + sMsg);
            }
        }
        this.StartWatchDog();
        int nAttempt = 0;
        do {
            try {
                this.ResetWatchDogDisconnect();
                ++nAttempt;
                HttpURLConnection rConnection = this.CreateConnection(rURL);
                if (rConnection == null) continue;
                this.SetConnection(rConnection);
                rConnection.setRequestMethod("GET");
                this.LoadRequestHeader(asRequestHeaderInfo);
                if (!this.TickleWatchDog() || !this.ConnectToServer()) continue;
                this.m_bIsCheckingConnectTimeout = false;
                nServerResponseCode = this.GetHTTPResponseCode();
            }
            catch (ProtocolException pe) {
                System.out.println("PException occurred during download: " + pe.getMessage());
                if (!DEBUG) continue;
                pe.printStackTrace();
            }
            catch (IOException ioe) {
                System.out.println("IOException occurred during download: " + ioe.getMessage());
                if (!DEBUG) continue;
                ioe.printStackTrace();
            }
            catch (Exception e) {
                System.out.println("Exception occurred during download: " + e.getMessage());
                if (!DEBUG) continue;
                e.printStackTrace();
            }
        } while ((nServerResponseCode == -1 || nServerResponseCode == 408) && nAttempt <= 3);
        if (nAttempt > 3) {
            nServerResponseCode = 408;
        }
        this.StopWatchDog();
        return nServerResponseCode;
    }

    public int Post(URL rURL, String[] asRequestHeaderInfo, int nContentLen) {
        int nServerResponseCode;
        block12: {
            nServerResponseCode = -1;
            if (DEBUG_PRINT_URL) {
                String sMsg = String.format("---------- URL ----------\r\n\t%s", rURL.toString());
                System.out.println(sMsg);
                sMsg = sMsg + "\r\n";
                if (DEBUG_TEXT_PANE != null) {
                    DEBUG_TEXT_PANE.setText(DEBUG_TEXT_PANE.getText() + sMsg);
                }
            }
            this.StartWatchDog();
            try {
                int nAttempt = 0;
                do {
                    this.ResetWatchDogDisconnect();
                    ++nAttempt;
                    HttpURLConnection rConnection = this.CreateConnection(rURL);
                    if (rConnection == null) continue;
                    this.SetConnection(rConnection);
                    rConnection.setRequestMethod("POST");
                    if (this.UseCompression()) {
                        this.GetConnection().setChunkedStreamingMode(0);
                    } else {
                        this.GetConnection().setFixedLengthStreamingMode(nContentLen);
                        this.GetConnection().setRequestProperty("Content-Length", Integer.toString(nContentLen));
                    }
                    this.LoadRequestHeader(asRequestHeaderInfo);
                    this.m_bIsCheckingConnectTimeout = false;
                    if (!this.TickleWatchDog()) continue;
                    nServerResponseCode = 1;
                } while (nServerResponseCode == -1 && nAttempt <= 3);
                if (nAttempt > 3) {
                    nServerResponseCode = 408;
                }
            }
            catch (ProtocolException pe) {
                if (DEBUG) {
                    pe.printStackTrace();
                }
            }
            catch (IOException ioe) {
                if (DEBUG) {
                    ioe.printStackTrace();
                }
            }
            catch (Exception e) {
                if (!DEBUG) break block12;
                e.printStackTrace();
            }
        }
        this.StopWatchDog();
        return nServerResponseCode;
    }

    private void CheckCompressionMethod() {
        String sContentEncoding;
        if (this.GetConnection() != null && (sContentEncoding = this.GetConnection().getContentEncoding()) != null && !sContentEncoding.isEmpty()) {
            if ((sContentEncoding = sContentEncoding.toLowerCase()).equals("gzip")) {
                this.SetCompressionType(1);
            } else if (sContentEncoding.equals("deflate")) {
                this.SetCompressionType(2);
            }
        }
    }

    protected BufferedInputStream GetInputStream(int[] anRetCodes) {
        this.m_InputStream = null;
        if (this.GetConnection() != null) {
            try {
                CSpeedTest spt = new CSpeedTest();
                if (DEBUG_GET_INPUT_STREAM) {
                    spt.Start();
                    SimpleDateFormat sdf = new SimpleDateFormat("E ddMMMyy hh:mm:ss");
                    String sTime = sdf.format(System.currentTimeMillis());
                    String sMsg = String.format("%s | pre-getInputStream() for -> ", sTime);
                    sMsg = this.GetConnection() != null && this.GetConnection().getURL() != null ? sMsg + this.GetConnection().getURL().toString() : sMsg + "<unknown URL>";
                    System.out.println(sMsg);
                }
                int nTimeout = 60000;
                this.GetConnection().setReadTimeout(nTimeout);
                this.StartWatchDog();
                try {
                    this.m_InputStream = new BufferedInputStream(this.GetConnection().getInputStream());
                }
                catch (Exception e) {
                    this.m_InputStream = null;
                    anRetCodes[1] = 11003;
                    if (DEBUG) {
                        CDebugLog.INFO("CHTTPConnection.GetInputStream -> getInputStream threw an Exception!");
                        e.printStackTrace();
                    }
                    this.CloseInputStream();
                }
                this.StopWatchDog();
                if (this.m_InputStream == null && this.IsDisconnectedByWatchDog() && anRetCodes != null && anRetCodes.length >= 1) {
                    anRetCodes[0] = 408;
                }
                if (DEBUG_GET_INPUT_STREAM) {
                    spt.Stop();
                    SimpleDateFormat sdf = new SimpleDateFormat("E ddMMMyy hh:mm:ss");
                    String sTime = sdf.format(System.currentTimeMillis());
                    String sMsg = String.format("%s | post-getInputStream() for -> ", sTime);
                    sMsg = this.GetConnection() != null && this.GetConnection().getURL() != null ? sMsg + this.GetConnection().getURL().toString() : sMsg + "<unknown URL>";
                    spt.PrintResults(sMsg);
                }
                this.CheckCompressionMethod();
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                this.CloseInputStream();
                anRetCodes[1] = 11003;
            }
        } else {
            this.CloseInputStream();
            anRetCodes[1] = 11000;
        }
        return this.m_InputStream;
    }

    public void CloseInputStream() {
        if (this.CloseInputStream(this.m_InputStream) == null) {
            this.m_InputStream = null;
        }
    }

    public void CloseOutputStream() {
        this.m_OutputStream = this.CloseOutputStream(this.m_OutputStream);
    }

    public InputStream CloseInputStream(InputStream rStream) {
        if (rStream != null) {
            block3: {
                try {
                    rStream.close();
                }
                catch (IOException ioe) {
                    if (!DEBUG) break block3;
                    ioe.printStackTrace();
                }
            }
            rStream = null;
        }
        return rStream;
    }

    public OutputStream GetOutputStream() {
        this.m_OutputStream = this.GetOutputStream(this.UseCompression());
        if (this.m_OutputStream == null) {
            this.m_OutputStream = this.GetOutputStream(false);
        }
        return this.m_OutputStream;
    }

    public OutputStream GetOutputStream(boolean bUseCompression) {
        block6: {
            if (this.GetConnection() != null) {
                if (this.m_OutputStream == null) {
                    try {
                        if (bUseCompression) {
                            this.m_OutputStream = this.GetCompressionType() == 1 ? new GZIPOutputStream(this.GetConnection().getOutputStream()) : (this.GetCompressionType() == 2 ? new DeflaterOutputStream(this.GetConnection().getOutputStream()) : new BufferedOutputStream(this.GetConnection().getOutputStream()));
                            break block6;
                        }
                        this.m_OutputStream = new BufferedOutputStream(this.GetConnection().getOutputStream());
                    }
                    catch (IOException ioe) {
                        this.m_OutputStream = this.CloseOutputStream(this.m_OutputStream);
                    }
                }
            } else {
                this.m_OutputStream = this.CloseOutputStream(this.m_OutputStream);
            }
        }
        return this.m_OutputStream;
    }

    public OutputStream CloseOutputStream(OutputStream rStream) {
        if (rStream != null) {
            block3: {
                try {
                    rStream.close();
                }
                catch (IOException ioe) {
                    if (!DEBUG) break block3;
                    ioe.printStackTrace();
                }
            }
            rStream = null;
        }
        return rStream;
    }

    public void Disconnect() {
        this.CloseInputStream();
        this.CloseOutputStream();
        this.DisconnectSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void DisconnectSocket() {
        Object object = this.m_Crit;
        synchronized (object) {
            if (this.m_Connection != null) {
                this.m_Connection.disconnect();
            }
            this.m_Connection = null;
        }
    }

    protected int GetHTTPResponseCode() {
        int nRespCode = -1;
        if (this.GetConnection() != null) {
            block3: {
                this.StartWatchDog();
                try {
                    nRespCode = this.GetConnection().getResponseCode();
                }
                catch (IOException ioe) {
                    nRespCode = this.IsDisconnectedByWatchDog() ? 408 : 503;
                    if (!DEBUG) break block3;
                    ioe.printStackTrace();
                }
            }
            this.StopWatchDog();
        }
        return nRespCode;
    }

    protected void PostEvent(CAttrMsg rAttrMsg) throws NullPointerException {
        CRhinoEvent rEvent = new CRhinoEvent(rAttrMsg);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(rEvent);
    }

    protected String GetHeaderValue(String sHTTPField, int[] anRetCodes) {
        String sValue = null;
        this.StartWatchDog();
        if (this.GetConnection() != null) {
            sValue = this.GetConnection().getHeaderField(sHTTPField);
        }
        this.StopWatchDog();
        if (sValue == null && this.IsDisconnectedByWatchDog() && anRetCodes != null && anRetCodes.length >= 1) {
            anRetCodes[0] = 408;
        }
        return sValue;
    }

    protected String CreateBoundary() {
        return "--------------------" + Long.toString(System.currentTimeMillis(), 16);
    }

    protected String FmtStartBoundary(String sBoundary, String sContentDispName, String sFileName) {
        StringBuilder sStartBoundary = new StringBuilder();
        if (sBoundary != null) {
            sStartBoundary.append("--");
            sStartBoundary.append(sBoundary);
            sStartBoundary.append("\r\n");
            String sEncodedFileName = sFileName;
            try {
                sEncodedFileName = sEncodedFileName.replaceAll("&", "&#38;");
                sEncodedFileName = CHTTPConnection.HTMLEncode(sEncodedFileName);
                if (DEBUG_UPLOAD_BOUNDARY) {
                    System.out.println("---------- HTTP Upload Boundary ----------");
                    System.out.printf("    Filename:  %s\r\n", sFileName);
                    String sUTF82 = new String(sFileName.getBytes("UTF-8"));
                    System.out.printf("    getBytes using UTF-8:  %s\r\n", sUTF82);
                    String sUTF8 = URLEncoder.encode(sFileName, "UTF-8");
                    System.out.printf("    URLEncoder using UTF-8:  %s\r\n", sUTF8);
                    String sISO = URLEncoder.encode(sFileName, "ISO-8859-1");
                    System.out.printf("    URLEncoder using ISO-8859-1:  %s\r\n", sISO);
                    String sHTML = CHTTPConnection.HTMLEncode(sFileName);
                    System.out.printf("    HTMLEncoded:  %s\r\n", sHTML);
                }
            }
            catch (Exception e) {
                sEncodedFileName = sFileName;
            }
            sStartBoundary.append(String.format("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"\r\n", sContentDispName, sEncodedFileName));
            sStartBoundary.append("Content-Type; application/octet-stream\r\n");
            sStartBoundary.append("\r\n");
        }
        return sStartBoundary.toString();
    }

    public static String HTMLEncode(String sStr) {
        StringBuffer sbRet = new StringBuffer();
        for (int nIdx = 0; nIdx < sStr.length(); ++nIdx) {
            char ch = sStr.charAt(nIdx);
            if (ch > '\u007f' || ch == '\"' || ch == '<' || ch == '>') {
                sbRet.append("&#" + ch + ";");
                continue;
            }
            sbRet.append(ch);
        }
        return sbRet.toString();
    }

    protected String FmtEndBoundary(String sBoundary) {
        StringBuilder sEndBoundary = new StringBuilder();
        if (sBoundary != null) {
            sEndBoundary.append("\r\n");
            sEndBoundary.append("--");
            sEndBoundary.append(sBoundary);
            sEndBoundary.append("--");
            sEndBoundary.append("\r\n");
        }
        return sEndBoundary.toString();
    }

    protected int GetFileBoundaryLength(String sBoundary, String sContentDispName, String sFileName) {
        int nTotal = 0;
        String sStartBoundary = this.FmtStartBoundary(sBoundary, sContentDispName, sFileName);
        String sEndBoundary = this.FmtEndBoundary(sBoundary);
        if (sStartBoundary != null && sEndBoundary != null) {
            nTotal = sStartBoundary.getBytes().length + sEndBoundary.getBytes().length;
        }
        return nTotal;
    }

    public boolean UseCompression() {
        boolean bUseCompression = false;
        if (this.GetCompressionType() == 1 || this.GetCompressionType() == 2) {
            bUseCompression = true;
        }
        if (DEBUG_OVERRIDE_USE_COMPRESSION) {
            bUseCompression = DEBUG_INFLATE_PACKETS;
        }
        return bUseCompression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void StartWatchDog() {
        Object object = this.m_Crit;
        synchronized (object) {
            this.m_bWatchDogIsActive = true;
            this.m_bIsDisconnectedByWatchDog = false;
        }
        this.TickleWatchDog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean TickleWatchDog() {
        boolean bCanContinue = true;
        Object object = this.m_Crit;
        synchronized (object) {
            this.m_lTickleTime = System.currentTimeMillis();
            bCanContinue = !this.m_bIsDisconnectedByWatchDog;
        }
        return bCanContinue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ResetWatchDogDisconnect() {
        Object object = this.m_Crit;
        synchronized (object) {
            this.m_bIsDisconnectedByWatchDog = false;
            this.m_bIsCheckingConnectTimeout = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void StopWatchDog() {
        Object object = this.m_Crit;
        synchronized (object) {
            this.m_bWatchDogIsActive = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean IsWatchDogActive() {
        boolean bWatchDogIsActive = false;
        Object object = this.m_Crit;
        synchronized (object) {
            bWatchDogIsActive = this.m_bWatchDogIsActive;
        }
        return bWatchDogIsActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long GetTickleTime() {
        long lTickleTime = 0L;
        Object object = this.m_Crit;
        synchronized (object) {
            lTickleTime = this.m_lTickleTime;
        }
        return lTickleTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean IsDisconnectedByWatchDog() {
        boolean bWatchDogDisconnected = false;
        Object object = this.m_Crit;
        synchronized (object) {
            bWatchDogDisconnected = this.m_bIsDisconnectedByWatchDog;
        }
        return bWatchDogDisconnected;
    }

    public boolean IsWatchDogExpired() {
        boolean bWatchDogExpired = false;
        if (this.IsWatchDogActive()) {
            if (this.m_bIsCheckingConnectTimeout) {
                if (System.currentTimeMillis() > this.GetTickleTime() + 10000L) {
                    bWatchDogExpired = true;
                }
            } else if (System.currentTimeMillis() > this.GetTickleTime() + 30000L) {
                bWatchDogExpired = true;
            }
        }
        return bWatchDogExpired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void OnTriggeredWatchDog() {
        if (DEBUG_WATCHDOG) {
            System.out.println("CHTTPConnection.OnTriggeredWatchDog -> Our watch dog just expired, so we're assuming some call is hung up!");
        }
        Object object = this.m_Crit;
        synchronized (object) {
            this.m_bIsDisconnectedByWatchDog = true;
        }
        this.DisconnectSocket();
    }

    public synchronized boolean GetCancel() {
        return this.m_bCancel;
    }

    public synchronized void SetCancel(boolean bCancel) {
        this.m_bCancel = bCancel;
        if (this.m_bCancel) {
            this.DisconnectSocket();
        }
    }

    @Override
    public void Destroy() {
        this.Disconnect();
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_PRINT_URL = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_PRINT_REQUEST_HEADER = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_UPLOAD_BOUNDARY = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_PRINT_RESPONSE_HEADER = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_PRINT_RESPONSE_BODY = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_GET_INPUT_STREAM = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_WATCHDOG = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_OVERRIDE_USE_COMPRESSION = false;
        DEBUG_INFLATE_PACKETS = false;
    }
}

