/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.messages;

import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CUIMessage;
import java.util.HashMap;

public class CUpdateDynamicBtns
extends CUIMessage {
    protected CButtonState[] m_aBtnStateObjs;
    protected HashMap<Integer, CButtonState> m_aBtnStateMap;
    private boolean m_bDispatchBtns = true;
    private boolean m_bDispatchText = true;

    public CUpdateDynamicBtns(int nMsgID, Object objSource) {
        super(nMsgID, objSource);
        this._CUpdateDynamicBtns();
    }

    public CUpdateDynamicBtns(Object objSource) {
        super(4023, objSource);
        this._CUpdateDynamicBtns();
    }

    private void _CUpdateDynamicBtns() {
        this.InitBtnStateObjs();
    }

    protected void InitBtnStateObjs() {
    }

    public String[] MakeBtnStateFlagArray() {
        String[] asFlags = new String[this.m_aBtnStateObjs.length * 2];
        int nFlagIdx = 0;
        int nIdx = 0;
        while (nIdx < this.m_aBtnStateObjs.length) {
            block4: {
                CButtonState rBtnState = this.m_aBtnStateObjs[nIdx];
                if (rBtnState != null) {
                    try {
                        asFlags[nFlagIdx] = rBtnState.GetEnabled() ? "1" : "0";
                        asFlags[nFlagIdx + 1] = rBtnState.IsVisible() ? "1" : "0";
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block4;
                        e.printStackTrace();
                    }
                }
            }
            ++nIdx;
            nFlagIdx += 2;
        }
        return asFlags;
    }

    protected CButtonState GetButtonStateObj(int nIndex) {
        CButtonState rBtnState = null;
        if (nIndex >= 0 && nIndex < this.m_aBtnStateObjs.length) {
            rBtnState = this.m_aBtnStateObjs[nIndex];
        } else if (DEBUG) {
            CDebugLog.ASSERT(CUpdateDynamicBtns.class.getName(), CDebugLog.GetLineNumber(), String.format("Out of Bounds: %d", nIndex));
        }
        return rBtnState;
    }

    protected CButtonState GetButtonStateObj_FromMap(int nBtnID) {
        CButtonState rBtnState = null;
        if (this.m_aBtnStateMap != null) {
            rBtnState = this.m_aBtnStateMap.get(nBtnID);
        } else if (DEBUG) {
            CDebugLog.ASSERT(CUpdateDynamicBtns.class.getName(), CDebugLog.GetLineNumber(), "Programming error, m_aBtnStateMap is null");
        }
        return rBtnState;
    }

    public boolean GetDispatchBtns() {
        return this.m_bDispatchBtns;
    }

    public void SetDispatchBtns(boolean bDispatchBtns) {
        this.m_bDispatchBtns = bDispatchBtns;
    }

    public boolean GetDispatchText() {
        return this.m_bDispatchText;
    }

    public void SetDispatchText(boolean bDispatchText) {
        this.m_bDispatchText = bDispatchText;
    }

    public boolean IsMatch(CUpdateDynamicBtns rCompareTo) {
        boolean bIsMatch = false;
        if (rCompareTo != null && rCompareTo.m_aBtnStateObjs != null) {
            boolean bAreSame = true;
            if (rCompareTo.m_aBtnStateObjs.length == this.m_aBtnStateObjs.length) {
                for (int nIdx = 0; nIdx < this.m_aBtnStateObjs.length && bAreSame; ++nIdx) {
                    CButtonState rBtnState = this.m_aBtnStateObjs[nIdx];
                    CButtonState rBtnStateCompareTo = rCompareTo.m_aBtnStateObjs[nIdx];
                    if (rBtnState != null && rBtnStateCompareTo != null) {
                        bAreSame = rBtnState.IsMatch(rBtnStateCompareTo);
                        continue;
                    }
                    if (rBtnStateCompareTo != null) continue;
                    bAreSame = false;
                }
            }
            if (bAreSame) {
                bIsMatch = true;
            }
        }
        this.SetDispatchBtns(!bIsMatch);
        return bIsMatch;
    }

    protected class CButtonState {
        private int m_nActionID = -1;
        private boolean m_bEnabled = true;
        private boolean m_bVisible = true;

        public CButtonState(int nActionID) {
            this.m_nActionID = nActionID;
            this.m_bEnabled = true;
            this.m_bVisible = true;
        }

        public CButtonState(int nActionID, boolean bEnabled, boolean bVisible) {
            this.m_nActionID = nActionID;
            this.m_bEnabled = bEnabled;
            this.m_bVisible = bVisible;
        }

        public boolean IsMatch(CButtonState rCompareTo) {
            boolean bIsMatch = false;
            if (rCompareTo != null && this.m_nActionID == rCompareTo.m_nActionID && this.m_bEnabled == rCompareTo.m_bEnabled && this.m_bVisible == rCompareTo.m_bVisible) {
                bIsMatch = true;
            }
            return bIsMatch;
        }

        public int GetActionID() {
            return this.m_nActionID;
        }

        public boolean SetEnabled(boolean bEnabled) {
            boolean bChanged = false;
            if (this.m_bEnabled != bEnabled) {
                this.m_bEnabled = bEnabled;
                bChanged = true;
            }
            return bChanged;
        }

        public final boolean GetEnabled() {
            return this.m_bEnabled;
        }

        public boolean SetVisible(boolean bVisible) {
            boolean bChanged = false;
            if (this.m_bVisible != bVisible) {
                this.m_bVisible = bVisible;
                bChanged = true;
            }
            return bChanged;
        }

        public final boolean IsHidden() {
            return !this.m_bVisible;
        }

        public final boolean IsVisible() {
            return this.m_bVisible;
        }
    }
}

