/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.messages;

import com.rhinosoft.messages.CUIMessage;
import java.awt.Dimension;
import java.awt.Point;

public class CUpdateCenterPointMsg
extends CUIMessage {
    public static boolean DEBUG_SCREEN_COORDS;
    private int m_nClientWidth;
    private int m_nClientHeight;
    private Point m_ptMainWndTopLeftOnScreen;
    private Dimension m_dimMainWndSize;
    private Point m_ptCenterPoint;

    public CUpdateCenterPointMsg(Object objSource, int nClientWidth, int nClientHeight, Point ptMainWndTopLeftOnScreen, Dimension dimMainWndSize) {
        super(3530, objSource);
        this._CUpdateCenterPointMsg(nClientWidth, nClientHeight, ptMainWndTopLeftOnScreen, dimMainWndSize);
    }

    private void _CUpdateCenterPointMsg(int nClientWidth, int nClientHeight, Point ptMainWndTopLeftOnScreen, Dimension dimMainWndSize) {
        this.m_nClientWidth = nClientWidth;
        this.m_nClientHeight = nClientHeight;
        this.m_ptMainWndTopLeftOnScreen = ptMainWndTopLeftOnScreen;
        this.m_dimMainWndSize = dimMainWndSize;
        this.m_ptCenterPoint = this.CalculateCenterPoint();
    }

    public int GetClientWidth() {
        return this.m_nClientWidth;
    }

    public int GetClientHeight() {
        return this.m_nClientHeight;
    }

    public Point GetMainWndTopLeftOnScreen() {
        return this.m_ptMainWndTopLeftOnScreen;
    }

    public Dimension GetMainWndSize() {
        return this.m_dimMainWndSize;
    }

    public Point GetCenterPoint() {
        return this.m_ptCenterPoint;
    }

    protected Point CalculateCenterPoint() {
        return this.CalculateCenterPoint(this.GetClientWidth(), this.GetClientHeight(), this.GetMainWndTopLeftOnScreen(), this.GetMainWndSize());
    }

    public Point CalculateCenterPoint(int nClientWidth, int nClientHeight, Point ptContainerTopLeftOnScreen, Dimension dimContainerSize) {
        Point ptCenterPoint = null;
        if (ptContainerTopLeftOnScreen != null && dimContainerSize != null && dimContainerSize.width > 0 && dimContainerSize.height > 0 && nClientWidth > 0 && nClientHeight > 0) {
            if (DEBUG_SCREEN_COORDS) {
                System.out.printf("ClientWidth: %d | ClientHeight: %d | Container Location (Onscreen): %d,%d | Container Size: %d,%d\r\n", nClientWidth, nClientHeight, ptContainerTopLeftOnScreen.x, ptContainerTopLeftOnScreen.y, dimContainerSize.width, dimContainerSize.height);
            }
            int nX = 0;
            int nY = 0;
            nX = ptContainerTopLeftOnScreen.x;
            nY = ptContainerTopLeftOnScreen.y - (nClientHeight - dimContainerSize.height);
            ptCenterPoint = new Point(nX += nClientWidth / 2, nY += nClientHeight / 2);
        }
        return ptCenterPoint;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_SCREEN_COORDS = false;
    }
}

