/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.messages;

import com.rhinosoft.attrs.CConnectionAttrs;
import com.rhinosoft.dialogs.CConfirmDlg;
import com.rhinosoft.dialogs.CConfirmFolderMergeDlg;
import com.rhinosoft.dialogs.CConfirmOverwriteDlg;
import com.rhinosoft.files.CFile;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CSUSourceMsg;
import com.rhinosoft.messages.CUIMessage;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.threads.CWorkerThread;
import com.rhinosoft.ui.CRhinoApp;
import java.awt.Component;
import java.io.File;

public abstract class CTransferMsg
extends CSUSourceMsg {
    private static boolean DEBUG_PACE_IT_TO_CHECK_GUI = CRhinoApp.DEBUG_PACE_IT_TO_CHECK_GUI;
    private boolean m_bTargetIsLocal;
    private String m_sAbsPathTarget;
    private boolean m_bTargetIsDir;
    private String m_sAbsRenameTargetTo;
    private int[] m_anRetCodeTarget;
    private CFile m_fTarget;

    public CTransferMsg(int nMsgID, String sHost, long lServerPort, boolean bIsSecure, long lHeaderPort, String sUserAgent, String sEncSessionID, long lUITransferID, boolean bSourceIsLocal, String sAbsPathSource, boolean bSourceIsDir, boolean bTargetIsLocal, String sAbsPathTarget, boolean bTargetIsDir) {
        super(nMsgID, sHost, lServerPort, bIsSecure, lHeaderPort, sUserAgent, sEncSessionID, lUITransferID, bSourceIsLocal, sAbsPathSource, bSourceIsDir);
        this._CTransferMsg(bTargetIsLocal, sAbsPathTarget, bTargetIsDir);
    }

    public CTransferMsg(int nMsgID, String sHost, long lServerPort, boolean bIsSecure, long lHeaderPort, String sUserAgent, String sEncSessionID, long lUITransferID, boolean bSourceIsLocal, String sAbsPathSource, boolean bSourceIsDir, boolean bTargetIsLocal) {
        super(nMsgID, sHost, lServerPort, bIsSecure, lHeaderPort, sUserAgent, sEncSessionID, lUITransferID, bSourceIsLocal, sAbsPathSource, bSourceIsDir);
        this._CTransferMsg(bTargetIsLocal, null, false);
    }

    private void _CTransferMsg(boolean bTargetIsLocal, String sAbsPathTarget, boolean bTargetIsDir) {
        this.m_bTargetIsLocal = bTargetIsLocal;
        this.m_sAbsPathTarget = sAbsPathTarget;
        this.m_bTargetIsDir = bTargetIsDir;
        this.m_fTarget = null;
    }

    @Override
    public void Destroy() {
        this.m_anRetCodeTarget = null;
        super.Destroy();
    }

    protected abstract int GetMsgID_OnRecvTransferring();

    protected abstract int GetMsgID_OnRecvTransfer();

    protected abstract int[] CreateTargetDir();

    protected abstract int[] TransferFile(long var1);

    public boolean IsTargetLocal() {
        return this.m_bTargetIsLocal;
    }

    public boolean IsTargetRemote() {
        return !this.IsTargetLocal();
    }

    public String GetTargetPath() {
        return this.m_sAbsPathTarget;
    }

    public void SetTargetPath(String sAbsPathTarget) {
        this.m_sAbsPathTarget = sAbsPathTarget;
    }

    public boolean IsDirTarget() {
        return this.m_bTargetIsDir;
    }

    public void SetTargetIsDir(boolean bIsDir) {
        this.m_bTargetIsDir = bIsDir;
    }

    protected int CreateLocalDirectory(String sAbsNewDir) {
        return this.CreateLocalDirectory(sAbsNewDir, true);
    }

    private int CreateLocalDirectory(String sAbsNewDir, boolean bRetryOnException) {
        int nRet = 1;
        File fTemp = new File(sAbsNewDir);
        if (fTemp != null && !fTemp.exists()) {
            try {
                if (fTemp.mkdir()) {
                    nRet = 0;
                }
            }
            catch (Exception ex) {
                if (DEBUG) {
                    System.out.println("ASSERT:  file system error, could not create a new folder");
                }
                nRet = -3;
            }
        } else {
            nRet = 12;
        }
        return nRet;
    }

    private void ShowConfirmFileOverwriteDlg(Component rSource, Component rCenterTo) {
        CWorkerThread rThumbThread = null;
        CConnectionAttrs rConnAttrs = null;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            rThumbThread = CRhinoApp.GET_RHINO_APP().GetGeneralThread();
            rConnAttrs = CRhinoApp.GET_RHINO_APP().GetConnectionAttrs();
        }
        boolean bIsMove = false;
        CConfirmOverwriteDlg dlg = new CConfirmOverwriteDlg(CRhinoApp.GetParentWindow(rCenterTo), this, this.GetSourceFile(), rThumbThread, rConnAttrs, this.GetUISourceAttrID(), bIsMove);
        boolean bShowResume = this.GetCanResume();
        dlg.ShowResumeBtn(bShowResume);
        dlg.SetVisible_DoNotAskAgain(this.GetShowDoNotAskAgainBtn());
        dlg.SetTargetFile(this.GetTargetFile());
        dlg.SetAbsRenameTo(this.GetAbsRenameTargetTo());
        boolean bShowConfirmCancelCloseDlg = true;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            bShowConfirmCancelCloseDlg = CRhinoApp.GET_RHINO_APP().GetShowConfirmCancelCloseDlg();
        }
        dlg.SetConfirmClose(bShowConfirmCancelCloseDlg);
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().PostAddDialogToQueue(rSource, dlg);
        }
    }

    private void ShowConfirmFolderMergeDlg(Component rSource, Component rCenterTo) {
        CConfirmFolderMergeDlg dlg = new CConfirmFolderMergeDlg(CRhinoApp.GetParentWindow(rCenterTo), this, this.GetSourceFile(), this.GetTargetFile());
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().PostAddDialogToQueue(rSource, dlg);
        }
    }

    @Override
    public void OnConfirm(Component rSource, Component rCenterTo) {
        if (this.IsDirSource()) {
            this.ShowConfirmFolderMergeDlg(rSource, rCenterTo);
        } else {
            this.ShowConfirmFileOverwriteDlg(rSource, rCenterTo);
        }
    }

    @Override
    protected String GetErrorDlgTitle() {
        String sTitle = CString.LoadString("IDS_ERROR_FMT_TITLE");
        sTitle = this.IsUpload() ? String.format(sTitle, CString.LoadString("IDS_ERROR_TITLE_UPLOAD")) : (this.IsDownload() ? String.format(sTitle, CString.LoadString("IDS_ERROR_TITLE_DOWNLOAD")) : String.format(sTitle, CString.LoadString("IDS_ERROR_TITLE_MOVING")));
        return sTitle;
    }

    @Override
    protected int GetErrorDlgType() {
        return 9;
    }

    @Override
    protected String GetErrorDlgMsg() {
        String sMsg = super.GetErrorDlgMsg();
        if (this.GetTargetPath() != null) {
            sMsg = String.format("%s\r\n\r\n\"%s\"", sMsg, this.GetTargetPath());
        }
        return sMsg;
    }

    protected void InitRenameTargetTo() {
        if (this.GetTargetPath() != null) {
            if (this.GetSourcePath() != null) {
                String sTargetDir = CString.GetParentPath(this.GetTargetPath(), true);
                String sTargetName = CString.GetFileName(this.GetSourcePath());
                String sRenameTo = sTargetDir + sTargetName;
                if (sRenameTo != null && !sRenameTo.isEmpty()) {
                    String sExt = CString.GetFileExtension(sRenameTo, false, true);
                    String sPathAndName = sRenameTo;
                    if (sExt != null) {
                        sPathAndName = sRenameTo.replace(sExt, "");
                    }
                    for (int nIdx = 2; nIdx < Short.MAX_VALUE && !this.GetCancel(); ++nIdx) {
                        sRenameTo = String.format("%s (%d)%s", sPathAndName, nIdx, sExt != null ? sExt : "");
                        int[] anRet = this.GetListing(sRenameTo, this.IsDirTarget(), this.IsTargetLocal());
                        if (anRet[0] == 200) {
                            if (anRet[1] != 6) {
                                if (anRet[1] == 0) continue;
                                if (DEBUG) {
                                    CDebugLog.ASSERT(CTransferMsg.class.getName(), CDebugLog.GetLineNumber(), "If we're not cancelled, and we assert, then we may have a problem.");
                                }
                                sRenameTo = null;
                            }
                        } else {
                            sRenameTo = null;
                        }
                        break;
                    }
                } else if (DEBUG) {
                    CDebugLog.ASSERT(CTransferMsg.class.getName(), CDebugLog.GetLineNumber(), "Programming error, sRenameTo variable is invalid.");
                }
                this.m_sAbsRenameTargetTo = sRenameTo;
            } else if (DEBUG) {
                CDebugLog.ASSERT(CTransferMsg.class.getName(), CDebugLog.GetLineNumber(), "Programming error, source is invalid.");
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CTransferMsg.class.getName(), CDebugLog.GetLineNumber(), "Programming error, target is invalid.");
        }
    }

    public String GetAbsRenameTargetTo() {
        return this.m_sAbsRenameTargetTo;
    }

    protected void OnSendTransfer() {
        CUIMessage rStatusMsg = new CUIMessage(this.GetMsgID_OnRecvTransferring(), this.GetThreadAttrID(), this.GetUISourceAttrID());
        this.PostBack(rStatusMsg);
        this.SetHTTPCode(-1);
        this.SetSUCode(-1);
        this.SetMsgID(4201);
        if (this.GetSUConnection() != null) {
            if (this.GetSource() == null) {
                this.GetSourceFileEx();
                if (this.m_anRetCodeSource != null && this.m_anRetCodeSource[0] == 200 && this.m_anRetCodeSource[1] == 0) {
                    this.SetMsgID(4268);
                } else {
                    this.SetMsgID(4201);
                    this.SetSUCode(11010);
                }
            } else if (!this.IsDirSource()) {
                this.OnTransferFile();
            } else {
                this.OnTransferDir();
            }
            if (DEBUG_PACE_IT_TO_CHECK_GUI) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            if (DEBUG) {
                CDebugLog.ASSERT(CTransferMsg.class.getName(), CDebugLog.GetLineNumber(), "Programming error; GetSUConnection() is null");
            }
            this.SetSUCode(11000);
            this.SetMsgID(4201);
        }
        this.PostBack(this);
    }

    protected int[] GetTargetListing() {
        return this.GetListing(this.GetTargetPath(), this.IsDirTarget(), this.IsTargetLocal());
    }

    protected void OnTransferFile() {
        int nHTTPCode = -1;
        int nSUCode = -1;
        int nMsgID = 4201;
        this.SetCanResume(false);
        if (this.GetSourceFileEx() != null) {
            if (!this.GetSourceFileEx().IsDirectory()) {
                int nUserConfirmedOption = 0;
                nUserConfirmedOption = this.GetUserWantsConfirmDlg() ? -2 : this.GetUserConfirmDlgResult();
                CFile fTarget = this.GetTargetFile_Relist();
                if (this.m_anRetCodeTarget[0] == 200) {
                    if (this.m_anRetCodeTarget[1] == 0 && fTarget != null) {
                        long lTargetFileSize = fTarget.GetSize();
                        if (lTargetFileSize < this.GetSourceFileEx().GetSize()) {
                            this.SetCanResume(true);
                            this.SetResumeStartIndex(lTargetFileSize);
                        }
                        this.InitRenameTargetTo();
                    } else if (this.m_anRetCodeTarget[1] == 6) {
                        nUserConfirmedOption = 0;
                    } else {
                        nUserConfirmedOption = -1;
                        nSUCode = 11011;
                    }
                } else {
                    nUserConfirmedOption = -1;
                    nSUCode = 11011;
                }
                if (nUserConfirmedOption == 0 || nUserConfirmedOption == 4 || nUserConfirmedOption == 5) {
                    long lResumeStartIdx = 0L;
                    if (nUserConfirmedOption == 4) {
                        if (this.m_anRetCodeTarget[0] == 200 && this.m_anRetCodeTarget[1] == 0 && fTarget != null) {
                            long lTargetFileSize = fTarget.GetSize();
                            if (lTargetFileSize < this.GetSourceFileEx().GetSize()) {
                                this.SetResumeStartIndex(lTargetFileSize);
                            } else {
                                this.SetResumeStartIndex(0L);
                            }
                        }
                        lResumeStartIdx = this.GetResumeStartIndex();
                        this.GetSUConnection().SetResume(lResumeStartIdx > 0L);
                    } else if (nUserConfirmedOption == 5) {
                        this.SetTarget(null);
                        this.InitRenameTargetTo();
                        this.SetTargetPath(this.GetAbsRenameTargetTo());
                        Object[] anItems = new Object[]{this.GetUISourceAttrID(), this.GetAbsRenameTargetTo()};
                        CUIMessage rRetargetMsg = new CUIMessage(4270, this.GetThreadAttrID(), (Object)anItems);
                        this.PostBack(rRetargetMsg);
                    }
                    int[] anRet = this.TransferFile(lResumeStartIdx);
                    nHTTPCode = anRet[0];
                    nSUCode = anRet[1];
                    if (nHTTPCode == 200 && nSUCode == 0) {
                        nMsgID = this.GetMsgID_OnRecvTransfer();
                        String sAbsPathSourceThumbFile = CFile.GetAbsPathThumbFile(this.GetSourcePath(), this.GetThumbCacheRootDir_Source(), 70, 70);
                        String sAbsPathTargetThumbFile = CFile.GetAbsPathThumbFile(this.GetTargetPath(), this.GetThumbCacheRootDir_Target(), 70, 70);
                        if (CLocalFileSystem.GetLocalFileSystem() != null) {
                            CLocalFileSystem.GetLocalFileSystem().Copy(sAbsPathSourceThumbFile, sAbsPathTargetThumbFile);
                        }
                        this.GetTargetFile(true);
                    } else {
                        nMsgID = 4201;
                    }
                } else {
                    nMsgID = nUserConfirmedOption == 1 || nUserConfirmedOption == 2 || nUserConfirmedOption == -5 || nUserConfirmedOption == -2 ? 4202 : 4201;
                }
            } else {
                nSUCode = 13;
            }
        } else {
            nSUCode = 6;
        }
        this.SetHTTPCode(nHTTPCode);
        this.SetSUCode(nSUCode);
        this.SetMsgID(nMsgID);
    }

    protected void OnTransferDir() {
        int nHTTPCode = -1;
        int nSUCode = -1;
        int nMsgID = 4201;
        this.GetSourceFileEx();
        nHTTPCode = this.m_anRetCodeSource[0];
        nSUCode = this.m_anRetCodeSource[1];
        if (this.m_anRetCodeSource != null && nHTTPCode == 200 && nSUCode == 0) {
            if (this.GetSourceFileEx().IsDirectory()) {
                int nUserConfirmedOption = 0;
                if (this.GetUserWantsConfirmDlg()) {
                    if (this.GetSourceFileEx().GetNumOfChildFiles() > 0) {
                        nUserConfirmedOption = -2;
                    }
                } else {
                    nUserConfirmedOption = this.GetUserConfirmDlgResult();
                }
                boolean bCreateImmediately = false;
                CFile fTarget = this.GetTargetFile();
                if (this.m_anRetCodeTarget[0] == 200) {
                    if (this.m_anRetCodeTarget[1] != 0 || fTarget == null) {
                        if (this.m_anRetCodeTarget[1] == 6) {
                            bCreateImmediately = true;
                            nUserConfirmedOption = 0;
                        } else {
                            nUserConfirmedOption = -1;
                            nSUCode = 11011;
                        }
                    }
                } else {
                    nUserConfirmedOption = -1;
                    nSUCode = 11011;
                }
                if (nUserConfirmedOption == 0) {
                    if (bCreateImmediately || this.GetTargetFile_Relist() == null) {
                        this.CreateTargetDir();
                    }
                    if (this.GetTargetFile_Relist() != null) {
                        nHTTPCode = this.m_anRetCodeSource[0];
                        nSUCode = this.m_anRetCodeSource[1];
                        nMsgID = nHTTPCode == 200 && nSUCode == 0 ? 4269 : 4201;
                    } else {
                        nSUCode = 6;
                        nMsgID = 4201;
                    }
                } else {
                    nMsgID = nUserConfirmedOption == 1 || nUserConfirmedOption == 2 || nUserConfirmedOption == -5 || nUserConfirmedOption == -2 ? 4202 : 4201;
                }
            } else {
                nSUCode = 14;
            }
        }
        this.SetHTTPCode(nHTTPCode);
        this.SetSUCode(nSUCode);
        this.SetMsgID(nMsgID);
    }

    public CFile GetTargetFile() {
        return this.GetTargetFile(false);
    }

    protected CFile GetTargetFile_Relist() {
        return this.GetTargetFile(true);
    }

    protected CFile GetTargetFile(boolean bFetchListing) {
        if (bFetchListing || this.GetTarget() == null) {
            this.SetTarget(null);
            this.m_anRetCodeTarget = this.GetTargetListing();
            if (this.m_anRetCodeTarget != null && this.m_anRetCodeTarget[0] == 200 && this.m_anRetCodeTarget[1] == 0) {
                this.SetTarget(this.TakeListFile());
            }
        }
        return this.GetTarget();
    }

    protected final synchronized void SetTarget(CFile fTarget) {
        if (this.m_fTarget != fTarget) {
            if (fTarget == null && this.m_fTarget != null) {
                this.m_fTarget.Destroy();
            }
            this.m_fTarget = fTarget;
        }
    }

    protected CFile GetTarget() {
        return this.m_fTarget;
    }

    public boolean IsUpload() {
        boolean bIsUpload = false;
        if (this.IsSourceLocal() && this.IsTargetRemote()) {
            bIsUpload = true;
        }
        return bIsUpload;
    }

    public boolean IsDownload() {
        boolean bIsDownload = false;
        if (this.IsSourceRemote() && this.IsTargetLocal()) {
            bIsDownload = true;
        }
        return bIsDownload;
    }

    @Override
    public CConfirmDlg.TYPE GetConfirmDlgType() {
        CConfirmDlg.TYPE nType = super.GetConfirmDlgType();
        if (nType == CConfirmDlg.TYPE.UNKNOWN) {
            nType = this.IsDirSource() ? CConfirmDlg.TYPE.MERGE_FOLDER : CConfirmDlg.TYPE.OVERWRITE_FILE;
        }
        return nType;
    }

    @Override
    public void Reset() {
        super.Reset();
        this.ResetTarget();
    }

    public void ResetTarget() {
        this.SetTarget(null);
    }

    @Override
    protected boolean CanUpdateTransferStats() {
        return true;
    }

    protected String GetThumbCacheRootDir_Source() {
        String sThumbCacheRootDir = "Local";
        if (this.IsSourceRemote()) {
            sThumbCacheRootDir = this.GetHost();
        }
        return sThumbCacheRootDir;
    }

    protected String GetThumbCacheRootDir_Target() {
        String sThumbCacheRootDir = "Local";
        if (this.IsTargetRemote()) {
            sThumbCacheRootDir = this.GetHost();
        }
        return sThumbCacheRootDir;
    }
}

