/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.messages;

import com.rhinosoft.images.CImageUtil;
import com.rhinosoft.messages.CThumbnailMsg;
import com.rhinosoft.strings.CString;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class CThumbnailMsg_Local
extends CThumbnailMsg {
    private MediaTracker m_MediaTracker = new MediaTracker(new JPanel());

    public CThumbnailMsg_Local(String sHost, long lServerPort, boolean bIsSecure, long lHeaderPort, String sUserAgent, String sEncSessionID, long lUITransferID, String sAbsPathSource, boolean bSourceIsDir, int nWidth, int nHeight, boolean bIsPreview) {
        super(sHost, lServerPort, bIsSecure, lHeaderPort, sUserAgent, sEncSessionID, lUITransferID, true, sAbsPathSource, bSourceIsDir, true, nWidth, nHeight, bIsPreview);
    }

    @Override
    protected int[] TransferFile(long lResumeStartIdx) {
        int[] anRet = new int[]{200, -1};
        ImageIcon rThumbImageIcon = this.GetScaledImage(this.GetSourcePath(), this.GetThumbWidth(), this.GetThumbHeight());
        if (!this.GetCancel()) {
            this.SetThumbImageIcon(rThumbImageIcon);
            if (rThumbImageIcon != null) {
                try {
                    Image rImg = rThumbImageIcon.getImage();
                    RenderedImage rRenderedImg = null;
                    if (rImg instanceof RenderedImage) {
                        rRenderedImg = (RenderedImage)((Object)rImg);
                    } else {
                        BufferedImage rBufferedImg = new BufferedImage(rThumbImageIcon.getIconWidth(), rThumbImageIcon.getIconHeight(), 1);
                        Graphics2D g = rBufferedImg.createGraphics();
                        g.drawImage(rImg, 0, 0, null);
                        g.dispose();
                        rRenderedImg = rBufferedImg;
                    }
                    ImageIO.write(rRenderedImg, "jpeg", new File(this.GetTargetPath()));
                    anRet[1] = 0;
                }
                catch (IOException e) {
                    if (DEBUG) {
                        e.printStackTrace();
                    }
                    anRet[1] = -5;
                }
            } else {
                anRet[1] = 602;
            }
        }
        return anRet;
    }

    private ImageIcon GetScaledImage(String sAbsPath, int nWidth, int nHeight) {
        ImageIcon iRetImage = null;
        sAbsPath = CString.MakeForwardSlashes(sAbsPath);
        Image rImage = Toolkit.getDefaultToolkit().createImage(sAbsPath);
        this.m_MediaTracker.addImage(rImage, 1);
        this.m_MediaTracker.checkID(1, true);
        try {
            this.m_MediaTracker.waitForID(1);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (!this.GetCancel() && !this.m_MediaTracker.isErrorAny()) {
            iRetImage = new ImageIcon(rImage);
            Image rScaledImage = CImageUtil.CreateScaledImage(null, rImage, nWidth, nHeight, CImageUtil.SCALE_OPTION.SHRINK);
            iRetImage = new ImageIcon(rScaledImage);
        }
        this.m_MediaTracker.removeImage(rImage, 1);
        return iRetImage;
    }
}

