/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.messages;

import com.rhinosoft.files.CFile;
import com.rhinosoft.images.CImageUtil;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CSUMsg;
import com.rhinosoft.messages.CTransferMsg;
import com.rhinosoft.messages.CUIMessage;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CLocalFileSystem;
import java.awt.Component;
import javax.swing.ImageIcon;

public abstract class CThumbnailMsg
extends CTransferMsg {
    private int m_nThumbWidth;
    private int m_nThumbHeight;
    private boolean m_bIsPreview;
    private ImageIcon m_rThumbImageIcon;
    private long m_lUISourceAttrID_AfterThumb;
    private AFTER_THUMB_ACTION m_nAfterThumbAction = AFTER_THUMB_ACTION.NOTHING;

    public CThumbnailMsg(String sHost, long lServerPort, boolean bIsSecure, long lHeaderPort, String sUserAgent, String sEncSessionID, long lUITransferID, boolean bSourceIsLocal, String sAbsPathSource, boolean bSourceIsDir, boolean bTargetIsLocal, int nWidth, int nHeight, boolean bIsPreview) {
        super(4238, sHost, lServerPort, bIsSecure, lHeaderPort, sUserAgent, sEncSessionID, lUITransferID, bSourceIsLocal, sAbsPathSource, bSourceIsDir, bTargetIsLocal);
        this._CThumbnailMsg(nWidth, nHeight, bIsPreview);
    }

    private void _CThumbnailMsg(int nWidth, int nHeight, boolean bIsPreview) {
        this.m_nThumbWidth = nWidth;
        this.m_nThumbHeight = nHeight;
        this.m_bIsPreview = bIsPreview;
    }

    @Override
    protected abstract int[] TransferFile(long var1);

    @Override
    public void OnMessage() {
        switch (this.GetMsgID()) {
            case 4238: {
                this.OnSendThumbnail();
                break;
            }
            default: {
                super.OnMessage();
            }
        }
    }

    protected void OnSendThumbnail() {
        CUIMessage rStatusMsg = new CUIMessage(this.GetMsgID_OnRecvTransferring(), this.GetThreadAttrID(), this.GetUISourceAttrID());
        this.PostBack(rStatusMsg);
        int nHTTPCode = -1;
        int nSUCode = -1;
        int nMsgID = 4201;
        String sAbsPathThumbFolder = CFile.GetAbsPathThumbFolder(this.GetSourcePath(), this.GetThumbCacheRootDir_Source());
        String sAbsPathThumbFile = CFile.GetAbsPathThumbFile(sAbsPathThumbFolder, this.GetThumbWidth(), this.GetThumbHeight());
        if (!this.GetCancel() && sAbsPathThumbFolder != null && sAbsPathThumbFile != null) {
            CLocalFileSystem.GetLocalFileSystem().CreateAllLocalDirs(sAbsPathThumbFolder);
            this.SetTargetPath(sAbsPathThumbFile);
            this.SetTargetIsDir(false);
            int[] anRetCodes = this.TransferFile(0L);
            if (anRetCodes != null && anRetCodes.length == 2) {
                nHTTPCode = anRetCodes[0];
                nSUCode = anRetCodes[1];
                nMsgID = anRetCodes[0] == 200 && anRetCodes[1] == 0 ? 4239 : 4201;
            }
        } else {
            if (DEBUG) {
                CDebugLog.ASSERT(CThumbnailMsg.class.getName(), CDebugLog.GetLineNumber(), "Programming error, failed to get thumbnail paths.");
            }
            nMsgID = 4201;
            nSUCode = 11009;
        }
        this.SetHTTPCode(nHTTPCode);
        this.SetSUCode(nSUCode);
        this.SetMsgID(nMsgID);
        this.PostBack(this);
    }

    public int GetThumbWidth() {
        return this.m_nThumbWidth;
    }

    public int GetThumbHeight() {
        return this.m_nThumbHeight;
    }

    @Override
    protected int GetMsgID_OnRecvTransferring() {
        return 4271;
    }

    @Override
    protected int GetMsgID_OnRecvTransfer() {
        return 4239;
    }

    @Override
    protected int[] CreateTargetDir() {
        int[] anRet = new int[]{200, -1};
        anRet[1] = this.CreateLocalDirectory(this.GetTargetPath());
        return anRet;
    }

    public boolean IsPreview() {
        return this.m_bIsPreview;
    }

    public ImageIcon GetThumbImage() {
        return this.m_rThumbImageIcon;
    }

    @Override
    public void OnError(Component rSource, Component rCenterTo) {
        if (DEBUG) {
            CDebugLog.TRACE("CThumbnailMsg.OnError - We failed to retrieve a thumbnail.");
        }
    }

    @Override
    protected String GetErrorDlgTitle() {
        String sTitle = String.format(CString.LoadString("IDS_ERROR_FMT_TITLE"), CString.LoadString("IDS_ERROR_TITLE_THUMBNAIL"));
        return sTitle;
    }

    @Override
    protected int GetErrorDlgType() {
        return 8;
    }

    @Override
    protected String GetErrorDlgMsg() {
        String sMsg = CSUMsg.GetSUError(this.GetSUCode());
        if (this.GetSourcePath() != null && this.GetTargetPath() != null) {
            sMsg = String.format("%s\r\n\r\n\"%s\"\r\n\r\n\"%s\"", sMsg, this.GetSourcePath(), this.GetTargetPath());
        }
        return sMsg;
    }

    protected void SetThumbImageIcon(ImageIcon rImageIcon) {
        this.m_rThumbImageIcon = rImageIcon;
    }

    protected void InitThumbImageIconFromCache() {
        ImageIcon rImageIcon;
        if (!this.GetCancel() && (rImageIcon = CImageUtil.GetImageFromFile(this.GetTargetPath())) != null) {
            this.SetThumbImageIcon(rImageIcon);
        }
    }

    @Override
    protected boolean CanUpdateTransferStats() {
        return false;
    }

    @Override
    public boolean SetCancel(boolean bCancel) {
        boolean bChanged = super.SetCancel(bCancel);
        return bChanged;
    }

    public void SetAfterThumbAction(AFTER_THUMB_ACTION nAfterThumbAction) {
        this.m_nAfterThumbAction = nAfterThumbAction;
    }

    public AFTER_THUMB_ACTION GetAfterThumbAction() {
        return this.m_nAfterThumbAction;
    }

    public void SetUISourceAttrID_AfterThumb(long lUISourceAttrID) {
        this.m_lUISourceAttrID_AfterThumb = lUISourceAttrID;
    }

    public long GetUISourceAttrID_AfterThumb() {
        return this.m_lUISourceAttrID_AfterThumb;
    }

    public static enum AFTER_THUMB_ACTION {
        NOTHING,
        DELETE,
        OVERWRITE;

    }
}

