/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.messages;

import com.rhinosoft.files.CFile;
import com.rhinosoft.messages.CSUMsg;

public abstract class CSUSourceMsg
extends CSUMsg {
    private boolean m_bSourceIsLocal;
    private String m_sAbsPathSource;
    private boolean m_bSourceIsDir;
    protected int[] m_anRetCodeSource;
    private CFile m_rSourceFile;

    public CSUSourceMsg(int nMsgID, String sHost, long lServerPort, boolean bIsSecure, long lHeaderPort, String sUserAgent, String sEncSessionID, long lUISourceAttrID, boolean bSourceIsLocal, String sAbsPathSource, boolean bSourceIsDir) {
        super(nMsgID, sHost, lServerPort, bIsSecure, lHeaderPort, sUserAgent, sEncSessionID, lUISourceAttrID);
        this.m_bSourceIsLocal = bSourceIsLocal;
        this.m_sAbsPathSource = sAbsPathSource;
        this.m_bSourceIsDir = bSourceIsDir;
        this.m_rSourceFile = null;
    }

    @Override
    public void Destroy() {
        this.m_anRetCodeSource = null;
        super.Destroy();
    }

    public boolean IsSourceLocal() {
        return this.m_bSourceIsLocal;
    }

    public boolean IsSourceRemote() {
        return !this.IsSourceLocal();
    }

    public String GetSourcePath() {
        return this.m_sAbsPathSource;
    }

    public void SetSourcePath(String sAbsPath) {
        this.m_sAbsPathSource = sAbsPath;
    }

    public boolean IsDirSource() {
        return this.m_bSourceIsDir;
    }

    public void SetSourceIsDir(boolean bIsDir) {
        this.m_bSourceIsDir = bIsDir;
    }

    protected CFile GetSource() {
        return this.m_rSourceFile;
    }

    public final synchronized void SetSource(CFile rFile) {
        if (this.m_rSourceFile != rFile) {
            this.m_rSourceFile = rFile;
            if (rFile != null) {
                this.SetFileTotal(rFile.GetSize());
            } else {
                this.SetFileTotal(0L);
            }
        }
    }

    public void Reset() {
        this.SetSource(null);
    }

    protected int[] GetSourceListing() {
        return this.GetListing(this.GetSourcePath(), this.IsDirSource(), this.IsSourceLocal());
    }

    public CFile GetSourceFile() {
        return this.GetSourceFile(false);
    }

    protected CFile GetSourceFileEx() {
        return this.GetSourceFile(true);
    }

    protected CFile GetSourceFile(boolean bFetchListing) {
        if (bFetchListing && this.GetSource() == null) {
            this.SetSource(null);
            this.m_anRetCodeSource = this.GetSourceListing();
            if (this.m_anRetCodeSource != null && this.m_anRetCodeSource[0] == 200 && this.m_anRetCodeSource[1] == 0) {
                this.SetSource(this.TakeListFile());
            }
        }
        return this.GetSource();
    }
}

