/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.messages;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.CConnectionAttrs;
import com.rhinosoft.attrs.CObjectAttr;
import com.rhinosoft.dialogs.CConfirmDlg;
import com.rhinosoft.dialogs.CConfirmErrorDlg;
import com.rhinosoft.files.CFile;
import com.rhinosoft.files.CLocalFile;
import com.rhinosoft.files.CRemoteFile;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CHTTPMsg;
import com.rhinosoft.messages.CTransferStatsMsg;
import com.rhinosoft.net.HTTP.SU.CSUConnection;
import com.rhinosoft.net.HTTP.SU.CTransferStatsEvent;
import com.rhinosoft.net.HTTP.SU.ITransferStatsListener;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.transfer.CTransferNode;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;

public abstract class CSUMsg
extends CHTTPMsg
implements ITransferStatsListener {
    public static final boolean DEBUG_TRACK_STATS_READ;
    public static final boolean DEBUG_TRACK_STATS_OVERALL;
    private static final boolean SEND_TRANSFER_STATS = true;
    private static HashMap<Integer, String> m_aSUErrorText;
    private static HashMap<Integer, String> m_aSUErrorDesc;
    private String m_sEncSessionID;
    private int m_nSUCode;
    private CSUConnection m_SUConnection;
    private long m_lFileRead = 0L;
    private long m_lFileTotal = 0L;
    private long m_lResumeStartIndex = 0L;
    private boolean m_bCanResume = false;
    private long m_lUISourceAttrID = -1L;
    private boolean m_bUserWantsConfirmDlg = true;
    private int m_nUserConfirmDlgResult = 1;
    private CFile m_fListFile;
    private boolean m_bShowDoNotAskAgain = false;

    public CSUMsg(int nMsgID, String sHost, long lServerPort, boolean bIsSecure, long lHeaderPort, String sUserAgent, String sEncSessionID, long lUISourceAttrID) {
        super(nMsgID, sHost, lServerPort, bIsSecure, lHeaderPort, sUserAgent);
        this._CSUMsg(sEncSessionID, lUISourceAttrID);
    }

    private void _CSUMsg(String sEncSessionID, long lUISourceAttrID) {
        this.m_sEncSessionID = sEncSessionID;
        this.m_lUISourceAttrID = lUISourceAttrID;
        this.InitSUConnection();
        if (CRhinoApp.GET_RHINO_APP() != null) {
            this.SetPostBackTo(CRhinoApp.GET_RHINO_APP());
        }
    }

    @Override
    public void Destroy() {
        if (this.m_SUConnection != null) {
            this.m_SUConnection.Destroy();
        }
        this.m_SUConnection = null;
        if (this.m_fListFile != null) {
            if (DEBUG) {
                CDebugLog.ASSERT(CSUMsg.class.getName(), CDebugLog.GetLineNumber(), "Programming error, we should never reach this.  Some other obj should have taken ownership of our member var.");
            }
            this.m_fListFile.Destroy();
        }
        this.m_fListFile = null;
        super.Destroy();
    }

    private static HashMap<Integer, String> CreateSUErrorText() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, "SESS_OKAY");
        map.put(1, "SESS_FAIL");
        map.put(2, "SESS_PENDING");
        map.put(3, "SESS_PERMISSION_DENIED");
        map.put(4, "SESS_INVALID_PARAMETER");
        map.put(5, "SESS_BAD_SEQUENCE_OF_COMMANDS");
        map.put(6, "SESS_NOT_FOUND");
        map.put(7, "SESS_PATH_IS_PORT");
        map.put(8, "SESS_LOGIN_TOO_MANY_INVALID_TRIES");
        map.put(9, "SESS_COMMAND_PENDING");
        map.put(10, "SESS_COMMAND_ABORTED");
        map.put(11, "SESS_INTERNAL_ERROR");
        map.put(12, "SESS_ALREADY_EXISTS");
        map.put(13, "SESS_FILE_IS_DIR");
        map.put(14, "SESS_DIR_IS_FILE");
        map.put(15, "SESS_CANT_REST_EMPTY_FILE");
        map.put(16, "SESS_CANT_REST_BEYOND_EOF");
        map.put(17, "SESS_CANT_SET_FILE_POS");
        map.put(18, "SESS_COMPRESSED_TRANSFER_COMPLETE");
        map.put(19, "SESS_UNAUTHORIZED_IP");
        map.put(20, "SESS_TIME_OUT");
        map.put(21, "SESS_EXCEEDED_MAX_SESSION_TIME");
        map.put(22, "SESS_TOO_MANY_SESSIONS_IP");
        map.put(23, "SESS_TOO_MANY_SESSIONS");
        map.put(24, "SESS_BLOCKED");
        map.put(25, "SESS_DATA_SOCKET_CONNECT");
        map.put(26, "SESS_DATA_SOCKET_CLOSED");
        map.put(27, "SESS_DECR_USER_QUOTA");
        map.put(28, "SESS_NO_FILES_FOUND");
        map.put(29, "SESS_LOCK_CONFLICT");
        map.put(30, "SESS_ADMIN_ABORTED");
        map.put(31, "SESS_UNAUTHORIZED");
        map.put(33, "SESS_NO_SUCH_PATH");
        map.put(34, "SESS_INVALID_PATH");
        map.put(35, "SESS_PROTOCOL_NOT_ALLOWED_FOR_USER");
        map.put(38, "SESS_REVERSE_DNS_NAME_REQUIRED_TO_LOGIN");
        map.put(100, "SESS_USER_OKAY_NEED_PWD");
        map.put(101, "SESS_USER_NOT_FOUND");
        map.put(102, "SESS_USER_OKAY_NEED_EMAIL");
        map.put(104, "SESS_USER_NEED_SECURE_CONNECTION");
        map.put(202, "SESS_PASSWORD_EXPIRED_CHANGE");
        map.put(300, "SESS_CHG_PASSWORD_NO_OLD_PASSWORD_MATCH");
        map.put(301, "SESS_CHG_PASSWORD_TOO_SHORT");
        map.put(302, "SESS_CHG_PASSWORD_NOT_COMPLEX");
        map.put(303, "SESS_CHG_PASSWORD_OLD_NEW_MATCH");
        map.put(304, "SESS_CHG_PASSWORD_CANT_CHANGE_ANONYMOUS");
        map.put(400, "SESS_XCRC_CANNOT_READ_FROM_FILE");
        map.put(601, "SESS_CANT_LOAD_GDI_PLUS");
        map.put(602, "SESS_CANT_CREATE_THUMBNAIL");
        map.put(603, "SESS_CANT_SAVE_THUMBNAIL");
        map.put(605, "SESS_CANT_WRITE");
        map.put(606, "SESS_SERVER_STOP_PENDING");
        map.put(607, "SESS_RETR_INSUFFICIENT_CREDIT");
        map.put(608, "SESS_STOR_INSUFFICIENT_DISK_QUOTA");
        map.put(609, "SESS_STOR_INSUFFICIENT_DISK_SPACE");
        map.put(610, "SESS_STOR_FILE_TOO_LARGE");
        map.put(700, "SESS_FUTURE_TIME");
        map.put(906, "SESS_LIC_NO_FVJV");
        map.put(5053, "SU_VALID_CANT_SET_ANONYMOUS_EMAIL_ADDRESS");
        map.put(5052, "SU_VALID_EMAIL_ADDRESS_EMPTY");
        map.put(5042, "SU_VALID_INVALID_EMAIL_ADDRESS");
        map.put(-6, "SESS_CANT_OPEN_LOCAL_FILE");
        map.put(-7, "SESS_TIME_OUT_WATCHDOG");
        map.put(-1, "DEFAULT_SU_RESULT_CODE");
        map.put(11000, "ERROR_NO_SUCONNECTION");
        map.put(11001, "ERROR_NO_URL_FACTORY");
        map.put(11002, "ERROR_HTTP_REQUEST_FAILED");
        map.put(11003, "ERROR_NO_INPUT_STREAM_FOR_SOCKET");
        map.put(11004, "ERROR_NO_OUTPUT_STREAM_FOR_SOCKET");
        map.put(11005, "ERROR_NO_INPUT_STREAM_FOR_FILE");
        map.put(11006, "ERROR_NO_OUTPUT_STREAM_FOR_FILE");
        map.put(11007, "ERROR_NO_RESOURCE_FILENAME");
        map.put(11008, "ERROR_NO_FILE_PATH_SERVER");
        map.put(11009, "ERROR_NO_FILE_PATH_CLIENT");
        map.put(11010, "ERROR_FAILED_TO_LIST_SOURCE_FILE");
        map.put(11011, "ERROR_FAILED_TO_LIST_TARGET_FILE");
        map.put(11012, "ERROR_NO_LOCAL_SOURCE_FILE");
        map.put(11013, "ERROR_NO_LOCAL_TARGET_FILE");
        map.put(11014, "ERROR_NO_REMOTE_SOURCE_FILE");
        map.put(11015, "ERROR_SET_MODIFIED_TIMESTAMP");
        map.put(11016, "ERROR_GET_HEADER_CONTENT_LEN");
        map.put(11017, "ERROR_GET_HEADER_XCONTENT_LEN");
        map.put(11018, "ERROR_GET_HEADER_CONTENT_TYPE");
        map.put(11019, "ERROR_GET_HEADER_LAST_MODIFIED");
        map.put(11020, "ERROR_GET_HEADER_SU_LAST_MODIFIED");
        map.put(11021, "ERROR_CANT_REST_BEYOND_EOF");
        map.put(11022, "ERROR_INVALID_FILE_SIZE");
        map.put(11023, "ERROR_NO_URL");
        map.put(11024, "ERROR_NO_PARSER");
        map.put(11025, "ERROR_NO_DELETE_FILE");
        map.put(11030, "ERROR_NPE_EXCEPTION_IN_DOWNLOAD_TO_FILE");
        map.put(11031, "ERROR_FILE_NOT_FOUND_EXCEPTION_IN_DOWNLOAD_TO_FILE");
        map.put(11032, "ERROR_NUM_FORMAT_EXCEPTION_IN_DOWNLOAD_TO_FILE");
        map.put(11033, "ERROR_ILLEGAL_ARG_EXCEPTION_IN_DOWNLOAD_TO_FILE");
        map.put(11034, "ERROR_SECURITY_EXCEPTION_IN_DOWNLOAD_TO_FILE");
        map.put(11035, "ERROR_IO_EXCEPTION_IN_DOWNLOAD_TO_FILE");
        map.put(11036, "ERROR_NPE_EXCEPTION_IN_UPLOAD_FILE");
        map.put(11037, "ERROR_IO_EXCEPTION_IN_UPLOAD_FILE");
        map.put(11038, "ERROR_IO_EXCEPTION_IN_CHG_PWORD");
        map.put(11039, "ERROR_IO_EXCEPTION_IN_CHG_EMAIL");
        return map;
    }

    private static HashMap<Integer, String> CreateSUErrorDesc() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, CString.LoadString("IDS_SU_CODE_SESS_OKAY"));
        map.put(1, CString.LoadString("IDS_SU_CODE_SESS_FAIL"));
        map.put(2, CString.LoadString("IDS_SU_CODE_SESS_PENDING"));
        map.put(3, CString.LoadString("IDS_SU_CODE_SESS_PERMISSION_DENIED"));
        map.put(4, CString.LoadString("IDS_SU_CODE_SESS_INVALID_PARAMETER"));
        map.put(5, CString.LoadString("IDS_SU_CODE_SESS_BAD_SEQUENCE_OF_COMMANDS"));
        map.put(6, CString.LoadString("IDS_SU_CODE_SESS_NOT_FOUND"));
        map.put(7, CString.LoadString("IDS_SU_CODE_SESS_PATH_IS_PORT"));
        map.put(8, CString.LoadString("IDS_SU_CODE_SESS_LOGIN_TOO_MANY_INVALID_TRIES"));
        map.put(9, CString.LoadString("IDS_SU_CODE_SESS_COMMAND_PENDING"));
        map.put(10, CString.LoadString("IDS_SU_CODE_SESS_COMMAND_ABORTED"));
        map.put(11, CString.LoadString("IDS_SU_CODE_SESS_INTERNAL_ERROR"));
        map.put(12, CString.LoadString("IDS_SU_CODE_SESS_ALREADY_EXISTS"));
        map.put(13, CString.LoadString("IDS_SU_CODE_SESS_FILE_IS_DIR"));
        map.put(14, CString.LoadString("IDS_SU_CODE_SESS_DIR_IS_FILE"));
        map.put(15, CString.LoadString("IDS_SU_CODE_SESS_CANT_REST_EMPTY_FILE"));
        map.put(16, CString.LoadString("IDS_SU_CODE_SESS_CANT_REST_BEYOND_EOF"));
        map.put(17, CString.LoadString("IDS_SU_CODE_SESS_CANT_SET_FILE_POS"));
        map.put(18, CString.LoadString("IDS_SU_CODE_SESS_COMPRESSED_TRANSFER_COMPLETE"));
        map.put(19, CString.LoadString("IDS_SU_CODE_SESS_UNAUTHORIZED_IP"));
        map.put(20, CString.LoadString("IDS_SU_CODE_SESS_TIME_OUT"));
        map.put(21, CString.LoadString("IDS_SU_CODE_SESS_EXCEEDED_MAX_SESSION_TIME"));
        map.put(22, CString.LoadString("IDS_SU_CODE_SESS_TOO_MANY_SESSIONS_IP"));
        map.put(23, CString.LoadString("IDS_SU_CODE_SESS_TOO_MANY_SESSIONS"));
        map.put(24, CString.LoadString("IDS_SU_CODE_SESS_BLOCKED"));
        map.put(25, CString.LoadString("IDS_SU_CODE_SESS_DATA_SOCKET_CONNECT"));
        map.put(26, CString.LoadString("IDS_SU_CODE_SESS_DATA_SOCKET_CLOSED"));
        map.put(27, CString.LoadString("IDS_SU_CODE_SESS_DECR_USER_QUOTA"));
        map.put(28, CString.LoadString("IDS_SU_CODE_SESS_NO_FILES_FOUND"));
        map.put(29, CString.LoadString("IDS_SU_CODE_SESS_LOCK_CONFLICT"));
        map.put(30, CString.LoadString("IDS_SU_CODE_SESS_ADMIN_ABORTED"));
        map.put(31, CString.LoadString("IDS_SU_CODE_SESS_UNAUTHORIZED"));
        map.put(33, CString.LoadString("IDS_SU_CODE_SESS_NO_SUCH_PATH"));
        map.put(34, CString.LoadString("IDS_SU_CODE_SESS_INVALID_PATH"));
        map.put(35, String.format(CString.LoadString("IDS_SU_CODE_SESS_PROTOCOL_NOT_ALLOWED_FOR_USER"), CSUMsg.GetAppName()));
        map.put(38, CString.LoadString("IDS_SU_CODE_SESS_REVERSE_DNS_NAME_REQUIRED_TO_LOGIN"));
        map.put(100, CString.LoadString("IDS_SU_CODE_SESS_USER_OKAY_NEED_PWD"));
        map.put(101, CString.LoadString("IDS_SU_CODE_SESS_USER_NOT_FOUND"));
        map.put(102, CString.LoadString("IDS_SU_CODE_SESS_USER_OKAY_NEED_EMAIL"));
        map.put(104, CString.LoadString("IDS_SU_CODE_SESS_USER_NEED_SECURE_CONNECTION"));
        map.put(300, CString.LoadString("IDS_SU_CODE_SESS_CHG_PASSWORD_NO_OLD_PASSWORD_MATCH"));
        map.put(301, CString.LoadString("IDS_SU_CODE_SESS_CHG_PASSWORD_TOO_SHORT"));
        map.put(302, CString.LoadString("IDS_SU_CODE_SESS_CHG_PASSWORD_NOT_COMPLEX"));
        map.put(303, CString.LoadString("IDS_SU_CODE_SESS_CHG_PASSWORD_OLD_NEW_MATCH"));
        map.put(304, CString.LoadString("IDS_SU_CODE_SESS_CHG_PASSWORD_CANT_CHANGE_ANONYMOUS"));
        map.put(400, CString.LoadString("IDS_SU_CODE_SESS_XCRC_CANNOT_READ_FROM_FILE"));
        map.put(601, CString.LoadString("IDS_SU_CODE_SESS_CANT_LOAD_GDI_PLUS"));
        map.put(602, CString.LoadString("IDS_SU_CODE_SESS_CANT_CREATE_THUMBNAIL"));
        map.put(603, CString.LoadString("IDS_SU_CODE_SESS_CANT_SAVE_THUMBNAIL"));
        map.put(605, CString.LoadString("IDS_SU_CODE_SESS_CANT_WRITE"));
        map.put(606, CString.LoadString("IDS_SU_CODE_SESS_SERVER_STOP_PENDING"));
        map.put(607, CString.LoadString("IDS_SU_CODE_SESS_RETR_INSUFFICIENT_CREDIT"));
        map.put(608, CString.LoadString("IDS_SU_CODE_SESS_STOR_INSUFFICIENT_DISK_QUOTA"));
        map.put(609, CString.LoadString("IDS_SU_CODE_SESS_STOR_INSUFFICIENT_DISK_SPACE"));
        map.put(610, CString.LoadString("IDS_SU_CODE_SESS_STOR_FILE_TOO_LARGE"));
        map.put(700, CString.LoadString("IDS_SU_CODE_SESS_FUTURE_TIME"));
        map.put(906, String.format(CString.LoadString("IDS_SU_CODE_SESS_LIC_NO_FVJV"), CSUMsg.GetAppName()));
        map.put(5042, CString.LoadString("IDS_SU_CODE_SU_VALID_INVALID_EMAIL_ADDRESS"));
        map.put(5052, CString.LoadString("IDS_SU_CODE_SU_VALID_EMAIL_ADDRESS_EMPTY"));
        map.put(5053, CString.LoadString("IDS_SU_CODE_SU_VALID_CANT_SET_ANONYMOUS_EMAIL_ADDRESS"));
        map.put(-6, CString.LoadString("IDS_SU_CODE_SESS_CANT_OPEN_LOCAL_FILE"));
        map.put(-7, CString.LoadString("IDS_SU_CODE_SESS_TIME_OUT"));
        map.put(-1, CString.LoadString("IDS_ERR_CODE_DEFAULT_SU_RESULT_CODE"));
        map.put(11000, CString.LoadString("IDS_ERR_ERROR_NO_SUCONNECTION"));
        map.put(11001, CString.LoadString("IDS_ERR_ERROR_NO_URL_FACTORY"));
        map.put(11002, CString.LoadString("IDS_ERR_ERROR_HTTP_REQUEST_FAILED"));
        map.put(11003, CString.LoadString("IDS_ERR_ERROR_NO_INPUT_STREAM_FOR_SOCKET"));
        map.put(11004, CString.LoadString("IDS_ERR_ERROR_NO_OUTPUT_STREAM_FOR_SOCKET"));
        map.put(11005, CString.LoadString("IDS_ERR_ERROR_NO_INPUT_STREAM_FOR_FILE"));
        map.put(11006, CString.LoadString("IDS_ERR_ERROR_NO_OUTPUT_STREAM_FOR_FILE"));
        map.put(11007, CString.LoadString("IDS_ERR_ERROR_NO_RESOURCE_FILENAME"));
        map.put(11008, CString.LoadString("IDS_ERR_ERROR_NO_FILE_PATH_SERVER"));
        map.put(11009, CString.LoadString("IDS_ERR_ERROR_NO_FILE_PATH_CLIENT"));
        map.put(11010, CString.LoadString("IDS_ERR_ERROR_FAILED_TO_LIST_SOURCE_FILE"));
        map.put(11011, CString.LoadString("IDS_ERR_ERROR_FAILED_TO_LIST_TARGET_FILE"));
        map.put(11012, CString.LoadString("IDS_ERR_ERROR_NO_LOCAL_SOURCE_FILE"));
        map.put(11013, CString.LoadString("IDS_ERR_ERROR_NO_LOCAL_TARGET_FILE"));
        map.put(11014, CString.LoadString("IDS_ERR_ERROR_NO_REMOTE_SOURCE_FILE"));
        map.put(11015, CString.LoadString("IDS_ERR_ERROR_SET_MODIFIED_TIMESTAMP"));
        map.put(11016, CString.LoadString("IDS_ERR_ERROR_GET_HEADER_CONTENT_LEN"));
        map.put(11017, CString.LoadString("IDS_ERR_ERROR_GET_HEADER_XCONTENT_LEN"));
        map.put(11018, CString.LoadString("IDS_ERR_ERROR_GET_HEADER_CONTENT_TYPE"));
        map.put(11019, CString.LoadString("IDS_ERR_ERROR_GET_HEADER_LAST_MODIFIED"));
        map.put(11020, CString.LoadString("IDS_ERR_ERROR_GET_HEADER_SU_LAST_MODIFIED"));
        map.put(11021, CString.LoadString("IDS_ERR_ERROR_CANT_REST_BEYOND_EOF"));
        map.put(11022, CString.LoadString("IDS_ERR_ERROR_INVALID_FILE_SIZE"));
        map.put(11023, CString.LoadString("IDS_ERR_ERROR_NO_URL"));
        map.put(11024, CString.LoadString("IDS_ERR_ERROR_NO_PARSER"));
        map.put(11025, CString.LoadString("IDS_ERR_ERROR_NO_DELETE_FILE"));
        map.put(11030, CString.LoadString("IDS_ERR_ERROR_NPE_EXCEPTION_IN_DOWNLOAD_TO_FILE"));
        map.put(11031, CString.LoadString("IDS_ERR_ERROR_FILE_NOT_FOUND_EXCEPTION_IN_DOWNLOAD_TO_FILE"));
        map.put(11032, CString.LoadString("IDS_ERR_ERROR_NUM_FORMAT_EXCEPTION_IN_DOWNLOAD_TO_FILE"));
        map.put(11033, CString.LoadString("IDS_ERR_ERROR_ILLEGAL_ARG_EXCEPTION_IN_DOWNLOAD_TO_FILE"));
        map.put(11034, CString.LoadString("IDS_ERR_ERROR_SECURITY_EXCEPTION_IN_DOWNLOAD_TO_FILE"));
        map.put(11035, CString.LoadString("IDS_ERR_ERROR_IO_EXCEPTION_IN_DOWNLOAD_TO_FILE"));
        map.put(11036, CString.LoadString("IDS_ERR_ERROR_NPE_EXCEPTION_IN_UPLOAD_FILE"));
        map.put(11037, CString.LoadString("IDS_ERR_ERROR_IO_EXCEPTION_IN_UPLOAD_FILE"));
        map.put(11038, CString.LoadString("IDS_ERR_ERROR_IO_EXCEPTION_IN_CHG_PWORD"));
        map.put(11039, CString.LoadString("IDS_ERR_ERROR_IO_EXCEPTION_IN_CHG_EMAIL"));
        return map;
    }

    public static String GetAppName() {
        String sAppName = "Unknown";
        if (CRhinoApp.GET_RHINO_APP() != null) {
            sAppName = CRhinoApp.GET_RHINO_APP().GetAppName();
        }
        return sAppName;
    }

    public static String GetSUErrorText(int nSUCode) {
        String sItem;
        String sError = "SESS_UNKNOWN";
        if (m_aSUErrorText != null && (sItem = m_aSUErrorText.get(nSUCode)) != null && !sItem.isEmpty()) {
            sError = sItem;
        }
        return sError;
    }

    public static String GetSUError(int nSUCode) {
        String sItem;
        String sError = CString.LoadString("IDS_SU_CODE_SESS_FAIL");
        if (m_aSUErrorDesc != null && (sItem = m_aSUErrorDesc.get(nSUCode)) != null && !sItem.isEmpty()) {
            sError = sItem;
        }
        return sError;
    }

    public static String FormatSUTextError(int nSUCode) {
        String sSUError = "";
        String sError = CSUMsg.GetSUErrorText(nSUCode);
        sSUError = sError != null && !sError.isEmpty() ? String.format("%s (%d)", sError, nSUCode) : String.format("%d", nSUCode);
        return sSUError;
    }

    public static String FormatErrorMsg(int nHTTPCode, int nSUCode) {
        String sHTTPError = CHTTPMsg.FormatHTTPTextError(nHTTPCode);
        String sSUError = CSUMsg.FormatSUTextError(nSUCode);
        String sError = CSUMsg.GetSUError(nSUCode);
        String sErrorMsg = String.format(CString.LoadString("IDS_HTTP_ERROR_SU_RESULT"), sHTTPError, sSUError, sError);
        return sErrorMsg;
    }

    protected void SetSUConnection(CSUConnection rSUConnection) {
        if (this.m_SUConnection != rSUConnection) {
            CSUConnection rPrevConn = this.m_SUConnection;
            this.m_SUConnection = rSUConnection;
            if (this.m_SUConnection != null) {
                this.m_SUConnection.AddTransferStatsListener(this);
            }
            if (rPrevConn != null) {
                rPrevConn.RemoveTransferStatsListener(this);
                rPrevConn.Destroy();
            }
        }
    }

    public void RemoveSUConnection() {
        this.SetSUConnection(null);
    }

    protected void InitSUConnection() {
        if (this.GetSUConnection() != null) {
            this.SetSUConnection(null);
        }
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CConnectionAttrs rConnInfo = CRhinoApp.GET_RHINO_APP().GetConnectionAttrs();
            CSUConnection pConnection = CRhinoApp.GET_RHINO_APP().CreateSUConnection(this.GetUserAgent(), rConnInfo, 0);
            this.SetSUConnection(pConnection);
        }
    }

    protected final CSUConnection GetSUConnection() {
        return this.m_SUConnection;
    }

    public final String GetEncSessionID() {
        return this.m_sEncSessionID;
    }

    public void SetEncSessionID(String sEncSessionID) {
        this.m_sEncSessionID = sEncSessionID;
    }

    public void SetSUCode(int nSUCode) {
        this.m_nSUCode = nSUCode;
    }

    public int GetSUCode() {
        return this.m_nSUCode;
    }

    @Override
    public void OnMessage() {
        if (DEBUG && this.GetOriginalMsgID() != this.GetMsgID() && this.GetSUCode() != 0) {
            String sDetails = CSUMsg.FormatErrorMsg(this.GetHTTPCode(), this.GetSUCode());
            CDebugLog.INFO(sDetails);
        }
        super.OnMessage();
    }

    protected String GetErrorDlgTitle() {
        return CString.LoadString("IDS_ERROR_TITLE");
    }

    protected int GetErrorDlgType() {
        return 7;
    }

    protected String GetErrorDlgMsg() {
        return CSUMsg.GetSUError(this.GetSUCode());
    }

    protected String GetErrorDlgDetails() {
        return CSUMsg.FormatErrorMsg(this.GetHTTPCode(), this.GetSUCode());
    }

    protected CConfirmErrorDlg CreateErrorDlg(Component rOwner) {
        CConfirmErrorDlg dlg = new CConfirmErrorDlg(CRhinoApp.GetParentWindow(rOwner), this, this.GetErrorDlgTitle(), this.GetErrorDlgType(), this.GetErrorDlgMsg(), this.GetErrorDlgDetails(), this.GetConfirmErrorOnCloseAttr());
        dlg.SetVisible_DoNotAskAgain(false);
        return dlg;
    }

    @Override
    public void OnError(Component rSource, Component rCenterTo) {
        if (!this.GetCancel()) {
            CConfirmErrorDlg dlg = this.CreateErrorDlg(rCenterTo);
            if (CRhinoApp.GET_RHINO_APP() != null) {
                CRhinoApp.GET_RHINO_APP().PostAddDialogToQueue(rSource, dlg);
            }
        } else if (DEBUG) {
            CDebugLog.TRACE("CTransferMsg.OnError - Don't display confirmation b/c the message was cancelled!");
        }
    }

    @Override
    public void OnUpdateTransferStats(CTransferStatsEvent event) {
        this.SetFileRead(event.GetReadPos());
        if (this.GetFileTotal() != event.GetReadMax() && DEBUG_TRACK_STATS_READ) {
            CDebugLog.ASSERT(CSUMsg.class.getName(), CDebugLog.GetLineNumber(), "Transferred data doesn't match the size of the listed file!");
        }
        this.SetFileTotal(event.GetReadMax());
        if (DEBUG_TRACK_STATS_READ) {
            System.out.printf("File Read: %d | File Total: %d\r\n", this.GetFileRead(), this.GetFileTotal());
        }
        this.PostBackTransferStats(event);
    }

    private void PostBackTransferStats(CTransferStatsEvent event) {
        if (this.CanUpdateTransferStats()) {
            CAttr rAttr;
            boolean bNotifyDirect = false;
            bNotifyDirect = true;
            if (bNotifyDirect && (rAttr = CAttr.FindGlobalAttr(this.GetUISourceAttrID())) != null) {
                if (rAttr instanceof CObjectAttr) {
                    CObjectAttr rObjAttr = (CObjectAttr)rAttr;
                    if (rObjAttr != null) {
                        Object rObj = rObjAttr.GetObject();
                        if (rObj instanceof CTransferNode) {
                            CTransferNode rNode = (CTransferNode)rObj;
                            if (rNode != null) {
                                CTransferStatsMsg rMsg = new CTransferStatsMsg(this.GetThreadAttrID(), this.GetUISourceAttrID(), event);
                                if (rNode.GetModel() != null) {
                                    rNode.GetModel().OnMessage(rMsg);
                                }
                            }
                        } else {
                            bNotifyDirect = false;
                        }
                    }
                } else {
                    bNotifyDirect = false;
                }
            }
            if (!bNotifyDirect) {
                CTransferStatsMsg rMsg = new CTransferStatsMsg(this.GetThreadAttrID(), this.GetUISourceAttrID(), event);
                this.PostBack(rMsg);
            }
        }
    }

    public boolean SetFileRead(long lNumOfBytes) {
        boolean bChanged = false;
        if (this.m_lFileRead != lNumOfBytes) {
            this.m_lFileRead = lNumOfBytes;
            bChanged = true;
        }
        return bChanged;
    }

    public long GetFileRead() {
        return this.m_lFileRead;
    }

    public boolean SetFileTotal(long lNumOfBytes) {
        boolean bChanged = false;
        if (this.m_lFileTotal != lNumOfBytes) {
            this.m_lFileTotal = lNumOfBytes;
            bChanged = true;
        }
        return bChanged;
    }

    public long GetFileTotal() {
        return this.m_lFileTotal;
    }

    public boolean SetResumeStartIndex(long lIndex) {
        boolean bChanged = false;
        if (this.m_lResumeStartIndex != lIndex) {
            this.m_lResumeStartIndex = lIndex;
            bChanged = true;
        }
        return bChanged;
    }

    public long GetResumeStartIndex() {
        return this.m_lResumeStartIndex;
    }

    public long GetUISourceAttrID() {
        return this.m_lUISourceAttrID;
    }

    public void SetUISourceAttrID(long lUISourceAttrID) {
        this.m_lUISourceAttrID = lUISourceAttrID;
    }

    @Override
    public boolean SetCancel(boolean bCancel) {
        boolean bChanged = super.SetCancel(bCancel);
        if (this.GetSUConnection() != null) {
            this.GetSUConnection().SetCancel(bCancel);
        }
        return bChanged;
    }

    public void SetUserWantsConfirmDlg(boolean bUserWantsConfirmDlg) {
        this.m_bUserWantsConfirmDlg = bUserWantsConfirmDlg;
    }

    public boolean GetUserWantsConfirmDlg() {
        return this.m_bUserWantsConfirmDlg;
    }

    public void SetUserConfirmDlgResult(int nDlgResult) {
        this.m_nUserConfirmDlgResult = nDlgResult;
    }

    public int GetUserConfirmDlgResult() {
        return this.m_nUserConfirmDlgResult;
    }

    protected void SetCanResume(boolean bCanResume) {
        this.m_bCanResume = bCanResume;
    }

    public boolean GetCanResume() {
        return this.m_bCanResume;
    }

    protected final int[] GetListing(String sAbsPath, boolean bIsDir, boolean bIsLocal) {
        int[] anRet = null;
        anRet = bIsLocal ? this.GetListingLocal(sAbsPath, bIsDir) : this.GetListingRemote(sAbsPath, bIsDir);
        if (anRet == null && DEBUG) {
            CDebugLog.EXCEPTION(CSUMsg.class.getName(), CDebugLog.GetLineNumber(), "Programming error, the array is null!", true);
        }
        return anRet;
    }

    private int[] GetListingLocal(String sAbsPath, boolean bIsDir) {
        int[] anRet = new int[]{200, -1};
        if (sAbsPath != null) {
            File fFile = new File(sAbsPath);
            if (fFile != null) {
                boolean bExists = fFile.exists();
                if (!bExists) {
                    // empty if block
                }
                if (bExists) {
                    File[] afFiles;
                    CLocalFile fLocalFile = new CLocalFile(fFile);
                    this.SetListFile(fLocalFile);
                    anRet[1] = 0;
                    if (fFile.isDirectory() && (afFiles = fFile.listFiles()) != null) {
                        for (int nIdx = 0; nIdx < afFiles.length; ++nIdx) {
                            CLocalFile fChild = new CLocalFile(afFiles[nIdx]);
                            fLocalFile.AddFile(fChild);
                        }
                    }
                } else {
                    anRet[1] = 6;
                }
            } else {
                anRet[1] = 11009;
            }
        } else {
            anRet[1] = 11009;
        }
        return anRet;
    }

    private int[] GetListingRemote(String sAbsPath, boolean bIsDir) {
        int[] anRet = null;
        if (sAbsPath != null) {
            if (this.GetSUConnection() != null) {
                if (bIsDir) {
                    anRet = this.GetSUConnection().SendListDir(sAbsPath);
                    if (anRet != null && anRet[0] == 200 && anRet[1] == 0) {
                        this.SetListFile(this.GetSUConnection().TakeListDir());
                    }
                } else {
                    anRet = this.GetSUConnection().SendListFile(sAbsPath);
                    if (anRet != null && anRet[0] == 200 && anRet[1] == 0) {
                        CRemoteFile fParent = this.GetSUConnection().TakeListDir();
                        if (fParent != null) {
                            CFile rChild = fParent.GetFile(0);
                            if (fParent.GetNumOfChildFiles() == 1 && rChild != null) {
                                CFile pCopyOf = null;
                                if (rChild instanceof CLocalFile) {
                                    pCopyOf = new CLocalFile(null);
                                } else if (rChild instanceof CRemoteFile) {
                                    pCopyOf = new CRemoteFile(rChild.GetAbsPath(), rChild.IsDirectory());
                                }
                                if (pCopyOf != null) {
                                    ((CFile)pCopyOf).Copy(rChild);
                                    this.SetListFile(pCopyOf);
                                }
                            } else {
                                anRet[1] = 6;
                            }
                        }
                        fParent.Destroy();
                        fParent = null;
                    }
                }
            } else {
                anRet = new int[]{-1, 11000};
            }
        } else {
            anRet = new int[]{-1, 11008};
        }
        return anRet;
    }

    protected void SetListFile(CFile fListFile) {
        this.m_fListFile = fListFile;
    }

    protected CFile TakeListFile() {
        CFile fListFile = this.m_fListFile;
        this.m_fListFile = null;
        return fListFile;
    }

    protected final int[] Delete(String sAbsPath, boolean bIsDir, boolean bIsLocal) {
        int[] anRetCodes = null;
        anRetCodes = bIsLocal ? (bIsDir ? this.DeleteLocalDir(sAbsPath) : this.DeleteLocalFile(sAbsPath)) : (bIsDir ? this.DeleteRemoteDir(sAbsPath) : this.DeleteRemoteFile(sAbsPath));
        if (anRetCodes == null && DEBUG) {
            CDebugLog.EXCEPTION(CSUMsg.class.getName(), CDebugLog.GetLineNumber(), "Programming error, our return cannot be null!", true);
        }
        return anRetCodes;
    }

    private int[] DeleteLocalDir(String sAbsPath) {
        int[] anRetCodes = new int[]{200, -1};
        if (sAbsPath != null && !sAbsPath.isEmpty()) {
            File fFile = new File(sAbsPath);
            anRetCodes[1] = fFile != null && fFile.exists() ? (fFile.isDirectory() ? (CLocalFileSystem.GetLocalFileSystem().Delete(new File(sAbsPath)) ? 0 : 1) : 14) : 6;
        } else {
            if (DEBUG) {
                CDebugLog.ASSERT(CSUMsg.class.getName(), CDebugLog.GetLineNumber(), "Programming error, the path is invalid.");
            }
            anRetCodes[1] = 11009;
        }
        return anRetCodes;
    }

    private int[] DeleteLocalFile(String sAbsPath) {
        int[] anRetCodes = new int[]{200, -1};
        if (sAbsPath != null && !sAbsPath.isEmpty()) {
            File fFile = new File(sAbsPath);
            anRetCodes[1] = fFile != null && fFile.exists() ? (!fFile.isDirectory() ? (CLocalFileSystem.GetLocalFileSystem().Delete(new File(sAbsPath)) ? 0 : 1) : 13) : 6;
        } else {
            if (DEBUG) {
                CDebugLog.ASSERT(CSUMsg.class.getName(), CDebugLog.GetLineNumber(), "Programming error, the path is invalid.");
            }
            anRetCodes[1] = 11009;
        }
        return anRetCodes;
    }

    private int[] DeleteRemoteDir(String sAbsPath) {
        int[] anRetCodes = new int[]{-1, -1};
        if (sAbsPath != null && !sAbsPath.isEmpty()) {
            if (this.GetSUConnection() != null) {
                anRetCodes = this.GetSUConnection().SendDeleteDir(sAbsPath);
            } else {
                anRetCodes[1] = 11000;
            }
        } else {
            if (DEBUG) {
                CDebugLog.ASSERT(CSUMsg.class.getName(), CDebugLog.GetLineNumber(), "Programming error, sAbsPath is null.");
            }
            anRetCodes[1] = 11008;
        }
        return anRetCodes;
    }

    private int[] DeleteRemoteFile(String sAbsPath) {
        int[] anRetCodes = new int[]{-1, -1};
        if (sAbsPath != null && !sAbsPath.isEmpty()) {
            if (this.GetSUConnection() != null) {
                anRetCodes = this.GetSUConnection().SendDeleteFile(sAbsPath);
            } else {
                anRetCodes[1] = 11000;
            }
        } else {
            if (DEBUG) {
                CDebugLog.ASSERT(CSUMsg.class.getName(), CDebugLog.GetLineNumber(), "Programming error, sAbsPath is null.");
            }
            anRetCodes[1] = 11008;
        }
        return anRetCodes;
    }

    public boolean GetShowDoNotAskAgainBtn() {
        return this.m_bShowDoNotAskAgain;
    }

    public void SetVisible_DoNotAskAgain(boolean bShowDoNotAskAgain) {
        this.m_bShowDoNotAskAgain = bShowDoNotAskAgain;
    }

    public CConfirmDlg.TYPE GetConfirmDlgType() {
        CConfirmDlg.TYPE nType = CConfirmDlg.TYPE.UNKNOWN;
        if (this.GetMsgID() == 4201) {
            nType = CConfirmDlg.TYPE.ERROR;
        }
        return nType;
    }

    protected boolean CanUpdateTransferStats() {
        return false;
    }

    @Override
    public boolean IsWatchDogExpired() {
        boolean bWatchDogExpired = false;
        if (this.GetSUConnection() != null) {
            bWatchDogExpired = this.GetSUConnection().IsWatchDogExpired();
        }
        return bWatchDogExpired;
    }

    @Override
    public void OnTriggeredWatchDog() {
        if (this.GetSUConnection() != null) {
            this.GetSUConnection().OnTriggeredWatchDog();
        }
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_STATS_READ = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_STATS_OVERALL = false;
        m_aSUErrorText = CSUMsg.CreateSUErrorText();
        m_aSUErrorDesc = CSUMsg.CreateSUErrorDesc();
    }
}

