/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.messages;

import com.rhinosoft.attrs.CBoolAttr;
import com.rhinosoft.dialogs.CConfirmErrorDlg;
import com.rhinosoft.messages.CSUMsg;
import com.rhinosoft.net.HTTP.SU.CNoop;
import com.rhinosoft.strings.CString;
import com.rhinosoft.ui.CRhinoApp;
import java.awt.Component;

public class CNoopMsg
extends CSUMsg {
    private int m_nConfirmResult;
    private boolean m_bCheckingCommunication;

    public CNoopMsg(String sHost, long lServerPort, boolean bIsSecure, long lHeaderPort, String sUserAgent, String sEncSessionID, long lUISourceAttrID, boolean bCheckingCommunication, CBoolAttr rbConfirmError, CBoolAttr rbConfirmOnCloseError) {
        super(4220, sHost, lServerPort, bIsSecure, lHeaderPort, sUserAgent, sEncSessionID, lUISourceAttrID);
        this._CNoopMsg(bCheckingCommunication, rbConfirmError, rbConfirmOnCloseError);
    }

    private void _CNoopMsg(boolean bCheckingCommunication, CBoolAttr rbConfirmError, CBoolAttr rbConfirmOnCloseError) {
        this.m_bCheckingCommunication = bCheckingCommunication;
        this.SetConfirmError(rbConfirmError);
        this.SetConfirmErrorOnClose(rbConfirmOnCloseError);
    }

    @Override
    public void OnMessage() {
        if (this.GetMsgID() == 4220) {
            this.OnSendNoop();
        } else {
            super.OnMessage();
        }
    }

    protected void OnProcessNoopData(CNoop rNoop) {
    }

    protected void OnSendNoop() {
        this.SetHTTPCode(-1);
        this.SetSUCode(-1);
        if (this.GetSUConnection() != null) {
            CNoop[] arNoop = new CNoop[1];
            int[] anRetCodes = this.GetSUConnection().SendNoop(arNoop);
            this.OnProcessNoopData(arNoop[0]);
            if (anRetCodes != null && anRetCodes.length == 2) {
                this.SetHTTPCode(anRetCodes[0]);
                this.SetSUCode(anRetCodes[1]);
            }
        } else {
            this.SetSUCode(11000);
        }
        this.SetMsgID(4260);
        this.PostBack(this);
    }

    protected CConfirmErrorDlg CreateErrorDlg(Component rCenterTo, String sTitle, String sMsg, String sDetails) {
        return new CConfirmErrorDlg(CRhinoApp.GetParentWindow(rCenterTo), this, sTitle, 7, sMsg, sDetails, this.GetConfirmErrorOnCloseAttr());
    }

    @Override
    public void OnError(Component rSource, Component rCenterTo) {
        if (this.GetConfirmError()) {
            String sTitle = CString.LoadString("IDS_ERROR_FMT_TITLE");
            sTitle = String.format(sTitle, CString.LoadString("IDS_ERROR_TITLE_NOOP"));
            String sMsg = CSUMsg.GetSUError(this.GetSUCode());
            String sDetails = CSUMsg.FormatErrorMsg(this.GetHTTPCode(), this.GetSUCode());
            CConfirmErrorDlg dlg = this.CreateErrorDlg(rCenterTo, sTitle, sMsg, sDetails);
            dlg.SetVisible_DoNotAskAgain(true);
            dlg.setVisible(true);
            if (this.GetConfirmErrorAttr() != null) {
                this.GetConfirmErrorAttr().SetValue(!dlg.GetDoNotShowAgain());
            }
            this.m_nConfirmResult = dlg.GetResult();
            switch (this.m_nConfirmResult) {
                case 0: {
                    this.SetMsgID(4244);
                    this.PostBack(this);
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
        }
    }

    public int GetConfirmResult() {
        return this.m_nConfirmResult;
    }

    public boolean SetCheckingCommunication(boolean bCheckingCommunication) {
        boolean bChanged = false;
        if (this.m_bCheckingCommunication != bCheckingCommunication) {
            this.m_bCheckingCommunication = bCheckingCommunication;
            bChanged = true;
        }
        return bChanged;
    }

    public boolean IsCheckingCommunication() {
        return this.m_bCheckingCommunication;
    }
}

