/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.messages;

import com.rhinosoft.messages.CSocketMsg;
import com.rhinosoft.strings.CString;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class CHTTPMsg
extends CSocketMsg {
    private long m_lHeaderPort;
    private String m_sUserAgent;
    private static HashMap<Integer, String> m_aHTTPErrorText = CHTTPMsg.CreateHTTPErrorText();

    public CHTTPMsg(int nMsgID, String sHost, long lServerPort, boolean bIsSecure, long lHeaderPort, String sUserAgent) {
        super(nMsgID, sHost, lServerPort, bIsSecure);
        this._CHTTPMsg(lHeaderPort, sUserAgent);
    }

    private void _CHTTPMsg(long lHeaderPort, String sUserAgent) {
        this.m_lHeaderPort = lHeaderPort;
        this.m_sUserAgent = sUserAgent;
    }

    private static HashMap<Integer, String> CreateHTTPErrorText() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(200, CString.LoadString("IDS_HTTP_CODE_OK"));
        map.put(201, CString.LoadString("IDS_HTTP_CODE_CREATED"));
        map.put(202, CString.LoadString("IDS_HTTP_CODE_ACCEPTED"));
        map.put(203, CString.LoadString("IDS_HTTP_CODE_NOT_AUTHORITATIVE"));
        map.put(204, CString.LoadString("IDS_HTTP_CODE_NO_CONTENT"));
        map.put(205, CString.LoadString("IDS_HTTP_CODE_RESET"));
        map.put(206, CString.LoadString("IDS_HTTP_CODE_PARTIAL"));
        map.put(300, CString.LoadString("IDS_HTTP_CODE_MULT_CHOICE"));
        map.put(301, CString.LoadString("IDS_HTTP_CODE_MOVED_PERM"));
        map.put(302, CString.LoadString("IDS_HTTP_CODE_MOVED_TEMP"));
        map.put(303, CString.LoadString("IDS_HTTP_CODE_SEE_OTHER"));
        map.put(304, CString.LoadString("IDS_HTTP_CODE_NOT_MODIFIED"));
        map.put(305, CString.LoadString("IDS_HTTP_CODE_USE_PROXY"));
        map.put(307, CString.LoadString("IDS_HTTP_CODE_TEMP_REDIR"));
        map.put(400, CString.LoadString("IDS_HTTP_CODE_BAD_REQUEST"));
        map.put(401, CString.LoadString("IDS_HTTP_CODE_UNAUTHORIZED"));
        map.put(402, CString.LoadString("IDS_HTTP_CODE_PAYMENT_REQUIRED"));
        map.put(403, CString.LoadString("IDS_HTTP_CODE_FORBIDDEN"));
        map.put(404, CString.LoadString("IDS_HTTP_CODE_NOT_FOUND"));
        map.put(405, CString.LoadString("IDS_HTTP_CODE_BAD_METHOD"));
        map.put(406, CString.LoadString("IDS_HTTP_CODE_NOT_ACCEPTABLE"));
        map.put(407, CString.LoadString("IDS_HTTP_CODE_PROXY_AUTH"));
        map.put(408, CString.LoadString("IDS_HTTP_CODE_CLIENT_TIMEOUT"));
        map.put(409, CString.LoadString("IDS_HTTP_CODE_CONFLICT"));
        map.put(410, CString.LoadString("IDS_HTTP_CODE_GONE"));
        map.put(411, CString.LoadString("IDS_HTTP_CODE_LENGTH_REQUIRED"));
        map.put(412, CString.LoadString("IDS_HTTP_CODE_PRECON_FAILED"));
        map.put(413, CString.LoadString("IDS_HTTP_CODE_ENTITY_TOO_LARGE"));
        map.put(414, CString.LoadString("IDS_HTTP_CODE_REQ_TOO_LONG"));
        map.put(415, CString.LoadString("IDS_HTTP_CODE_UNSUPPORTED_TYPE"));
        map.put(500, CString.LoadString("IDS_HTTP_CODE_INTERNAL_ERROR"));
        map.put(501, CString.LoadString("IDS_HTTP_CODE_NOT_IMPLEMENTED"));
        map.put(502, CString.LoadString("IDS_HTTP_CODE_BAD_GATEWAY"));
        map.put(503, CString.LoadString("IDS_HTTP_CODE_UNAVAILABLE"));
        map.put(504, CString.LoadString("IDS_HTTP_CODE_GATEWAY_TIMEOUT"));
        map.put(505, CString.LoadString("IDS_HTTP_CODE_VERSION"));
        map.put(-1, CString.LoadString("IDS_ERR_CODE_DEFAULT_HTTP_RESPONSE_CODE"));
        return map;
    }

    public static String FormatHTTPTextError(int nHTTPCode) {
        String sHTTPError = "";
        String sError = CHTTPMsg.GetHTTPError(nHTTPCode);
        sHTTPError = sError != null && !sError.isEmpty() ? String.format("%s (%d)", sError, nHTTPCode) : String.format("%d", nHTTPCode);
        return sHTTPError;
    }

    public static String GetHTTPError(int nHTTPCode) {
        String sItem;
        String sError = CString.LoadString("IDS_HTTP_CODE_UNAVAILABLE");
        if (m_aHTTPErrorText != null && (sItem = m_aHTTPErrorText.get(nHTTPCode)) != null && !sItem.isEmpty()) {
            sError = sItem;
        }
        return sError;
    }

    public final long GetHeaderPort() {
        return this.m_lHeaderPort;
    }

    public void SetHeaderPort(long lHeaderPort) {
        this.m_lHeaderPort = lHeaderPort;
    }

    public final String GetUserAgent() {
        return this.m_sUserAgent;
    }

    public void SetUserAgent(String sUserAgent) {
        this.m_sUserAgent = sUserAgent;
    }

    @Override
    public void OnMessage() {
        if (DEBUG && this.GetOriginalMsgID() != this.GetMsgID() && this.GetHTTPCode() != 200) {
            String sDetails = CHTTPMsg.FormatHTTPTextError(this.GetHTTPCode());
            System.out.println(sDetails);
        }
        super.OnMessage();
    }

    @Override
    public void OnError(Component rSource, Component rCenterTo) {
        String sDetails = CHTTPMsg.FormatHTTPTextError(this.GetHTTPCode());
        if (DEBUG) {
            JOptionPane.showMessageDialog(rCenterTo, "HTTP Error", sDetails, 0);
        }
    }

    public int GetHTTPCode() {
        return this.GetSocketResponseCode();
    }

    public void SetHTTPCode(int nHttpResponseCode) {
        this.SetSocketResponseCode(nHttpResponseCode);
    }
}

