/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.messages;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.CDateAttr;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CCacheMsg;
import com.rhinosoft.messages.CSUMsg;
import com.rhinosoft.net.HTTP.CHTTPConnection;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CLocalFileSystem;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;

public class CDownloadResourceMsg
extends CSUMsg {
    public static boolean DEBUG = CAttr.DEBUG;
    public static boolean DEBUG_PRINT_PATHS;
    public static boolean DEBUG_NOTIFY_IF_MODIFIED;
    public static JTextPane DEBUG_TEXT_PANE;
    private String m_sFileName;
    private String m_sClientDirPath;
    private String m_sServerDirPath;
    private Object m_rUISource;

    public CDownloadResourceMsg(String sHost, long lServerPort, boolean bIsSecure, long lHeaderPort, String sUserAgent, long lUISourceAttrID, String sFileName, String sClientDirPath, String sServerDirPath, Object rUISource) {
        super(4230, sHost, lServerPort, bIsSecure, lHeaderPort, sUserAgent, null, lUISourceAttrID);
        this.InitVars(sFileName, sClientDirPath, sServerDirPath, rUISource);
    }

    protected CDownloadResourceMsg(int nMsgID, String sHost, long lServerPort, boolean bIsSecure, long lHeaderPort, String sUserAgent, long lUISourceAttrID, String sFileName, String sClientDirPath, String sServerDirPath, Object rUISource) {
        super(nMsgID, sHost, lServerPort, bIsSecure, lHeaderPort, sUserAgent, null, lUISourceAttrID);
        this.InitVars(sFileName, sClientDirPath, sServerDirPath, rUISource);
    }

    private void InitVars(String sFileName, String sClientDirPath, String sServerDirPath, Object rUISource) {
        this.m_sFileName = sFileName;
        this.m_sClientDirPath = sClientDirPath;
        this.m_sServerDirPath = sServerDirPath;
        this.m_rUISource = rUISource;
    }

    protected void SetServerDirPath(String sServerDirPath) {
        this.m_sServerDirPath = sServerDirPath;
    }

    public String GetServerDirPath() {
        return this.m_sServerDirPath;
    }

    protected void SetClientDirPath(String sClientDirPath) {
        this.m_sClientDirPath = sClientDirPath;
    }

    public String GetClientDirPath() {
        return this.m_sClientDirPath;
    }

    public String GetFileName() {
        return this.m_sFileName;
    }

    public String GetClientAbsPath() {
        String sClientDirPath;
        String sAbsPath = null;
        String sFileName = this.GetFileName();
        if (sFileName != null && (sClientDirPath = this.GetClientDirPath()) != null && !sClientDirPath.isEmpty()) {
            sClientDirPath = CString.EnsureLastCharIsAFileSeparator(sClientDirPath);
            sAbsPath = sClientDirPath = sClientDirPath + sFileName;
        }
        return sAbsPath;
    }

    public String GetServerAbsPath() {
        String sServerDirPath;
        String sAbsPath = null;
        String sFileName = this.GetFileName();
        if (sFileName != null && (sServerDirPath = this.GetServerDirPath()) != null && !sServerDirPath.isEmpty()) {
            sServerDirPath = CString.EnsureLastCharIsAForwardSlash(sServerDirPath);
            sAbsPath = sServerDirPath = sServerDirPath + sFileName;
        }
        return sAbsPath;
    }

    @Override
    public void OnMessage() {
        if (this.GetMsgID() == this.GetSendMsgID()) {
            this.DownloadResource();
        } else {
            super.OnMessage();
        }
    }

    protected void DownloadResource() {
        this.SetHTTPCode(-1);
        this.SetSUCode(-1);
        this.SetMsgID(4201);
        String sFileName = this.GetFileName();
        if (sFileName != null) {
            String sServerDirPath = this.GetServerAbsPath();
            if (sServerDirPath != null && !sServerDirPath.isEmpty()) {
                String sClientDirPath = this.GetClientAbsPath();
                if (sClientDirPath != null && !sClientDirPath.isEmpty()) {
                    if (DEBUG_PRINT_PATHS) {
                        String sMsg = String.format("Client: %s | Server: %s\r\n", sClientDirPath, sServerDirPath);
                        System.out.printf(sMsg, new Object[0]);
                        if (DEBUG_TEXT_PANE != null) {
                            DEBUG_TEXT_PANE.setText(DEBUG_TEXT_PANE.getText() + sMsg);
                        }
                    }
                    String sAbsClientDirPath = this.GetClientDirPath();
                    if (CLocalFileSystem.GetLocalFileSystem() != null) {
                        CLocalFileSystem.GetLocalFileSystem().CreateAllLocalDirs(sAbsClientDirPath);
                    }
                    File fCachedResourceFile = new File(sClientDirPath);
                    String sModifiedTimestamp = null;
                    if (fCachedResourceFile != null) {
                        if (fCachedResourceFile.exists()) {
                            sModifiedTimestamp = CDateAttr.FormatURLDate(fCachedResourceFile.lastModified());
                        } else if (DEBUG_NOTIFY_IF_MODIFIED) {
                            String sMsg = String.format("%s\r\n\r\nDoesn't exist.  Therefore, we'll be retrieving this from the server.  If you want \"If-Modified-Since\" to be included in the HTTP request headers, make sure this file exists!", sClientDirPath);
                            JOptionPane.showMessageDialog(null, sMsg);
                        }
                    }
                    if (this.GetSUConnection() != null) {
                        int[] anRetCodes = this.GetSUConnection().SendGetResource(sServerDirPath, sClientDirPath, sModifiedTimestamp);
                        if (anRetCodes != null) {
                            this.SetHTTPCode(anRetCodes[0]);
                            this.SetSUCode(anRetCodes[1]);
                            if (anRetCodes[0] == 200 || anRetCodes[0] == 304) {
                                this.SetMsgID(this.GetRecvMsgID());
                            } else if (DEBUG) {
                                String sMsg = String.format("ASSERT:  Failed to get this resource file: %s\r\n", sServerDirPath);
                                System.out.printf(sMsg, new Object[0]);
                                if (DEBUG_TEXT_PANE != null) {
                                    DEBUG_TEXT_PANE.setText(DEBUG_TEXT_PANE.getText() + sMsg);
                                }
                            }
                        }
                    } else {
                        this.SetSUCode(11000);
                        if (DEBUG) {
                            CDebugLog.ASSERT(CCacheMsg.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid obj.");
                        }
                    }
                } else {
                    this.SetSUCode(11009);
                }
            } else {
                this.SetSUCode(11008);
            }
        } else {
            this.SetSUCode(11007);
        }
        this.PostBack(this);
    }

    protected int GetSendMsgID() {
        return 4230;
    }

    protected int GetRecvMsgID() {
        return 4231;
    }

    public Object GetSource() {
        return this.m_rUISource;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_PRINT_PATHS = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_NOTIFY_IF_MODIFIED = false;
        DEBUG_TEXT_PANE = CHTTPConnection.DEBUG_TEXT_PANE;
    }
}

