/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.messages;

import com.rhinosoft.attrs.CConnectionAttrs;
import com.rhinosoft.dialogs.CConfirmDeleteDlg;
import com.rhinosoft.dialogs.CConfirmDlg;
import com.rhinosoft.files.CFile;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CSUSourceMsg;
import com.rhinosoft.messages.CTransferMsg;
import com.rhinosoft.messages.CUIMessage;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CWorkerThread;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.transfer.CTransferNode;
import java.awt.Component;

public class CDeleteMsg
extends CSUSourceMsg {
    private CTransferNode m_rTreeNode;
    private String m_sWorkingDir;

    public CDeleteMsg(String sHost, long lServerPort, boolean bIsSecure, long lHeaderPort, String sUserAgent, String sEncSessionID, long lUITransferID, boolean bSourceIsLocal, String sAbsPathSource, boolean bSourceIsDir) {
        super(4223, sHost, lServerPort, bIsSecure, lHeaderPort, sUserAgent, sEncSessionID, lUITransferID, bSourceIsLocal, sAbsPathSource, bSourceIsDir);
        if (CRhinoApp.GET_RHINO_APP() != null) {
            this.m_sWorkingDir = CRhinoApp.GET_RHINO_APP().FetchCurWorkingDir(this);
        }
    }

    @Override
    public void Destroy() {
        this.m_rTreeNode = null;
        super.Destroy();
    }

    @Override
    public void OnMessage() {
        switch (this.GetMsgID()) {
            case 4223: {
                this.OnSendDelete();
                break;
            }
            default: {
                super.OnMessage();
            }
        }
    }

    protected void OnSendDelete() {
        CUIMessage rStatusMsg = new CUIMessage(4265, this.GetThreadAttrID(), this.GetUISourceAttrID());
        this.PostBack(rStatusMsg);
        this.SetHTTPCode(-1);
        this.SetSUCode(-1);
        this.SetMsgID(4201);
        if (this.GetSUConnection() != null) {
            if (!this.IsDirSource()) {
                this.OnDeleteFile();
            } else {
                this.OnDeleteDir();
            }
        } else {
            if (DEBUG) {
                CDebugLog.ASSERT(CTransferMsg.class.getName(), CDebugLog.GetLineNumber(), "Programming error; GetSUConnection() is null");
            }
            this.SetMsgID(4201);
            this.SetSUCode(11000);
        }
        this.PostBack(this);
    }

    @Override
    protected String GetErrorDlgTitle() {
        String sTitle = CString.LoadString("IDS_ERROR_FMT_TITLE");
        sTitle = String.format(sTitle, CString.LoadString("IDS_ERROR_TITLE_DELETE"));
        return sTitle;
    }

    @Override
    protected int GetErrorDlgType() {
        return 9;
    }

    protected void OnDelete(CFile fSource, int[] anRetVals) {
        if (anRetVals != null) {
            if (fSource != null) {
                int nHTTPCode = anRetVals[0];
                int nSUCode = anRetVals[1];
                int nMsgID = anRetVals[2];
                int nUserConfirmedOption = -2;
                if (this.GetUserWantsConfirmDlg()) {
                    nUserConfirmedOption = -2;
                    if (!this.IsDirSource()) {
                        this.SetSource(null);
                        this.GetSourceFile(true);
                    }
                } else {
                    nUserConfirmedOption = this.GetUserConfirmDlgResult();
                }
                if (nUserConfirmedOption == 0) {
                    int[] anRet = this.Delete(fSource.GetAbsPath(), fSource.IsDirectory(), fSource.IsLocal());
                    nHTTPCode = anRet[0];
                    nSUCode = anRet[1];
                    if (nHTTPCode == 200 && nSUCode == 0) {
                        CUIMessage rUIMsg = new CUIMessage(8012, this);
                        if (CRhinoApp.GET_RHINO_APP() != null) {
                            CRhinoApp.GET_RHINO_APP().OnMessage(rUIMsg);
                        }
                    }
                    nMsgID = nHTTPCode == 200 && nSUCode == 0 ? 4224 : 4201;
                } else {
                    nMsgID = nUserConfirmedOption == 1 || nUserConfirmedOption == 2 || nUserConfirmedOption == -5 || nUserConfirmedOption == -2 ? 4202 : 4201;
                }
                anRetVals[0] = nHTTPCode;
                anRetVals[1] = nSUCode;
                anRetVals[2] = nMsgID;
            } else {
                anRetVals[1] = 11025;
            }
        } else if (DEBUG) {
            CDebugLog.EXCEPTION(CDeleteMsg.class.getName(), CDebugLog.GetLineNumber(), "Invalid parameters.", true);
        }
    }

    protected void OnDeleteFile() {
        int nHTTPCode = -1;
        int nSUCode = -1;
        int nMsgID = 4201;
        CFile fSource = this.GetSourceFile(true);
        if (fSource != null) {
            if (!fSource.IsDirectory()) {
                int[] anCodes = new int[3];
                this.OnDelete(fSource, anCodes);
                nHTTPCode = anCodes[0];
                nSUCode = anCodes[1];
                nMsgID = anCodes[2];
            } else {
                nSUCode = 13;
            }
        } else {
            nSUCode = 6;
        }
        this.SetHTTPCode(nHTTPCode);
        this.SetSUCode(nSUCode);
        this.SetMsgID(nMsgID);
    }

    protected void OnDeleteDir() {
        int nHTTPCode = -1;
        int nSUCode = -1;
        int nMsgID = 4201;
        CFile fSource = this.GetSourceFile(true);
        if (fSource != null) {
            if (fSource.IsDirectory()) {
                int[] anCodes = new int[3];
                this.OnDelete(fSource, anCodes);
                nHTTPCode = anCodes[0];
                nSUCode = anCodes[1];
                nMsgID = anCodes[2];
            } else {
                nSUCode = 14;
            }
        } else {
            nSUCode = 6;
        }
        this.SetHTTPCode(nHTTPCode);
        this.SetSUCode(nSUCode);
        this.SetMsgID(nMsgID);
    }

    @Override
    public CConfirmDlg.TYPE GetConfirmDlgType() {
        CConfirmDlg.TYPE nType = super.GetConfirmDlgType();
        if (nType == CConfirmDlg.TYPE.UNKNOWN) {
            nType = CConfirmDlg.TYPE.DELETE_FILE;
            if (this.IsDirSource()) {
                nType = CConfirmDlg.TYPE.DELETE_FOLDER;
            }
        }
        return nType;
    }

    @Override
    protected String GetErrorDlgMsg() {
        String sMsg = super.GetErrorDlgMsg();
        if (this.GetSourcePath() != null) {
            sMsg = String.format("%s\r\n\r\n\"%s\"", sMsg, this.GetSourcePath());
        }
        return sMsg;
    }

    private void ShowConfirmFileDeleteDlg(Component rSource, Component rCenterTo) {
        CWorkerThread rThumbThread = null;
        CConnectionAttrs rConnAttrs = null;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            rThumbThread = CRhinoApp.GET_RHINO_APP().GetGeneralThread();
            rConnAttrs = CRhinoApp.GET_RHINO_APP().GetConnectionAttrs();
        }
        CConfirmDeleteDlg dlg = new CConfirmDeleteDlg(CRhinoApp.GetParentWindow(rCenterTo), this, this.IsDirSource(), this.GetSource(), rThumbThread, rConnAttrs, this.GetUISourceAttrID());
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().PostAddDialogToQueue(rSource, dlg);
        }
    }

    @Override
    public void OnConfirm(Component rSource, Component rCenterTo) {
        this.ShowConfirmFileDeleteDlg(rSource, rCenterTo);
    }

    public String GetWorkingDir() {
        return this.m_sWorkingDir;
    }

    @Override
    protected boolean CanUpdateTransferStats() {
        return true;
    }
}

