/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.messages;

import com.rhinosoft.attrs.CDateAttr;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CDownloadResourceMsg;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class CCacheMsg
extends CDownloadResourceMsg {
    public static boolean DEBUG_RECV_CACHE;
    private ImageIcon m_rImageIcon;
    private Vector<ActionListener> m_aRecvImageListeners;

    public CCacheMsg(String sHost, long lServerPort, boolean bIsSecure, long lHeaderPort, String sUserAgent, String sFileName, ImageIcon rImageIcon, String sClientDirPath, String sServerDirPath) {
        super(4234, sHost, lServerPort, bIsSecure, lHeaderPort, sUserAgent, -1L, sFileName, sClientDirPath, sServerDirPath, null);
        this.InitVars(rImageIcon);
    }

    private void InitVars(ImageIcon rImageIcon) {
        this.m_rImageIcon = rImageIcon;
        this.m_aRecvImageListeners = new Vector();
    }

    protected Vector<ActionListener> GetRecvImageListeners() {
        return this.m_aRecvImageListeners;
    }

    public void AddRecvImageListener(ActionListener rListener) {
        if (this.GetRecvImageListeners() != null && rListener != null) {
            this.GetRecvImageListeners().add(rListener);
        }
    }

    public void RemoveRecvImageListener(ActionListener rListener) {
        if (this.GetRecvImageListeners() != null && rListener != null) {
            this.GetRecvImageListeners().remove(rListener);
        }
    }

    protected void FireRecvImage() {
        for (int nIdx = this.GetRecvImageListeners().size() - 1; nIdx >= 0; --nIdx) {
            ActionListener rListener = this.GetRecvImageListeners().get(nIdx);
            if (rListener == null) continue;
            rListener.actionPerformed(new ActionEvent(this, 1, ""));
        }
    }

    public ImageIcon GetImageIcon() {
        return this.m_rImageIcon;
    }

    @Override
    public void OnMessage() {
        if (this.GetMsgID() == 4234) {
            this.LoadImageIcon();
        } else if (this.GetMsgID() == 4235) {
            if (DEBUG_RECV_CACHE) {
                CDebugLog.INFO("We either received the file from server or we've determined that the cached version doesn't need to be updated.");
            }
        } else {
            super.OnMessage();
        }
    }

    private void LoadImageIcon() {
        String sFileName = this.GetFileName();
        if (sFileName != null) {
            String sServerDirPath = this.GetServerAbsPath();
            if (sServerDirPath != null && !sServerDirPath.isEmpty()) {
                String sClientDirPath = this.GetClientAbsPath();
                if (sClientDirPath != null && !sClientDirPath.isEmpty()) {
                    if (DEBUG_PRINT_PATHS) {
                        String sMsg = String.format("Client: %s | Server: %s\r\n", sClientDirPath, sServerDirPath);
                        System.out.printf(sMsg, new Object[0]);
                        if (DEBUG_TEXT_PANE != null) {
                            DEBUG_TEXT_PANE.setText(DEBUG_TEXT_PANE.getText() + sMsg);
                        }
                    }
                    File fCachedImg = new File(sClientDirPath);
                    String sModifiedTimestamp = null;
                    if (fCachedImg != null) {
                        if (fCachedImg.exists()) {
                            sModifiedTimestamp = CDateAttr.FormatURLDate(fCachedImg.lastModified());
                            Image rImage = Toolkit.getDefaultToolkit().getImage(fCachedImg.getAbsolutePath());
                            this.m_rImageIcon.setImage(rImage);
                            this.FireRecvImage();
                        } else if (DEBUG_NOTIFY_IF_MODIFIED) {
                            String sMsg = String.format("%s\r\n\r\nDoesn't exist.  Therefore, we'll be retrieving this from the server.  If you want \"If-Modified-Since\" to be included in the HTTP request headers, make sure this file exists!", sClientDirPath);
                            JOptionPane.showMessageDialog(null, sMsg);
                        }
                    }
                    if (this.GetSUConnection() != null) {
                        int[] anRetCodes = this.GetSUConnection().SendGetImage(sServerDirPath, sClientDirPath, sModifiedTimestamp);
                        if (anRetCodes != null && (anRetCodes[0] == 200 || anRetCodes[0] == 304)) {
                            Image rImage = Toolkit.getDefaultToolkit().getImage(fCachedImg.getAbsolutePath());
                            this.m_rImageIcon.setImage(rImage);
                            this.SetMsgID(4235);
                            this.PostBack(this);
                            this.FireRecvImage();
                        } else if (DEBUG) {
                            String sMsg = String.format("ASSERT:  Failed to get this image file: %s\r\n", sServerDirPath);
                            System.out.printf(sMsg, new Object[0]);
                            if (DEBUG_TEXT_PANE != null) {
                                DEBUG_TEXT_PANE.setText(DEBUG_TEXT_PANE.getText() + sMsg);
                            }
                        }
                    } else {
                        this.SetSUCode(11000);
                        if (DEBUG) {
                            CDebugLog.ASSERT(CCacheMsg.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid obj.");
                        }
                    }
                } else {
                    this.SetSUCode(11009);
                }
            } else {
                this.SetSUCode(11008);
            }
        } else {
            this.SetSUCode(11007);
        }
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_RECV_CACHE = false;
    }
}

