/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.messages;

import com.rhinosoft.attrs.CStringURLAttr;
import com.rhinosoft.messages.CWorkerThreadMsg;

public abstract class CAddTransferItemsMsg
extends CWorkerThreadMsg {
    private boolean m_bSourceIsLocal;
    private String m_sTokenedItems;
    private boolean m_bIsParsed = false;
    private Object[] m_arSourceInfo;
    private String[] m_asAbsSourcePaths;
    private boolean[] m_abSourceDirs;
    private String m_sAbsTargetPath;

    public CAddTransferItemsMsg(int nID, boolean bSourceIsLocal, String sTokenedItems, String sAbsTargetPath) {
        super(nID);
        this._CAddTransferItemsMsg(bSourceIsLocal, sTokenedItems, sAbsTargetPath);
    }

    private void _CAddTransferItemsMsg(boolean bSourceIsLocal, String sTokenedItems, String sAbsTargetPath) {
        this.m_bSourceIsLocal = bSourceIsLocal;
        this.m_sTokenedItems = sTokenedItems;
        this.m_sAbsTargetPath = sAbsTargetPath;
    }

    public boolean GetSourceIsLocal() {
        return this.m_bSourceIsLocal;
    }

    public String GetTokenedItems() {
        return this.m_sTokenedItems;
    }

    public String GetAbsTargetPath() {
        return this.m_sAbsTargetPath;
    }

    @Override
    public void OnMessage() {
        super.OnMessage();
        if (!this.m_bIsParsed) {
            this.ParseData();
        }
    }

    private void ParseData() {
        if (this.m_sTokenedItems != null && !this.m_sTokenedItems.isEmpty()) {
            String[] asItems = this.m_sTokenedItems.split(",");
            if (asItems != null && asItems.length > 0) {
                int nLen = asItems.length / 2;
                this.m_asAbsSourcePaths = new String[nLen];
                this.m_abSourceDirs = new boolean[nLen];
                this.m_arSourceInfo = new Object[asItems.length];
                int nPathIdx = 0;
                int nDirIdx = 0;
                for (int nIdx = 0; nIdx < asItems.length; ++nIdx) {
                    if (nIdx % 2 == 0) {
                        String sURLDecoded = CStringURLAttr.URLDecode(asItems[nIdx]);
                        this.m_asAbsSourcePaths[nPathIdx++] = sURLDecoded;
                        this.m_arSourceInfo[nIdx] = sURLDecoded;
                        continue;
                    }
                    try {
                        int nIsDir = Integer.parseInt(asItems[nIdx]);
                        boolean bIsDir = false;
                        if (nIsDir != 0) {
                            bIsDir = true;
                        }
                        this.m_abSourceDirs[nDirIdx++] = bIsDir;
                        this.m_arSourceInfo[nIdx] = bIsDir;
                        continue;
                    }
                    catch (Exception e) {
                        if (!DEBUG) continue;
                        e.printStackTrace();
                    }
                }
            }
            this.m_bIsParsed = true;
        }
    }

    public final Object[] GetSourcePaths() {
        return this.m_arSourceInfo;
    }

    public final String[] GetSourcePathArray() {
        return this.m_asAbsSourcePaths;
    }

    public final boolean[] GetSourceDirArray() {
        return this.m_abSourceDirs;
    }
}

