/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.log;

import com.rhinosoft.attrs.CColorAttr;
import com.rhinosoft.attrs.CDateAttr;
import com.rhinosoft.attrs.CStringAttr;
import com.rhinosoft.strings.CString;
import java.awt.Color;
import java.util.Date;

public class CLogItem
extends CStringAttr {
    public static final int FORMAT_TEXT = 0;
    public static final int FORMAT_HTML = 1;
    private int m_nFormat;
    private boolean m_bIncludeTimestamp;
    private CColorAttr m_Color;
    private CDateAttr m_Timestamp;
    private CColorAttr m_TimestampColor;

    public CLogItem(int nFormat, boolean bIncludeTimestamp, String sValue, Color clrValue, Date dtTimestamp, Color clrTimeValue) {
        super(sValue, sValue);
        this._CLogItem(nFormat, bIncludeTimestamp, clrValue, dtTimestamp, clrTimeValue);
    }

    private void _CLogItem(int nFormat, boolean bIncludeTimestamp, Color clrValue, Date dtTimestamp, Color clrTimeValue) {
        this.m_nFormat = nFormat;
        this.m_bIncludeTimestamp = bIncludeTimestamp;
        this.m_Color = new CColorAttr(clrValue, clrValue);
        this.m_Timestamp = new CDateAttr(dtTimestamp, dtTimestamp);
        this.m_TimestampColor = new CColorAttr(clrTimeValue, clrTimeValue);
    }

    public void SetColor(Color clr) {
        this.m_Color.SetValue(clr);
    }

    public Color GetColor() {
        return this.m_Color.GetValue();
    }

    public void SetIncludeTimestamp(boolean bIncludeTimestamp) {
        this.m_bIncludeTimestamp = bIncludeTimestamp;
    }

    public boolean GetIncludeTimestamp() {
        return this.m_bIncludeTimestamp;
    }

    public CDateAttr GetTimestamp() {
        return this.m_Timestamp;
    }

    public final String GetFormattedTimestamp() {
        String sRet = "";
        if (this.GetTimestamp() != null) {
            sRet = this.GetTimestamp().Format("EE ddMMMyyyy HH:mm:ss");
        }
        return sRet;
    }

    public String GetText() {
        StringBuilder sRet = new StringBuilder();
        String sTimestamp = this.GetFormattedTimestamp();
        switch (this.m_nFormat) {
            case 0: {
                if (this.GetIncludeTimestamp()) {
                    sRet.append(sTimestamp);
                    sRet.append(" - ");
                }
                String sVal = this.GetValue();
                sVal = CString.EnsureLastSubString("\r\n", sVal);
                sRet.append(sVal);
                break;
            }
            case 1: {
                String sForegroundClr = "";
                String sBackgroundClr = "";
                sRet.append("    <font");
                if (this.GetIncludeTimestamp()) {
                    sRet.append(String.format(" style='color:%s'>", this.m_TimestampColor.GetHtmlValue()));
                    sRet.append(sTimestamp);
                    sRet.append("</font>");
                    sRet.append(" - ");
                    sRet.append("<font");
                }
                sRet.append(String.format(" style='color:%s'>", this.m_Color.GetHtmlValue()));
                String sTemp = CString.EnsureNotLastSubString("\r\n", this.GetValue());
                sRet.append(sTemp);
                sRet.append("</font><br>\r\n");
                break;
            }
        }
        return sRet.toString();
    }
}

