/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.log;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.CAttrs;
import com.rhinosoft.attrs.CFilePathAttr;
import com.rhinosoft.attrs.CLongAttr;
import com.rhinosoft.attrs.CStringAttr;
import com.rhinosoft.dialogs.CLogOptionsDlg;
import com.rhinosoft.log.CLogItem;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CLocalFileSystem;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class CLog
extends CAttrs {
    public static final long ITEMS_KEPT_BETWEEN_FLUSHES = 5L;
    public static final long ITEMS_BEFORE_FLUSH = 10L;
    public static final int FORMAT_TEXT = 0;
    public static final int FORMAT_HTML = 1;
    public static final String HTML_TAG_START = "<html>";
    public static final String HTML_TAG_END = "</html>";
    private CLongAttr m_nFormat;
    private CFilePathAttr m_sAbsFilePath;
    private CStringAttr m_sDesc;
    private boolean m_bClearLog;
    private FileOutputStream m_FileOutStream;
    private PrintStream m_PrintStream;
    private LinkedHashMap<Long, CAttr> m_LogItems;
    private CLongAttr m_lItemsBeforeFlush;
    private CLongAttr m_lItemsKeptBetweenFlushes;

    public static void main(String[] asArguments) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CLog log = null;
                String sAbsLogFile = null;
                boolean bDebugTxt = false;
                boolean bDebugHtml = true;
                if (bDebugTxt) {
                    sAbsLogFile = "C:\\Temp2\\a\\b\\Log.txt";
                    log = new CLog("Testing the \"text\" format capabilities of the log functionality", true, 0, sAbsLogFile, System.out);
                    log.ShowOptionsDlg();
                    log.Log("Grandpa\r\n", true);
                    log.Log("Grandma\r\n", true);
                    log.Log("Dad\r\n", true);
                    log.Log("Mom\r\n", true);
                    log.Log("Brother\r\n", true, Color.RED, Color.GREEN);
                    log.Log("Sister\r\n", true, Color.RED, Color.GREEN);
                }
                if (bDebugHtml) {
                    sAbsLogFile = "C:\\Temp2\\a\\b\\Log.html";
                    log = new CLog("Testing the \"HTML\" format capabilities of the log functionality", true, 1, sAbsLogFile, System.out);
                    log.Log("Grandpa\r\n", true, Color.BLACK, Color.GREEN);
                    log.Log("Grandma\r\n", true, Color.BLACK, Color.GREEN);
                    log.Log("Dad\r\n", true, Color.BLUE, Color.GREEN);
                    log.Log("Mom\r\n", true, Color.BLUE, Color.GREEN);
                    log.Log("Brother\r\n", true, Color.RED, Color.GREEN);
                    log.Log("Sister\r\n", true, Color.RED, Color.GREEN);
                    CString.InitStringTable("com/rhinosoft/strings/Strings", "en", "US");
                    log.ShowOptionsDlg();
                }
            }
        });
    }

    public CLog(String sDescription, boolean bClearLog, int nFormat, String sAbsFilePath) {
        this._CLog(sDescription, bClearLog, nFormat, sAbsFilePath, null);
    }

    public CLog(String sDescription, boolean bClearLog, int nFormat, PrintStream outStream) {
        this._CLog(sDescription, bClearLog, nFormat, null, outStream);
    }

    public CLog(String sDescription, boolean bClearLog, int nFormat, String sAbsFile, PrintStream outStream) {
        this._CLog(sDescription, bClearLog, nFormat, sAbsFile, outStream);
    }

    private void _CLog(String sDescription, boolean bClearLog, int nFormat, String sAbsFilePath, PrintStream outStream) {
        this.m_bClearLog = bClearLog;
        this.m_PrintStream = outStream;
        this.m_LogItems = new LinkedHashMap();
        this.m_lItemsBeforeFlush = new CLongAttr(10L, 10L);
        this.m_lItemsKeptBetweenFlushes = new CLongAttr(5L, 5L);
        this.m_sDesc = new CStringAttr(sDescription, sDescription);
        this.m_nFormat = new CLongAttr((long)nFormat, 0L);
        if (sAbsFilePath != null) {
            String sAbsDef = sAbsFilePath;
            String sFileName = CString.GetFileName(sAbsFilePath);
            File fTempDir = CLocalFileSystem.GetLocalFileSystem().GetTempFolder();
            sAbsDef = fTempDir.getAbsolutePath();
            sAbsDef = CString.EnsureLastCharIsAFileSeparator(sAbsDef);
            sAbsDef = sAbsDef + sFileName;
            this.m_sAbsFilePath = new CFilePathAttr(sAbsFilePath, sAbsDef);
        }
        this.SetOptionsDlg(new CLogOptionsDlg(null, this.m_sDesc, this.m_nFormat, this.m_sAbsFilePath, this.m_lItemsBeforeFlush, this.m_lItemsKeptBetweenFlushes));
    }

    public int GetFormat() {
        return (int)this.m_nFormat.GetValue();
    }

    public void SetItemsBeforeFlush(long lVal) {
        this.m_lItemsBeforeFlush.SetValue(lVal);
    }

    public long GetItemsBeforeFlush() {
        return this.m_lItemsBeforeFlush.GetValue();
    }

    public void SetItemsBetweenFlushes(long lVal) {
        this.m_lItemsKeptBetweenFlushes.SetValue(lVal);
    }

    public long GetItemsBetweenFlushes() {
        return this.m_lItemsKeptBetweenFlushes.GetValue();
    }

    private void LogItem(CLogItem rItem) {
        this.CheckFlush();
        this.AddItem(rItem);
        this.WriteItem(rItem);
    }

    public long Log(String sText, boolean bIncludeTimestamp) {
        CLogItem rItem = new CLogItem(this.GetFormat(), bIncludeTimestamp, sText, Color.BLACK, new Date(System.currentTimeMillis()), Color.GREEN);
        this.LogItem(rItem);
        return rItem.GetUniqueID();
    }

    public long Log(String sText, boolean bIncludeTimestamp, Color clrText, Color clrTimestamp) {
        CLogItem rItem = new CLogItem(this.GetFormat(), bIncludeTimestamp, sText, clrText, new Date(System.currentTimeMillis()), clrTimestamp);
        this.LogItem(rItem);
        return rItem.GetUniqueID();
    }

    private void AddItem(CLogItem rItem) {
        if (rItem != null) {
            this.m_LogItems.put(rItem.GetUniqueID(), rItem);
        } else if (CAttr.DEBUG) {
            System.out.println("ASSERT:  CLog.AddItem | rItem == null");
        }
    }

    private void WriteItem(CLogItem rItem) {
        if (rItem != null) {
            String sText = rItem.GetText();
            if (CLog.IsValid(sText)) {
                block13: {
                    if (this.m_PrintStream != null) {
                        this.m_PrintStream.println(rItem.GetValue());
                    }
                    boolean bClearLog = this.m_bClearLog;
                    if (this.m_bClearLog) {
                        this.m_bClearLog = false;
                    }
                    this.OpenFileStream(!bClearLog);
                    if (this.m_FileOutStream != null) {
                        FileChannel rFileChannel = this.m_FileOutStream.getChannel();
                        try {
                            if (this.GetFormat() == 1) {
                                if (bClearLog) {
                                    rFileChannel.write(ByteBuffer.wrap(HTML_TAG_START.getBytes()));
                                    rFileChannel.write(ByteBuffer.wrap("\r\n".getBytes()));
                                } else {
                                    long lSize = rFileChannel.size() - (long)HTML_TAG_END.getBytes().length;
                                    rFileChannel.truncate(lSize);
                                }
                            }
                            rFileChannel.write(ByteBuffer.wrap(sText.getBytes()));
                            if (this.GetFormat() == 1) {
                                rFileChannel.write(ByteBuffer.wrap(HTML_TAG_END.getBytes()));
                            }
                        }
                        catch (Exception e) {
                            if (!CAttr.DEBUG) break block13;
                            System.out.println("EXCEPTION:  CLog.WriteItem - failed to open or write to the file output stream!");
                        }
                    }
                }
                this.CloseFileStream();
            }
        } else if (CAttr.DEBUG) {
            System.out.println("ASSERT:  CLog.WriteItem | rItem == null");
        }
    }

    private boolean CheckFlush() {
        long lPrevSize = this.m_LogItems.size();
        if ((long)(this.m_LogItems.size() + 1) > this.GetItemsBeforeFlush()) {
            Set<Long> keys = this.m_LogItems.keySet();
            Iterator<Long> itr = keys.iterator();
            while (itr.hasNext() && this.GetItemsBetweenFlushes() < (long)this.m_LogItems.size()) {
                Long lID = itr.next();
                itr.remove();
            }
        }
        return lPrevSize != (long)this.m_LogItems.size();
    }

    private void OpenFileStream(boolean bAppendToFile) {
        this.CloseFileStream();
        if (this.m_FileOutStream == null && this.m_sAbsFilePath != null) {
            File fFile;
            block7: {
                fFile = new File(this.m_sAbsFilePath.GetValue());
                if (!fFile.exists()) {
                    String sParentDir = fFile.getParentFile().getAbsolutePath();
                    File fParent = CLocalFileSystem.GetLocalFileSystem().CreateAllLocalDirs(sParentDir);
                    try {
                        fFile.createNewFile();
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block7;
                        e.printStackTrace();
                    }
                }
            }
            if (fFile.exists()) {
                try {
                    fFile.setWritable(true);
                    this.m_FileOutStream = new FileOutputStream(fFile, bAppendToFile);
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(CLog.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private void CloseFileStream() {
        if (this.m_FileOutStream != null) {
            block3: {
                try {
                    this.m_FileOutStream.close();
                }
                catch (Exception e) {
                    if (!DEBUG) break block3;
                    System.out.println("EXCEPTION:  CLog.WriteItem - failed to close the file output stream!");
                    Logger.getLogger(CLog.class.getName()).log(Level.SEVERE, null, e);
                }
            }
            this.m_FileOutStream = null;
        }
    }

    public CLongAttr GetFormatAttr() {
        return this.m_nFormat;
    }

    public CFilePathAttr GetPathAttr() {
        return this.m_sAbsFilePath;
    }

    public CStringAttr GetDescAttr() {
        return this.m_sDesc;
    }

    public CLongAttr GetItemsBeforeFlushAttr() {
        return this.m_lItemsBeforeFlush;
    }

    public CLongAttr GetItemsKeptBetweenFlushesAttr() {
        return this.m_lItemsKeptBetweenFlushes;
    }
}

