/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.log;

import com.rhinosoft.log.CLog;
import com.rhinosoft.ui.CRhinoApp;
import java.awt.Color;
import java.io.PrintStream;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class CDebugLog
extends CLog {
    private static final String GLOBAL_DEBUG_LOGGER = "GlobalRhinoDebugger";

    public CDebugLog(String sDescription, boolean bClearLog, int nFormat, String sAbsFile, PrintStream outStream) {
        super(sDescription, bClearLog, nFormat, sAbsFile, outStream);
    }

    public static Logger GetGlobalDebugLogger() {
        return Logger.getLogger(GLOBAL_DEBUG_LOGGER);
    }

    public static String GetLineNumber() {
        Exception e;
        String sLineNum = null;
        if (Thread.currentThread() != null && Thread.currentThread().getStackTrace() != null && Thread.currentThread().getStackTrace().length >= 3) {
            sLineNum = Integer.toString(Thread.currentThread().getStackTrace()[2].getLineNumber());
        }
        if ((sLineNum == null || sLineNum.isEmpty()) && (e = new Exception()) != null && e.getStackTrace() != null && e.getStackTrace().length >= 1) {
            sLineNum = Integer.toString(e.getStackTrace()[0].getLineNumber());
        }
        if (sLineNum == null || sLineNum.isEmpty()) {
            sLineNum = "N/A";
        }
        return sLineNum;
    }

    public static String FormatAssert(String sClassName, String sLineNumber, String sMsg) {
        return String.format("ASSERT: (%s, %s) - %s", sClassName, sLineNumber, sMsg);
    }

    public static void ASSERT(String sClassName, String sLineNumber, String sMsg) {
        CDebugLog.ASSERT(sClassName, sLineNumber, sMsg, false);
    }

    public static void ASSERT(String sClassName, String sLineNumber, String sMsg, boolean bShowMsgBox) {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().Debug_Assert(sClassName, sLineNumber, sMsg, bShowMsgBox);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().severe(CDebugLog.FormatAssert(sClassName, sLineNumber, sMsg));
        }
    }

    public void Assert(String sClassName, String sLineNumber, String sMsg, boolean bShowMsgBox) {
        String sText = CDebugLog.FormatAssert(sClassName, sLineNumber, sMsg);
        this.Log(sText, true, Color.RED, Color.BLACK);
        if (bShowMsgBox) {
            sText = String.format("ASSERT triggered!\r\n\r\nClass:  %s\r\nLine Number:  %s\r\n\r\n%s", sClassName, sLineNumber, sMsg);
            JOptionPane.showMessageDialog(null, sText, "ASSERTION", 2);
        }
    }

    public static String FormatException(String sClassName, String sLineNumber, String sMsg) {
        return String.format("EXCEPTION: (%s, %s) - %s", sClassName, sLineNumber, sMsg);
    }

    public static void EXCEPTION(String sClassName, String sLineNumber, String sMsg, boolean bShowMsgBox) {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().Debug_Exception(sClassName, sLineNumber, sMsg, bShowMsgBox);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().warning(CDebugLog.FormatException(sClassName, sLineNumber, sMsg));
        }
    }

    public void Exception(String sClassName, String sLineNumber, String sMsg, boolean bShowMsgBox) {
        String sText = CDebugLog.FormatException(sClassName, sLineNumber, sMsg);
        this.Log(sText, true, Color.MAGENTA, Color.BLACK);
        if (bShowMsgBox) {
            sText = String.format("EXCEPTION triggered!\r\n\r\nClass:  %s\r\nLine Number:  %s\r\n\r\n%s", sClassName, sLineNumber, sMsg);
            JOptionPane.showMessageDialog(null, sText, "EXCEPTION", 2);
        }
    }

    public static void INFO(String sMsg) {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().Debug_Info(sMsg);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().info(sMsg);
        }
    }

    public void Info(String sMsg) {
        this.Log(sMsg, true, Color.ORANGE, Color.BLACK);
    }

    public static void ENTERING(String sSourceClass, String sSourceMethod) {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().Debug_Entering(sSourceClass, sSourceMethod);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().entering(sSourceClass, sSourceMethod);
        }
    }

    public static void ENTERING(String sSourceClass, String sSourceMethod, Object rFromObject) {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().Debug_Entering(sSourceClass, sSourceMethod, rFromObject);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().entering(sSourceClass, sSourceMethod, rFromObject);
        }
    }

    public static void ENTERING(String sSourceClass, String sSourceMethod, Object[] arFromObjects) {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().Debug_Entering(sSourceClass, sSourceMethod, arFromObjects);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().entering(sSourceClass, sSourceMethod, arFromObjects);
        }
    }

    public void Entering(String sSourceClass, String sSourceMethod) {
        String sText = String.format("Entering: %s.%s -->", sSourceClass, sSourceMethod);
        this.Log(sText, true, Color.LIGHT_GRAY, Color.BLACK);
    }

    public void Entering(String sSourceClass, String sSourceMethod, Object rFromObject) {
        this.Entering(sSourceClass, sSourceMethod);
    }

    public void Entering(String sSourceClass, String sSourceMethod, Object[] arFromObjects) {
        this.Entering(sSourceClass, sSourceMethod);
    }

    public static void EXITING(String sSourceClass, String sSourceMethod) {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().Debug_Exiting(sSourceClass, sSourceMethod);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().exiting(sSourceClass, sSourceMethod);
        }
    }

    public void Exiting(String sSourceClass, String sSourceMethod) {
        String sText = String.format("Exiting: %s.%s <--", sSourceClass, sSourceMethod);
        this.Log(sText, true, Color.LIGHT_GRAY, Color.BLACK);
    }

    public static void EXITING(String sSourceClass, String sSourceMethod, Object rFromObject) {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().Debug_Exiting(sSourceClass, sSourceMethod, rFromObject);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().exiting(sSourceClass, sSourceMethod, rFromObject);
        }
    }

    public void Exiting(String sSourceClass, String sSourceMethod, Object rFromObject) {
        this.Exiting(sSourceClass, sSourceMethod);
    }

    public static void TRACE(String sMsg) {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().Debug_Trace(sMsg);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().finer(sMsg);
        }
    }

    public void Trace(String sMsg) {
        this.Log(sMsg, true, Color.GRAY, Color.BLACK);
    }

    public static void TRACE1(String sMsg) {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().Debug_Trace1(sMsg);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().fine(sMsg);
        }
    }

    public void Trace1(String sMsg) {
        this.Log(sMsg, true, Color.GRAY, Color.BLACK);
    }

    public static void WARNING(String sMsg) {
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().Debug_Warning(sMsg);
        } else if (DEBUG) {
            CDebugLog.GetGlobalDebugLogger().warning(sMsg);
        }
    }

    public void Warning(String sMsg) {
        this.Log(sMsg, true, Color.MAGENTA, Color.BLACK);
    }
}

