/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.images;

import com.rhinosoft.utils.CSpeedTest;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class CJarResImages {
    public static final boolean DEBUG_FETCH_SPEED = true;
    private String m_sJarResourcePath;
    private HashMap<String, ImageIcon> m_aImageMap;
    protected CSpeedTest m_SpeedTest = new CSpeedTest();

    public CJarResImages(String sJarResourcePath) {
        this._CJarResImages(sJarResourcePath);
    }

    private void _CJarResImages(String sJarResourcePath) {
        this.m_aImageMap = new HashMap();
        this.m_sJarResourcePath = CJarResImages.FormatJarResPath(sJarResourcePath);
    }

    public static String FormatJarResPath(String sJarResourcePath) {
        String sRet = sJarResourcePath;
        sRet = sRet.replace('\\', '/');
        return sRet;
    }

    protected ImageIcon GetJarImage(String sResourcePath) {
        ImageIcon rRetImage = null;
        this.m_SpeedTest.Start();
        URL rURL = CJarResImages.class.getResource(sResourcePath);
        String sMsg = String.format("CJarResImages.GetJarImage | getResource(%s)", sResourcePath);
        this.m_SpeedTest.Stop();
        this.m_SpeedTest.PrintResults(sMsg);
        if (rURL != null) {
            this.m_SpeedTest.Start();
            rRetImage = new ImageIcon(rURL);
            sMsg = String.format("CJarResImages.GetJarImage | new ImageIcon(%s)", rURL.toString());
            this.m_SpeedTest.Stop();
            this.m_SpeedTest.PrintResults(sMsg);
        }
        return rRetImage;
    }

    protected HashMap<String, ImageIcon> GetMap() {
        return this.m_aImageMap;
    }

    protected boolean AddMappedItem(String sKey, ImageIcon rItem) {
        boolean bAdded = false;
        if (sKey != null && !sKey.isEmpty() && rItem != null && this.GetMap() != null) {
            bAdded = this.GetMap().put(sKey, rItem) != null;
        }
        return bAdded;
    }

    protected ImageIcon GetMappedItem(String sResourcePath) {
        ImageIcon rItem = null;
        if (this.GetMap() != null) {
            rItem = this.GetMap().get(sResourcePath);
        }
        if (rItem == null) {
            rItem = this.GetJarImage(sResourcePath);
            this.AddMappedItem(sResourcePath, rItem);
        }
        return rItem;
    }

    public final String GetJarResourcePath() {
        return this.m_sJarResourcePath;
    }

    private String GetJarResourcePath(String sFileName) {
        String sResPath = this.GetJarResourcePath();
        if (sResPath != null && !sResPath.isEmpty() && sFileName != null) {
            if (!sResPath.endsWith("/")) {
                sResPath = sResPath + '/';
            }
            sResPath = sResPath + sFileName;
        }
        return sResPath;
    }

    public ImageIcon GetImage(String sFileName) {
        return this.GetMappedItem(this.GetJarResourcePath(sFileName));
    }
}

