/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.images;

import com.rhinosoft.attrs.CAttr;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class CImageUtil {
    public static Image CreateScaledImage(Image jOriginalImage, int nWidth, int nHeight, SCALE_OPTION nScaleOpt) {
        return CImageUtil.CreateScaledImage(null, jOriginalImage, nWidth, nHeight, nScaleOpt);
    }

    public static Image CreateScaledImage(Component rComp, Image rOriginalImage, int nWidth, int nHeight, SCALE_OPTION nScaleOpt) {
        Image rRetImage = null;
        if (rOriginalImage != null) {
            int nImageWidth = rOriginalImage.getWidth(null);
            int nImageHeight = rOriginalImage.getHeight(null);
            if (nImageWidth > 0 && nImageHeight > 0) {
                int nTargetHeight;
                int nTargetWidth;
                rRetImage = rOriginalImage;
                float fAspectRatio = (float)nImageWidth / (float)nImageHeight;
                if (nImageWidth > nImageHeight) {
                    nTargetWidth = nWidth;
                    nTargetHeight = (int)((float)nTargetWidth / fAspectRatio);
                    if (nTargetHeight > nHeight) {
                        nTargetHeight = nHeight;
                        nTargetWidth = (int)(fAspectRatio * (float)nTargetHeight);
                    }
                } else {
                    nTargetHeight = nHeight;
                    nTargetWidth = (int)(fAspectRatio * (float)nTargetHeight);
                    if (nTargetWidth > nWidth) {
                        nTargetWidth = nWidth;
                        nTargetHeight = (int)((float)nTargetWidth / fAspectRatio);
                    }
                }
                boolean bScaleIt = false;
                if (nScaleOpt == SCALE_OPTION.SHRINK && (nTargetWidth < nImageWidth || nTargetHeight < nImageWidth)) {
                    bScaleIt = true;
                } else if (nScaleOpt == SCALE_OPTION.ENLARGE && (nTargetWidth > nImageWidth || nTargetHeight > nImageWidth)) {
                    bScaleIt = true;
                } else if (nScaleOpt == SCALE_OPTION.FIT_TO_TARGET && (nTargetWidth != nImageWidth || nTargetHeight != nImageWidth)) {
                    bScaleIt = true;
                }
                if (bScaleIt) {
                    rRetImage = rOriginalImage.getScaledInstance(nTargetWidth, nTargetHeight, 16);
                }
            }
        }
        return rRetImage;
    }

    public static ImageIcon GetImageFromFile(String sAbsPath) {
        BufferedImage rImage;
        ImageIcon rImageIcon;
        block4: {
            rImageIcon = null;
            rImage = null;
            try {
                File fFile;
                if (sAbsPath != null && !sAbsPath.isEmpty() && (fFile = new File(sAbsPath)) != null && fFile.exists()) {
                    rImage = ImageIO.read(fFile);
                }
            }
            catch (IOException ioe) {
                if (!CAttr.DEBUG) break block4;
                ioe.printStackTrace();
            }
        }
        if (rImage != null) {
            rImageIcon = new ImageIcon(rImage);
        }
        return rImageIcon;
    }

    public static enum SCALE_OPTION {
        FIT_TO_TARGET,
        SHRINK,
        ENLARGE;

    }
}

