/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.images;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.attrs.CConnectionAttrs;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CCacheMsg;
import com.rhinosoft.threads.CWorkerThread;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;

public class CCachedImageIcon
extends ImageIcon {
    public static boolean DEBUG = CAttr.DEBUG;
    private int m_nWidth;
    private int m_nHeight;
    private CCacheMsg m_CacheMsg;
    private CWorkerThread m_rWorkerThread;

    public CCachedImageIcon(String sFileName, boolean bIsCommon, int nWidth, int nHeight, CConnectionAttrs rConnInfo, CWorkerThread rThread, String sClientDirPath, String sServerDirPath) {
        String sHost = rConnInfo.GetHost();
        long lServerPort = rConnInfo.GetServerPort();
        long lHeaderPort = rConnInfo.GetHeaderPort();
        boolean bIsSecure = rConnInfo.IsSecure();
        String sUserAgent = rConnInfo.GetUserAgent();
        this._CCachedImageIcon(sFileName, sClientDirPath, sServerDirPath, sHost, lServerPort, bIsSecure, lHeaderPort, sUserAgent, rThread, nWidth, nHeight);
    }

    private void _CCachedImageIcon(String sFileName, String sClientDirPath, String sServerDirPath, String sHost, long lServerPort, boolean bIsSecure, long lHeaderPort, String sUserAgent, CWorkerThread rThread, int nWidth, int nHeight) {
        this.m_CacheMsg = new CCacheMsg(sHost, lServerPort, bIsSecure, lHeaderPort, sUserAgent, sFileName, this, sClientDirPath, sServerDirPath);
        this.m_nWidth = nWidth;
        this.m_nHeight = nHeight;
        this.AddRecvImageListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CCachedImageIcon.this.LoadLocalImage();
            }
        });
        this.m_rWorkerThread = rThread;
        this.LoadLocalImage();
    }

    public String GetFileName() {
        return this.m_CacheMsg.GetFileName();
    }

    public String GetServerDirPath() {
        return this.m_CacheMsg.GetServerDirPath();
    }

    public String GetClientDirPath() {
        return this.m_CacheMsg.GetClientDirPath();
    }

    private CWorkerThread GetThread() {
        return this.m_rWorkerThread;
    }

    private CCacheMsg GetCacheMsg() {
        return this.m_CacheMsg;
    }

    public void FetchImage(String sHost, long lServerPort, boolean bIsSecure, long lHeaderPort, String sUserAgent) {
        this.LoadLocalImage();
        CCacheMsg rCacheMsg = this.GetCacheMsg();
        if (rCacheMsg != null) {
            rCacheMsg.SetHost(sHost);
            rCacheMsg.SetServerPort(lServerPort);
            rCacheMsg.SetIsSecure(bIsSecure);
            rCacheMsg.SetHeaderPort(lHeaderPort);
            rCacheMsg.SetUserAgent(sUserAgent);
            if (this.GetThread() != null) {
                this.GetThread().NewMessage(rCacheMsg);
            }
        }
    }

    private void LoadLocalImage() {
        if (this.GetCacheMsg() != null) {
            String sAbsClientPath = this.GetCacheMsg().GetClientAbsPath();
            if (sAbsClientPath != null) {
                Image image;
                File fCached = new File(sAbsClientPath);
                if (fCached != null && fCached.exists() && (image = Toolkit.getDefaultToolkit().getImage(sAbsClientPath)) != null) {
                    this.setImage(image);
                }
            } else if (DEBUG) {
                CDebugLog.ASSERT(CCachedImageIcon.class.getName(), CDebugLog.GetLineNumber(), "CacheMsg.GetClientAbsPath is null!");
            }
        }
    }

    public void AddRecvImageListener(ActionListener rListener) {
        if (this.GetCacheMsg() != null && rListener != null) {
            this.GetCacheMsg().AddRecvImageListener(rListener);
        }
    }

    public void RemoveRecvImageListener(ActionListener rListener) {
        if (this.GetCacheMsg() != null && rListener != null) {
            this.GetCacheMsg().RemoveRecvImageListener(rListener);
        }
    }

    @Override
    public int getIconWidth() {
        return this.m_nWidth;
    }

    @Override
    public int getIconHeight() {
        return this.m_nHeight;
    }
}

