/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.files.cache;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.IRhinoConsts;
import java.io.File;
import javax.swing.Icon;

public class CRhinoFileInfoCacheItem {
    public static boolean DEBUG = CAttr.DEBUG;
    private Icon m_Icon16;
    private Icon m_Icon32;
    private String m_sType;

    public CRhinoFileInfoCacheItem(String sAbsPathToCachedExt) {
        this.Init(sAbsPathToCachedExt);
    }

    private void Init(String sAbsPathToCachedExt) {
        if (sAbsPathToCachedExt != null && !sAbsPathToCachedExt.isEmpty()) {
            if (sAbsPathToCachedExt.endsWith(CLocalFileSystem.GetLocalFileSystem().GetRootPath())) {
                this.SetIcon16(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_COMPUTER_PNG.GetFileName()));
                this.SetIcon32(CRhinoApp.GetImage(IRhinoConsts.CACHE_IMAGES_COMMON.IMG_COMPUTER_PNG.GetFileName()));
            } else {
                File fFile = CLocalFileSystem.GetLocalFileSystem().GetJavaFile(sAbsPathToCachedExt);
                this.SetIcon16(CLocalFileSystem.GetLocalFileSystem().GetIcon16(fFile));
                this.SetIcon32(CLocalFileSystem.GetLocalFileSystem().GetIcon32(fFile));
                this.SetType(CLocalFileSystem.GetLocalFileSystem().GetType(fFile));
            }
        } else if (DEBUG) {
            CDebugLog.ASSERT(CRhinoFileInfoCacheItem.class.getName(), CDebugLog.GetLineNumber(), "Programming error, invalid arg(s).");
        }
    }

    public Icon GetIcon16() {
        return this.m_Icon16;
    }

    public void SetIcon16(Icon rIcon) {
        this.m_Icon16 = rIcon;
    }

    public Icon GetIcon32() {
        return this.m_Icon32;
    }

    public void SetIcon32(Icon rIcon) {
        this.m_Icon32 = rIcon;
    }

    public String GetType() {
        return this.m_sType;
    }

    public void SetType(String sType) {
        this.m_sType = sType;
    }

    public String toString() {
        StringBuilder sRet = new StringBuilder();
        sRet.append("File Type: " + this.GetType());
        return sRet.toString();
    }
}

