/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.files.cache;

import com.rhinosoft.attrs.CAttr;
import com.rhinosoft.files.CFile;
import com.rhinosoft.files.cache.CRhinoFileInfoCacheItem;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.threads.CLocalFileSystem;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;

public class CRhinoFileInfoCache {
    public static boolean DEBUG = CAttr.DEBUG;
    public static boolean DEBUG_LONG_FILE_EXT;
    public static boolean DEBUG_CACHE_KEYS;
    public static final String KEY_EXT_DIR = "DirExt";
    public static final String KEY_EXT_NONE = "NoExt";
    public static final String NAME_FOLDER = "Folder";
    private File m_fCacheDir;
    private boolean m_bLoadedMap = false;
    private HashMap<String, CRhinoFileInfoCacheItem> m_aMappedItems;
    private String[] m_asExcludeFromLocalCache = new String[]{"exe", "lnk", "ico"};

    public CRhinoFileInfoCache(String sAbsCacheDir) {
        this.m_fCacheDir = this.CreateCacheDir(sAbsCacheDir);
        this.InitMap();
    }

    private File CreateCacheDir(String sAbsCacheDir) {
        File fDir = new File(sAbsCacheDir);
        if (fDir != null && !fDir.exists()) {
            fDir = CLocalFileSystem.GetLocalFileSystem().CreateAllLocalDirs(sAbsCacheDir);
        }
        return fDir;
    }

    protected File GetCacheDir() {
        return this.m_fCacheDir;
    }

    protected File CreateFileOnDisk(String sFileName) {
        File fNewFile;
        block5: {
            fNewFile = null;
            if (this.GetCacheDir() != null && this.GetCacheDir().exists() && sFileName != null) {
                String sAbsPath = this.GetCacheDir().getPath();
                if (!sAbsPath.endsWith(File.separator)) {
                    sAbsPath = sAbsPath + File.separator;
                }
                sAbsPath = sAbsPath + sFileName;
                File fNew = new File(sAbsPath);
                try {
                    if (fNew.createNewFile()) {
                        fNewFile = fNew;
                    }
                }
                catch (IOException ioe) {
                    if (!DEBUG_LONG_FILE_EXT) break block5;
                    ioe.printStackTrace();
                }
            }
        }
        return fNewFile;
    }

    private boolean IsValid(String sTest) {
        return sTest != null && !sTest.isEmpty();
    }

    public Icon GetIcon16(CFile rFile) {
        Icon icoRet = null;
        CRhinoFileInfoCacheItem rItem = this.GetMappedItem(rFile);
        if (rItem != null) {
            icoRet = rItem.GetIcon16();
        }
        return icoRet;
    }

    public Icon GetIcon32(CFile rFile) {
        Icon icoRet = null;
        CRhinoFileInfoCacheItem rItem = this.GetMappedItem(rFile);
        if (rItem != null) {
            icoRet = rItem.GetIcon32();
        }
        return icoRet;
    }

    public String GetType(CFile rFile) {
        String sType = "";
        CRhinoFileInfoCacheItem rItem = this.GetMappedItem(rFile);
        if (rItem != null) {
            sType = rItem.GetType();
        }
        return sType;
    }

    protected HashMap<String, CRhinoFileInfoCacheItem> GetMappedItems() {
        return this.m_aMappedItems;
    }

    protected CRhinoFileInfoCacheItem GetMappedItem(String sKey) {
        CRhinoFileInfoCacheItem rMappedItem = null;
        if (this.GetMappedItems() != null && sKey != null && !sKey.isEmpty()) {
            rMappedItem = this.GetMappedItems().get(sKey);
        }
        return rMappedItem;
    }

    protected CRhinoFileInfoCacheItem GetMappedItem(CFile rFile) {
        CRhinoFileInfoCacheItem rItem = null;
        if (rFile != null) {
            String sKey = this.FormatKey(rFile.IsLocal(), rFile.IsDrive(), rFile.IsDirectory(), rFile.GetAbsPath());
            if (DEBUG_CACHE_KEYS) {
                System.out.printf("Key: %s\r\n", sKey);
            }
            if ((rItem = this.GetMappedItem(sKey)) == null) {
                if (this.CanStoreOnDisk(rFile.IsLocal(), rFile.IsDrive(), rFile.IsDirectory(), rFile.GetAbsPath())) {
                    File fFile = this.GetFileOnDisk(rFile.IsDirectory(), sKey);
                    if (fFile != null) {
                        rItem = new CRhinoFileInfoCacheItem(fFile.getAbsolutePath());
                    } else if (DEBUG) {
                        CDebugLog.TRACE("CRhinoFileInfoCache.GetMappedItem | File is null: " + rFile.GetAbsPath());
                    }
                } else {
                    rItem = new CRhinoFileInfoCacheItem(rFile.GetAbsPath());
                }
                this.AddMappedItem(sKey, rItem);
            }
        }
        return rItem;
    }

    private void InitMap() {
        this.m_bLoadedMap = false;
        this.m_aMappedItems = new HashMap();
        if (this.GetMappedItems() != null) {
            File fCacheDir = this.GetCacheDir();
            File[] afFiles = fCacheDir.listFiles();
            for (int nIdx = 0; nIdx < afFiles.length; ++nIdx) {
                File fNext = afFiles[nIdx];
                if (fNext == null || !fNext.exists()) continue;
                boolean bIsDrive = FileSystemView.getFileSystemView().isDrive(fNext);
                String sKey = this.FormatKey(true, bIsDrive, fNext.isDirectory(), fNext.getPath());
                CRhinoFileInfoCacheItem rItem = new CRhinoFileInfoCacheItem(fNext.getPath());
                this.AddMappedItem(sKey, rItem);
            }
        }
        this.m_bLoadedMap = true;
    }

    protected String FormatKey(boolean bIsLocal, boolean bIsDrive, boolean bIsDir, String sAbsPath) {
        String sExt;
        String sKey = KEY_EXT_NONE;
        if (bIsDrive) {
            sKey = sAbsPath;
        } else if (bIsDir) {
            sKey = KEY_EXT_DIR;
            if (CLocalFileSystem.GetLocalFileSystem().IsARoot(sAbsPath)) {
                sKey = sAbsPath;
            } else if (sAbsPath != null && sAbsPath.endsWith(CLocalFileSystem.GetLocalFileSystem().GetRootPath())) {
                sKey = CLocalFileSystem.GetLocalFileSystem().GetRootPath();
            }
            if (!this.CanStoreOnDisk(bIsLocal, bIsDrive, bIsDir, sAbsPath)) {
                sKey = sAbsPath;
            }
        } else if (sAbsPath != null && !sAbsPath.isEmpty() && (sExt = this.GetExt(sAbsPath)) != null && !sExt.isEmpty()) {
            sKey = sExt.toLowerCase();
            if (this.m_bLoadedMap && !this.CanStoreOnDisk(bIsLocal, bIsDrive, bIsDir, sAbsPath)) {
                sKey = sAbsPath;
            }
        }
        return sKey;
    }

    protected boolean CanStoreOnDisk(boolean bIsLocal, boolean bIsDrive, boolean bIsDir, String sPath) {
        boolean bCanStoreOnDisk = true;
        if (bIsLocal && CLocalFileSystem.GetLocalFileSystem().IsWindows()) {
            if (!bIsDrive) {
                if (!bIsDir) {
                    String sExt = this.GetExt(sPath);
                    bCanStoreOnDisk = !this.IsExcludedExt(sExt);
                } else {
                    String sExt = this.GetExt(sPath);
                    if (CLocalFileSystem.GetLocalFileSystem().IsARoot(sPath) || sPath.endsWith(CLocalFileSystem.GetLocalFileSystem().GetRootPath()) || this.IsExcludedExt(sExt)) {
                        bCanStoreOnDisk = false;
                    }
                }
            } else {
                bCanStoreOnDisk = false;
            }
        }
        return bCanStoreOnDisk;
    }

    protected boolean AddMappedItem(String sKey, CRhinoFileInfoCacheItem rAddItem) {
        boolean bAdded = false;
        if (this.GetMappedItems() != null && rAddItem != null && this.GetMappedItems().put(sKey, rAddItem) != null) {
            bAdded = true;
        }
        return bAdded;
    }

    private boolean IsExcludedExt(String sExt) {
        boolean bFound = false;
        if (sExt != null && !sExt.isEmpty()) {
            sExt = sExt.toLowerCase();
            for (int nIdx = 0; nIdx < this.m_asExcludeFromLocalCache.length; ++nIdx) {
                String sNext = this.m_asExcludeFromLocalCache[nIdx];
                if (sNext == null || sNext.isEmpty() || !sNext.equals(sExt)) continue;
                bFound = true;
                break;
            }
        }
        return bFound;
    }

    protected String GetExt(String sAbsPath) {
        String sExt = null;
        if (sAbsPath != null && !sAbsPath.isEmpty()) {
            String sFileName = sAbsPath;
            int nLoc = (sFileName = sFileName.replace('\\', '/')).lastIndexOf(47);
            if (nLoc >= 0 && nLoc + 1 < sFileName.length()) {
                sFileName = sFileName.substring(nLoc + 1);
            }
            if ((nLoc = sFileName.lastIndexOf(46)) >= 0 && nLoc + 1 < sFileName.length()) {
                sExt = sFileName.substring(nLoc + 1);
            }
        }
        return sExt;
    }

    private File GetFileOnDisk(boolean bIsDir, String sKey) {
        File fRetFile = null;
        if (this.GetCacheDir() != null) {
            if (!bIsDir) {
                if (sKey != null && !sKey.isEmpty()) {
                    File[] afSubFiles = this.GetCacheDir().listFiles();
                    for (int nIdx = 0; nIdx < afSubFiles.length; ++nIdx) {
                        File fNext = afSubFiles[nIdx];
                        if (fNext == null || !fNext.exists()) continue;
                        String sName = fNext.getName();
                        if (sKey.equals(KEY_EXT_NONE) && sName.startsWith(KEY_EXT_NONE)) {
                            fRetFile = fNext;
                            break;
                        }
                        String sExt = this.GetExt(fNext.getAbsolutePath());
                        if (sExt == null || sExt.isEmpty() || !sExt.equals(sKey)) continue;
                        fRetFile = fNext;
                        break;
                    }
                    if (fRetFile == null || !fRetFile.exists()) {
                        String sKeyLower;
                        String sFileName = sKeyLower = sKey.toLowerCase();
                        if (!sKeyLower.equals(KEY_EXT_NONE.toLowerCase())) {
                            if (!sFileName.endsWith(".")) {
                                sFileName = sFileName + ".";
                            }
                            sFileName = sFileName + sKeyLower;
                        } else {
                            sFileName = KEY_EXT_NONE;
                        }
                        fRetFile = this.CreateFileOnDisk(sFileName);
                    }
                }
            } else if (CLocalFileSystem.GetLocalFileSystem().IsARoot(sKey)) {
                fRetFile = CLocalFileSystem.GetLocalFileSystem().GetRoot(sKey);
            } else if (sKey != null && sKey.endsWith(CLocalFileSystem.GetLocalFileSystem().GetRootPath())) {
                fRetFile = CLocalFileSystem.GetLocalFileSystem().GetJavaFile(sKey);
            } else {
                String sFolder = this.GetCacheDir().getAbsolutePath();
                if (!sFolder.endsWith(File.separator)) {
                    sFolder = sFolder + File.separator;
                }
                sFolder = sFolder + NAME_FOLDER;
                fRetFile = CLocalFileSystem.GetLocalFileSystem().CreateAllLocalDirs(sFolder);
            }
        }
        return fRetFile;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_LONG_FILE_EXT = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_CACHE_KEYS = false;
    }
}

