/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.files;

import com.rhinosoft.attrs.CConnectionAttrs;
import com.rhinosoft.files.CFile;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CThumbnailMsg;
import com.rhinosoft.messages.CThumbnailMsg_Remote;
import com.rhinosoft.strings.CString;
import com.rhinosoft.ui.CRhinoApp;
import java.io.File;

public class CRemoteFile
extends CFile {
    private static File m_fCacheRoot;
    private String m_sAbsPath;

    public CRemoteFile(String sAbsPath, boolean bIsDir) {
        this._CRemoteFile(sAbsPath, bIsDir);
    }

    private void _CRemoteFile(String sAbsPath, boolean bIsDir) {
        this.m_sAbsPath = sAbsPath;
        this.SetIsDirectory(bIsDir);
        this.SetName(CString.GetFileName(this.m_sAbsPath));
        this.InitFileInfoFromLocalCache();
    }

    @Override
    public void Copy(CFile rCopyFrom) {
        super.Copy(rCopyFrom);
        if (rCopyFrom != null) {
            CRemoteFile rCopyFromRemote = (CRemoteFile)rCopyFrom;
            this.m_sAbsPath = rCopyFromRemote.m_sAbsPath;
        }
    }

    @Override
    public char GetFileSeparatorChar() {
        return '/';
    }

    @Override
    public String GetFileSeparator() {
        return "/";
    }

    @Override
    public boolean IsLocal() {
        return false;
    }

    @Override
    public boolean IsRemote() {
        return true;
    }

    public static void SetCacheRoot(String sCacheRoot) {
        m_fCacheRoot = null;
        if (sCacheRoot != null && !sCacheRoot.isEmpty()) {
            m_fCacheRoot = new File(sCacheRoot);
        }
    }

    public static File GetCacheRoot() {
        return m_fCacheRoot;
    }

    private String PrepPath(String sAbsPath) {
        StringBuilder sbTemp = new StringBuilder(sAbsPath);
        int nIdx = sbTemp.indexOf(":");
        if (nIdx >= 0 && nIdx < sAbsPath.length()) {
            sbTemp = sbTemp.deleteCharAt(nIdx);
        }
        sbTemp = CString.SwapChars(sbTemp, '/', File.separatorChar);
        if (CRemoteFile.GetCacheRoot() != null) {
            String sCachePath = CRemoteFile.GetCacheRoot().getPath();
            sCachePath = CString.EnsureLastCharIsNotAFileSeparator(sCachePath);
            sbTemp = CString.EnsureFirstChar(Character.valueOf(File.separatorChar), sbTemp);
            sbTemp.insert(0, sCachePath);
        } else if (DEBUG) {
            CDebugLog.ASSERT(CRemoteFile.class.getName(), CDebugLog.GetLineNumber(), "Programming error, CacheRoot is null");
        }
        return sbTemp.toString();
    }

    @Override
    public String GetAbsPath() {
        return this.m_sAbsPath;
    }

    @Override
    protected CThumbnailMsg CreateThumbnailMsg(CConnectionAttrs rConnAttrs, long lUISourceAttrID, int nWidth, int nHeight, boolean bIsPreview) {
        CThumbnailMsg_Remote rThumbMsg = null;
        if (this.IsImage() && rConnAttrs != null) {
            rThumbMsg = new CThumbnailMsg_Remote(rConnAttrs.GetHost(), rConnAttrs.GetServerPort(), rConnAttrs.IsSecure(), rConnAttrs.GetHeaderPort(), rConnAttrs.GetUserAgent(), rConnAttrs.GetEncSessionID(), lUISourceAttrID, this.GetAbsPath(), this.IsDirectory(), nWidth, nHeight, bIsPreview);
        }
        return rThumbMsg;
    }

    @Override
    protected String GetThumbCacheRootDir() {
        String sRet = "Remote";
        if (CRhinoApp.GET_RHINO_APP() != null) {
            sRet = CRhinoApp.GET_RHINO_APP().GetHost();
        }
        return sRet;
    }
}

