/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.files;

import com.rhinosoft.attrs.CConnectionAttrs;
import com.rhinosoft.files.CFile;
import com.rhinosoft.files.WindowsLink.CWindowsLink;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CThumbnailMsg;
import com.rhinosoft.messages.CThumbnailMsg_Local;
import com.rhinosoft.threads.CLocalFileSystem;
import java.io.File;
import javax.swing.filechooser.FileSystemView;

public class CLocalFile
extends CFile {
    private File m_fFile;
    private String m_sDisplayName;

    public CLocalFile(File fFile) {
        this.InitFile(fFile);
    }

    @Override
    public void Destroy() {
        this.m_fFile = null;
        super.Destroy();
    }

    @Override
    public void Copy(CFile rCopyFrom) {
        super.Copy(rCopyFrom);
        if (rCopyFrom != null) {
            CLocalFile rCopyFromLocal = (CLocalFile)rCopyFrom;
            if (rCopyFromLocal.m_fFile != null) {
                this.m_fFile = new File(rCopyFromLocal.m_fFile.getAbsolutePath());
            }
            this.m_sDisplayName = rCopyFromLocal.m_sDisplayName;
        }
    }

    private void InitFile(File fFile) {
        boolean bExists;
        block7: {
            bExists = false;
            try {
                bExists = fFile.exists();
            }
            catch (SecurityException se) {
                if (!DEBUG) break block7;
                se.printStackTrace();
            }
        }
        if (fFile != null && bExists) {
            this.m_fFile = fFile;
            FileSystemView fsv = FileSystemView.getFileSystemView();
            this.SetDisplayName(fsv.getSystemDisplayName(fFile));
            this.SetIsDrive(fsv.isDrive(fFile));
            String sName = fFile.getName();
            if (!CLocalFile.IsValid(sName)) {
                sName = fFile.getAbsolutePath();
            }
            this.SetName(sName);
            boolean bIsDir = fFile.isDirectory();
            if (!bIsDir && FileSystemView.getFileSystemView().isTraversable(fFile).booleanValue()) {
                bIsDir = true;
            }
            this.SetIsDirectory(bIsDir);
            if (!bIsDir) {
                this.SetSize(fFile.length());
            } else {
                this.SetSize(0L);
            }
            this.SetTimestampModified(fFile.lastModified());
            this.SetUpDirEnabled(fFile.getParentFile() != null);
            this.SetIsReadOnly(!fFile.canWrite());
            this.InitLink(fFile);
            this.SetIsHidden(fFile.isHidden());
            this.SetHasListing(true);
            this.InitFileInfoFromLocalCache();
        }
    }

    public void SetDisplayName(String sName) {
        this.m_sDisplayName = sName;
    }

    @Override
    public String GetDisplayName() {
        return this.m_sDisplayName;
    }

    @Override
    public char GetFileSeparatorChar() {
        return File.separatorChar;
    }

    @Override
    public String GetFileSeparator() {
        return File.separator;
    }

    public static File GetParent(File fFile) {
        File fParent = null;
        if (fFile != null && (fParent = fFile.getParentFile()) == null) {
            fParent = FileSystemView.getFileSystemView().getParentDirectory(fFile);
        }
        return fParent;
    }

    @Override
    public boolean IsLocal() {
        return true;
    }

    @Override
    public boolean IsRemote() {
        return false;
    }

    @Override
    public void GetAbsPath(CFile rFile, StringBuilder rsRetAbsPath) {
        if (rFile != null && rsRetAbsPath != null) {
            CLocalFile fLocal = (CLocalFile)rFile;
            if (fLocal.m_fFile != null) {
                rsRetAbsPath.append(fLocal.m_fFile.getAbsolutePath());
            } else if (DEBUG) {
                CDebugLog.ASSERT(CLocalFile.class.getName(), CDebugLog.GetLineNumber(), "Programming error, why is fLocal.m_fFile is null?");
            }
        }
    }

    @Override
    protected CThumbnailMsg CreateThumbnailMsg(CConnectionAttrs rConnAttrs, long lUISourceAttrID, int nWidth, int nHeight, boolean bIsPreview) {
        CThumbnailMsg_Local rThumbMsg = null;
        if (rConnAttrs != null) {
            rThumbMsg = new CThumbnailMsg_Local(rConnAttrs.GetHost(), rConnAttrs.GetServerPort(), rConnAttrs.IsSecure(), rConnAttrs.GetHeaderPort(), rConnAttrs.GetUserAgent(), rConnAttrs.GetEncSessionID(), lUISourceAttrID, this.GetAbsPath(), this.IsDirectory(), nWidth, nHeight, bIsPreview);
        }
        return rThumbMsg;
    }

    @Override
    protected String GetThumbCacheRootDir() {
        return "Local";
    }

    public File GetLinkTarget() {
        File fTargetFile = null;
        if (this.IsLink()) {
            fTargetFile = new File(this.GetLinkPath());
        }
        return fTargetFile;
    }

    public static boolean IsWindowsLink(String sPath) {
        boolean bIsWindowsLink = false;
        if (CLocalFileSystem.GetLocalFileSystem() != null && CLocalFileSystem.GetLocalFileSystem().IsWindows() && sPath != null && !sPath.isEmpty() && (sPath = sPath.toLowerCase()).endsWith(".lnk")) {
            bIsWindowsLink = true;
        }
        return bIsWindowsLink;
    }

    private void InitLink(File fFile) {
        File fTarget;
        CWindowsLink link;
        String sPath;
        if (fFile != null && CLocalFile.IsWindowsLink(fFile.getAbsolutePath()) && (sPath = (link = new CWindowsLink(fFile.getAbsolutePath())).GetResolvedPath()) != null && !sPath.isEmpty() && (fTarget = new File(sPath)) != null) {
            this.SetIsLink(true);
            this.SetLinkPath(fTarget.getAbsolutePath());
        }
    }
}

