/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.files;

import com.rhinosoft.attrs.CAttrs;
import com.rhinosoft.files.CFile;
import com.rhinosoft.files.CRemoteFile;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.utils.CNaturalSort;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class CFiles
extends CAttrs {
    private int m_nNumOfDirs = 0;
    private int m_nNumOfFiles = 0;
    private Vector<CFile> m_afFiles;
    private HashMap<String, CFile> m_afFilesMap;
    private boolean m_bAutoSort;
    private Locale m_Locale;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CFiles rFiles = new CFiles(true, null);
                File fDir = new File("D:\\Temp\\_DnDTest");
                if (fDir.exists()) {
                    File[] aChildren = fDir.listFiles();
                    for (int nIdx = 0; nIdx < aChildren.length; ++nIdx) {
                        File fNext = aChildren[nIdx];
                        CRemoteFile rFile = new CRemoteFile(fNext.getAbsolutePath(), fNext.isDirectory());
                        rFiles.AddFile(rFile);
                    }
                }
                for (int nIdx = 0; nIdx < rFiles.GetNumOfChildFiles(); ++nIdx) {
                    CFile rFile = rFiles.GetFile(nIdx);
                    if (rFile == null) continue;
                    System.out.printf("%s (%s)\r\n", rFile.GetAbsPath(), Boolean.toString(rFile.IsDirectory()));
                }
            }
        });
    }

    public CFiles() {
        this._CFiles(false, null);
    }

    public CFiles(boolean bAutoSort, Locale rLocale) {
        this._CFiles(bAutoSort, rLocale);
    }

    private void _CFiles(boolean bAutoSort, Locale rLocale) {
        this.m_afFiles = new Vector();
        this.m_afFilesMap = new HashMap();
        this.m_bAutoSort = bAutoSort;
        this.m_Locale = rLocale;
    }

    @Override
    public void Destroy() {
        if (this.m_afFiles != null) {
            for (int nIdx = 0; nIdx < this.m_afFiles.size(); ++nIdx) {
                CFile fFile = this.m_afFiles.get(nIdx);
                if (fFile == null) continue;
                fFile.Destroy();
            }
            this.m_afFiles.clear();
        }
        this.m_afFiles = null;
        if (this.m_afFilesMap != null) {
            this.m_afFilesMap.clear();
        }
        this.m_afFilesMap = null;
        this.m_Locale = null;
        super.Destroy();
    }

    protected Locale GetLocale() {
        return this.m_Locale;
    }

    protected void SetLocale(Locale rLocale) {
        this.m_Locale = rLocale;
    }

    public void AddFile(CFile fFile) {
        if (fFile != null) {
            if (this.m_bAutoSort) {
                int nInsertIdx = this.GetInsertIndex(fFile);
                this.m_afFiles.add(nInsertIdx, fFile);
            } else {
                this.m_afFiles.add(fFile);
            }
            this.m_afFilesMap.put(fFile.GetAbsPath(), fFile);
            if (fFile.IsDirectory() || fFile.IsDrive()) {
                ++this.m_nNumOfDirs;
            } else {
                ++this.m_nNumOfFiles;
            }
        }
    }

    public void RemoveFile(CFile fFile) {
        if (fFile != null) {
            this.m_afFilesMap.remove(fFile.GetAbsPath());
            if (this.m_afFiles.remove(fFile)) {
                if (fFile.IsDirectory() || fFile.IsDrive()) {
                    --this.m_nNumOfDirs;
                } else {
                    --this.m_nNumOfFiles;
                }
            }
        }
    }

    public void RemoveAll() {
        this.m_afFiles.removeAllElements();
        this.m_afFilesMap.clear();
        this.m_nNumOfDirs = 0;
        this.m_nNumOfFiles = 0;
    }

    public int GetNumOfChildFiles() {
        if (DEBUG && this.m_afFiles.size() != this.m_afFilesMap.size()) {
            CDebugLog.ASSERT(CFiles.class.getName(), CDebugLog.GetLineNumber(), "Internal Vector size doesn't match HashMap size!");
        }
        return this.m_afFiles.size();
    }

    public CFile GetFile(String sAbsPath) {
        return this.m_afFilesMap.get(sAbsPath);
    }

    public CFile GetFile(int nIndex) {
        CFile fRetFile = null;
        if (this.m_afFiles != null && nIndex < this.m_afFiles.size()) {
            fRetFile = this.m_afFiles.get(nIndex);
        }
        return fRetFile;
    }

    public boolean SetAutoSort(boolean bAutoSort) {
        boolean bIsSet = false;
        if (bAutoSort) {
            if (this.m_afFiles.size() < 1) {
                this.m_bAutoSort = true;
                bIsSet = true;
            }
        } else {
            this.m_bAutoSort = false;
            bIsSet = true;
        }
        return bIsSet;
    }

    private int GetFirstFileIndex() {
        int nFirstFileIdx = -1;
        nFirstFileIdx = this.m_nNumOfDirs;
        return nFirstFileIdx;
    }

    private int GetInsertIndex(CFile fFile) {
        int nInsertIndex = this.m_afFiles.size();
        if (fFile != null) {
            int nFirstFileIdx = this.GetFirstFileIndex();
            int nFirst = 0;
            int nLast = this.m_afFiles.size() - 1;
            if (nFirstFileIdx > -1) {
                if (fFile.IsDirectory()) {
                    nLast = nFirstFileIdx;
                } else {
                    nFirst = nFirstFileIdx;
                }
            }
            boolean bIsFirstDir = this.m_nNumOfDirs < 1;
            int nMid = this.m_afFiles.size();
            while (nFirst <= nLast && (nMid = (nFirst + nLast) / 2) >= 0 && nMid < this.m_afFiles.size()) {
                CFile fNext = this.m_afFiles.get(nMid);
                if (fNext == null) continue;
                if (fFile.IsDirectory() && fNext.IsDirectory() || !fFile.IsDirectory() && !fNext.IsDirectory()) {
                    int nResult = CNaturalSort.Sort(true, fFile.GetDisplayName(), fNext.GetDisplayName(), false, this.GetLocale());
                    nInsertIndex = nMid;
                    if (nResult == 0) break;
                    if (nResult < 0) {
                        nLast = nMid - 1;
                    } else if (nResult > 0) {
                        nFirst = nMid + 1;
                    }
                    if (nFirst < nLast) continue;
                    nInsertIndex = nFirst;
                    continue;
                }
                if (!bIsFirstDir) break;
                nInsertIndex = 0;
                break;
            }
        }
        if (nInsertIndex < 0) {
            nInsertIndex = 0;
        } else if (nInsertIndex > this.m_afFiles.size()) {
            nInsertIndex = this.m_afFiles.size();
        }
        return nInsertIndex;
    }
}

