/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.files;

import com.rhinosoft.archive.IArchive;
import com.rhinosoft.attrs.CConnectionAttrs;
import com.rhinosoft.files.CFiles;
import com.rhinosoft.images.CImageUtil;
import com.rhinosoft.messages.CThumbnailMsg;
import com.rhinosoft.strings.CString;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.threads.CWorkerThread;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.utils.CDateFormatStringVerifier;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class CFile
extends CFiles {
    public static final String THUMB_DIVIDER = "x";
    public static final String THUMB_EXTENSION = ".jpg";
    private boolean m_bIsDir;
    private String m_sName;
    private long m_lSize;
    private String m_sType;
    private long m_lTimestampModified;
    private long m_lTimestampAccessed;
    private long m_lTimestampCreated;
    private boolean m_bUpDirEnabled;
    private boolean m_bIsDrive;
    private int m_nDriveType;
    private String m_sDriveLabel;
    private boolean m_bIsReadOnly;
    private boolean m_bIsLink;
    private String m_sAbsLinkPath;
    private boolean m_bIsImage;
    private boolean m_bIsHidden;
    private boolean m_bIsArchived;
    private boolean m_bIsNormal;
    private boolean m_bIsCompressed;
    private boolean m_bIsEncrypted;
    private boolean m_bIsAudio;
    private boolean m_bIsVideo;
    private CFile m_rParent;
    private boolean m_bHasListing;
    private Icon m_Icon16;
    private Icon m_Icon32;
    private Icon m_IconPreview;

    public CFile(String sName, boolean bIsDir) {
        this._CFile(sName, bIsDir);
    }

    protected CFile() {
    }

    private void _CFile(String sName, boolean bIsDir) {
        this.m_sName = sName;
        this.m_bIsDir = bIsDir;
        this.m_bHasListing = !this.m_bIsDir;
    }

    @Override
    public void Destroy() {
        this.m_rParent = null;
        super.Destroy();
    }

    public void Copy(CFile rCopyFrom) {
        if (rCopyFrom != null) {
            this.m_bIsDir = rCopyFrom.m_bIsDir;
            this.m_sName = rCopyFrom.m_sName;
            this.m_lSize = rCopyFrom.m_lSize;
            this.m_sType = rCopyFrom.m_sType;
            this.m_lTimestampModified = rCopyFrom.m_lTimestampModified;
            this.m_lTimestampAccessed = rCopyFrom.m_lTimestampAccessed;
            this.m_lTimestampCreated = rCopyFrom.m_lTimestampCreated;
            this.m_bUpDirEnabled = rCopyFrom.m_bUpDirEnabled;
            this.m_bIsDrive = rCopyFrom.m_bIsDrive;
            this.m_nDriveType = rCopyFrom.m_nDriveType;
            this.m_sDriveLabel = rCopyFrom.m_sDriveLabel;
            this.m_bIsReadOnly = rCopyFrom.m_bIsReadOnly;
            this.m_bIsLink = rCopyFrom.m_bIsLink;
            this.m_sAbsLinkPath = rCopyFrom.m_sAbsLinkPath;
            this.m_bIsImage = rCopyFrom.m_bIsImage;
            this.m_bIsHidden = rCopyFrom.m_bIsHidden;
            this.m_bIsArchived = rCopyFrom.m_bIsArchived;
            this.m_bIsNormal = rCopyFrom.m_bIsNormal;
            this.m_bIsCompressed = rCopyFrom.m_bIsCompressed;
            this.m_bIsEncrypted = rCopyFrom.m_bIsEncrypted;
            this.m_bIsAudio = rCopyFrom.m_bIsAudio;
            this.m_bIsVideo = rCopyFrom.m_bIsVideo;
            this.m_bHasListing = rCopyFrom.m_bHasListing;
            this.m_Icon16 = rCopyFrom.m_Icon16;
            this.m_Icon32 = rCopyFrom.m_Icon32;
            this.m_IconPreview = rCopyFrom.m_IconPreview;
        }
    }

    public abstract char GetFileSeparatorChar();

    public abstract String GetFileSeparator();

    protected abstract CThumbnailMsg CreateThumbnailMsg(CConnectionAttrs var1, long var2, int var4, int var5, boolean var6);

    protected abstract String GetThumbCacheRootDir();

    protected void InitFileInfoFromLocalCache() {
        Icon ico16 = null;
        Icon ico32 = null;
        String sType = "";
        if (CRhinoApp.GET_RHINO_APP() != null) {
            ico16 = CRhinoApp.GET_RHINO_APP().GetIcon16(this);
            ico32 = CRhinoApp.GET_RHINO_APP().GetIcon32(this);
            sType = CRhinoApp.GET_RHINO_APP().GetType(this);
        }
        this.SetIcon16(ico16);
        this.SetIcon32(ico32);
        this.SetType(sType);
    }

    public void SetName(String sName) {
        this.m_sName = sName;
    }

    public String GetName() {
        return this.m_sName;
    }

    public String GetDisplayName() {
        return this.GetName();
    }

    public void SetIsDirectory(boolean bVal) {
        this.m_bIsDir = bVal;
    }

    public boolean IsDirectory() {
        return this.m_bIsDir;
    }

    public void SetIsDrive(boolean bVal) {
        this.m_bIsDrive = bVal;
    }

    public boolean IsDrive() {
        return this.m_bIsDrive;
    }

    public void SetType(String sType) {
        this.m_sType = sType;
    }

    public String GetType() {
        return this.m_sType;
    }

    public void SetSize(long lSize) {
        this.m_lSize = lSize;
    }

    public long GetSize() {
        return this.m_lSize;
    }

    public void SetTimestampModified(long lTimestamp) {
        this.m_lTimestampModified = lTimestamp;
    }

    public void SetTimestampAccessed(long lTimestamp) {
        this.m_lTimestampAccessed = lTimestamp;
    }

    public void SetTimestampCreated(long lTimestamp) {
        this.m_lTimestampCreated = lTimestamp;
    }

    public void SetUpDirEnabled(boolean bEnabled) {
        this.m_bUpDirEnabled = bEnabled;
    }

    public int GetDriveType() {
        return this.m_nDriveType;
    }

    public void SetDriveType(int nDriveType) {
        this.m_nDriveType = nDriveType;
    }

    public String GetDriveLabel() {
        return this.m_sDriveLabel;
    }

    public void SetDriveLabel(String sLabel) {
        this.m_sDriveLabel = sLabel;
    }

    public void SetIsReadOnly(boolean bVal) {
        this.m_bIsReadOnly = bVal;
    }

    public boolean IsReadOnly() {
        return this.m_bIsReadOnly;
    }

    public boolean IsLink() {
        return this.m_bIsLink;
    }

    public void SetIsLink(boolean bVal) {
        this.m_bIsLink = bVal;
    }

    public void SetLinkPath(String sAbsLinkPath) {
        this.m_sAbsLinkPath = sAbsLinkPath;
    }

    public String GetLinkPath() {
        return this.m_sAbsLinkPath;
    }

    public boolean IsImage() {
        return this.m_bIsImage;
    }

    public void SetIsImage(boolean bVal) {
        this.m_bIsImage = bVal;
    }

    public void SetIsHidden(boolean bVal) {
        this.m_bIsHidden = bVal;
    }

    public void SetIsArchived(boolean bVal) {
        this.m_bIsArchived = bVal;
    }

    public void SetIsNormal(boolean bVal) {
        this.m_bIsNormal = bVal;
    }

    public boolean IsCompressed() {
        return this.m_bIsCompressed;
    }

    public void SetIsCompressed(boolean bVal) {
        this.m_bIsCompressed = bVal;
    }

    public boolean IsEncrypted() {
        return this.m_bIsEncrypted;
    }

    public void SetIsEncrypted(boolean bVal) {
        this.m_bIsEncrypted = bVal;
    }

    public boolean IsAudio() {
        return this.m_bIsAudio;
    }

    public void SetIsAudio(boolean bVal) {
        this.m_bIsAudio = bVal;
    }

    public boolean IsVideo() {
        return this.m_bIsVideo;
    }

    public void SetIsVideo(boolean bVal) {
        this.m_bIsVideo = bVal;
    }

    public void SetParent(CFile rParent) {
        this.m_rParent = rParent;
    }

    public CFile GetParent() {
        return this.m_rParent;
    }

    public void SetHasListing(boolean bVal) {
        this.m_bHasListing = bVal;
    }

    public boolean HasListing() {
        return this.m_bHasListing;
    }

    public Icon GetIcon16() {
        return this.m_Icon16;
    }

    public void SetIcon16(Icon icon) {
        this.m_Icon16 = icon;
    }

    public Icon GetIcon32() {
        return this.m_Icon32;
    }

    public void SetIcon32(Icon icon) {
        this.m_Icon32 = icon;
    }

    public String GetAbsPath() {
        StringBuilder sAbsPath = new StringBuilder();
        this.GetAbsPath(this, sAbsPath);
        return sAbsPath.toString();
    }

    protected void GetAbsPath(CFile rFile, StringBuilder rsRetAbsPath) {
        if (rFile != null && rsRetAbsPath != null) {
            while (rFile.GetParent() != null) {
                this.GetAbsPath(rFile.GetParent(), rsRetAbsPath);
            }
            rsRetAbsPath.append(rFile.GetName());
            rsRetAbsPath = CString.EnsureLastChar(Character.valueOf(this.GetFileSeparatorChar()), rsRetAbsPath);
        }
    }

    private String FmtLine(String sName, String sValue) {
        return String.format("%20s:%80s\r\n", sName, sValue);
    }

    @Override
    public String toString() {
        StringBuilder sRet = new StringBuilder();
        sRet.append(String.format("%s\r\n", this.GetDisplayName()));
        return CString.EnsureLastSubString("\r\n", sRet.toString());
    }

    public abstract boolean IsLocal();

    public abstract boolean IsRemote();

    public boolean IsRoot() {
        boolean bIsRoot = false;
        if (this.GetAbsPath().equals("/")) {
            bIsRoot = true;
        }
        return bIsRoot;
    }

    @Override
    public String GetArchiveKey() {
        return this.GetAbsPath();
    }

    public static String FormatFileSize(long lFileSize) {
        return CFile.FormatFileSize(lFileSize, true);
    }

    private static String FormatFileSize(long lFileSize, boolean bUseDecimal) {
        String sStr = !bUseDecimal ? CString.FormatNumOfBytes(lFileSize, false) : CString.FormatNumOfBytesDouble(lFileSize, false, 2);
        return sStr;
    }

    public static boolean GetDefaultShowDST() {
        boolean bDefault = false;
        if (CLocalFileSystem.GetLocalFileSystem().IsWindows()) {
            bDefault = true;
        }
        return bDefault;
    }

    public static String GetDefaultDatePattern() {
        String sPattern = "M/d/yy h:mm a";
        SimpleDateFormat Formatter = new SimpleDateFormat();
        sPattern = Formatter.toPattern();
        Formatter = null;
        return sPattern;
    }

    public static String FormatFileTimestamp(Date dtGMT, IArchive rArchive, boolean bSetToCST) {
        String sRet = "";
        if (dtGMT != null && dtGMT.getTime() > 0L) {
            boolean bShowDST = CFile.GetDefaultShowDST();
            String sDateFmtString = CFile.GetDefaultDatePattern();
            if (rArchive != null) {
                Boolean bVal = rArchive.GetValueBool("ShowDST", bShowDST);
                if (bVal != null) {
                    bShowDST = bVal;
                }
                if ((bVal = rArchive.GetValueBool("UseDateFormatString", false)) != null && bVal.booleanValue()) {
                    sDateFmtString = rArchive.GetValue("DateFormatString", CFile.GetDefaultDatePattern());
                }
            }
            Date dtAdjusted = CLocalFileSystem.GetLocalFileSystem().AdjustToLocal(dtGMT, bShowDST);
            sRet = CDateFormatStringVerifier.Format(sDateFmtString, dtAdjusted, bSetToCST, CFile.GetDefaultDatePattern());
        }
        return sRet;
    }

    public Date GetDateModified() {
        Date dtRet = null;
        if (this.GetTimestampModified() > 0L) {
            dtRet = new Date(this.GetTimestampModified());
        }
        return dtRet;
    }

    public long GetTimestampModified() {
        return this.m_lTimestampModified;
    }

    public static String GetAbsPathThumbFolder(String sAbsPath, String sThumbRootDir) {
        String sThumbCacheFolder = null;
        String sAbsThumbRootDir = null;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            sAbsThumbRootDir = CRhinoApp.GET_RHINO_APP().GetLocalStoragePathThumbnailRoot(sThumbRootDir);
        }
        if (sAbsThumbRootDir != null && !sAbsThumbRootDir.isEmpty() && sAbsPath != null && !sAbsPath.isEmpty()) {
            sAbsPath = sAbsPath.replaceAll(":", "");
            sAbsPath = CString.MakeFileSeparators(sAbsPath);
            sThumbCacheFolder = CString.EnsureLastCharIsAFileSeparator(sAbsThumbRootDir);
            sThumbCacheFolder = sThumbCacheFolder + CString.EnsureFirstCharIsNotAFileSeparator(sAbsPath);
        }
        return sThumbCacheFolder;
    }

    public static String GetAbsPathThumbFile(String sAbsPathThumbFolder, int nWidth, int nHeight) {
        String sAbsThumbPath = null;
        if (sAbsPathThumbFolder != null && !sAbsPathThumbFolder.isEmpty()) {
            sAbsThumbPath = CString.EnsureLastCharIsAFileSeparator(sAbsPathThumbFolder);
            sAbsThumbPath = String.format("%s%d%s%d%s", sAbsThumbPath, nWidth, THUMB_DIVIDER, nHeight, THUMB_EXTENSION);
        }
        return sAbsThumbPath;
    }

    public static String GetAbsPathThumbFile(String sAbsPathSource, String sThumbRootDir, int nWidth, int nHeight) {
        return CFile.GetAbsPathThumbFile(CFile.GetAbsPathThumbFolder(sAbsPathSource, sThumbRootDir), nWidth, nHeight);
    }

    public Icon GetThumbnail(boolean bIsPreview, int nWidth, int nHeight, CWorkerThread rThread, CConnectionAttrs rConnAttrs, long lUISourceAttrID, CThumbnailMsg[] arRetThumbMsg) {
        CThumbnailMsg rThumbMsg;
        Icon rThumb = null;
        if (bIsPreview && this.m_IconPreview != null) {
            rThumb = this.m_IconPreview;
        } else {
            String sAbsCachedThumbPath = CFile.GetAbsPathThumbFile(this.GetAbsPath(), this.GetThumbCacheRootDir(), nWidth, nHeight);
            if (sAbsCachedThumbPath != null && !sAbsCachedThumbPath.isEmpty()) {
                ImageIcon rImageIcon = CImageUtil.GetImageFromFile(sAbsCachedThumbPath);
                if (rImageIcon != null) {
                    rThumb = rImageIcon;
                }
            } else {
                rThumb = this.GetIcon32();
            }
        }
        if (rThread != null && (rThumbMsg = this.CreateThumbnailMsg(rConnAttrs, lUISourceAttrID, nWidth, nHeight, bIsPreview)) != null) {
            rThread.NewMessage(rThumbMsg);
            if (arRetThumbMsg != null) {
                arRetThumbMsg[0] = rThumbMsg;
            }
        }
        return rThumb;
    }
}

