/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dragdrop;

import com.rhinosoft.attrs.CAttrs;
import com.rhinosoft.dragdrop.CDndFile;
import com.rhinosoft.dragdrop.CDndMsg;
import com.rhinosoft.dragdrop.CFilesDragDropData;
import com.rhinosoft.dragdrop.CRhinoDragDropData;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.messages.CUIMessage;
import com.rhinosoft.threads.CLocalFileSystem;
import com.rhinosoft.ui.CRhinoApp;
import com.rhinosoft.ui.CRhinoEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public abstract class CRhinoDragDropHandler
extends TransferHandler {
    protected static final boolean DEBUG = CAttrs.DEBUG;
    protected static final boolean DEBUG_TRACE_METHODS;
    public static final boolean DEBUG_TRACK_CURSOR_FLICKER = false;
    public static final boolean DEBUG_TRACK_CREATE_TRANSFERRABLE;
    public static final boolean DEBUG_TRACK_RIGHT_CLICK;
    public static final boolean DEBUG_TRACK_CAN_IMPORT;
    public static final boolean DEBUG_TRACK_DROP_ACTION;
    public static final boolean DEBUG_TRACK_IMPORT_DATA;
    public static final boolean DEBUG_TRACK_EXPORT_DONE;
    public static final boolean DEBUG_TRACK_DRIVES = false;
    public static final boolean DEBUG_TRACK_MAC = false;
    public static final boolean DEBUG_DROP_ACTION_NIX = false;
    public static final boolean DEBUG_DROP_ACTION_MAC = false;
    public static final boolean DEBUG_DROP_ACTION_WINDOWS = false;
    private CRhinoDragDropData m_DragDropData;
    private Component m_rOwner;
    private CDndMsg m_InitDragDataMsg;
    private CDndMsg m_InitDropDataMsg;
    private CDndMsg m_ImportDropDataMsg;
    private int m_nTransferableCounter = 0;
    private int m_nCanImportCounter = 0;
    private int m_nImportDataCounter = 0;
    private int m_nExportDoneCounter = 0;

    public CRhinoDragDropHandler(Component rOwner) {
        this._CRhinoDragDropHandler(rOwner);
    }

    private void _CRhinoDragDropHandler(Component rOwner) {
        this.m_rOwner = rOwner;
        this.m_DragDropData = this.CreateDragDropData();
        this.m_InitDragDataMsg = CDndMsg.CreateInitDragDataMsg(rOwner);
        this.m_InitDropDataMsg = CDndMsg.CreateInitDropDataMsg(rOwner);
        this.m_ImportDropDataMsg = CDndMsg.CreateImportDropDataMsg(rOwner);
    }

    protected abstract CRhinoDragDropData CreateDragDropData();

    protected void ResetVars(Component rComp) {
        if (this.GetDragDropData() != null) {
            this.GetDragDropData().Reset();
        }
        if (rComp != null && rComp instanceof JComponent) {
            ((JComponent)rComp).putClientProperty("DndRightClick", null);
        }
    }

    protected CRhinoDragDropData GetDragDropData() {
        return this.m_DragDropData;
    }

    @Override
    public int getSourceActions(JComponent rComp) {
        if (DEBUG_TRACE_METHODS) {
            CDebugLog.ENTERING(CRhinoDragDropHandler.class.getName(), "getSourceActions");
            CDebugLog.INFO("    " + rComp.getClass().getName());
        }
        if (DEBUG_TRACE_METHODS) {
            CDebugLog.EXITING(CRhinoDragDropHandler.class.getName(), "getSourceActions");
        }
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent rDragSourceComp) {
        if (DEBUG_TRACK_CREATE_TRANSFERRABLE) {
            CDebugLog.ENTERING(CRhinoDragDropHandler.class.getName(), String.format("createTransferable | Count: %d", this.m_nTransferableCounter));
            CDebugLog.INFO(String.format("    Comp: %s", rDragSourceComp.getClass().getName()));
        }
        if (rDragSourceComp != null) {
            this.m_InitDragDataMsg.SetSource(rDragSourceComp);
            if (this.GetDragDropData() != null) {
                this.GetDragDropData().SetDragSourceObj(rDragSourceComp);
            }
            this.m_InitDragDataMsg.SetDragDropData(this.GetDragDropData());
            rDragSourceComp.dispatchEvent(new CRhinoEvent(this.m_InitDragDataMsg));
            if (DEBUG && this.GetDragDropData() != null && !this.GetDragDropData().HasDragData()) {
                CDebugLog.INFO("CRhinoDragDropHandler.createTransferable | The drag source component didn't fill in the drag data.");
            }
        }
        if (DEBUG_TRACK_CREATE_TRANSFERRABLE) {
            CDebugLog.EXITING(CRhinoDragDropHandler.class.getName(), String.format("createTransferable | Count: %d", this.m_nTransferableCounter++));
        }
        return this.GetDragDropData();
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport rTransferSupport) {
        CRhinoDragDropData rDragDropData;
        boolean bCanImport = false;
        if (DEBUG_TRACK_CAN_IMPORT) {
            CDebugLog.ENTERING(CRhinoDragDropHandler.class.getName(), String.format("canImport | Count: %d", this.m_nCanImportCounter));
            CDebugLog.INFO(String.format("    Comp:  %s", rTransferSupport.getComponent().getClass().getName()));
        }
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().SetAllowJSObject(rTransferSupport.getComponent(), false);
        }
        if (rTransferSupport.getComponent() != null && rTransferSupport.isDrop() && (rDragDropData = this.GetDragDropData()) != null) {
            rDragDropData.CheckHasDragData(rTransferSupport);
            if (rDragDropData.HasDragData()) {
                this.m_InitDropDataMsg.SetSource(rTransferSupport.getComponent());
                this.m_InitDropDataMsg.SetTransferSupport(rTransferSupport);
                this.m_InitDropDataMsg.SetDragDropData(rDragDropData);
                rTransferSupport.getComponent().dispatchEvent(new CRhinoEvent(this.m_InitDropDataMsg));
                bCanImport = rDragDropData.GetCanImport();
                if (rDragDropData.IsRightClick() && this.IsLinux()) {
                    bCanImport = false;
                }
                if (bCanImport) {
                    this.SetDropAction(rTransferSupport, rDragDropData.GetCursorState());
                    rTransferSupport.setShowDropLocation(rDragDropData.GetShowDropLocation());
                }
            }
        }
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().SetAllowJSObject(rTransferSupport.getComponent(), true);
        }
        if (DEBUG_TRACK_CAN_IMPORT) {
            CDebugLog.EXITING(CRhinoDragDropHandler.class.getName(), String.format("canImport | Count: %d", this.m_nCanImportCounter++));
        }
        return bCanImport;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport rTransferSupport) {
        CRhinoDragDropData rDragDropData;
        boolean bImported = false;
        if (DEBUG_TRACK_IMPORT_DATA) {
            CDebugLog.ENTERING(CRhinoDragDropHandler.class.getName(), String.format("importData | Count: %d", this.m_nImportDataCounter));
            CDebugLog.INFO(String.format("    Comp:  %s", rTransferSupport.getComponent().getClass().getName()));
        }
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().SetAllowJSObject(rTransferSupport.getComponent(), false);
        }
        if ((rTransferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || rTransferSupport.isDataFlavorSupported(DataFlavor.stringFlavor)) && (rDragDropData = this.GetDragDropData()) != null) {
            rDragDropData.CheckHasDragData(rTransferSupport, true);
        }
        if (this.canImport(rTransferSupport) && rTransferSupport.isDrop() && (rDragDropData = this.GetDragDropData()) != null) {
            if (rDragDropData.HasDragData()) {
                if (DEBUG) {
                    CDebugLog.INFO("    Has drag data, so continue with the drop!");
                }
                if (rTransferSupport.getComponent() != null) {
                    this.m_ImportDropDataMsg.SetSource(rTransferSupport.getComponent());
                    this.m_ImportDropDataMsg.SetTransferSupport(rTransferSupport);
                    this.m_ImportDropDataMsg.SetDragDropData(rDragDropData);
                    if (DEBUG_TRACK_IMPORT_DATA) {
                        String sDroppedData = "";
                        if (rDragDropData instanceof CFilesDragDropData) {
                            CFilesDragDropData rData = (CFilesDragDropData)rDragDropData;
                            for (int nIdx = 0; nIdx < rData.GetFileCount(); ++nIdx) {
                                CDndFile rNext = rData.GetFile(nIdx);
                                if (rNext == null) continue;
                                sDroppedData = sDroppedData + String.format("    %s\r\n", rNext.GetAbsPath());
                            }
                        }
                        if (!sDroppedData.isEmpty()) {
                            CDebugLog.INFO(sDroppedData);
                        }
                    }
                    rTransferSupport.getComponent().dispatchEvent(new CRhinoEvent(this.m_ImportDropDataMsg));
                    bImported = rDragDropData.HasImportedData();
                    if (bImported) {
                        CUIMessage rMsg = new CUIMessage(4503, rTransferSupport.getComponent());
                        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new CRhinoEvent(rMsg));
                    }
                }
            } else if (DEBUG) {
                CDebugLog.INFO("    Can't continue because we're missing drag data!");
            }
        }
        if (rTransferSupport.getComponent() != null) {
            this.ResetVars(rTransferSupport.getComponent());
        } else {
            this.ResetVars(null);
        }
        if (CRhinoApp.GET_RHINO_APP() != null) {
            CRhinoApp.GET_RHINO_APP().SetAllowJSObject(rTransferSupport.getComponent(), true);
        }
        if (DEBUG_TRACK_IMPORT_DATA) {
            CDebugLog.EXITING(CRhinoDragDropHandler.class.getName(), String.format("importData | Count: %d", this.m_nImportDataCounter++));
        }
        return bImported;
    }

    @Override
    protected void exportDone(JComponent rComp, Transferable rTransferable, int nAction) {
        if (DEBUG_TRACK_EXPORT_DONE) {
            CDebugLog.ENTERING(CRhinoDragDropHandler.class.getName(), String.format("exportDone | Count: %d", this.m_nExportDoneCounter));
            CDebugLog.INFO(String.format("    Comp:  %s", rComp.getClass().getName()));
            CDebugLog.INFO(String.format("    Transferable:  %s", rTransferable.toString()));
        }
        this.ResetVars(rComp);
        if (DEBUG_TRACK_EXPORT_DONE) {
            CDebugLog.EXITING(CRhinoDragDropHandler.class.getName(), String.format("exportDone | Count: %d", this.m_nExportDoneCounter++));
        }
    }

    private boolean IsMac() {
        boolean bIsMac = false;
        if (CLocalFileSystem.GetLocalFileSystem() != null) {
            bIsMac = CLocalFileSystem.GetLocalFileSystem().IsMac();
        }
        return bIsMac;
    }

    private boolean IsLinux() {
        boolean bIsLinux = false;
        if (CLocalFileSystem.GetLocalFileSystem() != null) {
            bIsLinux = CLocalFileSystem.GetLocalFileSystem().IsNIX();
        }
        return bIsLinux;
    }

    private void SetDropAction(TransferHandler.TransferSupport rTransferSupport, int nDropAction) {
        block26: {
            if (DEBUG_TRACE_METHODS) {
                CDebugLog.ENTERING(CRhinoDragDropHandler.class.getName(), "SetDropAction");
            }
            if (DEBUG_TRACK_DROP_ACTION) {
                Object[] objectArray = new Object[2];
                Object object = (rTransferSupport.getDropAction() & 2) == 2 ? "Move" : ((rTransferSupport.getDropAction() & 1) == 1 ? "Copy" : (objectArray[0] = (rTransferSupport.getDropAction() & 0x40000000) == 0x40000000 ? "Link" : "Not supported"));
                objectArray[1] = (rTransferSupport.getUserDropAction() & 2) == 2 ? "Move" : ((rTransferSupport.getUserDropAction() & 1) == 1 ? "Copy" : ((rTransferSupport.getUserDropAction() & 0x40000000) == 0x40000000 ? "Link" : "Not supported"));
                CDebugLog.INFO(String.format("    IN | DropAction: %s | UserDropAction: %s", objectArray));
            }
            if (rTransferSupport != null) {
                if (rTransferSupport.isDrop()) {
                    if ((nDropAction & 1) == 1) {
                        if (DEBUG_TRACK_DROP_ACTION) {
                            CDebugLog.INFO("    DropAction is: COPY");
                        }
                        if ((1 & rTransferSupport.getSourceDropActions()) != 1) {
                            if (DEBUG_TRACK_DROP_ACTION) {
                                CDebugLog.INFO("    COPY is NOT supported. Changed dropAction to NONE.");
                            }
                            nDropAction = 0;
                        }
                    } else if ((nDropAction & 2) == 2) {
                        if (DEBUG_TRACK_DROP_ACTION) {
                            CDebugLog.INFO("    DropAction is: MOVE");
                        }
                        if ((2 & rTransferSupport.getSourceDropActions()) != 2) {
                            if (DEBUG_TRACK_DROP_ACTION) {
                                CDebugLog.INFO("    MOVE is NOT supported. Changed dropAction to NONE.");
                            }
                            nDropAction = 0;
                        }
                    } else if ((nDropAction & 0x40000000) == 0x40000000) {
                        if ((0x40000000 & rTransferSupport.getSourceDropActions()) != 0x40000000) {
                            if (DEBUG_TRACK_DROP_ACTION) {
                                CDebugLog.INFO("LINK is NOT supported. Changed dropAction to NONE.");
                            }
                            nDropAction = 0;
                        }
                    } else {
                        if (DEBUG_TRACK_DROP_ACTION) {
                            CDebugLog.INFO("    Nothing is supported. Changed dropAction to NONE.");
                        }
                        nDropAction = 0;
                    }
                }
                if (DEBUG_TRACK_DROP_ACTION) {
                    CDebugLog.INFO(String.format("    DropAction: %s", (rTransferSupport.getDropAction() & 2) == 2 ? "Move" : ((rTransferSupport.getDropAction() & 1) == 1 ? "Copy" : ((rTransferSupport.getDropAction() & 0x40000000) == 0x40000000 ? "Link" : "Not supported"))));
                }
                try {
                    rTransferSupport.setDropAction(nDropAction);
                }
                catch (Exception e) {
                    if (DEBUG_TRACK_DROP_ACTION) {
                        CDebugLog.INFO("    Exception -->");
                        Object[] objectArray = new Object[2];
                        Object object = (rTransferSupport.getDropAction() & 2) == 2 ? "Move" : ((rTransferSupport.getDropAction() & 1) == 1 ? "Copy" : (objectArray[0] = (rTransferSupport.getDropAction() & 0x40000000) == 0x40000000 ? "Link" : "Not supported"));
                        objectArray[1] = (rTransferSupport.getUserDropAction() & 2) == 2 ? "Move" : ((rTransferSupport.getUserDropAction() & 1) == 1 ? "Copy" : ((rTransferSupport.getUserDropAction() & 0x40000000) == 0x40000000 ? "Link" : "Not supported"));
                        CDebugLog.INFO(String.format("    DropAction: %s | UserDropAction: %s", objectArray));
                    }
                    if (DEBUG) {
                        e.printStackTrace();
                    }
                    if (!DEBUG_TRACK_DROP_ACTION) break block26;
                    CDebugLog.INFO("    Exception <--");
                }
            }
        }
        if (DEBUG_TRACK_DROP_ACTION) {
            Object[] objectArray = new Object[2];
            Object object = (rTransferSupport.getDropAction() & 2) == 2 ? "Move" : ((rTransferSupport.getDropAction() & 1) == 1 ? "Copy" : (objectArray[0] = (rTransferSupport.getDropAction() & 0x40000000) == 0x40000000 ? "Link" : "Not supported"));
            objectArray[1] = (rTransferSupport.getUserDropAction() & 2) == 2 ? "Move" : ((rTransferSupport.getUserDropAction() & 1) == 1 ? "Copy" : ((rTransferSupport.getUserDropAction() & 0x40000000) == 0x40000000 ? "Link" : "Not supported"));
            CDebugLog.INFO(String.format("    OUT | DropAction: %s | UserDropAction: %s", objectArray));
        }
        if (DEBUG_TRACE_METHODS) {
            CDebugLog.EXITING(CRhinoDragDropHandler.class.getName(), "SetDropAction");
        }
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACE_METHODS = false;
        DEBUG_TRACK_CREATE_TRANSFERRABLE = DEBUG;
        boolean bl = DEBUG_TRACK_RIGHT_CLICK = DEBUG;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_CAN_IMPORT = false;
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACK_DROP_ACTION = false;
        DEBUG_TRACK_IMPORT_DATA = DEBUG;
        DEBUG_TRACK_EXPORT_DONE = DEBUG;
    }
}

