/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dragdrop;

import com.rhinosoft.attrs.CAttrs;
import com.rhinosoft.log.CDebugLog;
import com.rhinosoft.threads.CLocalFileSystem;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.TransferHandler;

public abstract class CRhinoDragDropData
implements Transferable,
Serializable {
    protected static final boolean DEBUG = CAttrs.DEBUG;
    protected static final boolean DEBUG_TRACE_METHODS;
    public static final String DND_KEY_RIGHT_CLICK = "DndRightClick";
    private DataFlavor m_SupportedDataFlavorWrapper;
    private DataFlavor[] m_aSupportedDataFlavors;
    private Object m_rDragSourceObj;
    private boolean m_bHasDragData;
    private boolean m_bCanImport;
    private int m_nCursorState;
    private boolean m_bShowDropLocation;
    private boolean m_bHasImportedData;
    private boolean m_bIsRightClick;
    private boolean m_bIsMove;

    public CRhinoDragDropData() {
        this._CRhinoDragDropData();
    }

    private void _CRhinoDragDropData() {
        this.m_SupportedDataFlavorWrapper = this.CreateSupportedDataFlavor();
        this.m_aSupportedDataFlavors = this.CreateSupportedDataFlavors();
        this.m_bHasDragData = false;
        this.m_bCanImport = false;
        this.m_nCursorState = 0;
        this.m_bShowDropLocation = false;
        this.m_bHasImportedData = false;
        this.m_bIsRightClick = false;
        this.m_bIsMove = false;
    }

    public abstract int GetType();

    protected abstract DataFlavor CreateSupportedDataFlavor();

    protected DataFlavor GetSupportedDataFlavorWrapper() {
        return this.m_SupportedDataFlavorWrapper;
    }

    protected DataFlavor[] CreateSupportedDataFlavors() {
        DataFlavor[] aSupportedDataFlavors = new DataFlavor[]{this.GetSupportedDataFlavorWrapper()};
        return aSupportedDataFlavors;
    }

    @Override
    public Object getTransferData(DataFlavor rDataFlavor) throws UnsupportedFlavorException, IOException {
        if (DEBUG_TRACE_METHODS) {
            CDebugLog.ENTERING(CRhinoDragDropData.class.getName(), "getTransferData");
        }
        CRhinoDragDropData rRet = null;
        if (rDataFlavor != null) {
            if (!this.isDataFlavorSupported(rDataFlavor)) {
                throw new UnsupportedFlavorException(rDataFlavor);
            }
        } else {
            throw new IOException();
        }
        rRet = this;
        if (DEBUG_TRACE_METHODS) {
            CDebugLog.EXITING(CRhinoDragDropData.class.getName(), "getTransferData");
        }
        return rRet;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (DEBUG_TRACE_METHODS) {
            CDebugLog.ENTERING(CRhinoDragDropData.class.getName(), "getTransferDataFlavors");
        }
        if (DEBUG_TRACE_METHODS) {
            CDebugLog.EXITING(CRhinoDragDropData.class.getName(), "getTransferDataFlavors");
        }
        return this.m_aSupportedDataFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor rCheckFlavor) {
        if (DEBUG_TRACE_METHODS) {
            CDebugLog.ENTERING(CRhinoDragDropData.class.getName(), "isDataFlavorSupported");
        }
        boolean bSupported = false;
        if (rCheckFlavor != null) {
            for (int nIdx = 0; nIdx < this.m_aSupportedDataFlavors.length; ++nIdx) {
                DataFlavor rNextFlavor = this.m_aSupportedDataFlavors[nIdx];
                if (rNextFlavor == null || !rNextFlavor.equals(rCheckFlavor)) continue;
                bSupported = true;
                break;
            }
        }
        if (DEBUG_TRACE_METHODS) {
            CDebugLog.EXITING(CRhinoDragDropData.class.getName(), "isDataFlavorSupported");
        }
        return bSupported;
    }

    public void SetIsRightClick(boolean bIsRightClick) {
        this.m_bIsRightClick = bIsRightClick;
    }

    public boolean IsRightClick() {
        return this.m_bIsRightClick;
    }

    public boolean HasDragData() {
        return this.m_bHasDragData;
    }

    protected void SetHasDragData(boolean bHasDragData) {
        this.m_bHasDragData = bHasDragData;
    }

    public void CheckHasDragData(TransferHandler.TransferSupport rTransferSupport) {
        this.CheckHasDragData(rTransferSupport, false);
    }

    public void CheckHasDragData(TransferHandler.TransferSupport rTransferSupport, boolean bOverride) {
        if (rTransferSupport != null && (!this.HasDragData() || bOverride)) {
            boolean bHasDragData = false;
            DataFlavor[] aSupportedDataFlavors = this.getTransferDataFlavors();
            if (aSupportedDataFlavors != null) {
                for (int nIdx = 0; nIdx < aSupportedDataFlavors.length && !bHasDragData; ++nIdx) {
                    DataFlavor rSupportedDataFlavor = aSupportedDataFlavors[nIdx];
                    if (rSupportedDataFlavor == null || !rTransferSupport.isDataFlavorSupported(rSupportedDataFlavor)) continue;
                    bHasDragData = this.InitDragData(rTransferSupport);
                }
            }
            this.SetHasDragData(bHasDragData);
        }
    }

    protected boolean InitDragData(TransferHandler.TransferSupport rTransferSupport) {
        boolean bHasDragData = false;
        if (rTransferSupport != null && rTransferSupport.isDataFlavorSupported(this.GetSupportedDataFlavorWrapper())) {
            bHasDragData = true;
        }
        return bHasDragData;
    }

    public boolean GetCanImport() {
        return this.m_bCanImport;
    }

    public void SetCanImport(boolean bCanImport) {
        this.m_bCanImport = bCanImport;
    }

    public boolean HasImportedData() {
        return this.m_bHasImportedData;
    }

    public void SetHasImportedData(boolean bHasImportedData) {
        this.m_bHasImportedData = bHasImportedData;
    }

    public void SetCursorState(int nCursorState) {
        this.m_nCursorState = nCursorState;
    }

    public int GetCursorState() {
        return this.m_nCursorState;
    }

    public void SetShowDropLocation(boolean bShowDropLocation) {
        this.m_bShowDropLocation = bShowDropLocation;
    }

    public boolean GetShowDropLocation() {
        return this.m_bShowDropLocation;
    }

    public void SetIsMove(boolean bIsMove) {
        this.m_bIsMove = bIsMove;
    }

    public boolean IsMove() {
        return this.m_bIsMove;
    }

    public Object GetDragSourceObj() {
        return this.m_rDragSourceObj;
    }

    public void SetDragSourceObj(Object rDragSourceObj) {
        this.m_rDragSourceObj = rDragSourceObj;
    }

    protected boolean IsMac() {
        boolean bIsMac = false;
        if (CLocalFileSystem.GetLocalFileSystem() != null) {
            bIsMac = CLocalFileSystem.GetLocalFileSystem().IsMac();
        }
        return bIsMac;
    }

    protected boolean IsLinux() {
        boolean bIsLinux = false;
        if (CLocalFileSystem.GetLocalFileSystem() != null) {
            bIsLinux = CLocalFileSystem.GetLocalFileSystem().IsNIX();
        }
        return bIsLinux;
    }

    public void Reset() {
        this.SetDragSourceObj(null);
        this.m_bHasDragData = false;
        this.m_bCanImport = false;
        this.m_nCursorState = 0;
        this.m_bShowDropLocation = false;
        this.m_bHasImportedData = false;
        this.m_bIsRightClick = false;
        this.m_bIsMove = false;
    }

    static {
        if (DEBUG) {
            // empty if block
        }
        DEBUG_TRACE_METHODS = false;
    }
}

