/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dragdrop;

import com.rhinosoft.dragdrop.CDndFile;
import com.rhinosoft.dragdrop.CRhinoDragDropData;
import com.rhinosoft.ui.CRhinoApp;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.TransferHandler;

public class CFilesDragDropData
extends CRhinoDragDropData {
    public static final int TYPE_LISTINGS = 0;
    private boolean m_bIsRemote;
    private boolean m_bIsSearch;
    private CDndFile m_DragSourceDir;
    private ArrayList<CDndFile> m_aFiles;
    private CDndFile m_DropTargetDir;

    public CFilesDragDropData() {
        this._CFilesDragDropData();
    }

    private void _CFilesDragDropData() {
        this.m_bIsRemote = false;
        this.m_bIsSearch = false;
        this.m_aFiles = new ArrayList();
    }

    @Override
    protected DataFlavor CreateSupportedDataFlavor() {
        return new DataFlavor(CFilesDragDropData.class, "CFilesDragDropData");
    }

    @Override
    protected DataFlavor[] CreateSupportedDataFlavors() {
        boolean bAllowStringFlavor = true;
        if (CRhinoApp.GET_RHINO_APP() != null) {
            bAllowStringFlavor = CRhinoApp.GET_RHINO_APP().AllowDragDropStringFlavors();
        }
        int nSize = 2;
        if (bAllowStringFlavor) {
            nSize = 3;
        }
        DataFlavor[] aSupportedDataFlavors = new DataFlavor[nSize];
        aSupportedDataFlavors[0] = this.GetSupportedDataFlavorWrapper();
        aSupportedDataFlavors[1] = DataFlavor.javaFileListFlavor;
        if (bAllowStringFlavor) {
            aSupportedDataFlavors[2] = DataFlavor.stringFlavor;
        }
        return aSupportedDataFlavors;
    }

    public void SetIsRemote(boolean bIsRemote) {
        this.m_bIsRemote = bIsRemote;
    }

    public boolean IsRemote() {
        return this.m_bIsRemote;
    }

    public void SetIsSearch(boolean bIsSearch) {
        this.m_bIsSearch = bIsSearch;
    }

    public boolean IsSearch() {
        return this.m_bIsSearch;
    }

    public void SetDragSourceDir(CDndFile rFile) {
        this.m_DragSourceDir = rFile;
    }

    public CDndFile GetDragSourceDir() {
        return this.m_DragSourceDir;
    }

    public void SetDropTargetDir(CDndFile rFile) {
        this.m_DropTargetDir = rFile;
    }

    public CDndFile GetDropTargetDir() {
        return this.m_DropTargetDir;
    }

    public void AddFile(CDndFile rFile) {
        if (rFile != null && !this.m_aFiles.contains(rFile)) {
            this.m_aFiles.add(rFile);
        }
    }

    public void RemoveFile(CDndFile rFile) {
        if (rFile != null) {
            this.m_aFiles.remove(rFile);
        }
    }

    public CDndFile GetFile(int nIdx) {
        return this.m_aFiles.get(nIdx);
    }

    public CDndFile[] GetFiles() {
        int nSize;
        CDndFile[] arFiles = null;
        if (this.m_aFiles != null && (nSize = this.m_aFiles.size()) > 0) {
            arFiles = new CDndFile[nSize];
            for (int nIdx = 0; nIdx < nSize; ++nIdx) {
                arFiles[nIdx] = this.m_aFiles.get(nIdx);
            }
        }
        return arFiles;
    }

    public int GetFileCount() {
        return this.m_aFiles.size();
    }

    public void ClearItems() {
        this.m_aFiles.clear();
    }

    @Override
    protected boolean InitDragData(TransferHandler.TransferSupport rTransferSupport) {
        boolean bHasDragData;
        block16: {
            block17: {
                block18: {
                    List afFileList;
                    block14: {
                        bHasDragData = super.InitDragData(rTransferSupport);
                        if (rTransferSupport == null || bHasDragData) break block16;
                        if (!rTransferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) break block17;
                        afFileList = null;
                        this.SetDragSourceDir(null);
                        if (this.m_aFiles != null) {
                            this.m_aFiles.clear();
                        }
                        try {
                            afFileList = (List)rTransferSupport.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                        }
                        catch (Exception e) {
                            if (!DEBUG) break block14;
                            e.printStackTrace();
                        }
                    }
                    if (afFileList == null || afFileList.size() <= 0) break block18;
                    CDndFile rPath = null;
                    for (int nIdx = 0; nIdx < afFileList.size(); ++nIdx) {
                        File fParent;
                        rPath = null;
                        File fFile = (File)afFileList.get(nIdx);
                        if (fFile == null) continue;
                        if (nIdx == 0 && (fParent = fFile.getParentFile()) != null && fParent.exists()) {
                            rPath = new CDndFile(fParent);
                            this.SetDragSourceDir(rPath);
                            rPath = null;
                            bHasDragData = true;
                        }
                        rPath = new CDndFile(fFile);
                        this.AddFile(rPath);
                    }
                    break block16;
                }
                if (!this.IsMac()) break block16;
                bHasDragData = true;
                break block16;
            }
            if (rTransferSupport.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String sFileURIs;
                block15: {
                    sFileURIs = null;
                    this.SetDragSourceDir(null);
                    if (this.m_aFiles != null) {
                        this.m_aFiles.clear();
                    }
                    try {
                        sFileURIs = (String)rTransferSupport.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block15;
                        e.printStackTrace();
                    }
                }
                if (sFileURIs != null && !sFileURIs.isEmpty()) {
                    String[] asFileURIs;
                    String sDelimiter = "\n";
                    int nFirstIdx = sFileURIs.indexOf(10);
                    if (nFirstIdx - 1 > 0 && sFileURIs.charAt(nFirstIdx - 1) == '\r') {
                        sDelimiter = "\r\n";
                    }
                    if ((asFileURIs = sFileURIs.split(sDelimiter)) != null) {
                        CDndFile rPath = null;
                        for (int nIdx = 0; nIdx < asFileURIs.length; ++nIdx) {
                            File fParent;
                            File fFile;
                            String sFileURI = asFileURIs[nIdx];
                            rPath = null;
                            if (sFileURI == null || sFileURI.isEmpty() || (fFile = new File(URI.create(sFileURI))) == null) continue;
                            if (nIdx == 0 && (fParent = fFile.getParentFile()) != null && fParent.exists()) {
                                rPath = new CDndFile(fParent);
                                this.SetDragSourceDir(rPath);
                                rPath = null;
                                bHasDragData = true;
                            }
                            rPath = new CDndFile(fFile);
                            this.AddFile(rPath);
                        }
                    }
                }
            }
        }
        return bHasDragData;
    }

    @Override
    public int GetType() {
        return 0;
    }

    @Override
    public void Reset() {
        super.Reset();
        this.m_bIsRemote = false;
        this.m_bIsSearch = false;
        this.m_DragSourceDir = null;
        if (this.m_aFiles != null) {
            this.m_aFiles.clear();
        }
        this.m_DropTargetDir = null;
    }
}

