/*
 * Decompiled with CFR 0.152.
 */
package com.rhinosoft.dragdrop;

import com.rhinosoft.dragdrop.CDndFile;
import com.rhinosoft.dragdrop.CDndMsg;
import com.rhinosoft.dragdrop.CDndRightClickMenu;
import com.rhinosoft.dragdrop.CFilesDragDropData;
import com.rhinosoft.strings.CString;
import com.rhinosoft.ui.CRhinoEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;

public class CDndRightClickMenuFiles
extends CDndRightClickMenu {
    private JMenuItem m_cCopyMenuItem;
    private JMenuItem m_cMoveMenuItem;

    public CDndRightClickMenuFiles(CDndMsg rDndMsg) {
        super(rDndMsg);
    }

    @Override
    protected void OnCreate() {
        super.OnCreate();
        this.removeAll();
        this.m_cCopyMenuItem = new JMenuItem(CString.LoadString("IDS_DND_COPY_HERE"));
        this.m_cMoveMenuItem = new JMenuItem(CString.LoadString("IDS_DND_MOVE_HERE"));
        this.m_cCopyMenuItem.addActionListener(this);
        this.m_cMoveMenuItem.addActionListener(this);
        this.add(this.m_cCopyMenuItem);
        this.add(this.m_cMoveMenuItem);
        this.addSeparator();
        this.add(this.m_cCancelMenuItem);
    }

    @Override
    public void setVisible(boolean bVisible) {
        this.FmtBoldText();
        this.PreventRemoteCopy();
        super.setVisible(bVisible);
    }

    @Override
    public void actionPerformed(ActionEvent rEvent) {
        if (rEvent.getSource() == this.m_cCopyMenuItem) {
            if (this.m_rDndMsg != null) {
                CFilesDragDropData rDragDropData = this.GetDragDropData();
                Component rDropTargetComp = this.GetDropTargetComp();
                if (rDragDropData != null && rDropTargetComp != null) {
                    rDragDropData.SetIsRightClick(false);
                    rDragDropData.SetIsMove(false);
                    rDropTargetComp.dispatchEvent(new CRhinoEvent(this.m_rDndMsg));
                }
            }
        } else if (rEvent.getSource() == this.m_cMoveMenuItem && this.m_rDndMsg != null) {
            CFilesDragDropData rDragDropData = this.GetDragDropData();
            Component rDropTargetComp = this.GetDropTargetComp();
            if (rDragDropData != null && rDropTargetComp != null) {
                rDragDropData.SetIsRightClick(false);
                rDragDropData.SetIsMove(true);
                rDropTargetComp.dispatchEvent(new CRhinoEvent(this.m_rDndMsg));
            }
        }
    }

    private void FmtBoldText() {
        String sCopy = CString.LoadString("IDS_DND_COPY_HERE");
        String sMove = CString.LoadString("IDS_DND_MOVE_HERE");
        if (!this.IsMove()) {
            sCopy = String.format("<html><span style=\"font-weight: bold;\">%s</span></html>", sCopy);
        } else {
            sMove = String.format("<html><span style=\"font-weight: bold;\">%s</span></html>", sMove);
        }
        this.m_cCopyMenuItem.setText(sCopy);
        this.m_cMoveMenuItem.setText(sMove);
    }

    protected CDndFile GetDragSourceDir() {
        CDndFile rDir = null;
        CFilesDragDropData rDropData = this.GetDragDropData();
        if (rDropData != null) {
            rDir = rDropData.GetDragSourceDir();
        }
        return rDir;
    }

    protected CDndFile GetDropTargetDir() {
        CDndFile rDir = null;
        CFilesDragDropData rDropData = this.GetDragDropData();
        if (rDropData != null) {
            rDir = rDropData.GetDropTargetDir();
        }
        return rDir;
    }

    private void PreventRemoteCopy() {
        CDndFile rSourceDir = this.GetDragSourceDir();
        CDndFile rTargetDir = this.GetDropTargetDir();
        if (rSourceDir != null && rTargetDir != null && !rSourceDir.IsLocal() && !rTargetDir.IsLocal() && this.m_cCopyMenuItem != null) {
            this.m_cCopyMenuItem.setVisible(false);
        }
    }
}

